/*
    romquerybuilder.cpp - Build a ROM SQL query.

    Copyright (c) 2005-2006      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "romquerybuilder.h"

// Qt includes
#include <qmap.h>

// KDE include
#include <kdebug.h>

const QString baseRomQuery = QString::fromUtf8("SELECT rom.rom_name,"
			"rom.rom_url,"
			"rom.rom_md5Hash,"
			"rom.rom_year,"
			"rom.rom_titlescreenpath,"
			"rom.rom_screenshotpath,"
			"system.system_name," 
			"editor.editor_name, "
 			"country.country_name,"
 			"genre.genre_name "
			"FROM rom, system, editor, country, genre "
			"WHERE system.system_id = rom.system_id AND "
			"editor.editor_id = rom.editor_id AND "
 			"country.country_id = rom.country_id AND "
 			"genre.genre_id = rom.genre_id");

namespace Kamefu 
{

class RomQueryBuilder::Private
{
public:
	// Key = table(filter) name, value= filter value
	QMap<QString,QString> currentFilters;
};

RomQueryBuilder::RomQueryBuilder()
 : d(new Private)
{
}

RomQueryBuilder::~RomQueryBuilder()
{
	kdDebug() << k_funcinfo << endl;
	delete d;
}

void RomQueryBuilder::addFilter(const QString &filterTable, const QString &filterValue)
{
	kdDebug() << k_funcinfo << "Adding " << filterTable << " filter on value " << filterValue << endl;

	d->currentFilters.insert(filterTable, filterValue);
}

void RomQueryBuilder::removeFilter(const QString &filterTable)
{
	kdDebug() << k_funcinfo << "Removing filter on " << filterTable << endl;

	d->currentFilters.remove(filterTable);	
}

QString RomQueryBuilder::sqlQuery() const
{
	QString finalQuery = baseRomQuery;
	
	// Add the WHERE clause if there are filters.
	if( !d->currentFilters.isEmpty() )
		finalQuery += " AND ";
//		finalQuery += " WHERE ";

	// For each filter, we are adding this WHERE clause:
	// table_id = (SELECT table_id FROM table WHERE table_name LIKE ('Value%')
	QMap<QString,QString>::Iterator filterIt, filterItEnd = d->currentFilters.end();
	QString tableName, filterValue;

	for(filterIt = d->currentFilters.begin(); filterIt != filterItEnd; )
	{
		tableName = filterIt.key();
		filterValue = filterIt.data();

		finalQuery += QString("rom.%1_id = (SELECT %2_id FROM %3 WHERE %4_name = '%5')").arg(tableName).arg(tableName).arg(tableName).arg(tableName).arg(filterValue);
		
		// Add the AND clause if it's not the end of the iterator
		// Also increment the iterator here to get of the end early.
		if(++filterIt != filterItEnd)
		{
			finalQuery += " AND ";
		}
	}

	return finalQuery;
}

}
