/*
    RomQueryBuilder test suite

    Copyright (c) 2005-2006 by Michaël Larouche <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <kunittest/module.h>
#include "romquerybuilder_test.h"

// for setenv
#include <qfile.h>
#include <qdir.h>
#include <cstdlib>

#include <romquerybuilder.h>

#define EXPECTED_BARE_QUERY QString("SELECT * FROM rom")
#define EXPECTED_ONEFILTER_QUERY QString("SELECT * FROM rom WHERE country_id = (SELECT country_id FROM country WHERE country_name LIKE('America%'))")
#define EXPECTED_TWOFILTER_QUERY QString("SELECT * FROM rom WHERE country_id = (SELECT country_id FROM country WHERE country_name LIKE('America%')) AND editor_id = (SELECT editor_id FROM editor WHERE editor_name LIKE('Capcom%'))")

KUNITTEST_MODULE( kunittest_romquerybuilder_test, "LibKamefuTestSuite");
KUNITTEST_MODULE_REGISTER_TESTER( RomQueryBuilder_Test );

RomQueryBuilder_Test::~RomQueryBuilder_Test()
{
	delete queryBuilder;
}

void RomQueryBuilder_Test::allTests()
{
	queryBuilder = new Kamefu::RomQueryBuilder;

	// change user data dir to avoid messing with user's .kde dir
	setenv( "KDEHOME", QFile::encodeName( QDir::homeDirPath() + "/.kamefu-unittest" ), true );

	testFilters();
}

void RomQueryBuilder_Test::testFilters()
{
	QString sqlQuery;
	
	// Check for bare query.
	CHECK(queryBuilder->sqlQuery(), EXPECTED_BARE_QUERY);

	// Add first filter
	queryBuilder->addFilter("country", "America");
	CHECK(queryBuilder->sqlQuery(), EXPECTED_ONEFILTER_QUERY);

	// Add second filter
	queryBuilder->addFilter("editor", "Capcom");
	CHECK(queryBuilder->sqlQuery(), EXPECTED_TWOFILTER_QUERY);

	// Remove a filter
	queryBuilder->removeFilter("editor");
	CHECK(queryBuilder->sqlQuery(), EXPECTED_ONEFILTER_QUERY);
}
