
/*
 * Kanatest
 *
 * Copyright (C) 2001 Tomasz Mka
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "gui.h"
#include "test.h"
#include "prefs.h"

#include "main.h"
#include "i18n.h"

void kanatest_usage (void)
{
	printf(_("\nKanatest "VERSION"\n"));
	printf("---------------\n\n");
	printf(_("Usage:   kanatest [options]\n\n"));
	printf(_("Options: -s : displays statistics\n"));
	printf(_("         -r : reset statistics\n"));
	printf(_("         -h : displays this text\n"));
	printf("\n");
}


gint test_mode;

int main (int argc, char **argv)
{
gint opt, o, r, s;
gchar *optstring = "rsh";

	opterr = 0;
	o = r = s = FALSE;

	while ((opt = getopt(argc, argv, optstring)) != -1) {

		switch (opt) {

			case 'r':	r = o = TRUE;
						break;

			case 's':	s = o = TRUE;
						break;

			case 'h':   kanatest_usage();
						o = TRUE;
						break;

			default:	break;
		}
	}

	if(o!=TRUE) {

		read_config ();
		test_init ();

	#if ENABLE_NLS
	    gtk_set_locale();
	    bindtextdomain(PACKAGE, LOCALEDIR);
	    textdomain(PACKAGE);
	#endif

		test_mode = config.last_mode;
		config.run_counter++;

		if (!gtk_init_check (&argc, &argv)) {
			kanatest_usage();
			exit(-1);
		}

		gui_create_window ();
		gtk_main ();

		write_config ();

	} else if(r==TRUE) {

		/* reset statistics */

		printf("\nresetting statistics...");

		read_config ();

		config.hiragana_counter = 0;
		config.katakana_counter = 0;
		config.mixed_counter = 0;
		config.hiragana_max_result = 0;
		config.katakana_max_result = 0;
		config.mixed_max_result = 0;

		config.hiragana_time = 0.0;
		config.katakana_time = 0.0;
		config.mixed_time = 0.0;

		write_config ();

		printf("done\n\n");

	} else if(s==TRUE) {

		/* displays statistics */

		printf("\nSTATISTICS\n============\n\n");

		read_config ();

		printf("- Hiragana\n");
		printf("    best result = %d / 104 answer(s)\n", config.hiragana_max_result);
		printf("    overall tests time = %s\n", test_min2str(config.hiragana_time));
		printf("\n");
		printf("- Katakana\n");
		printf("    best result = %d / 104 answer(s)\n", config.katakana_max_result);
		printf("    overall tests time = %s\n", test_min2str(config.katakana_time));
		printf("\n");
		printf("- Mixed\n");
		printf("    best result = %d / 208 answer(s)\n", config.mixed_max_result);
		printf("    overall tests time = %s\n", test_min2str(config.mixed_time));
		printf("\n");

	}

	return 0;
}


