/*
    Copyright (C) 2005 by Ryan Schultz <schultz.ryan@gmail.com>
	GNU GPL v2 
*/

#ifndef __kanjisaver_H__
#define __kanjisaver_H__

#include "kscreensaver.h"
#include "kanjisaverui.h"

class kanjisaver : public KScreenSaver
{
    Q_OBJECT
public:
    kanjisaver( WId drawable );
    virtual ~kanjisaver();
private:
    void readSettings();
	void init();
    void blank();

    int TranslationOrReading;
    int ReadingToUse;
	int JLPTSet;
	unsigned int DisplayTime;
    QString KanaFontName;
    QString KanjiFontName;
    QStringList UsableFontList;
	QColor KanaColor;
	QColor KanjiColor;
	QColor TransReadColor;
	QColor BackgroundColor;
	
protected:
    QTimer * timer;
    QFont * kanaFont;
    QFont * kanjiFont;
    QFont * romajiFont;

protected slots:
    void draw_kanji();
};

// -------------------------

class kanjisaverSetup : public kanjisaverUI
{
    Q_OBJECT
public:
    kanjisaverSetup( QWidget *parent = NULL, const char *name = NULL );

private slots:
    void slotOkPressed();
    void slotCancelPressed();
    void FontChanged();

private:
    void readSettings();
    kanjisaver *saver;

    int TranslationOrReading;
    int ReadingToUse;
    int JLPTSet;
	unsigned int DisplayTime;
    QStringList UsableFontList;
	QColor KanaColor;
	QColor KanjiColor;
	QColor TransReadColor;
	QColor BackgroundColor;
    
};

#endif
