/***************************************************************************
                          kaptainwizard.cpp  -  description
                             -------------------
    begin                : Wed Sep 13 2000
    copyright            : (C) 2000 by Terk Zsolt
    email                : tz124@hszk.bme.hu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kgrammar.h"
#include "kplace.h"
#include "krule.h"
#include "kaptainwizard.h"

#include <qlayout.h>


extern KGrammar * gr;

KaptainWizard::KaptainWizard(KRule * start, QWidget *parent, const char *name)
  : QWizard(parent, name, true)
{
  QWidget * myPage=0;
  QBoxLayout * myLayout;
  KRule * myRule;
  KPlace * myPlace;

  setCaption(start->getTitle());

  QValueList<int> pages=start->children();
  QValueListIterator<int> it;
  for (it=pages.begin(); it!=pages.end(); ++it)
  {
    myPage=new QWidget(this);
    myLayout=new QVBoxLayout(myPage, BORDER, SPACING);
    myRule=gr->getRule(*it);
    if (myRule)
    {
      myPlace=
        new KPlace(myRule, false, false,  false, false, false, myPage, myLayout, this, this, true, false);
      addPage(myPage, myRule->getTitle());
      setHelpEnabled (myPage, false);
      setFinishEnabled (myPage, false);
    }
  }
  if (myPage)
    setFinishEnabled ( myPage, true );
}

KaptainWizard::~KaptainWizard()
{
}
