/***************************************************************************
                          fontscolors.cpp  -  description
                             -------------------
    begin                : Tue Mar 7 2000
    copyright            : (C) 2000 by mark dufour
    email                : m.dufour@twi.tudelft.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "fontscolors.h"
#include "globals.h"
#include "browser.h"
#include "sourcebox.h"
#include "chatbox.h"
#include "utility.h"
#include "separator.h"

#include <qfontdialog.h>
#include <qcolordialog.h>
#include <qlineedit.h>

fontscolors::fontscolors(QWidget *parent, const char *name) : QWidget(parent,name){
	initDialog();

	QObject::connect( Bbrowserfont, SIGNAL( clicked() ), this, SLOT( changeBrowserFont() ) );
	QObject::connect( Bsourcefont, SIGNAL( clicked() ), this, SLOT( changeSourceFont() ) );
	QObject::connect( Bircfont, SIGNAL( clicked() ), this, SLOT( changeIrcFont() ) );
	QObject::connect( Bemailfont, SIGNAL( clicked() ), this, SLOT( changeEmailFont() ) );

	QObject::connect( Bextensionforeground, SIGNAL( clicked() ), this, SLOT( changeExtensionColor() ) );
	QObject::connect( Bvisitedforeground, SIGNAL( clicked() ), this, SLOT( changeVisitedColor() ) );
	QObject::connect( Btitleforeground, SIGNAL( clicked() ), this, SLOT( changeTitleForeground() ) );
	QObject::connect( Btitlebackground, SIGNAL( clicked() ), this, SLOT( changeTitleBackground() ) );
	QObject::connect( Bhighlightforeground, SIGNAL( clicked() ), this, SLOT( changeHighlightForeground() ) );
	QObject::connect( Bhighlightbackground, SIGNAL( clicked() ), this, SLOT( changeHighlightBackground() ) );
	QObject::connect( Bbackground, SIGNAL( clicked() ), this, SLOT( changeBackgroundColor() ) );

	extensionColor = QColor( blue );
	visitedColor = QColor( darkMagenta ); 
	titleForeground = QColor( black );
	titleBackground = QColor( blue );
	highlightForeground = QColor( white );
	highlightBackground = QColor( darkBlue );
	backgroundColor = QColor( lightGray );
}

void fontscolors::changeExtensionColor()
{
	if( changeColor( extensionColor ) )
		browser->setCatLabelColors();
}

void fontscolors::changeVisitedColor()
{
	if( changeColor( visitedColor ) )
		browser->setCatLabelColors();
}

void fontscolors::changeTitleForeground()
{
	if( changeColor( titleForeground ) )
		browser->setTitleLabelColors();
}

void fontscolors::changeTitleBackground()
{
	if( changeColor( titleBackground ) )
		browser->setTitleLabelColors();
}

void fontscolors::changeHighlightForeground()
{
	if( changeColor( highlightForeground ) )
		browser->setCatLabelColors();
}

void fontscolors::changeBackgroundColor()
{
	if( changeColor( backgroundColor ) )
	{
		browser->setBackgroundColor();
		browser->setCatLabelColors();
	}	
}

void fontscolors::changeHighlightBackground()
{
	if( changeColor( highlightBackground ) )
		browser->setCatLabelColors();
}

int fontscolors::changeColor( QColor &color )
{
	QColor c = QColorDialog::getColor( color );

	if( c.isValid() )
	{
		color = c;	
		return TRUE;
	}	

	return FALSE;
}

void fontscolors::changeBrowserFont()
{
	bool ok;
	QFont f = QFontDialog::getFont( &ok, browser->font() );
	if( ok )
	{
		LEbrowserfont->setText( f.rawName() );
		LEbrowserfont->setCursorPosition( 0 );
		browser->setFont( f ); 
		browser->maskSep->adjustFont( f );
		browser->genSep->adjustFont( f );
	}
}

void fontscolors::changeSourceFont()
{
	bool ok;
	QFont f = QFontDialog::getFont( &ok, browser->sourceBox->font() );
	if( ok )
	{
		LEsourcefont->setText( f.rawName() );
		LEsourcefont->setCursorPosition( 0 );
		browser->sourceBox->setFont( f ); 
	}
}

void fontscolors::changeEmailFont()
{
	bool ok;
	
	QFont f;
	f.setRawName( LEemailfont->text() );
	
	f = QFontDialog::getFont( &ok, f );
	if( ok )
	{
		LEemailfont->setText( f.rawName() );
		LEemailfont->setCursorPosition( 0 );
	}
}

void fontscolors::changeIrcFont()
{
	bool ok;
	QFont f = QFontDialog::getFont( &ok, browser->chatBox->font() );
	if( ok )
	{
		LEircfont->setText( f.rawName() );
		LEircfont->setCursorPosition( 0 );
		browser->chatBox->setFont( f ); 
	}
}

fontscolors::~fontscolors(){
}
