module Portability64 where

import Lib
import System.IO
import System.Environment

-- GHC 6.4 and above library incompatibilities.

environment :: String -> IO (Maybe String)
environment x = catch (do e <- getEnv x
		          return (Just e))
		      (\_ -> return Nothing)

tempfile :: IO (FilePath, Handle)
tempfile = do env <- environment "TMPDIR"
	      let dir = case env of
		    Nothing -> tmpdir
		    (Just d) -> d
	      openTempFile tmpdir "kaya"
