/*
 *  Copyright (C) 2003 Takuro Ashie <ashie@homa.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  Based on Epiphany's code.
 *  Copyright (C) 2001 Philip Langdale
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <glib/gi18n.h>
#include <nsComponentManagerUtils.h>
#include <nsCOMPtr.h>
#define MOZILLA_STRICT_API
#include <nsEmbedString.h>
#undef MOZILLA_STRICT_API
#include <nsIURI.h>
#include <nsIURL.h>
#include <nsIMIMEInfo.h>
#include <nsMemory.h>

#include "kz-mozlauncher.h"
#include "kz-mozfilepicker.h"

NS_IMPL_ISUPPORTS1(KzContentHandler, nsIHelperAppLauncherDialog)


KzContentHandler::KzContentHandler() :
	mUri(nsnull),
	mDownloadCanceled(PR_FALSE)
{
	NS_INIT_ISUPPORTS();
}

KzContentHandler::~KzContentHandler()
{
}


NS_IMETHODIMP KzContentHandler::Show(nsIHelperAppLauncher *aLauncher,
				     nsISupports *aContext,
				     PRUint32 aForced)
{
	nsresult rv;

	mLauncher = aLauncher;
	mContext = aContext;

	rv = Init();
	
	mLauncher->SaveToDisk(nsnull, PR_FALSE);

	return NS_OK;
}

NS_IMETHODIMP KzContentHandler::PromptForSaveToFile(
				    nsIHelperAppLauncher *aLauncher,
				    nsISupports *aWindowContext,
				    const PRUnichar *aDefaultFile,
				    const PRUnichar *aSuggestedFileExtension,
				    nsILocalFile **_retval)
{
	nsresult rv;

	mContext = aWindowContext;

	nsCOMPtr<nsIDOMWindowInternal> windowInternal = 
					do_QueryInterface(aWindowContext);
	
	nsCOMPtr<nsILocalFile> saveDir;
	static nsEmbedCString dirName;
	
	if (dirName.IsEmpty())
		dirName.Assign(g_get_home_dir());

	saveDir = do_CreateInstance(NS_LOCAL_FILE_CONTRACTID);
	saveDir->InitWithNativePath(dirName);

	nsCOMPtr <nsILocalFile> saveFile(do_CreateInstance(NS_LOCAL_FILE_CONTRACTID));

	PRInt16 okToSave = nsIFilePicker::returnCancel;

	nsCOMPtr<nsIFilePicker> filePicker =
				do_CreateInstance(KZ_FILEPICKER_CONTRACTID);

	nsEmbedCString cTitle(_("Select the destination filename"));

	nsEmbedString title;
	NS_CStringToUTF16(cTitle,
			  NS_CSTRING_ENCODING_UTF8, title);

	filePicker->Init(windowInternal,
			 title, 
			 nsIFilePicker::modeSave);
	nsEmbedString defaultFile(aDefaultFile);
	filePicker->SetDefaultString(defaultFile);
	filePicker->SetDisplayDirectory(saveDir);

	filePicker->Show(&okToSave);

	if (okToSave == nsIFilePicker::returnOK)
	{
		filePicker->GetFile(getter_AddRefs(saveFile));

		saveFile->GetNativePath(dirName);
		
		nsCOMPtr<nsIFile> directory;
		rv = saveFile->GetParent(getter_AddRefs(directory));

		NS_IF_ADDREF(*_retval = saveFile);

		return NS_OK;
	}

	return NS_ERROR_FAILURE;
}


NS_METHOD KzContentHandler::Init (void)
{
	nsresult rv;

	nsCOMPtr<nsIMIMEInfo> MIMEInfo;
	rv = mLauncher->GetMIMEInfo(getter_AddRefs(MIMEInfo));

	rv = MIMEInfo->GetMIMEType(mMimeType);

	rv = mLauncher->GetSource(getter_AddRefs(mUri));
	rv = mLauncher->GetTargetFile(getter_AddRefs(mTempFile));
	
	rv = mUri->GetSpec(mUrl);
	rv = mUri->GetScheme(mScheme);

	return NS_OK;
}
