/***************************************************************************
                          kbearquickconnect.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <klineedit.h>
#include <knuminput.h>
#include "kbearquickconnect.h"

//-----------------------------------------------
KBearQuickConnect::KBearQuickConnect(QWidget *parent, const char *name)
		 : KBearQuickConnectDialog(parent,name,true){
}
//-----------------------------------------------
KBearQuickConnect::~KBearQuickConnect(){
}
//-----------------------------------------------
void KBearQuickConnect::accept(){
	close();
	SiteInfo siteInfo;
	siteInfo.info.host = HostNameEdit->text();
	if( siteInfo.info.host == "" )
		return;
	siteInfo.info.port = PortSpinBox->value();
	if( siteInfo.info.port == 0 )
		return;
	siteInfo.info.anonym = AnonymousCheck->isChecked();
	siteInfo.info.user = UserNameEdit->text();
	siteInfo.info.pass = PasswordEdit->text();
	siteInfo.info.path = RemoteDirEdit->text();
	siteInfo.info.label = siteInfo.info.host;
	if( saveSite() ) {
		siteInfo.parent = "Root";
		siteInfo.description = "";
		emit saveToSiteManager( siteInfo );
	}
	emit remoteConnect( siteInfo.info, false );
}
//-----------------------------------------------
void KBearQuickConnect::reject(){
	close();
}
//-----------------------------------------------
