/***************************************************************************
                          connection.cpp  -  description
                             -------------------
    begin                : sn jan 6 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qdir.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kurl.h>
#include <kio/slaveconfig.h>
#include <kprotocolmanager.h>
#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "connection.h"
//-----------------------------------------------
Connection::Connection()
{
	m_label = i18n("No Name");
	m_protocol = QString::fromLatin1("ftp");
	m_host = QString::null;
	m_port = 21;
	m_anonym = true;
	m_user =  QString::fromLatin1("anonymous");
	m_pass = QString::null;
	m_remotePath = QString::fromLatin1("/");
	m_localPath = QDir::homeDirPath();
	m_passiveMode = true;
	m_extendedPassiveMode = true;
	m_listA = true;
	m_binaryMode = true;
	m_enableLog = true;
	m_markPartial = false;
	m_queue = false;
	m_singleConnection = false;
	m_autoReconnect = false;
	m_reconnectTime = 30;
	m_numOfRetries = 10;
	m_firewallType = 0;
	m_firewallHost = QString::null;
	m_firewallUser = QString::null;
	m_firewallPass = QString::null;
	m_firewallAccount = QString::null;
	m_firewallMacro = QString::null;
	m_fileSysEncoding = "iso-8859-1";
	kdDebug()<<"Connection::Connection()"<<m_fileSysEncoding<<endl;
	
}
//-----------------------------------------------
Connection::Connection( const KURL& url )
{
	QString anonymous = QString::fromLatin1("anonymous");
	m_label =  (url.host()==QString::null) ? QString("Localhost") : url.host();
	m_protocol =  url.protocol();
	m_host = url.host();
	m_port = url.port();
	if( url.user() == QString::null || url.user() == anonymous ){
		m_user = anonymous;
		m_anonym = true;
	}
	else {
		m_user = url.user();
		m_anonym = false;
	}
	m_anonym = (m_user == anonymous);
	m_pass = url.pass();
	m_remotePath = url.path(1);
	m_localPath = QDir::homeDirPath();
	m_passiveMode = true;
	m_extendedPassiveMode = true;
	m_listA = true;
	m_binaryMode = true;
	m_enableLog = true;
	m_markPartial = false;
	m_queue = false;
	m_singleConnection = false;
	m_autoReconnect = false;
	m_reconnectTime = 30;
	m_numOfRetries = 10;
	m_firewallType = 0;
	m_firewallHost = QString::null;
	m_firewallUser = QString::null;
	m_firewallPass = QString::null;
	m_fileSysEncoding = "iso-8859-1";
	kdDebug()<<"Connection::Connection(url)"<<m_fileSysEncoding<<endl;

}
//-----------------------------------------------
Connection::~Connection(){
}
//-----------------------------------------------
KIO::MetaData Connection::metaData() const {
	KIO::MetaData meta;
	meta.insert( "EnableLog", m_enableLog?"true":"false" );
	meta.insert( "DisablePassiveMode", m_passiveMode?"false":"true" );
	meta.insert( "DisableEPSV", m_extendedPassiveMode?"false":"true" );
	meta.insert( "DisableListA", m_listA?"false":"true" );
	meta.insert( "BinaryMode", m_binaryMode?"true":"false" );
	meta.insert( "MarkPartial", m_markPartial?"true":"false" );
	meta.insert( "Queue", m_queue?"true":"false" );
	meta.insert( "FileSysEncoding", m_fileSysEncoding );
	if( m_protocol == "ftp" || m_protocol == "kbearftp" ) {
		meta.insert( "FirewallType", QString::number( m_firewallType ) );
		if( m_firewallType ) {
			if( m_firewallHost != "" )
				meta.insert( "FirewallHost", m_firewallHost );
			if( m_firewallPort > 0 )
				meta.insert( "FirewallPort", QString::number( m_firewallPort ) );
			if( m_firewallUser != "" )
				meta.insert( "FirewallUser", m_firewallUser );
			if( m_firewallPass != "" )
				meta.insert( "FirewallPass", m_firewallPass );
			if( m_firewallAccount != "" )
				meta.insert( "FirewallAccount", m_firewallAccount );
			if( m_firewallType == 8 ) {// Special
				meta.insert( "FirewallMacro", m_firewallMacro );
			}
		}
	}
	return meta;
}
//-----------------------------------------------
void Connection::setMetaData( const KIO::MetaData& metaData ) {
	if( metaData["EnableLog"] =="true" )
		m_enableLog = true;
	else if( metaData["EnableLog"] =="false" )
		m_enableLog = false;
	if( metaData["DisablePassiveMode"] =="true" )
		m_passiveMode = false;
	else if( metaData["DisablePassiveMode"] =="false" )
		m_passiveMode = true;
	if( metaData["DisableEPSV"] =="true" )
		m_extendedPassiveMode = false;
	else if( metaData["DisableEPSV"] =="false" )
		m_extendedPassiveMode = true;
	if( metaData["DisableListA"] =="true" )
		m_listA = false;
	else if( metaData["DisableListA"] =="false" )
		m_listA = true;
	if( metaData["BinaryMode"] =="true" )
		m_binaryMode = true;
	else if( metaData["BinaryMode"] =="false" )
		m_binaryMode = false;
	if( metaData["MarkPartial"] =="true" )
		m_markPartial = true;
	else if( metaData["MarkPartial"] =="false" )
		m_markPartial = false;
	if( metaData["Queue"] =="true" )
		m_queue = true;
	else if( metaData["Queue"] =="false" )
		m_queue = false;
	if( metaData.contains("FileSysEncoding") )
		m_fileSysEncoding = metaData["FileSysEncoding"];
}
//-----------------------------------------------
KURL Connection::url() const {
	KURL url( QDir::homeDirPath() );
	url.setProtocol( m_protocol );
	url.setUser( m_user );
	url.setPass( m_pass );
	url.setHost( m_host );
	url.setPort( m_port );
	url.setPath( (m_remotePath ==""?QString("/"):m_remotePath) );
	return url;
}
//-----------------------------------------------
void Connection::insert( QDataStream& out ) const {
	out << m_label << m_protocol << m_host << m_port << m_anonym
		<< m_passiveMode << m_extendedPassiveMode << m_binaryMode
		<< m_enableLog << m_markPartial << m_listA << m_user << m_pass
		<< m_remotePath << m_localPath << m_autoReconnect
		<< m_reconnectTime << m_numOfRetries << m_queue
		<< m_singleConnection << m_firewallType << m_firewallHost
		<< 	m_firewallPort << m_firewallUser << m_firewallPass << m_firewallAccount
		<< m_fileSysEncoding;
}
//-----------------------------------------------
void Connection::extract( QDataStream& in )  {
	in>>m_label>>m_protocol>>m_host>>m_port>>m_anonym>>m_passiveMode
		>>m_extendedPassiveMode>>m_binaryMode>>m_enableLog>>m_markPartial
		>>m_listA>>m_user>>m_pass>>m_remotePath>>m_localPath
		>>m_autoReconnect>>m_reconnectTime>>m_numOfRetries >> m_queue
		>> m_singleConnection >> m_firewallType >> m_firewallHost
		>> m_firewallPort >> m_firewallUser >> m_firewallPass >> m_firewallAccount
		>> m_fileSysEncoding;
}
//-----------------------------------------------
