/*********************************************************************************
                          kbeartransferviewitem.h  -  description
                             -------------------
    Begin					: Mn Maj 06 2002
    Copyright				: (C) 2000 by Bjrn Sahlstrm
    Email						: kbjorn@users.sourceforge.net
 ********************************************************************************/

/*********************************************************************************
 *																						*
 *   This program is free software; you can redistribute it and/or modify		*
 *   it under the terms of the GNU General Public License as published by	*
 *   the Free Software Foundation; either version 2 of the License, or			*
 *   (at your option) any later version.												*
 *																						*
 ********************************************************************************/

#ifndef KBEARTRANSFERVIEWITEM_H
#define KBEARTRANSFERVIEWITEM_H
//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qtimer.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/job.h>
#include <kio/jobclasses.h>
//#include <kio/progressbase.h>
#include <kurl.h>
//////////////////////////////////////////////////////////////////////
// application specific include files
#include "kbearcopyjob.h"

class KBearTransferViewPage;
class QListViewItem;
class Transfer;

/**
	*This class represents a transferjob, it connects the @ref KIO::Job signals with apropriate slots.
	* On the graphic side it shows an item in the TransferView
	*@short This class represents a transferjob
	*@see KBearTransferView
  *@author Bjrn Sahlstrm
*/
class KBearTransferViewItem : public QObject {
   Q_OBJECT
public:
	/**  */
	KBearTransferViewItem( KBearTransferViewPage* v, Transfer* );
	/**  */
	~KBearTransferViewItem();
	/* **/
//	QListViewItem* myTreeViewItem()const{ return p_myTreeViewItem;}
	/* **/
	KBearCopyJob* start();
	/* **/
	void stop();
signals: // Signals
	/** No descriptions */
	void lastTransfer( KBearTransferViewPage* );
	/** No descriptions */
	void start( Transfer* );
	/** No descriptions */
	void finished( KBearTransferViewItem* );
public slots: // Public slots
	/**  */
	void slotShowMenu( QListViewItem* item );
	/**  */
	void slotPause();
	/**  */
	void slotResume();
protected slots: // Protected slots
	/** */
	void slotTotalSize( KIO::Job*, KIO::filesize_t );
	/** */
	void slotMoving( KIO::Job* job, const KURL& source, const KURL& dest ) ;
	/** */
	void slotCopying( KIO::Job* job, const KURL& source, const KURL& dest ) ;
	/** */
	void slotLinking( KIO::Job* job, const QString& target, const KURL& dest ) ;
	/**  */
	void slotTotalFiles( KIO::Job*, unsigned long );
	/**  */
	void slotTotalDirs( KIO::Job*, unsigned long );
	/**  */
	void slotProcessedSize( KIO::Job*, KIO::filesize_t );
	/**  */
	void slotProcessedDirs( KIO::Job*, unsigned long pDirs );
	/**  */
	void slotProcessedFiles( KIO::Job*, unsigned long pFiles );
	/**  */
	void slotSpeed( KIO::Job*, unsigned long );
	/**  */
	void slotPercent( KIO::Job*, unsigned long );
	/**  */
	void slotPaused( KIO::Job* );
	/**  */
	void slotResumed( KIO::Job* );
	/**  */
	void slotStart();
	/**  */
	void slotStop();
	/**  */
	void slotFinished( KIO::Job* job = 0L );
private: // Private methods
	/** For internal use only */
	void init();
private: // Private attributes
	KBearTransferViewPage* m_transferViewPage;
	QListViewItem* transferTypeItem;
	QListViewItem* totalSizeItem;
	QListViewItem* processedSizeItem;
	QListViewItem* progressItem;
	QListViewItem* speedItem;
	QListViewItem* remainingTimeItem;
	QListViewItem* sourceItem;
	QListViewItem* destinationItem;
	QListViewItem* totalDirsItem;
	QListViewItem* totalFilesItem;
	QListViewItem* processedDirsItem;
	QListViewItem* processedFilesItem;
	KIO::filesize_t m_totalSize;
	KIO::filesize_t m_processedSize;
	Transfer* m_transfer;
	class KBearTransferViewSubItem;
	KBearTransferViewSubItem* p_myTreeViewItem;
	bool m_finishedStat;
};
#endif
