/***************************************************************************
                          kbearsitemanagerplugin.cpp  -  description
                             -------------------
    begin                : sn mar 17 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qlayout.h>
#include <qiconset.h>
#include <qcheckbox.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/slaveconfig.h>
#include <kprotocolinfo.h>
#include <kparts/part.h>
#include <kparts/browserextension.h>
#include <kservice.h>
#include <ktrader.h>
#include <kapplication.h>
#include <kpopupmenu.h>
#include <dcopclient.h>
#include <dcopref.h>
#include <kinstance.h>
#include <kgenericfactory.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <krun.h>
#include <klocale.h>
#include <kconfig.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearsitemanagerplugin.h"
#include "kbearsitemanager.h"
#include "kbearsitemanagertreeview.h"
#include "../../base/site.h"
#include "../../base/siteimportfilterpluginiface.h"
#include "../../base/group.h"

typedef KGenericFactory<KBearSiteManagerPlugin> KBearSiteManagerPluginFactory;
K_EXPORT_COMPONENT_FACTORY( libkbearsitemanager, KBearSiteManagerPluginFactory( "kbearsitemanager" ) );
//-----------------------------------------------
KBearSiteManagerPlugin::KBearSiteManagerPlugin(QObject* parent, const char* name, const QStringList& )
	:	KParts::Plugin(parent,name),
		DCOPObject("KBearSiteManagerInterface"),
		m_DB_DCOP_Name("kbearsitemanagerdb"),
		m_DB_DCOP_ID("SiteManagerDBInterface"),
		m_idleTimer( this ), m_hasSelectedSite( false ),
		m_pendingSelectedSite( 0L )
{
	KRun::run( "kbearsitemanagerdb",KURL::List() );
//	KGlobal::locale()->setMainCatalogue("kbear");
//	KInstance* instance = KBearSiteManagerPluginFactory::instance();
//	setInstance ( instance );
	(void) KGlobal::locale()->insertCatalogue("kbear");

	m_kbearMode = parent->inherits("KBear");

	m_privateActionCollection = new KActionCollection( 0L, this, "PrivateActionCollection"/*, instance*/ );

	m_siteManager = new KBearSiteManager( 0L, "SiteManager" );

	setXMLFile("kbearsitemanagerui.rc");
	
	setupActions();
	setupConnections();
	QByteArray data;
	QCString tmp1;
	// First see if sitemanager daemon is registered, if not wait until it is.
	if( kapp->dcopClient()->findObject(m_DB_DCOP_Name, m_DB_DCOP_ID, "ping()", data, tmp1, tmp1, true) )
	{
		slotInit();
	}
	else
		kdDebug()<<"KBearSiteManagerPlugin kbearsitemanagerdb not registered, will initialize later !!!!!!"<<endl;

	connect( &m_idleTimer, SIGNAL( timeout() ), this, SLOT( slotIdleTimeout() ) );
}
//-----------------------------------------------
KBearSiteManagerPlugin::~KBearSiteManagerPlugin(){
/*
	QByteArray data;
	if( ! kapp->dcopClient()->send(m_DB_DCOP_Name, m_DB_DCOP_ID, "unregReferer()", data ) )
		kdDebug()<<"DCOP call unregReferer() failed !!!!"<<endl;
*/
	m_idleTimer.stop();
	if( m_pendingSelectedSite )
		delete m_pendingSelectedSite;
	delete m_privateActionCollection;
	delete m_siteManager;
	kdDebug()<<"KBearSiteManagerPlugin::~KBearSiteManagerPlugin()="<<this<<endl;
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotImportOldSitemanager( QString fileName ) {
	QValueList<KService::Ptr> pluginList = m_siteManager->m_importDialog->pluginList();
	KTrader::OfferList::Iterator it( pluginList.begin() );
	for( ; it != pluginList.end(); ++it ) {
		KService::Ptr ptr = (*it);
		if( ptr->property( "X-KBear-OldSiteManager" ).toBool() ) {
			SiteImportFilterPluginIface* plugin = static_cast<SiteImportFilterPluginIface*>( KParts::Plugin::loadPlugin( this, ptr->library() ) );
			m_siteManager->m_importDialog->startImport( plugin, fileName );
		}
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::setupActions() {
	m_recentAction = new KSelectAction( i18n("Open &Recent"), 0, actionCollection(), "kbear_open_recent" );
//	m_recentAction = KStdAction::openRecent( this, 0, actionCollection(), "kbear_open_recent" );
	if( ! m_kbearMode )
		m_recentAction->setIcon("kbear");
	m_clearRecentAction = new KAction( i18n("Cl&ear Recent"), 0, 0, this, SLOT( slotClearRecent() ), actionCollection(), "kbear_clear_recent" );
	if( ! m_kbearMode )
		m_clearRecentAction->setIcon("kbear");
	m_siteManagerMenu = new KActionMenu( i18n("S&itemanager"), actionCollection(), "kbearsitemanager_menu");
	KAction* action = KStdAction::redisplay( this, SLOT( slotUpdate() ), actionCollection(), KStdAction::stdName(KStdAction::Redisplay) );
	action->setText( i18n("&Reload"));
	m_siteManagerAction = new KAction( i18n("&KBear Sitemanager"), "kbearsitemanager", CTRL+Key_O, this, SLOT( slotOpenSiteManager() ), actionCollection(), "kbearsitemanager" );

	KStdAction::addBookmark( this, SLOT( slotAddBookmark() ), actionCollection(), "add_bookmark" );
	new KAction( i18n("&New Group"), "folder_new", 0, this, SLOT(slotAddGroup()), actionCollection(), "new_group" );

	m_siteManagerMenu->insert( actionCollection()->action( KStdAction::stdName(KStdAction::Redisplay) ) );
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotIdleTimeout() {
	QByteArray data;
	QCString tmp1;
	if( ! kapp->dcopClient()->findObject(m_DB_DCOP_Name, m_DB_DCOP_ID,"ping()", data, tmp1, tmp1 ) )
	{
		if( m_hasSelectedSite ) {
			m_pendingSelectedSite = new Site;
			*m_pendingSelectedSite = m_siteManager->getCurrentSite();
		}
		KRun::run( "kbearsitemanagerdb",KURL::List() );
		connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "initialize()", "slotInit()", false );
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotInit() {
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	if( !kapp->dcopClient()->send(m_DB_DCOP_Name, m_DB_DCOP_ID, "regReferer()", data ) )
		kdDebug()<<"DCOP call regReferer() failed !!!!"<<endl;
	disconnectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "initialize()", "slotInit()" );

	kdDebug()<<"DCOP Database found name="<<m_DB_DCOP_Name<<" ID="<<m_DB_DCOP_ID<<endl;
	
	slotUpdate();

	if( m_pendingSelectedSite && m_hasSelectedSite ) {
		slotSiteSelected( *m_pendingSelectedSite );
		delete m_pendingSelectedSite;
		m_pendingSelectedSite = 0L;
	}
	KConfig config( "kbearsitemanagerrc" );
	setShowSystemTray( config.readBoolEntry( "ShowSysemTrayIcon", true ) );
	setPlugInKonq( config.readBoolEntry( "PlugInKonq", false ) );
	// this will check every 5 second if sitemanager database is up and running
	// if not it will restart it
	m_idleTimer.start( 5000 );
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotUpdate() {
	QApplication::setOverrideCursor( waitCursor );
	QByteArray data, replyData;
	QDataStream arg( data, IO_WriteOnly );
	QCString replyType;

	if( m_hasSelectedSite ) {
		m_pendingSelectedSite = new Site;
		*m_pendingSelectedSite = m_siteManager->getCurrentSite();
	}
	if( kapp->dcopClient()->call(m_DB_DCOP_Name, m_DB_DCOP_ID, "getSiteDataBase()", data, replyType, replyData, true ) ) {
		QDataStream answer( replyData, IO_ReadOnly );
		QString XMLDataBase;
		answer >> XMLDataBase;
		m_siteManager->siteTreeView->clear();
		parseDatabase( XMLDataBase );
		if( m_pendingSelectedSite && m_hasSelectedSite ) {
			slotSiteSelected( *m_pendingSelectedSite );
			delete m_pendingSelectedSite;
			m_pendingSelectedSite = 0L;
		}
	}
	else {
		kdDebug()<<"DCOP call getSiteDataBase() failed !!!!"<<endl;
		slotIdleTimeout();
		QTimer::singleShot( 1000, this, SLOT( slotUpdate() ) );
	}
	QApplication::restoreOverrideCursor();
}
//-----------------------------------------------
void KBearSiteManagerPlugin::setupConnections() {
	//DCOP connections
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "initialize()", "slotInit()", false );
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "updateDatabase(QString)", "slotUpdateDatabase(QString)", false );
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "newSite(Site)", "slotNewSite(Site)", false );
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "siteChanged(Site,QString)", "slotSiteChanged(Site,QString)", false );
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "siteRemoved(Site)", "slotSiteRemoved(Site)", false );
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "siteMoved(Site,QString,QString)", "slotSiteMoved(Site,QString,QString)", false );
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "newGroup(Group)", "slotNewGroup(Group)", false );
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "groupChanged(Group,QString)", "slotGroupChanged(Group,QString)", false );
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "groupRemoved(Group)", "slotGroupRemoved(Group)", false );
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "groupMoved(Group,QString)", "slotGroupMoved(Group,QString)", false );
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "newEncoding(QString)", "slotEncodingChanged(QString)", false );
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "importOldSitemanager(QString)", "slotImportOldSitemanager(QString)", false );
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "showSystemTray(bool)", "setShowSystemTray(bool)", false );
	connectDCOPSignal( m_DB_DCOP_Name, m_DB_DCOP_ID, "plugInKonq(bool)", "setPlugInKonq(bool)", false );
	//Ordinary connections
	connect( m_siteManager, SIGNAL( showSystemTray(bool) ),
				this, SLOT( slotShowSystemTray( bool ) ) );
	connect( m_siteManager, SIGNAL( plugInKonq(bool) ),
				this, SLOT( slotPlugInKonq( bool ) ) );
	connect( m_siteManager, SIGNAL( importSites( const QString& ) ),
				this, SLOT( slotImportSites( const QString&) ) );
	connect( m_siteManager, SIGNAL( siteSelected( const Site& ) ),
				this, SLOT( slotSiteSelected( const Site& ) ) );
	connect( m_siteManager, SIGNAL( selectionCleared() ),
				this, SLOT( slotSelectionCleared() ) );
	connect( m_siteManager, SIGNAL( openConnection( const Site& ) ),
				this, SLOT( slotOpenConnection( const Site& ) ) );
	connect( m_siteManager, SIGNAL( newGroup( const Group& ) ),
				this, SLOT( slotAddGroup( const Group& ) ) );
	connect( m_siteManager, SIGNAL( moveSite( const Site&, const QString& ) ),
				this, SLOT( slotMoveSite( const Site&, const QString& ) ) );
	connect( m_siteManager, SIGNAL( moveGroup( const Group&, const QString& ) ),
				this, SLOT( slotMoveGroup( const Group&, const QString& ) ) );
	connect( m_siteManager, SIGNAL( changeGroup( const Group&, const QString& ) ),
				this, SLOT( slotChangeGroup( const Group&, const QString& ) ) );
	connect( m_siteManager, SIGNAL( changeSite( const Site&, const QString& ) ),
				this, SLOT( slotChangeSite( const Site&, const QString& ) ) );
	connect( m_siteManager, SIGNAL( newEncoding( const QString& ) ),
				this, SLOT( slotNewEncoding( const QString& ) ) );
	connect( m_siteManager, SIGNAL( saveSite( const Site& ) ),
				this, SLOT( slotSaveSite( const Site& ) ) );
	connect( m_siteManager, SIGNAL( removeSite( const Site& ) ),
				this, SLOT( slotRemoveSite( const Site& ) ) );
	connect( m_siteManager, SIGNAL( update() ), this, SLOT( slotUpdate() ) );
	connect( m_siteManager, SIGNAL( removeGroup( const Group& ) ),
				this, SLOT( slotRemoveGroup( const Group& ) ) );
	connect( m_recentAction->popupMenu(), SIGNAL( aboutToShow() ),
				this, SLOT( slotRecentAboutToShow() ) );
	connect( m_recentAction, SIGNAL( activated( const QString& ) ),
				this, SLOT(slotOpenRecent( const QString& ) ) );
}
//-----------------------------------------------
void KBearSiteManagerPlugin::setShowSystemTray(bool show) {
	kdDebug()<<"KBearSiteManagerPlugin::setShowSystemTray="<<show<<endl;
	m_siteManager->p_showSystemTrayCheckBox->setChecked( show );
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotShowSystemTray(bool show) {
	kdDebug()<<"KBearSiteManagerPlugin::slotShowSystemTray="<<show<<endl;
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << show;
	DCOPClient* client = kapp->dcopClient();
	if( ! client->send( m_DB_DCOP_Name, m_DB_DCOP_ID, "showSystemTrayIcon(bool)", data ) ) {
		kdDebug()<<"DCOP send showSystemTrayIcon(bool) failed !!!!"<<endl;
		slotIdleTimeout();
	}
	KConfig config( "kbearsitemanagerrc" );
	config.writeEntry( "ShowSysemTrayIcon", show );
	config.sync();
}
//-----------------------------------------------
void KBearSiteManagerPlugin::setPlugInKonq(bool plug) {
	kdDebug()<<"KBearSiteManagerPlugin::setPlugInKonq="<<plug<<endl;
	m_siteManager->p_plugInKonqCheckBox->setChecked( plug );
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotPlugInKonq(bool plug ) {
	kdDebug()<<"KBearSiteManagerPlugin::slotPlugInKonq="<<plug<<endl;
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << plug;
	DCOPClient* client = kapp->dcopClient();
	if( ! client->send( m_DB_DCOP_Name, m_DB_DCOP_ID, "setPlugInKonq(bool)", data ) ) {
		kdDebug()<<"DCOP send setPlugInKonq(bool) failed !!!!"<<endl;
		slotIdleTimeout();
	}
	KConfig config( "kbearsitemanagerrc" );
	config.writeEntry( "PlugInKonq", plug );
	config.sync();
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotOpenConnection( const Site& site ) {
kdDebug()<<"KBearSiteManagerPlugin::slotOpenConnection KBear mode="<<m_kbearMode<<"   "<<site.label()<<endl;
	if( m_kbearMode ) {
		Connection c = site.connection();
		QByteArray data;
		QDataStream arg( data, IO_WriteOnly );
		arg << c;
		DCOPClient* client = kapp->dcopClient();
		if( ! client->send( client->appId(), client->defaultObject(), "openConnection(Connection)", data ) ) {
			kdDebug()<<"DCOP send openConnection(Connection) failed !!!!"<<endl;
			slotIdleTimeout();
		}
	}
	else {
		Site s =(Site)site;
		if( s.protocol() == "kbearftp" ) {
			// Now if it's over ftp we have to set firewall support
			KConfig config( "kbearrc" );
			config.setGroup("Firewall");
			unsigned int type = config.readUnsignedNumEntry( "Type", 0 ); // default is no firewall
			QString firewallHost = config.readEntry( "Host", QString::null );
			int firewallPort = config.readUnsignedNumEntry( "Port", 21 );
			QString firewallUser = config.readEntry( "User", QString::null );
			QString firewallPass = config.readEntry( "Pass", QString::null );
			QString firewallAccount = config.readEntry( "Account", QString::null );
			QString firewallMacro = QString::null;
			if( type == 8 ) // Special
				firewallMacro = config.readEntry( "Macro", QString::null );

			s.setFireWallType( type );
			s.setFireWallHost( firewallHost );
			s.setFireWallPort( firewallPort );
			s.setFireWallUser( firewallUser );
			s.setFireWallPass( firewallPass );
			s.setFireWallAccount( firewallAccount );
			s.setFireWallMacro( firewallMacro );
		}
		KIO::SlaveConfig::self()->reset();
		KIO::SlaveConfig::self()->setConfigData( s.protocol(), s.host(), s.metaData() );

		KParts::BrowserExtension* extension = KParts::BrowserExtension::childObject( parent() );
		if( extension ) {
			kdDebug()<<"KBearSiteManagerPlugin::slotOpenConnection extension="<<extension<<endl;

			KParts::URLArgs args;
			args.metaData() = s.metaData();
			args.reload = true;
			emit extension->openURLRequest( s.url(), args );
			slotAddToRecent( site );
		}
		else
			static_cast<KParts::ReadOnlyPart*>(parent())->openURL( s.url() );
	}
	slotAddToRecent( site );
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotSelectionCleared() {
	m_hasSelectedSite = false;
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotSiteSelected( const Site& site ) {
	QByteArray data, replyData;
	QDataStream arg( data, IO_WriteOnly );
	QCString replyType;
	arg << site;
	if( kapp->dcopClient()->call(m_DB_DCOP_Name, m_DB_DCOP_ID, "getSite(Site)", data, replyType, replyData, true ) ) {
		QDataStream answer( replyData, IO_ReadOnly );
		Site s;
		answer >> s;
		m_siteManager->setSite( s );
		m_hasSelectedSite = true;
	}
	else {
		kdDebug()<<"DCOP call getSite(Site) failed !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotImportSites( const QString& sites) {
	QByteArray data;
	QDataStream stream( data, IO_WriteOnly );
	stream << sites;
	if( ! kapp->dcopClient()->send( m_DB_DCOP_Name, m_DB_DCOP_ID,"importDomDocument(QString)", data ) ) {
		kdDebug()<<"DCOP call importDomDocument(QString) failed !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotUpdateDatabase( QString domTree ) {
	parseDatabase( domTree );
}
//-----------------------------------------------
void KBearSiteManagerPlugin::parseDatabase( const QString& XMLString ) {
//	m_siteManager->siteTreeView->clear();
	m_siteManagerMenu->popupMenu()->clear();
	m_privateActionCollection->clear();
	m_actionSeparator = new KActionSeparator( m_privateActionCollection, "separator" );
	QDomDocument document;
	document.setContent( XMLString );
	QString encoding = document.documentElement().attribute( "encoding" );
	for( int i = 0; i < m_siteManager->p_encodingComboBox->count(); i++ ) {
		QString tmp = KGlobal::charsets()->encodingForName( m_siteManager->p_encodingComboBox->text( i ) );
		if( tmp == encoding )
			m_siteManager->p_encodingComboBox->setCurrentItem( i );
	}
	m_siteManagerMenu->insert( m_siteManagerAction );
	m_siteManagerMenu->insert( m_actionSeparator );
	m_siteManagerMenu->insert( actionCollection()->action( KStdAction::stdName(KStdAction::Redisplay) ) );
	m_siteManagerMenu->insert( m_actionSeparator );
	m_siteManagerMenu->insert( actionCollection()->action( "add_bookmark" ) );
	m_siteManagerMenu->insert( actionCollection()->action( "new_group" ) );
	m_siteManagerMenu->insert( m_actionSeparator );
	buildTree( document.documentElement(), 0L, m_siteManagerMenu );
}
//-----------------------------------------------
void KBearSiteManagerPlugin::buildTree( QDomElement parentElement, QListViewItem* parentItem,  KActionMenu* parentMenu ) {
	static QString parentStr = QString::null;
	QListViewItem* item = 0L;
	KActionMenu* menu = 0L;
	KAction* action = 0L;
	QDomNode node = parentElement.firstChild();

	if( parentElement !=  parentElement.ownerDocument().documentElement() ) {
		action = new KAction( i18n("&Add Bookmark"), QIconSet(BarIcon("bookmark_add")), 0, this, SLOT(slotAddBookmark()), m_privateActionCollection, QString("addbookmark_"+parentStr).utf8() );
		parentMenu->insert( action );
		action = new KAction( i18n("&New Group"), QIconSet(BarIcon("folder_new")), 0, this, SLOT(slotAddGroup()), m_privateActionCollection, QString("new_group"+parentStr).utf8() );
		parentMenu->insert( action );
		parentMenu->insert( m_actionSeparator );
	}
	while( ! node.isNull() ) {
		QString name;
		if( node.toElement().tagName() == "group" ) {
			name = node.toElement().attribute( "label" );	
			item = m_siteManager->siteTreeView->findItemByName( parentItem, name );
			if( ! item ) {
				item = m_siteManager->siteTreeView->addGroup( parentItem, name );
			}
			parentStr = parentStr + "/" + name;
			menu = new KActionMenu( name, "bookmark_folder", m_privateActionCollection, parentStr.utf8() );
			parentMenu->insert( menu );
			// recursive build of the tree
			buildTree( node.toElement(), item, menu );
		}
		else if( node.toElement().tagName()  == "site" ) {
			name = node.toElement().attribute( "label" );
			item = m_siteManager->siteTreeView->findItemByName( parentItem, name );
			if( ! item ) {
				item = m_siteManager->siteTreeView->addSite( parentItem, name );
			}
			QString fullName = parentStr + "/" + name;
			action = new KAction( name, "ftp", 0, this, SLOT( slotBookmarkActivated() ), m_privateActionCollection, fullName.utf8() );
			parentMenu->insert( action );
		}
		node = node.nextSibling();
	}
	int length = parentStr.length() - parentElement.attribute("label").length() -1;
	parentStr = parentStr.left( length >= 0 ? length : 0 );
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotAddGroup( const Group& group ) {
	// now we're done so lets save the bookmark
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << group;
	if( ! kapp->dcopClient()->send( m_DB_DCOP_Name, m_DB_DCOP_ID, "saveGroup(Group)", data ) ) {
		kdDebug()<<"DCOP call saveGroup(Group) failed !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotChangeGroup( const Group& group, const QString& oldName ) {
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << group << oldName;
	if( ! kapp->dcopClient()->send( m_DB_DCOP_Name, m_DB_DCOP_ID, "changeGroup(Group,QString)", data ) ) {
		kdDebug()<<"DCOP call changeGroup(Group,String) failed !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotChangeSite( const Site& site, const QString& oldName ) {
kdDebug()<<"KBearSiteManagerPlugin::slotChangeSite="<<site.label()<<" old name="<<oldName<<endl;
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << site << oldName;
	if( ! kapp->dcopClient()->send( m_DB_DCOP_Name, m_DB_DCOP_ID, "changeSite(Site,QString)", data ) ) {
		kdDebug()<<"DCOP call changeSite(Site,String) failed !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotAddGroup() {
	QString senderName( QObject::sender()->name() );
	QString name = m_siteManager->promptForGroupName();
	if( name.isNull() )
		return;
	Group group;
	group.setLabel( name );
	if( senderName == "new_group" ) {
		group.setParent( QString::null );
	}
	else {
		senderName = senderName.right( senderName.length() - 9 ); // minus length of "new_group"
		group.setParent( senderName );
	}
	slotAddGroup( group );
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotAddBookmark() {
	QString senderName( QObject::sender()->name() );
	Site site;
	QByteArray data, replyData;
	QCString replyType;
	DCOPClient* client = kapp->dcopClient();
	if( m_kbearMode ) { // do we communicate with KBear ?
		if( client->call( client->appId(), client->defaultObject(), "currentMdiChildView()", data, replyType, replyData, true ) ) {
			DCOPRef ref;
			QDataStream answer( replyData, IO_ReadOnly );
			answer >> ref;
			if( client->call( ref.app(), ref.object(), "connection()", data, replyType, replyData, true ) ) {
				Connection c;
				QDataStream answer( replyData, IO_ReadOnly );
				answer >> c;
				site = Site( c );
			}
			else {
				kdDebug()<<"DCOP call currentURL() failed !!!!"<<endl;
				slotIdleTimeout();
				return;
			}
		}
		else {
			kdDebug()<<"DCOP call currentMdiChildView() failed !!!!"<<endl;
			slotIdleTimeout();
			return;
		}
	}
	else { // No, not KBear
		site =  Site(static_cast<KParts::ReadOnlyPart*>(parent())->url());
	}
	if( senderName == "add_bookmark" ) {
		site.setParent( QString::null );
	}
	else {
		senderName = senderName.right( senderName.length() - 12 ); // minus length of "addbookmark_"
		site.setParent( senderName );
	}
		
	// now we're done so lets save the bookmark
	QDataStream arg( data, IO_WriteOnly );
	arg << site;
	if( ! client->send( m_DB_DCOP_Name, m_DB_DCOP_ID, "saveSite(Site)", data ) ) {
		kdDebug()<<"DCOP call saveSite(Site) failed !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotSaveSite( const Site& site ) {
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << site;
	if( ! kapp->dcopClient()->send( m_DB_DCOP_Name, m_DB_DCOP_ID, "saveSite(Site)", data ) ) {
		kdDebug()<<"DCOP call saveSite(Site) failed !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotBookmarkActivated() {
	QString fullName( QObject::sender()->name() );
	fullName = QString::fromUtf8( fullName );
	QStringList list = QStringList::split( "/", fullName );
	Site site;
	site.setLabel( list.last() );
	site.setParent( fullName.left( fullName.length() - site.label().length() - 1 ) );
	QByteArray data, replyData;
	QDataStream arg( data, IO_WriteOnly );
	QCString replyType;
	arg << site;
	if( kapp->dcopClient()->call(m_DB_DCOP_Name, m_DB_DCOP_ID, "getSite(Site)", data, replyType, replyData, true ) ) {
		QDataStream answer( replyData, IO_ReadOnly );
		Site s;
		answer >> s;
		if( s.protocol() == "ftp" && m_siteManager->hasKBearFTP() )
			s.setProtocol( "kbearftp" );
		s.setPass( m_siteManager->decodePassword( s.pass() ) );
		slotOpenConnection( s );
	}
	else {
		kdDebug()<<"DCOP call getSite(Site) failed in slotBookmarkActivated !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotMoveSite( const Site& site, const QString& newParent ) {
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << site << newParent;
	if( ! kapp->dcopClient()->send( m_DB_DCOP_Name, m_DB_DCOP_ID, "moveSite(Site,QString)", data ) ) {
		kdDebug()<<"DCOP call moveSite(Site,QString) failed !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotMoveGroup( const Group& group, const QString& newParent ) {
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << group << newParent;
	if( ! kapp->dcopClient()->send( m_DB_DCOP_Name, m_DB_DCOP_ID, "moveGroup(Group,QString)", data ) ){
		kdDebug()<<"DCOP call moveGroup(Group,QString) failed !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotNewSite( Site site ) {
	QListViewItem* parent = m_siteManager->siteTreeView->findParentByFullName( site.parent() );
	QListViewItem* siteItem = m_siteManager->siteTreeView->addSite( parent, site.label() );
	if( m_siteManager->siteTreeView->selectedItem()
		&& site.parent() == m_siteManager->siteTreeView->getFullPath(m_siteManager->siteTreeView->selectedItem() )
		&& site.label() == m_siteManager->siteEdit->text() )
	{
		m_siteManager->siteTreeView->setSelected( siteItem, true );
	}

	KActionMenu* menu;
	if( ! parent )
		menu = m_siteManagerMenu;
	else
		menu = static_cast<KActionMenu*>(m_privateActionCollection->action( site.parent() ) );	
	QString fullName = site.parent() + "/" + site.label();
	KAction* action = new KAction( site.label(), "ftp", 0, this, SLOT( slotBookmarkActivated() ), m_privateActionCollection, fullName );
	menu->insert( action );
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotSiteChanged( Site site, QString oldName ) {
	QListViewItem* parentItem = m_siteManager->siteTreeView->findParentByFullName( site.parent() );
	//First we look for oldName
	QListViewItem* item = m_siteManager->siteTreeView->findItemByName( parentItem, oldName );
	if( item ) { // the item was found
		item->setText( 0, site.label() );
	}
	else { // If we get here is the site was renamed in this sitemanager
		item = m_siteManager->siteTreeView->findItemByName( parentItem, site.label() );
		kdDebug()<<"KBearSiteManagerPlugin::slotSiteChanged in this sitemanager="<<(item?item->text(0):QString::null)<<endl;
	}
	if( item ) {
		if( item == m_siteManager->siteTreeView->selectedItem() ){ // is it the selected site ?
			kdDebug()<<"KBearSiteManagerPlugin::slotSiteChanged selected item="<<item->text(0)<<endl;
			m_siteManager->slotSelectedSite( item );
		}
	}

}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotSiteRemoved( Site site ) {
	QListViewItem* parent = m_siteManager->siteTreeView->findParentByFullName( site.parent() );
	QListViewItem* item = m_siteManager->siteTreeView->findItemByName( parent, site.label() );
	QListViewItem* newSelection = 0L;
	if( item ==  m_siteManager->siteTreeView->selectedItem() )
		newSelection = item->parent();
	if( item )
		delete item;
	if( newSelection )
		m_siteManager->siteTreeView->setSelected( newSelection, true );

	slotUpdate();
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotSiteMoved( Site site, QString oldParent, QString oldName ) {
	QListViewItem* oldParentItem = m_siteManager->siteTreeView->findParentByFullName( oldParent );
	QListViewItem* newParentItem = m_siteManager->siteTreeView->findParentByFullName( site.parent() );
	QListViewItem* siteItem = m_siteManager->siteTreeView->findItemByName( oldParentItem, oldName );
	siteItem->setText( 0, site.label() );
	m_siteManager->siteTreeView->moveItem( siteItem, newParentItem, newParentItem );

	slotUpdate();
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotNewGroup( Group group ) {
	QListViewItem* parent = m_siteManager->siteTreeView->findParentByFullName( group.parent() );
	m_siteManager->siteTreeView->addGroup( parent, group.label() );

	KActionMenu* menu;
	if( ! parent )
		menu = m_siteManagerMenu;
	else
		menu = static_cast<KActionMenu*>(m_privateActionCollection->action( group.parent() ) );	
	QString fullName = group.parent() + "/" + group.label();
	KActionMenu* newMenu = new KActionMenu( group.label(), "bookmark_folder", m_privateActionCollection, fullName );
	KAction* action = KStdAction::addBookmark( this, SLOT( slotAddBookmark() ), m_privateActionCollection, "addbookmark_"+fullName );
	action->setShortcut( KShortcut() );
	newMenu->insert( action );
	action = new KAction( i18n("&New Group"), "folder_new", 0, this, SLOT(slotAddGroup()), m_privateActionCollection, "new_group"+fullName );
	newMenu->insert( action );
	newMenu->insert( m_actionSeparator );

	menu->insert( newMenu );
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotGroupChanged( Group group, QString oldName ) {
	QListViewItem* parentItem = m_siteManager->siteTreeView->findParentByFullName( group.parent() );
	// First look for old name
	QListViewItem* item = m_siteManager->siteTreeView->findItemByName( parentItem, oldName );
	if( item ) { // this is the case for all sitemanager except the one were the actual change was	
		item->setText( 0, group.label() );
	}
	else  // this is the case for the sitemanager were the actual change was	
		item = m_siteManager->siteTreeView->findItemByName( parentItem, group.label() );					 			

	if( item ) { // we should have an item here, otherwise something is wrong
		if( item == m_siteManager->siteTreeView->selectedItem() ) {
			//if the changed item is the selected on we have to update the selection
			m_siteManager->slotSelectedSite( item );
		}
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotRemoveSite( const Site& site ) {
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << site;
	if( ! kapp->dcopClient()->send( m_DB_DCOP_Name, m_DB_DCOP_ID, "removeSite(Site)", data ) ) {
		kdDebug()<<"DCOP call removeSite(Site) failed !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotRemoveGroup( const Group& group ) {
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << group;
	if( ! kapp->dcopClient()->send( m_DB_DCOP_Name, m_DB_DCOP_ID, "removeGroup(Group)", data ) ) {
		kdDebug()<<"DCOP call removeGroup(Group) failed !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotGroupRemoved( Group group ) {
	QListViewItem* parent = m_siteManager->siteTreeView->findParentByFullName( group.parent() );
	QListViewItem* item = m_siteManager->siteTreeView->findItemByName( parent, group.label() );
	QListViewItem* newSelection = 0L;
	if( item ==  m_siteManager->siteTreeView->selectedItem() )
		newSelection = item->parent();
	if( item )
		delete item;
	if( newSelection )
		m_siteManager->siteTreeView->setSelected( newSelection, true );

	slotUpdate();
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotGroupMoved( Group group, QString oldParent ) {
	QListViewItem* oldParentItem = m_siteManager->siteTreeView->findParentByFullName( oldParent );
	QListViewItem* newParentItem = m_siteManager->siteTreeView->findParentByFullName( group.parent() );
	QListViewItem* siteItem = m_siteManager->siteTreeView->findItemByName( oldParentItem, group.label() );
	m_siteManager->siteTreeView->moveItem( siteItem, newParentItem, newParentItem );

	slotUpdate();
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotEncodingChanged( QString encoding ) {
	for( int i = 0; i < m_siteManager->p_encodingComboBox->count(); i++ ) {
		QString tmp = KGlobal::charsets()->encodingForName( m_siteManager->p_encodingComboBox->text( i ) );
		if( tmp == encoding )
			m_siteManager->p_encodingComboBox->setCurrentItem( i );
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotNewEncoding( const QString& encoding ) {
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << encoding;
	if( ! kapp->dcopClient()->send( m_DB_DCOP_Name, m_DB_DCOP_ID, "setEncoding(QString)", data ) ) {
		kdDebug()<<"DCOP call setEncoding(QString) failed !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotOpenSiteManager() {
	m_siteManager->exec();
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotOpenRecent( const QString& path) {
	QStringList list = QStringList::split( "/", path );
	Site site;
	site.setLabel( list.last() );
	site.setParent( path.left( path.length() - site.label().length() -1 ) );

	QByteArray data, replyData;
	QDataStream arg( data, IO_WriteOnly );
	QCString replyType;
	arg << site;
	if( kapp->dcopClient()->call(m_DB_DCOP_Name, m_DB_DCOP_ID, "getSite(Site)", data, replyType, replyData, true ) ) {
		QDataStream answer( replyData, IO_ReadOnly );
		Site s;
		answer >> s;
		if( s.label() != QString::null ) {
			s.setPass( m_siteManager->decodePassword( s.pass() ) );
			QStringList protList = KProtocolInfo::protocols();
			bool hasKBearFtp = false;
			for( QStringList::Iterator it = protList.begin(); it != protList.end(); ++it ) {
				if( *it == "kbearftp" )
					hasKBearFtp = true;
			}
			if( s.protocol() == "ftp" && hasKBearFtp )
				s.setProtocol( "kbearftp" );
			slotOpenConnection( s );			
		}
		else {
			QString entry = site.parent() + "/" + site.label();
			KMessageBox::error ( (QWidget*)parent(), i18n("Can't find the site: %1\n"
										"It's probably removed from the SiteManager.\n"
										"It will now also be removed from the list over recent connections")
										.arg( entry ), i18n("Error opening recent...") );
			QStringList list = m_recentAction->items();
			list.remove( entry );
			m_recentAction->setItems( list );
			saveRecent();
		}
	}
	else {
		kdDebug()<<"DCOP call getSite(Site) failed !!!!"<<endl;
		slotIdleTimeout();
	}
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotRecentAboutToShow() {
	loadRecent();
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotClearRecent() {
	m_recentAction->setItems( QStringList() );
	saveRecent();
}
//-----------------------------------------------
void KBearSiteManagerPlugin::slotAddToRecent( const Site& site ) {
	QString entry = site.parent() + "/" + site.label();
	loadRecent();
	QStringList list = m_recentAction->items();

	// remove file if already in list
	list.remove( entry );

	// remove last item if already maxitems in list
	while( list.count() >= 10 ) {
		// remove last item
		list.remove( list.last() );
	}

	// add file to list
	list.prepend( entry );
	m_recentAction->setItems( list );
	saveRecent();
}
//-----------------------------------------------
void KBearSiteManagerPlugin::saveRecent() {
	KConfig config( "kbearsitemanagerrc" );
	config.writeEntry( "RecentFiles", m_recentAction->items() );
	config.sync();
}
//-----------------------------------------------
void KBearSiteManagerPlugin::loadRecent() {
	KConfig config( "kbearsitemanagerrc" );
	QStringList list = config.readListEntry( "RecentFiles" );
	m_recentAction->setItems( list );
}
//-----------------------------------------------

#ifndef NO_INCLUDE_MOCFILES
#include "kbearsitemanagerplugin.moc"
#endif
