/***************************************************************************
                          kbearsitemanagertreeview.cpp  -  description
                             -------------------
    begin                : fre mar 15 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qdragobject.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kiconloader.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearsitemanagertreeview.h"
#include "kbearsitemanager.h"

//-----------------------------------------------
KBearSiteManagerTreeView::KBearSiteManagerTreeView(QWidget *parent, const char *name )
	:	KBearTreeView(parent,name)
{
	setItemsRenameable( false );
}
//-----------------------------------------------
KBearSiteManagerTreeView::~KBearSiteManagerTreeView(){
}
//-----------------------------------------------
bool KBearSiteManagerTreeView::acceptDrag(QDropEvent* e ) const {
	return e->source() == viewport();
}
//-----------------------------------------------
void KBearSiteManagerTreeView::startDrag() {
	if(! selectedItem() )
		return;

	KBearSiteManager* manager = static_cast<KBearSiteManager*>( parentWidget() );
	manager->checkModified();
	QPoint hotspot;
	QPixmap pixmap = * selectedItem()->pixmap(0);
	hotspot.setX( pixmap.width() / 2 );
	hotspot.setY( pixmap.height() / 2 );
	QString parent = getFullPath( selectedItem()->parent() );
	QString name = currentItem()->text( 0 );
	QStoredDrag* dragObject = new QStoredDrag( "application/x-qlistviewitem", viewport() );
	QByteArray data;
	QDataStream arg( data, IO_WriteOnly );
	arg << parent << name;
	dragObject->setEncodedData( data );
	dragObject->setPixmap( pixmap, hotspot );
	dragObject->drag();   // start the drag;
}
//-----------------------------------------------
void KBearSiteManagerTreeView::contentsDropEvent( QDropEvent* e ) {
	m_autoOpenTimer.stop();  // stop timer
	if( ! acceptDrag( e ) )
		return;

	QListViewItem* newParentItem = 0L;
	if( selectedItem() ) {
		if( selectedItem()->isExpandable() )
			 newParentItem = selectedItem();
		else
			newParentItem = selectedItem()->parent();
	}
	QString parent;
	QString name;
	QDataStream arg( e->encodedData("application/x-qlistviewitem"), IO_ReadOnly );
	arg >> parent;
	arg >> name;

	QListViewItem* parentItem = findParentByFullName( parent );
	QListViewItem* item = findItemByName( parentItem, name );
	if( item )
		emit moved( parent, name, newParentItem, item->isExpandable() );

	m_dropItem = 0; // reset
}
//-----------------------------------------------
QString KBearSiteManagerTreeView::getParentString( QListViewItem* item ) const {
	return getFullPath( item->parent() );
}
//-----------------------------------------------
QString KBearSiteManagerTreeView::getFullPath( QListViewItem* item ) const {
	QString parentStr = QString::null;
	while( item ) {	
		if( parentStr.isNull() ) {
			parentStr = "/" + item->text( 0 ) ;
		}
		else {
			parentStr = "/" + item->text( 0 ) + parentStr;
		}
		item = item->parent();
	}
	return parentStr;
}
//-----------------------------------------------
QListViewItem* KBearSiteManagerTreeView::addSite( QListViewItem* parent, const QString& site ) {
	QPixmap pix(KGlobal::iconLoader()->loadIcon("ftp", KIcon::Small ));
	KBearTreeViewItem* item;
	if( parent )
		item = new KBearTreeViewItem( parent, site );
	else
		item = new KBearTreeViewItem( this, site );
	item->setExpandable( false );
	item->setPixmap( pix );
	return item;
}
//-----------------------------------------------
QListViewItem* KBearSiteManagerTreeView::addGroup( QListViewItem* parent, const QString& group ) {
	KBearTreeViewItem* item;
	if( parent )
		item = new KBearTreeViewItem( parent, group );
	else
		item = new KBearTreeViewItem( this, group );
	item->setOpen( false );
	return item;
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbearsitemanagertreeview.moc"
#endif
