/***************************************************************************
                          kbeartoolswidget.cpp  -  description
                             -------------------
    begin                : sn mar 3 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
//////////////////////////////////////////////////////
// KDE specific includes
#include <kapplication.h>
#include <klistbox.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <kdesktopfile.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbeartoolswidget.h"
#include "treeview.h"
#include "entry.h"

//-----------------------------------------------
KBearToolsWidget::KBearToolsWidget(QWidget *parent, const char *name )
	:	KBearToolsBase(parent,name)
{
	applications.setAutoDelete(true);
	loadToolsList();
	enableButtons();
}
//-----------------------------------------------
KBearToolsWidget::~KBearToolsWidget(){
}
//-----------------------------------------------
void KBearToolsWidget::slotToList() {
	TreeItem *item = (TreeItem*) m_applicationsTreeView->selectedItem();
	if(item && ! item->desktopEntryPath().isEmpty() ) {
		addToList( item->desktopEntryPath() );
	}
	enableButtons();
}
//-----------------------------------------------
void KBearToolsWidget::slotToTree() {
	if( ! m_toolsMenuList->currentItem() )
		return;
	applications.remove( m_toolsMenuList->currentItem() );
	updateList();
	enableButtons();
}
//-----------------------------------------------
void KBearToolsWidget::slotUp() {
	int current = m_toolsMenuList->currentItem();
	Entry* entry = applications.take( current );
	applications.insert( current - 1, entry );
	updateList();
	m_toolsMenuList->setCurrentItem( current - 1 );
	enableButtons();
}
//-----------------------------------------------
void KBearToolsWidget::slotDown() {
	int current = m_toolsMenuList->currentItem();
	Entry* entry = applications.take( current );
	applications.insert( current + 1, entry );
	updateList();
	m_toolsMenuList->setCurrentItem( current + 1 );
	enableButtons();
}
//-----------------------------------------------
void KBearToolsWidget::loadToolsList() {
	applications.clear();

	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("Tools");
	QStringList list = kapp->config()->readListEntry("Tools");

	for(QStringList::Iterator it = list.begin(); it != list.end(); ++it)
		addToList(*it);
	kapp->config()->setGroup( oldGroup );
}
//-----------------------------------------------
void KBearToolsWidget::saveToolsList() {
	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("Tools");

	QStringList list;
	QPtrListIterator<Entry> it( applications );
	for( ; it.current(); ++it)
		list.append(it.current()->desktopFile);

	kapp->config()->writeEntry("Tools", list);
	kapp->config()->sync();
	kapp->config()->setGroup( oldGroup );
}
//-----------------------------------------------
void KBearToolsWidget::addToList(const QString &desktopFile) {
	KDesktopFile df(desktopFile, true);

	if(df.readName().isEmpty())
		return;

	Entry *entry = new Entry;

	if(!df.readIcon().isEmpty())
		entry->icon = BarIcon(df.readIcon());
	entry->name = df.readName();
	entry->desktopFile = desktopFile;

	applications.append(entry);

	updateList();
	enableButtons();
}
//-----------------------------------------------
void KBearToolsWidget::updateList() {
	m_toolsMenuList->setUpdatesEnabled(false);
	m_toolsMenuList->clear();

	QPtrListIterator<Entry> it( applications );
	for( ; it.current(); ++it)
		m_toolsMenuList->insertItem(it.current()->icon, it.current()->name);

	m_toolsMenuList->setUpdatesEnabled(true);
	m_toolsMenuList->repaint();
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbeartoolswidget.moc"
#endif

