/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include <comment.h>
#include <xsltransform.h>

namespace BibTeX
{

    Comment::Comment( const QString& text, bool usePercent ) : Element(), m_text( text ), m_usePercent( usePercent )
    {
        // nothing
    }

    Comment::Comment( Comment *other )
    {
        m_text = other->m_text;
        m_usePercent = other->m_usePercent;
    }

    Comment::~Comment()
    {
        // nothing
    }

    QString Comment::text()
    {
        return m_text;
    }

    void Comment::setText( const QString &text )
    {
        m_text = text;
    }

    bool Comment::usePercent()
    {
        return m_usePercent;
    }

    void Comment::setUsePercent( bool usePercent )
    {
        m_usePercent = usePercent;
    }

    bool Comment::containsPattern( const QString& pattern, EntryField::FieldType fieldType, bool caseSensitive )
    {
        return fieldType == EntryField::ftUnknown && m_text.contains( pattern, caseSensitive );
    }

}
