#ifndef __DIR_FILTER_PLUGIN_H
#define __DIR_FILTER_PLUGIN_H

#include <qmap.h>

#include <kfileitem.h>
#include <klibloader.h>
#include <kparts/plugin.h>

class QStringList;
class KActionMenu;

namespace KParts {
struct URLArgs;
}

class DirFilterPlugin : public KParts::Plugin
{
  Q_OBJECT

public:
  struct MimeInfo
  {
    MimeInfo() {
      count=0;
      useAsFilter=false;
    };

    int count;
    bool useAsFilter;
    QString iconName;
    QString mimeComment;
  };

  DirFilterPlugin(QObject* parent, const char* name);
  ~DirFilterPlugin();

private slots:
  void slotAboutToShow();
  void slotItemSelected( int );
  void slotDeleteItem( const KFileItem * );
  void slotNewItems( const KFileItemList& );
  void slotMultipleFilters();
  void slotShowCount();
  void slotReset();

private:
  void loadSettings();
  void saveSettings();

private:
  QString m_pURL;
  bool m_bShowCount;
  bool m_bUseMultipleFilters;
  QStringList m_pItemList;
  KActionMenu* m_pFilterMenu;
  QMap<QString,MimeInfo> m_pMimeInfo;

  typedef QMap<QString,MimeInfo>::Iterator MimeInfoIterator;
  typedef QMap<QString,MimeInfo>::ConstIterator MimeInfoConstIterator;
};

class DirFilterPluginFactory : public KLibFactory
{
    Q_OBJECT
public:
    DirFilterPluginFactory( QObject* parent = 0, const char* name = 0 );
    ~DirFilterPluginFactory();
    virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
                                   const char* name = "QObject",
                                   const QStringList &args = QStringList() );
private:
    static KInstance* s_instance;
};
#endif
