/***************************************************************************
                            KDirSize.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Compute directory size (similar to "du", but doesn't give the same results
 since we simply sum up the dir and file sizes, whereas du speaks disk blocks)
 
 See {@link KDirSizeSignals} for signals emitted by KDirSize.

 See {@link KDirSizeEventHandling} for event handlers to override in subclasses of KDirSize.

 @short 
 Compute directory size (similar to "du", but doesn't give the same results
 since we simply sum up the dir and file sizes, whereas du speaks disk blocks)
 
*/
public class KDirSize extends Job  {
	protected KDirSize(Class dummy){super((Class) null);}


/** 

*/
	public native long totalSize();

/** 

*/
	public native long totalSize64();

/** 
 Asynchronous method. Connect to the result signal.
 This one lists a single directory.
   
*/
	public static native KDirSize dirSizeJob( KURL directory);

/** 
 Asynchronous method. Connect to the result signal.
 This one lists the items from <code>lstItems.</code>
 The reason we asks for items instead of just urls, is so that
 we directly know if the item is a file or a directory,
 and in case of a file, we already have its size.
   
*/
	public static native KDirSize dirSizeJob( ArrayList lstItems);

/** 
 Synchronous method - you get the result as soon as
 the call returns.
   
*/
	public static native long dirSize( KURL directory);

/** 
 Synchronous method - you get the result as soon as
 the call returns.
   
*/
	public static native long dirSize64( KURL directory);
	private native void newKDirSize( KURL directory);
	public KDirSize( KURL directory) {
		super((Class) null);
		newKDirSize( directory);
	}
	private native void newKDirSize( ArrayList lstItems);
	public KDirSize( ArrayList lstItems) {
		super((Class) null);
		newKDirSize( lstItems);
	}
	protected native void finalize() throws InternalError;

/** 

   
*/
	protected native void setSync();
	protected native void startNextJob( KURL url);
	protected native void slotResult( Job job);
//	protected native void slotEntries( Job arg1, UDSEntryList arg2);
	protected native void processList();
}
