/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "kbluelockrc.h"
#include <kdebug.h>

kbluelockrc* kbluelockrc::_instance = 0;

kbluelockrc* kbluelockrc::getDefaultRC()
{
    kdDebug() << "init" << endl;
    if (_instance == 0)
    {
        _instance = new kbluelockrc();
    }
    return _instance;
}

kbluelockrc::kbluelockrc()
{
  kdDebug() << "kbluelockrc" << endl;
  config = kapp->config();
  config->setGroup("ScanOptions");
  scaninterval = config->readNumEntry("ScanInterval",0);

  config->setGroup("AuthenticationOptions");
  validate_bdaddr = config->readNumEntry("ValidateBDADDR",1);
  validate_name = config->readNumEntry("ValidateName",0);
  validate_devtype = config->readNumEntry("ValidateDeviceType",0);

  config->setGroup("Devices");
  dev_addrs = config->readListEntry("BDADDR");
  dev_names = config->readListEntry("Names");
  dev_types = config->readListEntry("Types");

  changed = FALSE;
}

void kbluelockrc::write() {
  config = kapp->config();

  config->setGroup("ScanOptions");
  config->writeEntry("ScanInterval",scaninterval);

  config->setGroup("AuthenticationOptions");
  config->writeEntry("ValidateBDADDR",validate_bdaddr);
  config->writeEntry("ValidateName",validate_name);
  config->writeEntry("ValidateDeviceType",validate_devtype);

  config->setGroup("Devices");
  config->writeEntry("BDADDR",dev_addrs);
  config->writeEntry("Names",dev_names);
  config->writeEntry("Types",dev_types);

  config->sync();

  validate();
}

bool kbluelockrc::addDevice(const QString &_bdaddr, const QString &_name, const QString &_type) {
  QStringList::Iterator it;
  bool inlist = false;
  for ( it = dev_addrs.begin() ; it != dev_addrs.end() ; ++it ) {
    if (*it == _bdaddr) {
      inlist = true;
    }
  }
  if (!inlist) {
    dev_addrs << _bdaddr;
    dev_names << _name;
    dev_types << _type;
    invalidate();
    return true;
  } else { return false; }
}

bool kbluelockrc::removeDevice(int _idx) {
  QString _bdaddr = dev_addrs[_idx]; // why ? 'cause one day this method
                                     // will be "removeDevice(QString), so
                                     // I will just need to remove this line.
  QStringList::Iterator it_a = dev_addrs.begin();
  QStringList::Iterator it_n = dev_names.begin();
  QStringList::Iterator it_t = dev_types.begin();
  while ( it_a != dev_addrs.end() ) {
    if (*it_a == _bdaddr) {
      dev_addrs.remove(it_a);
      dev_names.remove(it_n);
      dev_types.remove(it_t);
      invalidate();
      return true;
    }
    it_a++;it_n++;it_t++;
  }
  return false; // uhuhu !!! bad inconsistency if this line is reached ...
}

kbluelockrc::~kbluelockrc()
{
}
