//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PINDIALOG_H
#define PINDIALOG_H

#include <kdialogbase.h>
#include <qguardedptr.h>

class PinGenerateDialog;
class PinDefaultDialog;
class QWidget;
namespace KBluetooth {
    class HciSocket;
}

/**
@author Fred Schaettgen
*/
class PinDialog : public KDialogBase
{
Q_OBJECT
public:
    PinDialog(QWidget* owner, bool bIn, bool ownAuth, QString addr, QString name);
    ~PinDialog();
    static QString getPin(bool bIn, bool ownAuth, QString addr, QString name);
protected:
    QGuardedPtr<PinDefaultDialog> pinDlg;
    QGuardedPtr<PinGenerateDialog> pinGenDlg;
    QString addr;
    KBluetooth::HciSocket *hciSocket;
    bool bOwnAuth;
    bool bGotGenPin;
    
protected slots:
    void slotCustomPinToggled(bool);
    void slotGo();
    void slotHciEvent(unsigned char, QByteArray);
};

#endif
