//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kdebluetooth@schaettgen.de                                            *
 *   marco@kmobiletools.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KBLUETOOTHRFCOMMSOCKETDEVICE_H
#define KBLUETOOTHRFCOMMSOCKETDEVICE_H

#include <qsocketdevice.h>
#include <qobject.h>
#include "deviceaddress.h"

namespace KBluetooth {
class RfcommSocketDevicePrivate;

/**
	@author Marco Gulino <rockman81@tin.it>
*/
class RfcommSocketDevice : public QObject, public QSocketDevice
{
Q_OBJECT
public:
    RfcommSocketDevice();

    ~RfcommSocketDevice();
    /** Opens a rfcomm connection.
    @param addr The target bluetooth device address.
    @param channel The rfcomm channel to use.
     */
    virtual bool connect(
            const KBluetooth::DeviceAddress& addr, int channel);
    Offset size() const { if(bytesAvailable()>0) return bytesAvailable(); return 0; }

    KBluetooth::DeviceAddress addr() const;
    private:
        RfcommSocketDevicePrivate *d;
};

}

#endif
