//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kdebluetooth@schaettgen.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KBLUETOOTHSCOSOCKET_H
#define KBLUETOOTHSCOSOCKET_H

#include <qstring.h>
#include <qsocket.h>

namespace KBluetooth {

class DeviceAddress;

/** Bluetooth Sco socket class.
 * Allows to open Sco connections to other bluetooth devices
 * and to use the socket the "Qt way" by connecting to the
 * inherited signals socketReadyRead() and error().
 */
class ScoSocket : public QSocket
{
Q_OBJECT
public:
    /** Constructor.
    @param parent parent object
    @name object name
    */
    ScoSocket(QObject* parent = NULL, const char* name = NULL);

    /** Destructor */
    virtual ~ScoSocket();

    /** Opens a Sco connection.
    @param addr The target bluetooth device address.
    @param channel The Sco channel to use.
    */
    virtual void connectToHost(const KBluetooth::DeviceAddress& addr);
};

}

#endif
