/* search.c
 *   Handles the search window popup
 */

#include <stdio.h>

#include <Xos.h>
#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xfuncs.h>

#include <Shell.h>

#include <Xaw/Command.h>
#include <Xaw/Label.h>
#include <Xaw/Form.h>
#include <Xaw/Box.h>
#include <Xaw/AsciiText.h>
#include <cursorfont.h>

#include "defs.h"
#include "externs.h"
#include "game.h"
#include "widgets.h"
#include "search.h"
#include "convert.h"
#include "multikanji.h"
#include "strokesearch.h"

#include "searchwidgets.h"

#include "utils.h"
#include "init.h"
#include "log.h"


Cursor textcursor;

Widget search_popup=NULL;
Widget searchstatusline=NULL;

Widget searchwidgets[NUM_OF_W];
Widget searchnumbers[NUM_OF_N];
Widget searchkanjiW,searchokuW; /* display current kanji here */

/* note.. if your compiler bitches about this initialization...
 * just remove  the "={{0,0}}".
 * It will probably get initialized to 0,0 anyways
 * kanastring is the string held by the "type romaji here" widget.
 */
XChar2b kanastring[MAXKANALENGTH]={{0,0}};

/* flag, if we only match kanji/kana at beginning of translation */
int match_onlyatstart=0;


static char *searchAccel = 
 " <Key>Return:  do-find()";





/* This gets called after clicking on the "search" button, or
 *  using the keyboard accelerator. It pops up the search window.
 */
void SearchCallback(Widget w,XtPointer client_data, XtPointer call_data)
{
	static int search_up = -1; 
	static Position rel_x,rel_y;
	Position x,y;

	/* sometimes we are called with w==NULL by hand */

	if(search_up==-1){
		/* first time init.. */
		rel_x = GetXtrmNumber("search_popupx","Search_popupx");
		rel_y = GetXtrmNumber("search_popupy","Search_popupy");
		setup_deletewindow(search_popup);
		search_up=0;
	}
	if(isMapped(search_popup)==False){
		/* Map in! */

		XtTranslateCoords(toplevel,rel_x,rel_y,&x,&y);
		/* it seems some window managers let you have extreme
		 * negative coordinates for pop-ups. sigh
		 */
		if(x<0) x=0;
		if(y<0) y=0;

		XtVaSetValues(search_popup,
		      XtNx,x,
		      XtNy,y,
		      NULL);

		XtMapWidget(search_popup);
		setstatus("Bringing up search window...");

	} else {
		XtUnmapWidget(search_popup);
	}
}

/* handle toggle for "match only if kana STARTS a phrase" */
/* actual search curerntly done in matchkana() */
void Handle_starttoggle(Widget w,XtPointer client_data, XtPointer call_data)
{
	Pixel fg,bg;
	match_onlyatstart=!match_onlyatstart;

	XtVaGetValues(w, XtNforeground, &fg,
		      XtNbackground, &bg, NULL);

	XtVaSetValues(w, XtNforeground, bg,
		      XtNbackground, fg, NULL);
		    
}

/* deal with matchkanji button. */
/* Find all matches for what is currently being displayed by the search win*/
void Handle_matchkanji(Widget w,XtPointer client_data, XtPointer call_data)
{
	findkanjiall(lastsearch->kanji);
}

/* Given a translation, return the index into translations[] that it
 * sits at
 */
int trans_to_index(TRANSLATION trans)
{
	return trans->kdrill_index;
}

/* handle toggle for "This kanji in in usefile" button*/
void Handle_usetoggle(Widget w,XtPointer client_data, XtPointer call_data)
{
	Pixel fg,bg;
	int kcount=trans_to_index(lastsearch);
	SetUseKanji(kcount, !InUsefile(kcount));
	CountKanji();
}

/* handle "Show" usefile button */
void Handle_showusefile(Widget w,XtPointer client_data, XtPointer call_data)
{
	setstatus("Showing usefile...");

	dousefilefind();
}

/* Update the labels for the info widgets at the top of search window.*/
/* Assumes variable "lastsearch" points to currently desired TRANSLATION */
void updatesearchlabels()
{
	TRANSLATION This=lastsearch;
	int kanjinum=0, kindex;

	if(search_popup==NULL)
		return;
	if(This==NULL){
		return;
	}

	XtVaSetValues(searchkanjiW,XtNlabel,This->kanji,
		XtNwidth,KANJIWIDTH,XtNheight,KANJIWIDTH,NULL);

	SetWidgetNumberval(searchnumbers[G_INPUT],(int)This->grade_level);
	SetWidgetNumberval(searchnumbers[F_INPUT],(int)This->frequency);
	SetWidgetNumberval(searchnumbers[H_INPUT],(int)This->Hindex);
	SetWidgetNumberval(searchnumbers[N_INPUT],(int)This->Nindex);
	SetWidgetHexval(searchnumbers[U_INPUT],(int)This->Uindex);

	kindex=trans_to_index(This);

	if(InUsefile(kindex))
	{
		HighlightButton(searchnumbers[INUSEFILE]);
	} else
	{
		UnhighlightButton(searchnumbers[INUSEFILE]);
	}

	/* assume if kanji entry is ONE char long, that we
	 * can use that byte as old kdrill/kanjidic index
	 *  ('#x' window)
	 */

	if(This->kanji != NULL)
	  if(This->kanji[1].byte1 == 0)
	  {
		kanjinum = This->kanji[0].byte1;
		kanjinum = kanjinum <<8;
		kanjinum |= This->kanji[0].byte2;
		
	  }
	if(kanjinum == NOKANJI)
	{
		kanjinum = 0;
	}

	SetWidgetHexval(searchnumbers[POUND_INPUT], kanjinum);

	if(romajiswitch==1)
	{
		char stringbuff[MAXROMAJI+1];
		/*translate all kana into romaji */
		/* translate to buffer, then set widget string*/
		kanatoromaji(This->pronunciation, stringbuff);
		XtVaSetValues(searchwidgets[KANA_W],
		      XtNencoding,XawTextEncoding8bit,
		      XtNfont,englishfont,
		      NULL);
		XtVaSetValues(searchwidgets[KANA_W],
		      XtNlabel,stringbuff,
		      NULL);
	
	} else
	{
		XtVaSetValues(searchwidgets[KANA_W],
		      XtNencoding, XawTextEncodingChar2b,
		      XtNfont,smallkfont,
		      NULL);
		XtVaSetValues(searchwidgets[KANA_W],
		      XtNlabel,This->pronunciation,NULL);
	}
	XtVaSetValues(searchwidgets[ENGLISH_W],
		      XtNlabel,This->english,NULL);
	
}

/* clear labels of "current kanji" display, in top of search window */
void clearsearchlabels()
{
	XChar2b blank = {0x0, 0x0};

	XtVaSetValues(searchkanjiW,
		      XtNlabel,"                               ",
		      NULL);
	XtVaSetValues(searchwidgets[ENGLISH_W],XtNlabel,"",NULL);
	SetWidgetNumberval(searchnumbers[G_INPUT],0);
	SetWidgetNumberval(searchnumbers[F_INPUT],0);
	SetWidgetNumberval(searchnumbers[POUND_INPUT],0);
	SetWidgetNumberval(searchnumbers[H_INPUT],0);
	SetWidgetNumberval(searchnumbers[N_INPUT],0);
	SetWidgetNumberval(searchnumbers[U_INPUT],0);
	XtVaSetValues(searchkanjiW,XtNlabel,&blank,
		XtNwidth,KANJIWIDTH,XtNheight,KANJIWIDTH,NULL);
		
}

/* printsearch:
*	Given an index, make search window print out appropriate stuff.
*	printsearch(0) means "clear windows".
*
*	This also sets the lastsearch static global!!
*/
void printsearch(TRANSLATION This)
{
	if(isMapped(search_popup)==False){
		/* pop up window, if it isnt already */
		SearchCallback(search_popup,NULL,NULL);
	}

	if(This==NULL){
		return;
	}
	lastsearch = This;
	updatesearchlabels();
}

/* SearchRefresh()
 *	called by romajicallback, when user toggles romaji/kana display
 */
void SearchRefresh()
{
	updatesearchlabels();
	if(isMapped(search_popup))
		printsearch(lastsearch);
}

/* stolen from xclipboard */
long TextLength (w)
    Widget  w;
{
    return XawTextSourceScan (XawTextGetSource (w),
                              (XawTextPosition) 0,
                              XawstAll, XawsdRight, 1, TRUE);
}

/* This tries using the secretnasty stuff in xclipboard
 * but fails.
 * We don't do anything in this routine any more.
 * but its nice to keep around for debug purposes.
 */
void doFunkyGrab(Widget textwin)
{
	int length; /* this is nastynastynasty...*/
	XPointer value;
	int strparse=0;
	char *str;

	length=TextLength(textwin);

	/* Okay, this is pseudo-undocumented. sorry. its what works! */
	value = (XPointer)_XawTextGetSTRING((TextWidget) textwin, 0, length);
	if(value==NULL)
	{
		printf("value is a dud");
		return;
	}
	str=value;
	printf("Using XawTextGetSTRING, we get:\n  ");
	for(strparse=0; strparse<length; strparse++)
	{
		printf("%.2x ",str[strparse]);

	}
	puts("");
	
}

/*
 * Kay, this is ugly.
 * This whole routine is because I'm too lazy to jump through the
 * incredible hoops of learning how to do X cut-n-paste properly.
 * So, I made a fake drop-target out of a asciiTextWidget, and
 * made it so we also get notified of a mouseclick.
 * Then, we have to do nasty decoding to JIS, and THEN
 * do a lookup ;-)
 *
 * We do this on button RELEASE, so that we can be reasonably sure
 * the widget has had the text inserted already.
 */
void Handle_searchPasted(Widget widget, XtPointer cl, XEvent *e, Boolean *cont)
{
	/* only handle up to three chars */
	XChar2b kstring[4];
	String str;
	int strparse;
	
	if(e->type != ButtonRelease)
		return;

	bzero(kstring, sizeof(kstring));

/* alternate way of getting pasted value */
/*	doFunkyGrab(widget);*/

	XtVaGetValues(widget,XtNstring,&str,NULL);

	strparse=0;

	if(str[strparse]=='\0'){
		doFunkyGrab(widget);
	}
#define OLDDEBUG
#ifdef OLDDEBUG
	puts("Handle_searchPasted: values of XtNstring pasted are:");
	while(str[strparse] != '\0');
	{
		printf("%.2x.",str[strparse++]);

	} 
	puts("");
	printf("strparse is now %d\n", strparse);
#else
	while(str[strparse++] != '\0');
#endif

	if(strparse<2)
	{
		puts("Paste error: Less than 2 bytes pasted");
		return;
	}

	/* POSSIBILITIES:
	 * 1. "raw" JIS, that looks to us like
	 *   0xffffff##, 0xffffff##
	 *
	 * 2. prefaced JIS, that looks to us like
	 *   0x1b, 0x2d, 0x41, 0xffffff##, 0xffffff##
	 * 
	 * 3. A different (older?) kind of prefaced JIS,that looks like
	 *   0x1b, 0x24, 0x29, 0x42, blahblahblah
	 */

	if(str[0]&0xffffff00)
	{
		puts("DEBUG: pure JIS paste");

		/* just PURE JIS (probably) */
		kstring[0].byte1=str[0]&0x7f;
		kstring[0].byte2=str[1]&0x7f;

		if(str[2]&0xffffff00)
		{
			kstring[1].byte1=str[2]&0x7f;
			kstring[1].byte2=str[3]&0x7f;
		}
		if(str[4]&0xffffff00)
		{
			kstring[2].byte1=str[4]&0x7f;
			kstring[2].byte2=str[5]&0x7f;
		}

	}
	else if (str[0] == 0x1b){
		int startchar=0;
		/* do goodstuff.. figure out which of the two it is */
		if((str[1]==0x2d) &&
		   (str[2]==0x41)){
			startchar=3;
		}
		else if((str[1]==0x24) &&
			(str[2]==0x29) &&
			(str[3]==0x42)){
			startchar=4;
		}else{
			puts("DEBUG: unrecognized paste encoding");
			return;
		}
		
		kstring[0].byte1=str[startchar]&0x7f;
		kstring[0].byte2=str[startchar+1]&0x7f;
		if(str[startchar+2] != 0)
		{
			kstring[1].byte1=str[startchar+2]&0x7f;
			kstring[1].byte2=str[startchar+3]&0x7f;
			if(str[startchar+4] != 0)
			{
				kstring[2].byte1=str[startchar+4]&0x7f;
				kstring[2].byte2=str[startchar+5]&0x7f;
			}
		}
	}

	XtVaSetValues(widget,XtNstring,"\0",NULL);

	findkanjiall(&kstring[0]);
}


/*************************************************************
 *    Widget Creation Below Here                             *
 *************************************************************/

/* make the G, F, # , etc,  for the search popup */
void makenumbers(Widget parent){
	searchnumbers[G_LABEL] = XtVaCreateWidget("0",labelWidgetClass,parent,
		       XtNlabel,"G:",      XtNborderWidth,0,
		       NULL);
	searchnumbers[G_INPUT] = XtVaCreateWidget("1",asciiTextWidgetClass,parent,
		       XtNfromHoriz,searchnumbers[G_LABEL],
		       XtNstring,"  ",  XtNdisplayCaret,False,
		       XtNwidth,30,	/* leave this short */
		       NULL);
	searchnumbers[H_LABEL] = XtVaCreateWidget("6",labelWidgetClass,parent,
		       XtNfromVert,searchnumbers[G_LABEL],
		       XtNlabel,"H:",   XtNborderWidth,0,
		       NULL);
	searchnumbers[H_INPUT] = XtVaCreateWidget("7",asciiTextWidgetClass,parent,
		       XtNfromVert,searchnumbers[G_LABEL],
		       XtNfromHoriz,searchnumbers[G_LABEL],
		       XtNstring," ",  XtNwidth,INPUTWIDTH,
		       XtNeditType,XawtextEdit,
		       NULL);

	searchnumbers[F_LABEL] = XtVaCreateWidget("2",labelWidgetClass,parent,
		       XtNfromHoriz,searchnumbers[H_INPUT],
		       XtNlabel,"F:",  XtNborderWidth,0,
		       NULL);
	searchnumbers[F_INPUT] = XtVaCreateWidget("3",asciiTextWidgetClass,parent,
		       XtNfromHoriz,searchnumbers[F_LABEL],
		       XtNstring,"",  XtNwidth,INPUTWIDTH,
		       XtNeditType,XawtextEdit,
		       NULL);
	searchnumbers[N_LABEL] = XtVaCreateWidget("8",labelWidgetClass,parent,
		       XtNfromVert,searchnumbers[G_LABEL],
		       XtNfromHoriz,searchnumbers[H_INPUT],
		       XtNlabel,"N:",   XtNborderWidth,0,
		       NULL);
	searchnumbers[N_INPUT] = XtVaCreateWidget("9",asciiTextWidgetClass,parent,
		       XtNfromVert,searchnumbers[G_LABEL],
		       XtNfromHoriz,searchnumbers[F_LABEL],
		       XtNstring," ",  XtNwidth,INPUTWIDTH,
		       XtNeditType,XawtextEdit,
		       NULL);

	searchnumbers[POUND_LABEL] = XtVaCreateWidget("4",labelWidgetClass,parent,
		       XtNfromHoriz,searchnumbers[F_INPUT],
		       XtNfromHoriz,searchnumbers[N_INPUT],
		       XtNlabel,"#x:",  XtNborderWidth,0,
		       NULL);
	searchnumbers[POUND_INPUT] = XtVaCreateWidget("5",asciiTextWidgetClass,parent,
		       XtNfromHoriz,searchnumbers[POUND_LABEL],
		       XtNstring,"",  XtNwidth,INPUTWIDTH,
		       XtNeditType,XawtextEdit,
		       NULL);
	searchnumbers[U_LABEL] = XtVaCreateWidget("10",labelWidgetClass,parent,
		       XtNfromVert,searchnumbers[G_LABEL],
		       XtNfromHoriz,searchnumbers[F_INPUT],
		       XtNfromHoriz,searchnumbers[N_INPUT],
		       XtNlabel,"Ux:",   XtNborderWidth,0,
		       NULL);
	searchnumbers[U_INPUT] = XtVaCreateWidget(
			"11",asciiTextWidgetClass,parent,
			XtNfromVert,searchnumbers[G_LABEL],
			XtNfromHoriz,searchnumbers[U_LABEL],
			XtNstring," ",  XtNwidth,INPUTWIDTH,
			XtNeditType,XawtextEdit,
			NULL);

	searchnumbers[INUSEFILE] = XtVaCreateWidget(
			"12",commandWidgetClass,parent,
			XtNlabel, "usefile",
			XtNfromHoriz,searchnumbers[U_INPUT],
			XtNhorizDistance, 20,
		       NULL);
	searchnumbers[SHOWUSEFILE] = XtVaCreateWidget(
			"12",commandWidgetClass,parent,
			XtNlabel, "show u.",
			XtNshapeStyle,XawShapeRoundedRectangle,
			XtNcornerRoundPercent,50,
			XtNfromHoriz,searchnumbers[U_INPUT],
			XtNfromVert,searchnumbers[INUSEFILE],
			XtNhorizDistance, 20,
		       NULL);

	XtManageChildren(searchnumbers,NUM_OF_N);
}


/* make topstuff:
 * Make widgets dealing with "current kanji", at top of search popup
 */
void maketopsearchstuff(Widget parent){
	Widget numbersform,matchbutton;

	searchkanjiW = XtVaCreateManagedWidget("kanjilarge",
						  labelWidgetClass,
						  parent,
			XtNwidth,FULLWIDTH - 100,
			XtNheight,KANJIWIDTH,
			XtNlabel,"",
			XtNencoding,XawTextEncodingChar2b,
			XtNfont,largekfont,
			NULL);
	matchbutton = XtVaCreateManagedWidget("matchkanjib",
			commandWidgetClass,parent,
			XtNfromHoriz,searchkanjiW,
			XtNlabel, "match",
			NULL);
	
	XtAddCallback(matchbutton, XtNcallback, Handle_matchkanji, NULL);

	numbersform = XtVaCreateManagedWidget("numform",
			formWidgetClass, parent,
			XtNfromVert,searchkanjiW,
       			NULL);

	makenumbers(numbersform);


}



/* define the label and input widgets for inputting english
 * and kana. At the TOP LEVEL of the search window.
 *
 * For kana, the "label" is actually a button that will bring up the
 * special kana input window. User can then point-and-click.
 */
void makesearchinputs(Widget parent)
{
	Widget kanjisform;

	searchwidgets[SEARCH_ENG_L] =
		XtVaCreateWidget("searchenglishlabel",
			labelWidgetClass,
			parent,
			XtNjustify, XtJustifyRight,
			XtNlabel, "English search",
			XtNvertDistance, 20,
			XtNborderWidth, 0,
			XtNfromVert, searchwidgets[ENGLISH_W],
			NULL);
						       
	searchwidgets[SEARCH_ENG_W] =
		XtVaCreateWidget("searchenglish",
			asciiTextWidgetClass,
			parent, 
			XtNfromVert, searchwidgets[ENGLISH_W],
			XtNfromHoriz, searchwidgets[SEARCH_ENG_L],
			XtNvertDistance, 20,
			XtNfont, englishfont,
			XtNeditType, XawtextEdit,
			XtNwidth, FULLWIDTH - 150,
			NULL);

	kanjisform=
		XtVaCreateManagedWidget("searchkanjif",
			formWidgetClass,parent,
			XtNfromVert, searchwidgets[SEARCH_ENG_L],
			XtNvertDistance, 10,
			NULL);

	searchwidgets[SEARCH_KANJI_L] =
		XtVaCreateManagedWidget("searchkanjibutton",
			commandWidgetClass, kanjisform,
			XtNjustify, XtJustifyRight,
			XtNlabel, "Kanji search  ",
			NULL);

	searchwidgets[SEARCH_SKIP_W] =
		XtVaCreateManagedWidget("searchskipbutton",
			commandWidgetClass, kanjisform,
			XtNlabel, "Kanji SKIP search",
			XtNfromHoriz, searchwidgets[SEARCH_KANJI_L],
			NULL);

	searchwidgets[SEARCH_STROKE_W] =
		XtVaCreateManagedWidget("searchstrokebutton",
			commandWidgetClass,kanjisform,
			XtNjustify, XtJustifyRight,
			XtNlabel, "Stroke count  ",
			/*XtNborderWidth, 0,*/
			XtNfromVert, searchwidgets[SEARCH_KANJI_L],
			NULL);


	searchwidgets[SEARCH_KANJI_L2] =
		XtVaCreateManagedWidget("searchkanjil2",
			labelWidgetClass,
			kanjisform,
			XtNjustify, XtJustifyRight,
			XtNlabel, "(or paste char ->)",
			XtNborderWidth, 0,
			XtNfromVert, searchwidgets[SEARCH_KANJI_L],
			XtNfromHoriz, searchwidgets[SEARCH_STROKE_W],
			NULL);

	searchwidgets[SEARCH_KANJIPASTE] =
		XtVaCreateManagedWidget("searchkanji",
			asciiTextWidgetClass,
			kanjisform, 
			XtNwidth, 50,
			XtNlabel, "",
			XtNfromVert, searchwidgets[SEARCH_KANJI_L],
			XtNfromHoriz, searchwidgets[SEARCH_KANJI_L2],
			XtNfont, smallkfont,
			XtNencoding, XawTextEncodingChar2b,
			XtNeditType, XawtextEdit,
			XtNjustify, XtJustifyLeft,
			XtNdisplayCaret, False,
			NULL);


	/* and now the kana search input widgets. gets a bit messy here */

	searchwidgets[KANA_FORM]=XtVaCreateManagedWidget("kanasearchgroup",
			 formWidgetClass, parent,
			 XtNfromVert, kanjisform,
			 XtNvertDistance, 10,
			 XtNborderWidth, 1,
			 NULL);


	searchwidgets[SEARCH_STARTTOG]=
		XtVaCreateManagedWidget("atstart_toggle",
			commandWidgetClass, parent,
			XtNfromVert, kanjisform,
			XtNvertDistance, 10,
			XtNfromHoriz, searchwidgets[KANA_FORM],
			XtNhorizDistance, 15,
			XtNlabel, "[...",
			NULL);
		

	searchwidgets[SEARCH_KANA_L] =
		XtVaCreateManagedWidget("searchkanalabel",
			commandWidgetClass, searchwidgets[KANA_FORM],
			XtNjustify, XtJustifyRight,
			XtNlabel, "Kana search   ",
			/*XtNborderWidth, 0,*/
			NULL);


	searchwidgets[SEARCH_KANA_W] =
		XtVaCreateManagedWidget("searchkana",
			labelWidgetClass, searchwidgets[KANA_FORM], 
			XtNwidth, FULLWIDTH - 100,
			XtNlabel,"\0",
			/*XtNlabel, "!z",*/ /* 0x217a */
			XtNfromVert, searchwidgets[SEARCH_KANA_L],
			XtNfont, smallkfont,
			XtNencoding, XawTextEncodingChar2b,
			XtNjustify, XtJustifyLeft,
			XtNcursor, textcursor,
			NULL);


	/* This possibly now has the wrong value.(?) sigh. */
	XtManageChildren(searchwidgets,SEARCH_ENG_W+1);

	XtAddCallback(searchwidgets[SEARCH_KANA_L], 
		      XtNcallback, Showinputkana, NULL);
	XtAddCallback(searchwidgets[SEARCH_KANJI_L], 
		      XtNcallback, Showinputkanji, NULL);
	XtAddCallback(searchwidgets[SEARCH_SKIP_W], 
		      XtNcallback, ShowSKIP, NULL);
	XtAddCallback(searchwidgets[SEARCH_STROKE_W], 
		      XtNcallback, Showstroke, NULL);

	XtAddCallback(searchwidgets[SEARCH_STARTTOG], 
		      XtNcallback, Handle_starttoggle, NULL);

	XtAddCallback(searchnumbers[INUSEFILE], 
		      XtNcallback, Handle_usetoggle, NULL);
	XtAddCallback(searchnumbers[SHOWUSEFILE], 
		      XtNcallback, Handle_showusefile, NULL);



	XtAddEventHandler(searchwidgets[SEARCH_KANA_W],
			  KeyPressMask,
			  False, Handle_romajikana,NULL);
	
	XtAddEventHandler(searchwidgets[SEARCH_KANJIPASTE],
			  ButtonReleaseMask, False,
			  Handle_searchPasted,NULL);
			  

}


/* This is the only exported "make widgets" routine */
void MakeSearchPopup()
{
	 Widget searchform;
	 XtAccelerators Accel;

	textcursor=XCreateFontCursor(display,XC_xterm);

#ifdef OLDWAY
	search_popup = XtVaCreatePopupShell("kdrill_search",
		transientShellWidgetClass,
		toplevel,
		NULL);
#else
	search_popup = XtVaCreateWidget("kdrill_search",
		shellWidgetClass,
		toplevel,
		NULL);
	XtSetMappedWhenManaged(search_popup,False);
#endif

	searchform = XtVaCreateManagedWidget("searchform",
					     formWidgetClass,
					     search_popup,
					     NULL);

	searchwidgets[NFORM_W] = XtVaCreateManagedWidget("northform",
			formWidgetClass,
			searchform,
			XtNborderWidth,2,
			NULL);

	maketopsearchstuff(searchwidgets[NFORM_W]);

	/* now make the long output display widgets */
	searchwidgets[KANA_W] = XtVaCreateWidget("searchkana",
						 labelWidgetClass,
						 searchform,
			XtNlabel,"                               ",
			XtNfromVert,searchwidgets[NFORM_W],
			XtNvertDistance,20,
			XtNencoding,XawTextEncodingChar2b,
			XtNfont,smallkfont,
			XtNwidth,FULLWIDTH,
			NULL);

	searchwidgets[ENGLISH_W] = XtVaCreateWidget("searchenglish",
						    labelWidgetClass,
						    searchform, 
			XtNlabel,"                                       ",
			XtNfromVert,searchwidgets[KANA_W],
			XtNfont,englishfont,
			XtNwidth,FULLWIDTH,
			NULL);

	/* This makes other searchwidgets[] stuffs, below the static
	 * display we just made, above.
	 */
	makesearchinputs(searchform);

	searchstatusline = XtVaCreateManagedWidget("searchstatus",
			labelWidgetClass, searchform,
		      XtNlabel,"Search popup",
		      XtNwidth,FULLWIDTH,
		      XtNborderWidth,2,
		      XtNfromVert, searchwidgets[KANA_FORM],
		      XtNresize,True,
		      NULL);

	Accel = XtParseAcceleratorTable(searchAccel);
	XtOverrideTranslations(searchwidgets[SEARCH_ENG_W],Accel);


	XtOverrideTranslations(searchnumbers[F_INPUT],Accel);
	XtOverrideTranslations(searchnumbers[POUND_INPUT],Accel);
	XtOverrideTranslations(searchnumbers[H_INPUT],Accel);
	XtOverrideTranslations(searchnumbers[N_INPUT],Accel);
	XtOverrideTranslations(searchnumbers[U_INPUT],Accel);

	MakeKanainputPopup();
	MakeKanjiinputPopup();
	MakeStrokeinputPopup();
	MakeSKIPInputPopup();
}
