/* $Id: linux_logo.h,v 1.3 1998/07/06 15:51:16 jj Exp $
 * include/linux/linux_logo.h: This is a linux logo
 *                             to be displayed on boot.
 *
 * Created with ppm2logo, (c) 1998 by Bernd Paysan (bernd.paysan@gmx.de)
 *
 * You can put anything here, but:
 * LINUX_LOGO_COLORS has to be less than 224
 * image size has to be 80x80
 * values have to start from 0x20
 * (i.e. RGB(linux_logo_red[0],
 *           linux_logo_green[0],
 *           linux_logo_blue[0]) is color 0x20)
 * BW image has to be 80x80 as well, with MS bit
 * on the left
 * Serial_console ascii image can be any size,
 * but should contain %s to display the version
 */


#include <linux/init.h>
#include <linux/version.h>

#define linux_logo_banner "Linux/UltraSPARC version " UTS_RELEASE

#define LINUX_LOGO_COLORS 221

#ifdef INCLUDE_LINUX_LOGO_DATA

unsigned char linux_logo_red[] __initdata = {
  0xEE, 0xEE, 0xFE, 0xFE, 0xCA, 0x06, 0x3A, 0x02,
  0xFA, 0xEE, 0xDA, 0x26, 0x7A, 0x16, 0x66, 0x4A,
  0xB6, 0xBA, 0x1A, 0x5A, 0x36, 0x8A, 0xFE, 0xFA,
  0xF6, 0xF2, 0xF2, 0xF6, 0xFA, 0xFA, 0xFA, 0xFE,
  0xFE, 0xC6, 0xF6, 0xEE, 0xE2, 0xDA, 0xD6, 0xDA,
  0xDA, 0xDE, 0xE2, 0xFE, 0xEE, 0xD6, 0xDA, 0xE6,
  0xFE, 0x2A, 0x86, 0x2A, 0xA6, 0xF6, 0xE2, 0xDE,
  0xE2, 0xE6, 0xEA, 0xEA, 0xE6, 0xDE, 0xDA, 0xF6,
  0x46, 0xDE, 0xFE, 0xF2, 0xDE, 0xFA, 0xFE, 0xEE,
  0xE6, 0xDA, 0x9A, 0xAA, 0xE6, 0x9E, 0xF2, 0xD6,
  0xE6, 0xEE, 0xFA, 0xF2, 0xE2, 0xDE, 0xE6, 0x56,
  0x3A, 0xEA, 0xEE, 0xE2, 0xF6, 0xDE, 0xD6, 0xFA,
  0xB6, 0xF2, 0x9A, 0xE2, 0xEE, 0xF2, 0xC6, 0xC6,
  0xEE, 0xF6, 0xFA, 0xFA, 0x62, 0xBA, 0xE2, 0xFE,
  0xEA, 0xE2, 0xA6, 0xCE, 0xA6, 0xD2, 0xFA, 0xF6,
  0xD6, 0x86, 0xDE, 0xDE, 0xAA, 0x92, 0xC2, 0xCE,
  0x6A, 0x7E, 0xF2, 0xDA, 0xBE, 0xF6, 0xEA, 0xAA,
  0xEA, 0x56, 0xDA, 0xF6, 0xF2, 0xDA, 0xD6, 0xEE,
  0xE6, 0xEE, 0xF2, 0xC2, 0xF6, 0xEA, 0xEA, 0xEE,
  0xFE, 0x6A, 0xEA, 0xEA, 0xE2, 0x4A, 0x4E, 0x1A,
  0x82, 0xE2, 0xDE, 0x8A, 0x86, 0xEA, 0x9A, 0x7E,
  0x8E, 0x4A, 0x62, 0x5E, 0x72, 0xA2, 0xC6, 0x76,
  0x92, 0x7A, 0x82, 0x82, 0x96, 0xCA, 0x72, 0xAA,
  0xD2, 0xB2, 0xDA, 0x7E, 0xBE, 0x52, 0x32, 0xCA,
  0xCE, 0x0A, 0x8E, 0xF2, 0x96, 0xEA, 0xBA, 0x82,
  0xDE, 0x6E, 0xEE, 0xA2, 0x72, 0x3E, 0x0E, 0x1E,
  0x42, 0x5E, 0x22, 0xE2, 0x4E, 0x62, 0xAE, 0x12,
  0x2E, 0x00, 0x00, 0x00, 0x00
};

unsigned char linux_logo_green[] __initdata = {
  0x9A, 0x96, 0xFE, 0xFE, 0xCA, 0x06, 0x3A, 0x02,
  0xFA, 0x9A, 0xDA, 0x26, 0x7A, 0x16, 0x66, 0x4A,
  0xB6, 0xBA, 0x1A, 0x5A, 0x36, 0x8A, 0xFA, 0xE6,
  0xC6, 0xB2, 0xAE, 0xCE, 0xD6, 0xD2, 0xDA, 0xEA,
  0xFA, 0xC6, 0xCA, 0x8A, 0x3E, 0x1A, 0x0A, 0x0E,
  0x22, 0x2A, 0x42, 0xF2, 0x86, 0x06, 0x1E, 0x66,
  0xEE, 0x2A, 0x86, 0x26, 0xA6, 0xC6, 0x56, 0x36,
  0x46, 0x6A, 0x82, 0x7A, 0x62, 0x3A, 0x12, 0xD2,
  0x46, 0xCE, 0xF6, 0xAA, 0x32, 0xE2, 0xEE, 0xA2,
  0x5A, 0x16, 0x9A, 0xAA, 0xE6, 0x9E, 0xA6, 0x0A,
  0x56, 0x92, 0xEA, 0xA2, 0x46, 0x26, 0x5E, 0x3E,
  0x2A, 0xEA, 0x8E, 0x4E, 0xC2, 0x2E, 0x0E, 0xDE,
  0x7E, 0xBA, 0x6A, 0x4A, 0x92, 0xAA, 0xA6, 0x8E,
  0xCA, 0xD6, 0xE2, 0xDE, 0x46, 0x86, 0xAA, 0xF6,
  0x72, 0x52, 0x76, 0x96, 0x86, 0x9A, 0xD2, 0xBE,
  0xA6, 0x66, 0x3E, 0x36, 0x9A, 0x5E, 0x96, 0xBE,
  0x6A, 0x7A, 0xB6, 0x1E, 0xAA, 0xBA, 0x8A, 0x92,
  0x76, 0x56, 0x1A, 0xF6, 0xAE, 0x26, 0xD6, 0x9E,
  0x5A, 0x8E, 0xBA, 0xC2, 0xBA, 0x6E, 0x7E, 0x9E,
  0xEA, 0x66, 0xD6, 0x86, 0xB2, 0x4A, 0x36, 0x1A,
  0x56, 0xAA, 0xAA, 0x8A, 0x6A, 0xB2, 0x9A, 0x5A,
  0x6A, 0x32, 0x4E, 0x4A, 0x5E, 0x8A, 0xBE, 0x76,
  0x92, 0x72, 0x76, 0x6A, 0x56, 0xA2, 0x4A, 0xAA,
  0xD2, 0xB2, 0xDA, 0x7E, 0xBE, 0x52, 0x32, 0xCA,
  0xCE, 0x0A, 0x8E, 0xF2, 0x96, 0xEA, 0xBA, 0x82,
  0xDE, 0x6E, 0xEE, 0xA2, 0x72, 0x3E, 0x0E, 0x1E,
  0x42, 0x5E, 0x22, 0xE2, 0x4E, 0x62, 0xAE, 0x12,
  0x2E, 0x00, 0x00, 0x00, 0x00
};

unsigned char linux_logo_blue[] __initdata = {
  0xB6, 0xB6, 0xFE, 0xFA, 0xD6, 0x06, 0x3A, 0x02,
  0xFA, 0xBA, 0xEA, 0x26, 0x7A, 0x16, 0x66, 0x4A,
  0xB6, 0xC6, 0x1A, 0x5A, 0x36, 0x8E, 0xFE, 0xEE,
  0xDA, 0xCA, 0xC6, 0xDD, 0xE2, 0xE2, 0xE6, 0xF2,
  0xFA, 0xC6, 0xDA, 0xAE, 0x7A, 0x62, 0x56, 0x59,
  0x66, 0x6A, 0x7C, 0xF6, 0xAE, 0x52, 0x66, 0x96,
  0xF6, 0x2A, 0x86, 0x26, 0xA6, 0xD6, 0x8A, 0x72,
  0x82, 0x96, 0xAA, 0xA2, 0x92, 0x76, 0x5A, 0xDE,
  0x46, 0xC2, 0xFA, 0xC2, 0x72, 0xEA, 0xF2, 0xBE,
  0x8E, 0x5E, 0xA2, 0xB2, 0xE6, 0x9E, 0xC2, 0x52,
  0x8A, 0xB2, 0xF1, 0xBE, 0x7E, 0x6A, 0x91, 0x0A,
  0x06, 0xFE, 0xB2, 0x85, 0xD6, 0x6E, 0x57, 0xE6,
  0x0A, 0x0E, 0x06, 0x82, 0xB6, 0xC6, 0x32, 0x0A,
  0x12, 0x1E, 0xEE, 0xEA, 0x0E, 0x0E, 0x0E, 0xF6,
  0x9E, 0x87, 0x0E, 0x0A, 0x2E, 0x0A, 0xDE, 0xD2,
  0x16, 0x1E, 0x7A, 0x76, 0x9E, 0x06, 0x22, 0xBE,
  0x6A, 0x7E, 0xCD, 0x62, 0xB6, 0xCE, 0xAE, 0x36,
  0xA0, 0x56, 0x5E, 0xF6, 0xCA, 0x67, 0xD6, 0xBA,
  0x8A, 0xAE, 0xCE, 0xC2, 0xD2, 0x9A, 0xA6, 0xBE,
  0xEE, 0x6A, 0xBA, 0xAB, 0x4E, 0x46, 0x06, 0x16,
  0x09, 0x0A, 0x12, 0x8A, 0x6A, 0x0E, 0x9A, 0x06,
  0x0A, 0x06, 0x1E, 0x1E, 0x26, 0x62, 0xAE, 0x76,
  0x92, 0x5E, 0x62, 0x5A, 0x4E, 0x92, 0x06, 0xAA,
  0xD2, 0xB2, 0xDA, 0x7E, 0xBE, 0x52, 0x32, 0xCA,
  0xCE, 0x0A, 0x8E, 0xF2, 0x96, 0xEA, 0xBA, 0x82,
  0xDE, 0x6E, 0xEE, 0xA2, 0x72, 0x3E, 0x0E, 0x1E,
  0x42, 0x5E, 0x22, 0xE2, 0x4E, 0x62, 0xAE, 0x12,
  0x2E, 0x00, 0x00, 0x00, 0x00
};

unsigned char linux_logo[] __initdata = {
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
  0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
  0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
  0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
  0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
  0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
  0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x24, 0x25, 0x25, 0x25, 0x25, 0x25,
  0x26, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x20,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x25, 0x25, 0x26, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x28, 0x21,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x2A,
  0x27, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25,
  0x27, 0x2B, 0x27, 0x27, 0x2C, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x25,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x25,
  0x2D, 0x2E, 0x2F, 0x27, 0x27, 0x30, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x22, 0x31, 0x27,
  0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x27,
  0x32, 0x33, 0x34, 0x32, 0x25, 0x25, 0x24, 0x22,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x22, 0x25, 0x27,
  0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x25, 0x27,
  0x27, 0x25, 0x27, 0x27, 0x27, 0x27, 0x35, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x36, 0x37,
  0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
  0x40, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x23, 0x22, 0x27, 0x25,
  0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x27, 0x25,
  0x25, 0x27, 0x25, 0x25, 0x25, 0x25, 0x2B, 0x41,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x36, 0x42, 0x43, 0x44,
  0x45, 0x46, 0x47, 0x48, 0x49, 0x48, 0x49, 0x4A,
  0x43, 0x3B, 0x3E, 0x4B, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x22, 0x27, 0x27,
  0x27, 0x2D, 0x27, 0x27, 0x27, 0x25, 0x27, 0x27,
  0x25, 0x2D, 0x27, 0x27, 0x27, 0x27, 0x25, 0x31,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x37, 0x4C, 0x48, 0x46, 0x4D,
  0x4D, 0x4D, 0x4D, 0x46, 0x46, 0x46, 0x46, 0x4D,
  0x46, 0x4E, 0x49, 0x4F, 0x38, 0x50, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x22, 0x22, 0x22, 0x25, 0x25,
  0x51, 0x32, 0x51, 0x25, 0x25, 0x27, 0x25, 0x33,
  0x52, 0x26, 0x53, 0x25, 0x25, 0x25, 0x27, 0x54,
  0x22, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x36, 0x55, 0x56, 0x47, 0x4D, 0x4D, 0x4D,
  0x47, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D,
  0x5E, 0x4D, 0x4D, 0x46, 0x48, 0x59, 0x5F, 0x22,
  0x22, 0x22, 0x22, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x22, 0x22, 0x27, 0x2B,
  0x31, 0x31, 0x60, 0x27, 0x25, 0x27, 0x52, 0x24,
  0x61, 0x31, 0x2B, 0x27, 0x27, 0x25, 0x25, 0x54,
  0x22, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x62, 0x63, 0x57, 0x4D, 0x4D, 0x4D, 0x46, 0x64,
  0x5A, 0x65, 0x66, 0x4B, 0x62, 0x62, 0x4B, 0x65,
  0x67, 0x68, 0x69, 0x4D, 0x4D, 0x46, 0x44, 0x55,
  0x36, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x28, 0x28, 0x25, 0x6A,
  0x31, 0x61, 0x22, 0x25, 0x27, 0x51, 0x22, 0x6B,
  0x2D, 0x6C, 0x6B, 0x25, 0x25, 0x27, 0x27, 0x6D,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x6E, 0x48, 0x4D, 0x4D, 0x6F, 0x70, 0x71, 0x3B,
  0x66, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x40, 0x72, 0x73, 0x57, 0x4D, 0x4D, 0x4D, 0x74,
  0x3B, 0x22, 0x22, 0x22, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x28, 0x28, 0x22, 0x22, 0x22, 0x27, 0x61,
  0x27, 0x2E, 0x22, 0x32, 0x34, 0x34, 0x36, 0x27,
  0x32, 0x60, 0x22, 0x27, 0x25, 0x25, 0x27, 0x6A,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x23, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x65,
  0x5D, 0x4D, 0x4D, 0x75, 0x76, 0x3E, 0x40, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x40, 0x42, 0x58, 0x4D, 0x4D, 0x6F,
  0x68, 0x22, 0x22, 0x22, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x22, 0x23, 0x23, 0x22, 0x28, 0x25, 0x41,
  0x27, 0x2D, 0x31, 0x77, 0x77, 0x78, 0x79, 0x25,
  0x27, 0x32, 0x28, 0x25, 0x27, 0x27, 0x25, 0x6A,
  0x22, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x50, 0x62, 0x7A,
  0x47, 0x46, 0x7B, 0x7C, 0x66, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x38, 0x7D, 0x4D, 0x4D,
  0x7E, 0x7F, 0x22, 0x22, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x22, 0x28, 0x25, 0x35,
  0x2F, 0x78, 0x80, 0x81, 0x81, 0x82, 0x81, 0x78,
  0x27, 0x6B, 0x2A, 0x25, 0x25, 0x27, 0x25, 0x35,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x28, 0x23, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x65, 0x3C, 0x83,
  0x6F, 0x74, 0x3B, 0x40, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x62, 0x84, 0x7E, 0x7E,
  0x4E, 0x85, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x22, 0x28, 0x28, 0x22, 0x22, 0x27, 0x2D,
  0x86, 0x87, 0x81, 0x81, 0x88, 0x89, 0x89, 0x89,
  0x81, 0x86, 0x77, 0x27, 0x27, 0x25, 0x27, 0x2E,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x62, 0x4A, 0x46,
  0x44, 0x5F, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x4B, 0x8A, 0x8B, 0x65, 0x4B,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x37, 0x64, 0x49,
  0x6E, 0x7C, 0x22, 0x22, 0x28, 0x28, 0x28, 0x28,
  0x28, 0x22, 0x22, 0x23, 0x22, 0x22, 0x27, 0x8C,
  0x8D, 0x8E, 0x81, 0x88, 0x88, 0x89, 0x89, 0x89,
  0x89, 0x81, 0x81, 0x25, 0x27, 0x25, 0x27, 0x34,
  0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x28, 0x23,
  0x28, 0x23, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x8F, 0x7C, 0x46, 0x46,
  0x67, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x42, 0x90, 0x4F, 0x21, 0x6E, 0x85,
  0x8A, 0x22, 0x22, 0x22, 0x22, 0x62, 0x91, 0x6F,
  0x5C, 0x66, 0x22, 0x22, 0x23, 0x23, 0x23, 0x22,
  0x23, 0x23, 0x23, 0x28, 0x23, 0x22, 0x27, 0x92,
  0x93, 0x8E, 0x81, 0x88, 0x89, 0x89, 0x89, 0x89,
  0x94, 0x93, 0x95, 0x27, 0x25, 0x27, 0x25, 0x25,
  0x22, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x22,
  0x23, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x3E, 0x5C, 0x4D, 0x75,
  0x96, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x97, 0x91, 0x43, 0x3E, 0x62, 0x23, 0x8F,
  0x3E, 0x50, 0x22, 0x22, 0x22, 0x22, 0x90, 0x4D,
  0x74, 0x4B, 0x40, 0x22, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x28, 0x36, 0x22, 0x27, 0x2D,
  0x80, 0x81, 0x88, 0x89, 0x89, 0x89, 0x98, 0x80,
  0x95, 0x95, 0x99, 0x27, 0x25, 0x60, 0x27, 0x25,
  0x6B, 0x23, 0x23, 0x23, 0x23, 0x23, 0x28, 0x23,
  0x28, 0x23, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x3C, 0x9A, 0x7E, 0x90,
  0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x8B, 0x43, 0x55, 0x40, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x23, 0x22, 0x22, 0x22, 0x40, 0x7A, 0x4D,
  0x9B, 0x22, 0x36, 0x22, 0x22, 0x22, 0x23, 0x22,
  0x28, 0x28, 0x22, 0x22, 0x23, 0x22, 0x25, 0x27,
  0x9C, 0x9D, 0x80, 0x80, 0x92, 0x8D, 0x87, 0x87,
  0x9E, 0x9F, 0x31, 0x25, 0x27, 0xA0, 0xA1, 0x27,
  0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x22,
  0x23, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0xA2, 0xA3, 0x49, 0x7C,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x4B,
  0x21, 0x55, 0x36, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x29, 0x4D,
  0x4E, 0x8F, 0x22, 0x22, 0x28, 0x28, 0x28, 0x22,
  0x22, 0x23, 0x23, 0x23, 0x23, 0x36, 0x25, 0x2D,
  0x31, 0x9C, 0x82, 0x87, 0x87, 0x8D, 0x80, 0xA4,
  0x31, 0x24, 0x2A, 0x34, 0x27, 0x2D, 0x2F, 0x25,
  0x27, 0x52, 0x28, 0x28, 0x28, 0x23, 0x28, 0x23,
  0x28, 0x23, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0xA5, 0x4E, 0x4A, 0x7F,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3E,
  0xA6, 0x66, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x8A, 0x22, 0x22, 0x22, 0x63, 0x4D,
  0x5E, 0x8A, 0x22, 0x28, 0x23, 0x22, 0x23, 0x23,
  0x23, 0x28, 0x23, 0x22, 0x40, 0x79, 0x27, 0x2D,
  0x61, 0x31, 0x31, 0x92, 0x82, 0xA7, 0x30, 0x31,
  0x2A, 0x36, 0x28, 0x79, 0x25, 0x25, 0x27, 0x27,
  0x25, 0x25, 0x24, 0x23, 0x23, 0x22, 0x23, 0x22,
  0x23, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x39, 0x4E, 0x91, 0x3F,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x39,
  0xA8, 0x62, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x65, 0x22, 0x22, 0x22, 0x67, 0x4D,
  0x91, 0x22, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x28, 0x28, 0x23, 0x23, 0x25, 0x25, 0x41,
  0x79, 0x9F, 0x30, 0x31, 0x31, 0x31, 0x24, 0x6C,
  0x36, 0x22, 0x22, 0x36, 0xA9, 0x25, 0x25, 0x27,
  0x27, 0x27, 0x35, 0x23, 0x28, 0x23, 0x28, 0x23,
  0x28, 0x23, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x36, 0x3A, 0xAA, 0x5C, 0xAB,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x67,
  0x68, 0x66, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x29, 0x7E,
  0x43, 0x40, 0x22, 0x22, 0x23, 0x22, 0x28, 0x28,
  0x22, 0x22, 0x23, 0x22, 0x2D, 0x27, 0x60, 0x22,
  0x36, 0x79, 0x31, 0x31, 0x31, 0x2A, 0x36, 0x36,
  0x22, 0x23, 0x28, 0x22, 0x22, 0x27, 0x27, 0x25,
  0x25, 0x25, 0x27, 0x41, 0x23, 0x22, 0x23, 0x22,
  0x23, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x36, 0xAC, 0xA3, 0x5A, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21,
  0x5D, 0x65, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x62, 0x8B, 0x40, 0x22, 0x22, 0x4B, 0x76, 0xAD,
  0x39, 0xAB, 0x40, 0x28, 0x28, 0x22, 0x22, 0x23,
  0x23, 0x23, 0x23, 0x33, 0x25, 0x25, 0x36, 0x40,
  0x36, 0x36, 0x36, 0x79, 0x62, 0x22, 0x22, 0x23,
  0x22, 0x22, 0x23, 0x22, 0x22, 0x2B, 0x27, 0x27,
  0x27, 0x25, 0x25, 0x25, 0xAE, 0x22, 0x28, 0x23,
  0x28, 0x23, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x3A, 0x45, 0x29, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xAF,
  0x7D, 0x3D, 0x22, 0x22, 0x22, 0x22, 0x62, 0x40,
  0x8F, 0x37, 0x36, 0x22, 0x36, 0x21, 0x48, 0x4C,
  0x37, 0x22, 0x23, 0x22, 0x23, 0x23, 0x23, 0x28,
  0x23, 0x22, 0x30, 0x27, 0x27, 0xA9, 0x23, 0x23,
  0x23, 0x23, 0x40, 0x36, 0x22, 0x22, 0x23, 0x23,
  0x28, 0x23, 0x23, 0x23, 0x22, 0x35, 0x25, 0x25,
  0x25, 0x27, 0x27, 0x27, 0x2F, 0x22, 0x23, 0x22,
  0x23, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x3A, 0xA3, 0x71, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x55,
  0x9A, 0x7C, 0x22, 0x22, 0x22, 0x62, 0x42, 0x8B,
  0x22, 0x22, 0x22, 0x22, 0x65, 0x91, 0xB0, 0x3E,
  0x62, 0x22, 0x23, 0x23, 0x23, 0x23, 0x23, 0x28,
  0x28, 0x24, 0x25, 0x25, 0x25, 0x31, 0x22, 0x23,
  0x23, 0x23, 0x23, 0x79, 0x28, 0x23, 0x28, 0x23,
  0x23, 0x28, 0x28, 0x6C, 0x79, 0x61, 0x27, 0x27,
  0x25, 0x25, 0x25, 0x27, 0x27, 0x2F, 0xAE, 0x22,
  0x28, 0x23, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x3A, 0xAA, 0x58, 0x8B,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3C,
  0xB1, 0x5A, 0x66, 0x22, 0x22, 0x22, 0x36, 0x40,
  0x22, 0x22, 0x62, 0x3B, 0x76, 0x9A, 0xA2, 0x22,
  0x22, 0x23, 0x23, 0x22, 0x28, 0x28, 0x22, 0x22,
  0x79, 0x27, 0x27, 0x27, 0x27, 0x6A, 0x41, 0x6C,
  0x28, 0x22, 0x23, 0x28, 0x79, 0x28, 0x22, 0x22,
  0xAE, 0x24, 0x24, 0x24, 0x31, 0x2A, 0x27, 0x25,
  0x27, 0x27, 0x27, 0x25, 0x25, 0x27, 0x6D, 0x2A,
  0x23, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x39, 0xA3, 0x7D, 0x42,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x37,
  0xA5, 0x29, 0x39, 0x50, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x4B, 0x21, 0x74, 0x4A, 0xB2, 0x40, 0x22,
  0x22, 0x28, 0x28, 0x22, 0x22, 0x23, 0x23, 0x22,
  0x6D, 0x25, 0x25, 0x25, 0x32, 0x31, 0x79, 0x22,
  0x22, 0x23, 0x23, 0x23, 0x22, 0x23, 0x22, 0x22,
  0x22, 0x36, 0x6C, 0x61, 0xB3, 0x24, 0x6C, 0x25,
  0x32, 0x53, 0x27, 0x27, 0x25, 0x27, 0x27, 0x24,
  0x28, 0x23, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0xB4, 0xA3, 0x45, 0x85,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x4B, 0x3A, 0x4C, 0xA6, 0xA5, 0x3C, 0x3D, 0x39,
  0x5C, 0x57, 0xAD, 0xB5, 0x7F, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x23, 0x23, 0x28, 0x23, 0x36,
  0x2D, 0x27, 0x53, 0x27, 0x54, 0x22, 0x22, 0x22,
  0x28, 0x28, 0x23, 0x28, 0x23, 0x23, 0x28, 0x22,
  0x28, 0x22, 0x22, 0x36, 0x22, 0x2A, 0x24, 0x6A,
  0x27, 0x25, 0x26, 0x25, 0x27, 0x25, 0x25, 0x52,
  0x2A, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x7C, 0xAD, 0x47, 0xA8,
  0x3B, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x72, 0x20, 0x56, 0x90, 0xB6, 0x91, 0x7D,
  0x64, 0x70, 0x3A, 0x66, 0x22, 0x22, 0x22, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x28, 0x23, 0x22,
  0x25, 0x32, 0x25, 0x32, 0x22, 0x28, 0x23, 0x23,
  0x22, 0x23, 0x23, 0x23, 0x28, 0x23, 0x23, 0x22,
  0x22, 0x36, 0x22, 0x22, 0x36, 0x22, 0x2A, 0x2A,
  0x27, 0x27, 0x2D, 0x53, 0x27, 0x27, 0x25, 0x32,
  0x41, 0x22, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x3C, 0x9B, 0x4D, 0xAD,
  0x4A, 0x96, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x3E, 0xB7, 0x7A, 0xB7, 0xB2,
  0x72, 0x8F, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23,
  0x23, 0x22, 0x28, 0x28, 0x22, 0x22, 0x22, 0x24,
  0x27, 0x34, 0x27, 0x24, 0x36, 0x22, 0x28, 0x22,
  0x23, 0x28, 0x22, 0x28, 0x22, 0x23, 0x28, 0x23,
  0x23, 0x23, 0x23, 0x40, 0x22, 0x28, 0x36, 0x22,
  0xA1, 0x32, 0x26, 0x25, 0x25, 0x25, 0x27, 0x27,
  0x31, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x66, 0x56, 0x4D, 0x4D,
  0x45, 0xA5, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x23, 0x66, 0x3F, 0x8F,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x28, 0x28,
  0x28, 0x22, 0x22, 0x23, 0x23, 0x28, 0x36, 0x26,
  0x32, 0x27, 0x2D, 0x22, 0x23, 0x23, 0x23, 0x23,
  0x22, 0x23, 0x22, 0x23, 0x22, 0x22, 0x23, 0x28,
  0x23, 0x23, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x2A, 0x2D, 0x27, 0x27, 0x34, 0x25, 0x25, 0x27,
  0x2E, 0x2A, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0xAF, 0x4D, 0x4D,
  0x7E, 0xA6, 0x36, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x23, 0x23, 0x23, 0x28, 0x23, 0x22, 0x22, 0x27,
  0x53, 0x25, 0x31, 0x23, 0x23, 0x22, 0x28, 0x28,
  0x23, 0x28, 0x23, 0x23, 0x28, 0x23, 0x28, 0x22,
  0x23, 0x28, 0x23, 0x23, 0x23, 0x23, 0x28, 0x22,
  0x28, 0x25, 0x25, 0x25, 0x53, 0x27, 0x27, 0x25,
  0x2D, 0x24, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0xB8, 0x48, 0x4D,
  0x4D, 0x83, 0x3F, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x28, 0x23, 0x22, 0xB9, 0x27,
  0x2D, 0x27, 0x36, 0x28, 0x23, 0x23, 0x22, 0x23,
  0x23, 0x23, 0x28, 0x23, 0x23, 0x22, 0x23, 0x28,
  0x22, 0x22, 0x28, 0x23, 0x23, 0x23, 0x28, 0x22,
  0x36, 0x27, 0x27, 0x25, 0x53, 0x25, 0x27, 0x25,
  0x27, 0x31, 0x28, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x4C, 0x5E,
  0x4D, 0x75, 0xB2, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x22,
  0x28, 0x28, 0x22, 0x22, 0x22, 0x6C, 0x25, 0x32,
  0x25, 0x51, 0x23, 0x22, 0x28, 0x22, 0x23, 0x28,
  0x22, 0x28, 0x22, 0x23, 0x28, 0x23, 0x23, 0x22,
  0x23, 0x28, 0x23, 0x28, 0x28, 0x22, 0x22, 0x23,
  0x22, 0x25, 0x25, 0x27, 0x51, 0x27, 0x25, 0x27,
  0x25, 0x54, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x8A, 0x5C,
  0x4D, 0x4D, 0x74, 0x3C, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x28, 0x22,
  0x22, 0x23, 0x23, 0x28, 0x22, 0x34, 0x27, 0x2D,
  0x27, 0x6B, 0x23, 0x23, 0x23, 0x23, 0x22, 0x23,
  0x22, 0x23, 0x22, 0x22, 0x23, 0x28, 0x23, 0x23,
  0x23, 0x22, 0x22, 0x22, 0x23, 0x23, 0x22, 0x22,
  0x22, 0x2D, 0x25, 0x27, 0x53, 0x27, 0x25, 0x27,
  0x25, 0x35, 0xAE, 0x22, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x42,
  0x57, 0x4D, 0x46, 0x4F, 0x3F, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x23,
  0x23, 0x28, 0x23, 0x22, 0x2A, 0x25, 0x25, 0x51,
  0x25, 0x41, 0x23, 0x22, 0x28, 0x28, 0x23, 0x28,
  0x23, 0x23, 0x28, 0x23, 0x28, 0x22, 0x23, 0x28,
  0x23, 0x23, 0x23, 0x23, 0x28, 0x23, 0x28, 0x23,
  0x28, 0x53, 0x27, 0x25, 0x51, 0x25, 0x27, 0x25,
  0x27, 0x35, 0x2A, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0xB4, 0x7D, 0x4D, 0x7E, 0x43, 0x3F, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x23,
  0x23, 0x28, 0x22, 0x22, 0x31, 0x27, 0x27, 0x34,
  0x25, 0x2A, 0x28, 0x22, 0x22, 0x23, 0x23, 0x23,
  0x28, 0x23, 0x23, 0x22, 0x23, 0x28, 0x22, 0x22,
  0x28, 0x23, 0x23, 0x23, 0x28, 0x23, 0x28, 0x22,
  0x22, 0x51, 0x27, 0x27, 0x27, 0x25, 0x27, 0x25,
  0x27, 0x35, 0x28, 0x22, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x40, 0xA2, 0x64, 0x4D, 0x69, 0x90, 0x8B, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x28, 0x28,
  0x22, 0x22, 0x23, 0x28, 0x9C, 0x25, 0x25, 0x25,
  0x2D, 0x6C, 0x22, 0x23, 0x23, 0x28, 0x22, 0x28,
  0x22, 0x23, 0x28, 0x23, 0x23, 0x22, 0x23, 0x28,
  0x23, 0x28, 0x28, 0x22, 0x22, 0x23, 0x22, 0x23,
  0x22, 0x2D, 0x25, 0x53, 0x25, 0x2D, 0x27, 0x25,
  0x27, 0x35, 0x22, 0x23, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x36, 0x5F, 0x5C, 0xAA, 0x6F, 0x70, 0x8B,
  0x36, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23,
  0x23, 0x28, 0x22, 0x28, 0x2A, 0x99, 0x8E, 0x92,
  0x25, 0x24, 0x22, 0x23, 0x22, 0x23, 0x22, 0x23,
  0x22, 0x22, 0x23, 0x28, 0x23, 0x23, 0x23, 0x22,
  0x22, 0x22, 0x23, 0x23, 0x22, 0x23, 0x23, 0x22,
  0x22, 0x27, 0x25, 0x27, 0x25, 0x25, 0x27, 0x33,
  0x27, 0x6A, 0x36, 0x23, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x37, 0x63, 0x7B, 0xA3, 0x83,
  0x43, 0x66, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x28,
  0x23, 0x22, 0x23, 0x22, 0x61, 0x8E, 0x81, 0x81,
  0x92, 0x27, 0x41, 0x28, 0x23, 0x28, 0x23, 0x23,
  0x28, 0x23, 0x28, 0x22, 0x23, 0x28, 0x23, 0x23,
  0x23, 0x23, 0x28, 0x23, 0x28, 0x23, 0xBA, 0x81,
  0x81, 0x77, 0x27, 0x25, 0x27, 0x27, 0x27, 0x26,
  0x32, 0x54, 0x23, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x62, 0x3C, 0xA6,
  0xB0, 0xBB, 0x42, 0x3F, 0x62, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x28,
  0x23, 0x28, 0x36, 0x6C, 0x87, 0x81, 0x81, 0x81,
  0x81, 0x99, 0x25, 0x6A, 0x22, 0x23, 0x28, 0x23,
  0x23, 0x22, 0x23, 0x28, 0x22, 0x22, 0x28, 0x23,
  0x23, 0x23, 0x28, 0x23, 0x28, 0x23, 0xBC, 0x81,
  0x88, 0x78, 0x27, 0x25, 0x25, 0x25, 0x27, 0x25,
  0x81, 0x94, 0xAE, 0x22, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x40,
  0x37, 0x55, 0xA2, 0x7C, 0x3C, 0x62, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x9F,
  0x9E, 0x87, 0x8D, 0x87, 0x8E, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x78, 0x25, 0xBD, 0x28, 0x22, 0x23,
  0x28, 0x23, 0x23, 0x22, 0x23, 0x28, 0x23, 0x28,
  0x28, 0x22, 0x22, 0x23, 0x22, 0x28, 0xBC, 0x81,
  0x8E, 0xBE, 0x25, 0x27, 0x27, 0x25, 0x27, 0x92,
  0x81, 0x81, 0x31, 0x22, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x40, 0x40, 0x40, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x79, 0x93,
  0x8E, 0x8E, 0x8E, 0x81, 0x81, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x81, 0x27, 0x25, 0xBF, 0x22, 0x22,
  0x23, 0x28, 0x23, 0x23, 0x23, 0x22, 0x22, 0x22,
  0x23, 0x23, 0x22, 0x23, 0x23, 0x24, 0x98, 0x81,
  0x8E, 0x80, 0x27, 0x25, 0x27, 0x25, 0x82, 0x8E,
  0x81, 0x81, 0x54, 0x22, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x30, 0x95,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x88, 0xC0, 0x27, 0x27, 0x27, 0x24,
  0x28, 0x22, 0x23, 0x28, 0x23, 0x23, 0x23, 0x23,
  0x28, 0x23, 0x28, 0x23, 0x22, 0x41, 0x86, 0x8E,
  0x8E, 0x87, 0x8D, 0x80, 0x80, 0x8D, 0x93, 0x81,
  0x81, 0x81, 0x6A, 0x2A, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x79, 0x93,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x81, 0x88, 0x25, 0x25, 0x27, 0x25,
  0x23, 0x28, 0x22, 0x22, 0x28, 0x23, 0x23, 0x23,
  0x28, 0x23, 0x28, 0x22, 0x22, 0x41, 0x9E, 0x8E,
  0x8E, 0x98, 0x93, 0x95, 0x93, 0x8E, 0x81, 0x81,
  0x81, 0x81, 0x8E, 0x31, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x36, 0x95,
  0xC1, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x81, 0x81, 0x9E, 0x27, 0x25, 0x27,
  0x41, 0x22, 0x23, 0x28, 0x23, 0x28, 0x28, 0x22,
  0x22, 0x23, 0x22, 0x28, 0x28, 0x24, 0x92, 0x98,
  0x81, 0x81, 0x8E, 0x8E, 0x8E, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x81, 0x8E, 0x24, 0x6C, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x87,
  0xC1, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x81, 0x81, 0x88, 0x77, 0x25, 0x25,
  0x22, 0x22, 0x23, 0x22, 0x22, 0x22, 0x23, 0x23,
  0x22, 0x22, 0x22, 0x22, 0x36, 0xB9, 0x82, 0x98,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x94, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x40, 0x87,
  0xC1, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x30, 0x22,
  0x22, 0x28, 0x23, 0x23, 0x23, 0x23, 0x28, 0x23,
  0x28, 0x23, 0x23, 0x23, 0x2F, 0x27, 0x82, 0x98,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x31, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x40, 0x87,
  0xC1, 0x81, 0x81, 0x88, 0x81, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x87, 0x28,
  0x22, 0x22, 0x28, 0x23, 0x23, 0x23, 0x28, 0x23,
  0x28, 0x23, 0x6C, 0x27, 0x27, 0x27, 0x82, 0x8E,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x81, 0x81, 0x8E, 0x95, 0x54, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x94, 0x95,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x88, 0x81,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x98, 0x33,
  0x23, 0x28, 0x23, 0x28, 0x28, 0x22, 0x22, 0x23,
  0x79, 0x60, 0x25, 0x25, 0x27, 0x25, 0x82, 0x8E,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x88, 0x81,
  0x81, 0x81, 0x81, 0xC1, 0x8D, 0x6A, 0x31, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x8D, 0x98,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x93, 0x9D,
  0x25, 0x26, 0xA1, 0x6B, 0x52, 0xA1, 0x60, 0x27,
  0x25, 0x27, 0x27, 0x25, 0x25, 0x2D, 0x82, 0x8E,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
  0x81, 0xC2, 0x8D, 0xA1, 0x6B, 0x24, 0xAE, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x80, 0x87,
  0x95, 0xC1, 0xC1, 0xC1, 0x81, 0x81, 0x81, 0x81,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x95, 0x9D,
  0x2D, 0x27, 0x25, 0x27, 0x25, 0x27, 0x25, 0x25,
  0x27, 0x25, 0x25, 0x27, 0x25, 0x2D, 0x82, 0x95,
  0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0xC1, 0x95,
  0x8D, 0xC3, 0x6B, 0x30, 0x2A, 0x36, 0x22, 0x29,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x40, 0x2A, 0xC4,
  0x82, 0x80, 0x80, 0x8D, 0x87, 0x95, 0x95, 0xC1,
  0x81, 0x81, 0x81, 0x81, 0x81, 0xC2, 0x80, 0xC0,
  0xBF, 0x27, 0x25, 0x27, 0x25, 0x27, 0x27, 0x25,
  0x27, 0x27, 0x27, 0x25, 0x27, 0x32, 0x9D, 0x87,
  0xC5, 0x81, 0x81, 0x81, 0xC5, 0x95, 0x87, 0x99,
  0xC6, 0x31, 0x2A, 0x36, 0x22, 0x22, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x23, 0x23,
  0x24, 0x30, 0xC3, 0xA0, 0xC7, 0x9D, 0x82, 0x80,
  0x8D, 0x95, 0xC1, 0xC5, 0xC8, 0xC7, 0xC0, 0x8C,
  0x27, 0x2F, 0x60, 0xA1, 0x2C, 0xA1, 0xA1, 0xA1,
  0xA1, 0xA1, 0xA1, 0x2F, 0x60, 0x53, 0xC0, 0x92,
  0x87, 0x95, 0xC2, 0x95, 0x87, 0x92, 0x33, 0x6B,
  0x41, 0x40, 0x22, 0x22, 0x22, 0x40, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x23, 0x22,
  0x22, 0x40, 0x23, 0x2A, 0x24, 0x31, 0xC6, 0x33,
  0xC9, 0xC9, 0xCA, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE,
  0x6A, 0x6B, 0x24, 0x24, 0x22, 0x22, 0x36, 0x22,
  0x22, 0x36, 0x36, 0x24, 0x24, 0x31, 0x77, 0x9D,
  0x92, 0x92, 0x92, 0x92, 0x9D, 0xCF, 0x6B, 0x2A,
  0x22, 0x36, 0x23, 0x23, 0x23, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x40, 0x23, 0x23, 0x2A, 0x2A,
  0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0x22, 0x22,
  0x24, 0x22, 0x36, 0x36, 0x28, 0x28, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x36, 0x36, 0x79, 0x30, 0xC9,
  0xD6, 0xC0, 0xD6, 0x77, 0x35, 0xD7, 0x40, 0x22,
  0x22, 0x23, 0x23, 0x28, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xAB, 0xD8,
  0xD9, 0xCF, 0x41, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x28, 0xDA, 0x41,
  0xDB, 0x2C, 0x22, 0x22, 0x23, 0x28, 0x23, 0x23,
  0x23, 0x23, 0x3E, 0x91, 0x4D, 0x48, 0x96, 0x22,
  0x40, 0x23, 0x23, 0x22, 0x22, 0x23, 0x40, 0x40,
  0x23, 0x23, 0x23, 0x23, 0x40, 0x22, 0x23, 0x24,
  0x31, 0x54, 0x54, 0x6B, 0x36, 0x23, 0x40, 0x23,
  0x23, 0x28, 0x23, 0x22, 0x28, 0x23, 0x28, 0x21,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x6C, 0x26,
  0x27, 0x2B, 0xDC, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x6C, 0xA0, 0x25,
  0x27, 0xCF, 0x22, 0x22, 0x22, 0x23, 0x28, 0x22,
  0x22, 0x23, 0x63, 0x69, 0x4D, 0x4D, 0xBB, 0x22,
  0x23, 0x22, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x40, 0x23, 0x40, 0x23, 0x40,
  0x23, 0x22, 0x22, 0x40, 0x23, 0x22, 0x23, 0x28,
  0x22, 0x22, 0x22, 0x28, 0x23, 0x22, 0x23, 0x20,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xDD,
  0x27, 0xDE, 0xDF, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xD0, 0x25,
  0x27, 0xC3, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x72, 0x5B, 0x69, 0x56, 0x8A, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x33,
  0x27, 0x34, 0xE0, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x6D, 0xE1,
  0x27, 0xE2, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x72, 0x39, 0x7F, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0xAB, 0xE3, 0xE3, 0x28, 0xA9,
  0x27, 0x26, 0xD8, 0x22, 0x22, 0x22, 0x28, 0xAB,
  0xE3, 0xE3, 0xAB, 0x28, 0x22, 0x22, 0xC6, 0xE1,
  0x27, 0xE4, 0x22, 0x28, 0xAB, 0xE3, 0x28, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x28, 0x22,
  0x22, 0x22, 0x22, 0xAB, 0xAB, 0xE3, 0xAB, 0xAB,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xAB,
  0x22, 0x22, 0xAB, 0xE3, 0xE3, 0x28, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0xE5, 0xE6, 0xD0, 0xE7, 0xCF, 0xCF, 0xC3, 0x26,
  0x27, 0x26, 0xD8, 0x22, 0xE8, 0xD9, 0xE4, 0xDB,
  0xE9, 0xE9, 0xDB, 0xE4, 0xE0, 0x22, 0xC6, 0xE1,
  0x27, 0xC6, 0xAE, 0xE4, 0x2C, 0xCF, 0xD0, 0xD8,
  0x22, 0x22, 0xEA, 0xDF, 0xDC, 0x6D, 0xD8, 0x22,
  0x28, 0xD8, 0xEB, 0xE7, 0xEC, 0xEC, 0xCF, 0x52,
  0x6D, 0xDA, 0x22, 0x22, 0xE5, 0xDF, 0xE6, 0xE2,
  0xE8, 0x6D, 0x2C, 0xE9, 0xEC, 0xE7, 0xE6, 0x28,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xE3,
  0xE7, 0x32, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27,
  0x27, 0xED, 0xAE, 0xE3, 0x2F, 0xEE, 0x27, 0x27,
  0xEE, 0x25, 0x27, 0x27, 0xED, 0xE5, 0xC6, 0xE1,
  0x27, 0xC3, 0xA9, 0x27, 0x27, 0x27, 0x25, 0x60,
  0xAE, 0x22, 0xDA, 0xDD, 0xEF, 0xE1, 0xE0, 0x22,
  0xD9, 0x26, 0x25, 0x27, 0x27, 0x27, 0x27, 0x27,
  0xE1, 0xA0, 0xEA, 0x28, 0xDC, 0xF0, 0x32, 0x2D,
  0x52, 0xEE, 0x27, 0x27, 0x27, 0x27, 0xDE, 0xE5,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xAE,
  0xEF, 0x27, 0xEE, 0xEC, 0x6D, 0xD7, 0xC3, 0x32,
  0x27, 0x26, 0xD8, 0xD9, 0x27, 0x27, 0x34, 0x54,
  0xB3, 0x30, 0xA9, 0x25, 0x25, 0xD7, 0xC6, 0xE1,
  0x27, 0xF1, 0x2D, 0xF2, 0xEF, 0x27, 0x27, 0x25,
  0xCF, 0xAB, 0xF3, 0xF4, 0x27, 0x27, 0xE8, 0x22,
  0xD7, 0xEF, 0x32, 0xF1, 0x2C, 0xDB, 0xF5, 0xE1,
  0x27, 0x51, 0xE8, 0x22, 0xDF, 0xDE, 0x27, 0xE1,
  0x2F, 0x33, 0xEC, 0xA9, 0x27, 0x27, 0xEE, 0xF3,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xEB,
  0x27, 0x27, 0x2C, 0xE3, 0x28, 0x28, 0x28, 0x2F,
  0x27, 0x26, 0xD8, 0xCF, 0x27, 0x25, 0xE2, 0x28,
  0x22, 0x22, 0xF6, 0xEF, 0x25, 0xDB, 0xC6, 0xE1,
  0x27, 0x2B, 0xC3, 0xEA, 0xE3, 0xDC, 0x2D, 0x27,
  0x2D, 0xDA, 0xE5, 0xF5, 0x27, 0x27, 0xE8, 0x22,
  0xF3, 0xC3, 0xF3, 0xAB, 0xAB, 0x28, 0xEA, 0xDD,
  0x27, 0x2D, 0xDA, 0x22, 0xE8, 0x60, 0x27, 0xE1,
  0xCF, 0xAB, 0x28, 0xE5, 0x51, 0x27, 0x25, 0xF3,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xE7,
  0x27, 0x27, 0xF6, 0x22, 0x22, 0x22, 0x22, 0x2F,
  0x27, 0xED, 0xD8, 0xA9, 0x27, 0x2D, 0xD7, 0x22,
  0x22, 0x22, 0xE6, 0x2B, 0x27, 0xEC, 0xC6, 0xE1,
  0x27, 0x2B, 0xDA, 0x22, 0x22, 0xEA, 0xDD, 0x27,
  0x27, 0x30, 0xEA, 0xA0, 0x27, 0x27, 0xE8, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x62, 0xF1,
  0x27, 0x2D, 0xAE, 0x22, 0xF3, 0xF4, 0x27, 0xF7,
  0xD9, 0x22, 0x22, 0xAB, 0x2F, 0x27, 0x25, 0xDA,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xE9,
  0x27, 0x27, 0xE6, 0x22, 0x22, 0x22, 0x22, 0x60,
  0x27, 0xED, 0xD8, 0xF4, 0x27, 0x32, 0xD9, 0x22,
  0x22, 0x22, 0xDC, 0x2B, 0x27, 0xA0, 0xC6, 0xE1,
  0x27, 0xF4, 0x22, 0x22, 0x22, 0xE3, 0xE9, 0x27,
  0x27, 0xEB, 0xE3, 0xE9, 0x27, 0x27, 0xE8, 0x22,
  0x22, 0x22, 0xE3, 0xF3, 0xDA, 0xAE, 0xE0, 0xDD,
  0x27, 0xF7, 0xAE, 0x22, 0x6C, 0xDD, 0x27, 0x32,
  0xDA, 0x22, 0x22, 0xAB, 0xDD, 0x27, 0x25, 0xE8,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xF5,
  0x27, 0x27, 0xDC, 0x22, 0x22, 0x22, 0x22, 0x60,
  0x27, 0x26, 0xAE, 0xF4, 0x27, 0xEE, 0x2F, 0xA0,
  0xA0, 0xA0, 0xF4, 0xEE, 0x27, 0xF5, 0xC6, 0xE1,
  0x27, 0xCF, 0x22, 0x22, 0x22, 0xAB, 0xDB, 0x27,
  0x27, 0xC6, 0xE3, 0xEC, 0x27, 0x27, 0xF3, 0x22,
  0xEA, 0xE4, 0x2F, 0x26, 0x34, 0x34, 0x34, 0x2D,
  0x27, 0x2D, 0xAE, 0x22, 0xE5, 0xDD, 0x27, 0x32,
  0x6C, 0x22, 0x22, 0xAB, 0xA9, 0x27, 0x27, 0xE8,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xF1,
  0x27, 0x25, 0xDC, 0x22, 0x22, 0x22, 0x22, 0x60,
  0x27, 0x26, 0xD8, 0xF4, 0x27, 0x27, 0xE1, 0xF7,
  0xF7, 0xEE, 0xEE, 0xEE, 0xF7, 0xEC, 0xC6, 0xE1,
  0x27, 0xC3, 0x22, 0x22, 0x22, 0xAB, 0xE7, 0x27,
  0x27, 0xC6, 0xE3, 0xEC, 0x27, 0x27, 0x6C, 0xE3,
  0xCF, 0xEE, 0x27, 0xF2, 0xF0, 0xA9, 0xA9, 0x2B,
  0x27, 0x2D, 0xAE, 0x22, 0x6C, 0xF4, 0x27, 0x32,
  0xE5, 0x22, 0x22, 0xAB, 0xDD, 0x27, 0x27, 0xE8,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xF5,
  0x27, 0x27, 0xE6, 0x22, 0x22, 0x22, 0x22, 0xF0,
  0x27, 0xED, 0xD8, 0xDD, 0x27, 0xEE, 0xEC, 0x54,
  0x54, 0xD7, 0xD7, 0x54, 0xD7, 0xD8, 0xC6, 0xE1,
  0x27, 0xE2, 0x22, 0x22, 0x22, 0x28, 0xE7, 0x27,
  0x27, 0xD7, 0xE3, 0xEC, 0x27, 0x27, 0x6C, 0xD8,
  0x26, 0x27, 0x51, 0xF3, 0x22, 0x22, 0xAB, 0xA0,
  0x27, 0x2D, 0xAE, 0x22, 0x6C, 0xDD, 0x27, 0xEF,
  0x6C, 0x22, 0x22, 0xAB, 0xA9, 0x27, 0x25, 0xE8,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xA0,
  0x27, 0x27, 0xEB, 0x22, 0x22, 0x22, 0x22, 0x26,
  0x27, 0xED, 0xD8, 0x33, 0x27, 0xF7, 0xD7, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xC6, 0xE1,
  0x27, 0xE2, 0x22, 0x22, 0x22, 0xAB, 0x2C, 0x27,
  0x27, 0x41, 0xEA, 0xA0, 0x27, 0x27, 0x6C, 0xB3,
  0x51, 0x27, 0xF4, 0x22, 0x22, 0x22, 0xAB, 0xF1,
  0x27, 0x2D, 0xAE, 0x22, 0x6C, 0xF4, 0x27, 0x32,
  0xE5, 0x22, 0x22, 0xAB, 0xDD, 0x27, 0x27, 0xE8,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xCF,
  0x27, 0x27, 0xCF, 0x28, 0x22, 0x22, 0x22, 0xDE,
  0x27, 0x26, 0xD8, 0xF5, 0x27, 0xF7, 0xEB, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xC6, 0xE1,
  0x27, 0xE2, 0x22, 0x22, 0x22, 0xE3, 0xCF, 0x27,
  0xEF, 0xF3, 0xE3, 0xE9, 0x27, 0x27, 0xE5, 0xDC,
  0xF2, 0x27, 0x33, 0x22, 0x22, 0x22, 0xAB, 0xF0,
  0x27, 0x2D, 0xAE, 0x22, 0xF3, 0xF4, 0x27, 0xEF,
  0x6C, 0x22, 0x22, 0xAB, 0xA9, 0x27, 0x25, 0xE8,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xE7,
  0x27, 0x27, 0x60, 0xAB, 0x22, 0x22, 0x28, 0x2B,
  0x27, 0x26, 0xD8, 0x2C, 0x27, 0xE1, 0xE4, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xC6, 0xE1,
  0x27, 0xE2, 0x22, 0x22, 0x22, 0xEA, 0x33, 0x27,
  0xA0, 0xE3, 0xE5, 0x2E, 0x27, 0x27, 0xEA, 0xE6,
  0xF2, 0x27, 0xA9, 0x22, 0x22, 0x22, 0xAE, 0xE1,
  0x27, 0x2D, 0xAE, 0x22, 0xF3, 0x2F, 0x27, 0x32,
  0xE5, 0x22, 0x22, 0xAB, 0xDD, 0x27, 0x27, 0xE8,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xEB,
  0x27, 0x27, 0x25, 0xD7, 0xAE, 0xAE, 0xD9, 0x2D,
  0x27, 0xF8, 0x41, 0xF6, 0x27, 0x27, 0xDD, 0xE0,
  0xE3, 0xAB, 0x28, 0x28, 0xE5, 0xE5, 0xC6, 0xE1,
  0x27, 0xE2, 0x22, 0x22, 0x22, 0xD8, 0xEF, 0xF2,
  0x41, 0x22, 0xE5, 0x33, 0x27, 0x27, 0xEA, 0x41,
  0x51, 0x27, 0xF2, 0xE0, 0xE8, 0xD8, 0xDD, 0xF7,
  0x27, 0x2D, 0xAE, 0x22, 0xDA, 0x60, 0x27, 0xEF,
  0x6C, 0x22, 0x22, 0xAB, 0xA9, 0x27, 0x25, 0xE8,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xB3,
  0xE1, 0x27, 0x27, 0xEE, 0xF8, 0xF8, 0xF2, 0x2B,
  0x27, 0xEF, 0xE6, 0xE5, 0x2B, 0x27, 0x25, 0x26,
  0xA0, 0xDB, 0x52, 0xE7, 0xF1, 0xEB, 0xD0, 0x25,
  0x27, 0xA9, 0xF6, 0xF6, 0xC6, 0xA9, 0xE1, 0xCF,
  0xEA, 0x22, 0x6C, 0xDD, 0x27, 0x27, 0xEA, 0xF3,
  0x2F, 0x27, 0x25, 0x51, 0xF0, 0x51, 0xF2, 0xDD,
  0x27, 0xEE, 0xD8, 0x22, 0xDA, 0xF0, 0x27, 0x32,
  0xE5, 0x22, 0x22, 0xE3, 0x60, 0x27, 0x27, 0xE8,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xE5,
  0xF1, 0x25, 0x27, 0x27, 0x27, 0x27, 0xF5, 0x2F,
  0x27, 0xE1, 0xC6, 0x28, 0xF6, 0x34, 0x25, 0x27,
  0x27, 0x27, 0x27, 0x27, 0xE1, 0x54, 0xC3, 0x25,
  0x27, 0xE1, 0x32, 0x2D, 0xE1, 0x27, 0x60, 0xD8,
  0x22, 0x22, 0xDA, 0xF0, 0x27, 0x27, 0xDC, 0x28,
  0xD9, 0xDE, 0x27, 0x27, 0x27, 0x25, 0xC3, 0xE9,
  0x27, 0x27, 0x30, 0x22, 0xE0, 0x34, 0x27, 0x32,
  0xAE, 0x22, 0x22, 0xAB, 0x34, 0x27, 0x27, 0xD8,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21,
  0x29, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x6C, 0xF6, 0x52, 0xDB, 0x52, 0xD7, 0xF3, 0xB3,
  0xD7, 0xD7, 0xD8, 0x22, 0x28, 0xDA, 0xD9, 0xE2,
  0x2C, 0xE9, 0xE9, 0xCF, 0xEB, 0xEA, 0x6C, 0xD9,
  0xC3, 0xEC, 0xE9, 0xE9, 0xEC, 0xC6, 0xF3, 0x22,
  0x22, 0x22, 0xEA, 0xE6, 0xE6, 0xDC, 0xAE, 0x22,
  0x28, 0xDA, 0xC6, 0xE7, 0xE2, 0x30, 0xEA, 0xE0,
  0xD7, 0xF6, 0xAE, 0x22, 0xE5, 0xE6, 0x30, 0xD9,
  0x6C, 0x22, 0x22, 0x28, 0x30, 0xB3, 0x30, 0x6C,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
  0x21, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x20,
  0x20, 0x21, 0x21, 0x29, 0x29, 0x21, 0x21, 0x21,
  0x20, 0x20, 0x21, 0x21, 0x21, 0x29, 0x20, 0x20,
  0x20, 0x20, 0x21, 0x29, 0x20, 0x21, 0x29, 0x29,
  0x21, 0x21, 0x20, 0x29, 0x29, 0x29, 0x21, 0x20,
  0x29, 0x29, 0x29, 0x20, 0x29, 0x21, 0x20, 0x29,
  0x21, 0x29, 0x21, 0x21, 0x21, 0x21, 0x20, 0x21,
  0x20, 0x21, 0x21, 0x29, 0x20, 0x29, 0x21, 0x21,
  0x29, 0x29, 0x21, 0x21, 0x29, 0x21, 0x21, 0x29,
  0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x29, 0x21,
};

unsigned char linux_logo_bw[] __initdata = {
  0x32, 0x35, 0x35, 0x0A, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
};

unsigned char linux_logo16_red[] __initdata = {
  0x00, 0x90, 0xD9, 0xE8, 0xFD, 0xD9, 0x05, 0x32,
  0xE2, 0x83, 0xC9, 0xE0, 0xDA, 0xD6, 0xD3, 0xF2
};

unsigned char linux_logo16_green[] __initdata = {
  0x00, 0x90, 0x9F, 0x8A, 0xFD, 0xCA, 0x05, 0x30,
  0xD6, 0x75, 0xB8, 0x3E, 0x1D, 0x08, 0x9B, 0xBA
};

unsigned char linux_logo16_blue[] __initdata = {
  0x00, 0x90, 0x9C, 0x9D, 0xFB, 0xC2, 0x05, 0x2B,
  0xC8, 0x59, 0xC0, 0x79, 0x62, 0x54, 0x0A, 0x0E
};

unsigned char linux_logo16[] __initdata = {
  0x23, 0x23, 0x22, 0x32, 0x32, 0x23, 0x23, 0x22,
  0x32, 0x32, 0x23, 0x23, 0x22, 0x32, 0x32, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x56, 0x66, 0x66, 0x74, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x46, 0x66, 0x66, 0x66, 0x66, 0x74, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x48,
  0x66, 0x66, 0x66, 0x66, 0x67, 0x66, 0x94, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x46,
  0x66, 0x66, 0x66, 0x66, 0x69, 0x76, 0x6A, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xA6,
  0x66, 0x66, 0x66, 0x66, 0x69, 0x77, 0x66, 0x54,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x66,
  0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x94,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x48,
  0x55, 0x28, 0x88, 0x84, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x66,
  0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x75,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x48, 0x3B,
  0xCD, 0xDC, 0xCC, 0xCB, 0x38, 0x84, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x66,
  0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x6A,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x3C, 0xDD,
  0xDD, 0xDC, 0xDC, 0xDD, 0xDC, 0xBB, 0x54, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x66,
  0x76, 0x76, 0x66, 0x69, 0x97, 0x76, 0x66, 0x6A,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x5B, 0xDD, 0xDD,
  0xDB, 0xB3, 0x33, 0xBB, 0xDD, 0xDC, 0xC3, 0x54,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x67,
  0xAA, 0x76, 0x66, 0x95, 0x8A, 0x76, 0x66, 0x6A,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x44, 0x44, 0x42, 0xBD, 0xDD, 0xDB,
  0x38, 0x88, 0x44, 0x44, 0x2B, 0xCD, 0xDD, 0xB5,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x62,
  0xA8, 0x46, 0x67, 0x4A, 0x68, 0x26, 0x66, 0x69,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x44, 0x44, 0x2C, 0xDD, 0xDB, 0x38,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x2B, 0xDD, 0xDB,
  0x84, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x65,
  0x69, 0x46, 0x77, 0x46, 0x77, 0x46, 0x66, 0x6A,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x44, 0x48, 0xBD, 0xDC, 0x38, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x45, 0xBD, 0xDC,
  0xB4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x65,
  0x66, 0x57, 0x77, 0x86, 0x66, 0x46, 0x66, 0x69,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x44, 0x43, 0xDD, 0xB5, 0x84, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x5C, 0xDD,
  0xC8, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x69,
  0x77, 0xEF, 0xF9, 0xF7, 0x6A, 0x86, 0x66, 0x69,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x48, 0x8B, 0xCB, 0x84, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43, 0xDC,
  0xC2, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x67,
  0xEE, 0xFF, 0xF8, 0xF8, 0xFE, 0x76, 0x66, 0x69,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x44, 0xBD, 0xB8, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x88, 0x44, 0x44, 0x44, 0x48, 0xBC,
  0x28, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x67,
  0xEE, 0xFF, 0xF4, 0xF8, 0x8F, 0xF6, 0x66, 0x67,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x45, 0xDD, 0x24, 0x44, 0x44, 0x44,
  0x44, 0x53, 0x33, 0x22, 0x84, 0x44, 0x44, 0xBC,
  0xB4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x69,
  0xEF, 0xFF, 0x8F, 0x4F, 0xEE, 0xE6, 0x66, 0x66,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x8B, 0xCC, 0x84, 0x44, 0x44, 0x44,
  0x45, 0xB3, 0x54, 0x44, 0x84, 0x44, 0x44, 0x3D,
  0xB4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x66,
  0xEF, 0xF4, 0x88, 0xFE, 0xEE, 0x96, 0x67, 0x66,
  0xA4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x8B, 0xD3, 0x44, 0x44, 0x44, 0x44,
  0x83, 0x54, 0x44, 0x44, 0x44, 0x44, 0x44, 0x3D,
  0xB4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x66,
  0x29, 0x9E, 0xE9, 0xE9, 0xEA, 0xA6, 0x69, 0x96,
  0x64, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x5C, 0xC5, 0x44, 0x44, 0x44, 0x44,
  0x35, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x2D,
  0xC4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x66,
  0xA2, 0x9E, 0x9E, 0x92, 0xAA, 0x87, 0x66, 0x76,
  0x69, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x5C, 0xB8, 0x44, 0x44, 0x44, 0x48,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x84, 0x44, 0x2D,
  0xC8, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x66,
  0xAA, 0x29, 0x9E, 0xAA, 0x84, 0x44, 0x66, 0x66,
  0x66, 0x54, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x2C, 0xB4, 0x44, 0x44, 0x44, 0x4A,
  0x38, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x2D,
  0xB4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x46, 0x65,
  0x4A, 0xAA, 0x2A, 0x58, 0x44, 0x44, 0x96, 0x66,
  0x66, 0x94, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x2B, 0xB4, 0x44, 0x44, 0x44, 0x42,
  0xB4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x3C,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x66, 0x74,
  0x48, 0xAA, 0xA8, 0x44, 0x44, 0x44, 0x46, 0x66,
  0x66, 0x65, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0xAC, 0x34, 0x44, 0x44, 0x44, 0x43,
  0xB8, 0x44, 0x44, 0x44, 0x48, 0x44, 0x44, 0xBB,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x49, 0x66, 0x44,
  0x44, 0x48, 0x44, 0x44, 0x44, 0x44, 0x47, 0x66,
  0x66, 0x66, 0x84, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x2C, 0x24, 0x44, 0x44, 0x44, 0x42,
  0xB8, 0x44, 0x44, 0x44, 0x48, 0x44, 0x42, 0xC3,
  0x44, 0x44, 0x44, 0x44, 0x44, 0xA6, 0x69, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x49, 0x66,
  0x66, 0x66, 0x74, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0xAC, 0x34, 0x44, 0x44, 0x44, 0x45,
  0xB5, 0x44, 0x44, 0x58, 0x44, 0x44, 0x8B, 0xB4,
  0x84, 0x44, 0x44, 0x44, 0x45, 0x66, 0x6A, 0x44,
  0x44, 0x48, 0x44, 0x44, 0x44, 0x48, 0x45, 0x66,
  0x66, 0x66, 0x67, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x2C, 0xB8, 0x44, 0x44, 0x44, 0x48,
  0x33, 0x44, 0x44, 0x44, 0x44, 0x48, 0x3B, 0xA4,
  0x44, 0x44, 0x44, 0x44, 0x86, 0x66, 0x69, 0x58,
  0x44, 0x44, 0x84, 0x44, 0x85, 0x55, 0xA8, 0x66,
  0x66, 0x66, 0x66, 0x28, 0x44, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x5C, 0xB8, 0x44, 0x44, 0x44, 0x48,
  0x53, 0x24, 0x44, 0x44, 0x44, 0x3B, 0xBA, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x26, 0x66, 0x7A, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x85, 0x55, 0x86,
  0x77, 0x66, 0x66, 0x6A, 0x44, 0x44, 0x44, 0x43,
  0x34, 0x44, 0xAC, 0xC2, 0x44, 0x44, 0x44, 0x44,
  0x42, 0x33, 0xA8, 0x85, 0xBB, 0xC3, 0x84, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x66, 0x76, 0xA4, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x48, 0x89,
  0x66, 0x76, 0x66, 0x69, 0x84, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x5C, 0xD3, 0x84, 0x44, 0x44, 0x44,
  0x44, 0x3B, 0x33, 0xBB, 0xBB, 0x24, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x66, 0x66, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x88,
  0x66, 0x77, 0x66, 0x67, 0x54, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x8B, 0xDC, 0xB8, 0x44, 0x44, 0x44,
  0x44, 0x48, 0x33, 0x3A, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x45, 0x67, 0x65, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x96, 0x76, 0x66, 0x66, 0xA4, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x4B, 0xDD, 0xCA, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x47, 0x76, 0x64, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x87, 0x66, 0x76, 0x66, 0x98, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x42, 0xDD, 0xD3, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x46, 0x76, 0xA4, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x46, 0x66, 0x76, 0x66, 0x65, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x44, 0xCD, 0xDB, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x96, 0x66, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x46, 0x66, 0x76, 0x66, 0x6A, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x44, 0x3C, 0xDC, 0x54, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x48, 0x67, 0x67, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x46, 0x66, 0x76, 0x66, 0x6A, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x44, 0x8B, 0xCD, 0xB8, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x47, 0x66, 0x6A, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x46, 0x66, 0x76, 0x66, 0x69, 0x84, 0x44, 0x43,
  0x34, 0x44, 0x44, 0x45, 0xBD, 0xCB, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x86, 0x67, 0x6A, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x47, 0x66, 0x76, 0x66, 0x69, 0x84, 0x44, 0x42,
  0x24, 0x44, 0x44, 0x44, 0xAC, 0xDC, 0x34, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0xA6, 0x67, 0x68, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x47, 0x66, 0x66, 0x66, 0x69, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x44, 0x44, 0x42, 0xBD, 0xD3, 0x84,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x26, 0x66, 0x78, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x46, 0x67, 0x66, 0x66, 0x69, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x8B, 0xCD, 0xB4,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x59, 0xE9, 0x65, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x46, 0x66, 0x66, 0x69, 0x6A, 0x44, 0x44, 0x43,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0xAB, 0xCB,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x5F, 0xFF, 0x96, 0x54, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x8F,
  0xF7, 0x66, 0x66, 0x67, 0x6A, 0x44, 0x44, 0x42,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x83,
  0xB3, 0x84, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x48, 0xEF, 0xFF, 0xF9, 0x69, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xFF,
  0xF7, 0x66, 0x66, 0x66, 0xF9, 0x84, 0x44, 0x43,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x85, 0x25, 0x84, 0x44, 0x44, 0x44, 0x44, 0x4A,
  0xEE, 0x9E, 0xEF, 0xFF, 0xFF, 0x76, 0x74, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xFF,
  0xF7, 0x66, 0x66, 0x69, 0xFF, 0xA4, 0x44, 0x42,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x8E,
  0xEF, 0xEF, 0xFF, 0xFF, 0xFF, 0xF6, 0x67, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x4A, 0xEF,
  0xF9, 0x66, 0x66, 0x9F, 0xFF, 0xA4, 0x44, 0x43,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xAE,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x66, 0x6A,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x45, 0xEF,
  0xEE, 0x9E, 0x9E, 0xEF, 0xFF, 0x98, 0x44, 0x42,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x4E,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x66, 0x66,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x45, 0xEE,
  0xFE, 0xEE, 0xEE, 0xFF, 0xFF, 0xFA, 0x44, 0x43,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x4E,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE6, 0x66,
  0x54, 0x44, 0x44, 0x44, 0x44, 0x44, 0x45, 0x9E,
  0xFF, 0xEE, 0xEF, 0xFF, 0xFF, 0xFF, 0xA4, 0x42,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x4E,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x66,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x49, 0x9E,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x43,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x4E,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA4,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x76, 0x9F,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA2,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x49,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE4,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x86, 0x66, 0x9E,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xA3,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0xEE,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
  0x44, 0x44, 0x44, 0x44, 0x47, 0x66, 0x66, 0x9F,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xE9, 0xA2,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x9E,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE9,
  0x67, 0x9A, 0x99, 0x76, 0x66, 0x66, 0x66, 0x9E,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xE9, 0xAA, 0x82,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x9E,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE9,
  0x76, 0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x9E,
  0xFF, 0xFF, 0xFF, 0xEE, 0xE9, 0xAA, 0x84, 0x43,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x89,
  0x99, 0x9E, 0xEE, 0xEF, 0xFF, 0xFF, 0xFE, 0x99,
  0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xBE,
  0xFF, 0xFF, 0xFE, 0xE9, 0x9A, 0x84, 0x44, 0x42,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x5A, 0x97, 0x99, 0x99, 0xEE, 0xEF, 0x99, 0xB7,
  0x67, 0x79, 0x99, 0x99, 0x99, 0x97, 0x77, 0x99,
  0xEE, 0xEE, 0xE9, 0x7A, 0x54, 0x44, 0x44, 0x43,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x48, 0x52, 0x27, 0x77, 0x97, 0x79, 0x95,
  0x2A, 0x85, 0x44, 0x44, 0x44, 0x48, 0x8A, 0x79,
  0x99, 0x99, 0x99, 0xA8, 0x44, 0x44, 0x44, 0x42,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x88, 0x99, 0x99, 0x92, 0x44,
  0xA4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x48, 0x27,
  0xB9, 0xB7, 0x9A, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x48,
  0xA9, 0xA4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x8A,
  0x99, 0x44, 0x44, 0x44, 0x44, 0x8B, 0xDC, 0x84,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x45,
  0xAE, 0xAA, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x87,
  0x67, 0xA4, 0x44, 0x44, 0x44, 0x44, 0x48, 0x96,
  0x69, 0x44, 0x44, 0x44, 0x44, 0x2C, 0xDD, 0x34,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x47,
  0x67, 0x54, 0x44, 0x44, 0x44, 0x44, 0x44, 0x96,
  0x69, 0x44, 0x44, 0x44, 0x44, 0x43, 0xDB, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x34, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x49,
  0x67, 0x54, 0x44, 0x44, 0x44, 0x44, 0x44, 0xA6,
  0x69, 0x44, 0x44, 0x44, 0x44, 0x44, 0xA8, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
  0x24, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x47,
  0x67, 0x84, 0x44, 0x44, 0x44, 0x44, 0x44, 0x26,
  0x6A, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
  0x44, 0x48, 0x44, 0x44, 0x44, 0x44, 0x44, 0x42,
  0x34, 0x44, 0x44, 0x44, 0x4A, 0x99, 0x99, 0x27,
  0x67, 0x84, 0x8A, 0x99, 0x99, 0x99, 0xA4, 0xA6,
  0x69, 0x89, 0x99, 0x95, 0x44, 0x85, 0xA2, 0x54,
  0x45, 0xA9, 0x99, 0x99, 0x28, 0x44, 0x85, 0xA9,
  0x89, 0x99, 0x99, 0xA4, 0x44, 0x44, 0x44, 0x43,
  0x24, 0x44, 0x44, 0x44, 0x97, 0x66, 0x66, 0x66,
  0x67, 0x84, 0x77, 0x66, 0x66, 0x66, 0x74, 0x96,
  0x69, 0x96, 0x66, 0x67, 0x84, 0x89, 0x66, 0x54,
  0xA7, 0x66, 0x66, 0x66, 0x69, 0x44, 0xA7, 0x77,
  0x97, 0x66, 0x66, 0x74, 0x44, 0x44, 0x44, 0x42,
  0x34, 0x44, 0x44, 0x48, 0x66, 0x69, 0x9A, 0x97,
  0x67, 0x5A, 0x66, 0x7A, 0xAA, 0x96, 0x6A, 0xA6,
  0x69, 0x67, 0x76, 0x66, 0x98, 0x47, 0x66, 0x84,
  0xA7, 0x69, 0x99, 0x96, 0x67, 0x84, 0x87, 0x66,
  0x97, 0x99, 0x66, 0x68, 0x44, 0x44, 0x44, 0x43,
  0x24, 0x44, 0x44, 0x4A, 0x66, 0x94, 0x44, 0x47,
  0x67, 0x89, 0x66, 0x94, 0x44, 0xA6, 0x69, 0x96,
  0x67, 0x94, 0x85, 0x66, 0x78, 0x49, 0x66, 0x84,
  0x89, 0x84, 0x44, 0x87, 0x66, 0x84, 0x87, 0x66,
  0x94, 0x48, 0x76, 0x68, 0x44, 0x44, 0x44, 0x42,
  0x34, 0x44, 0x44, 0x49, 0x66, 0xA4, 0x44, 0x49,
  0x67, 0x59, 0x66, 0xA4, 0x44, 0xA7, 0x69, 0xA6,
  0x67, 0x84, 0x44, 0x76, 0x6A, 0x89, 0x66, 0x84,
  0x44, 0x44, 0x44, 0x49, 0x66, 0x84, 0x89, 0x66,
  0xA4, 0x44, 0x76, 0x68, 0x44, 0x44, 0x44, 0x43,
  0x24, 0x44, 0x44, 0x49, 0x66, 0xA4, 0x44, 0x47,
  0x67, 0x87, 0x67, 0xA4, 0x44, 0xA7, 0x69, 0x96,
  0x67, 0x44, 0x44, 0x96, 0x6A, 0x89, 0x66, 0x84,
  0x44, 0x48, 0x88, 0x57, 0x67, 0x84, 0x87, 0x67,
  0x54, 0x44, 0x96, 0x68, 0x44, 0x44, 0x44, 0x42,
  0x34, 0x44, 0x44, 0x49, 0x66, 0xA4, 0x44, 0x47,
  0x67, 0x87, 0x66, 0x79, 0x99, 0x76, 0x69, 0xA6,
  0x69, 0x44, 0x44, 0x96, 0x69, 0x49, 0x66, 0x84,
  0x8A, 0x77, 0x77, 0x77, 0x66, 0x84, 0x47, 0x67,
  0x84, 0x44, 0x76, 0x68, 0x44, 0x44, 0x44, 0x43,
  0x24, 0x44, 0x44, 0x47, 0x66, 0xA4, 0x44, 0x47,
  0x77, 0x89, 0x66, 0x66, 0x66, 0x76, 0x69, 0x96,
  0x69, 0x44, 0x44, 0x96, 0x6A, 0x89, 0x66, 0x84,
  0x96, 0x67, 0x79, 0x77, 0x66, 0x84, 0x89, 0x66,
  0x44, 0x44, 0x96, 0x68, 0x44, 0x44, 0x44, 0x42,
  0x34, 0x44, 0x44, 0x49, 0x66, 0xA4, 0x44, 0x47,
  0x67, 0x87, 0x66, 0x9A, 0xAA, 0xAA, 0xA8, 0xA6,
  0x69, 0x44, 0x44, 0x96, 0x6A, 0x49, 0x66, 0x88,
  0x76, 0x78, 0x44, 0x49, 0x66, 0x84, 0x47, 0x67,
  0x84, 0x44, 0x76, 0x68, 0x44, 0x44, 0x44, 0x43,
  0x24, 0x44, 0x44, 0x49, 0x66, 0x24, 0x44, 0x47,
  0x67, 0x89, 0x66, 0xA4, 0x48, 0x44, 0x44, 0x97,
  0x62, 0x44, 0x44, 0x96, 0x6A, 0x89, 0x66, 0x4A,
  0x76, 0x74, 0x44, 0x49, 0x67, 0x54, 0x89, 0x66,
  0x44, 0x44, 0x96, 0x68, 0x44, 0x44, 0x44, 0x42,
  0x34, 0x44, 0x44, 0x49, 0x66, 0x94, 0x44, 0x47,
  0x67, 0x59, 0x67, 0x94, 0x44, 0x44, 0x44, 0xA6,
  0x69, 0x44, 0x44, 0x96, 0x78, 0x49, 0x66, 0x4A,
  0x76, 0x94, 0x44, 0x47, 0x66, 0x84, 0x87, 0x67,
  0x84, 0x44, 0x76, 0x68, 0x44, 0x44, 0x44, 0x43,
  0x24, 0x44, 0x44, 0x49, 0x66, 0x74, 0x44, 0x47,
  0x67, 0x89, 0x66, 0xA4, 0x44, 0x44, 0x44, 0x96,
  0x69, 0x44, 0x48, 0x96, 0x98, 0x89, 0x66, 0x8A,
  0x76, 0x74, 0x44, 0x56, 0x67, 0x54, 0x89, 0x66,
  0x44, 0x44, 0x96, 0x68, 0x44, 0x44, 0x44, 0x42,
  0x34, 0x44, 0x44, 0x42, 0x66, 0x6A, 0x88, 0xA6,
  0x67, 0xAA, 0x66, 0x75, 0x84, 0x44, 0x48, 0xA6,
  0x69, 0x44, 0x48, 0x67, 0xA4, 0x89, 0x66, 0x4A,
  0x76, 0x75, 0x85, 0x96, 0x66, 0x84, 0x87, 0x67,
  0x84, 0x44, 0x76, 0x68, 0x44, 0x44, 0x44, 0x43,
  0x24, 0x44, 0x44, 0x4A, 0x66, 0x66, 0x77, 0x77,
  0x67, 0xA8, 0x76, 0x67, 0x99, 0x99, 0x99, 0xA6,
  0x69, 0xAA, 0x99, 0x69, 0x44, 0x87, 0x66, 0x88,
  0x76, 0x67, 0x77, 0x69, 0x66, 0x84, 0x87, 0x66,
  0x44, 0x44, 0x76, 0x68, 0x44, 0x44, 0x44, 0x42,
  0x34, 0x44, 0x44, 0x48, 0x96, 0x66, 0x66, 0x97,
  0x66, 0x94, 0xA7, 0x66, 0x66, 0x66, 0x6A, 0x96,
  0x66, 0x76, 0x66, 0x75, 0x44, 0x47, 0x66, 0x54,
  0xA7, 0x66, 0x66, 0x99, 0x66, 0xA4, 0x87, 0x66,
  0x84, 0x44, 0x76, 0x65, 0x44, 0x44, 0x44, 0x43,
  0x24, 0x44, 0x44, 0x44, 0x8A, 0x99, 0x9A, 0x8A,
  0xAA, 0x84, 0x48, 0xA9, 0x99, 0x99, 0xA8, 0x4A,
  0x99, 0x99, 0x9A, 0x84, 0x44, 0x4A, 0xAA, 0x84,
  0x48, 0x29, 0x95, 0x4A, 0xAA, 0x54, 0x4A, 0xAA,
  0x84, 0x44, 0xAA, 0xA4, 0x44, 0x44, 0x44, 0x42,
  0x23, 0x22, 0x23, 0x22, 0x22, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x22, 0x32, 0x22, 0x22,
  0x22, 0x23, 0x22, 0x22, 0x23, 0x22, 0x22, 0x22,
  0x22, 0x22, 0x23, 0x22, 0x22, 0x32, 0x22, 0x22,
  0x22, 0x22, 0x22, 0x22, 0x32, 0x23, 0x23, 0x23,
};

#else

/* prototypes only */
extern unsigned char linux_logo_red[];
extern unsigned char linux_logo_green[];
extern unsigned char linux_logo_blue[];
extern unsigned char linux_logo[];
extern unsigned char linux_logo_bw[];
extern unsigned char linux_logo16_red[];
extern unsigned char linux_logo16_green[];
extern unsigned char linux_logo16_blue[];
extern unsigned char linux_logo16[];

#endif
