/*
 * ******************************************************************
 * $Id: common.h,v 1.5 2000/12/02 01:17:32 orjana Exp $
 * Filename:      common.h
 * Status:        Experimental, do not distribute.
 * Author:        rjan Nygaard Austvold <austvold@acm.org>
 * Created at:    Mon Nov 24 21:13:05 2000
 * Modified at:   Fri Dec  1 15:14:38 2000
 * Modified by:   rjan Nygaard Austvold <austvold@acm.org>
 *                
 * Copyright (c) 2000 rjan Nygaard Austvold, All Rights Reserved.
 *                
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * Revision History:
 *
 *   01-Dec-00 15:14:55   rjan Nygaard Austvold <austvold@acm.org>
 *     Removed inclusion of gnome-window-icon.h. Changed to plain
 *     gdk implementation of setting the default window icon to
 *     remove dpendencies.
 *
 * *****************************************************************
 */

#ifndef COMMON_H
#define COMMON_H 1

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <pthread.h>
#include <math.h>
#include <gnome.h>
#include <applet-widget.h>
#include <libintl.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/XKBlib.h>

#define OFF 0
#define ON  1
#define NUM_LOCK    0
#define CAPS_LOCK   1
#define SCROLL_LOCK 2

#define NUM_LOCK_OFF    0
#define NUM_LOCK_ON     1
#define CAPS_LOCK_OFF   2
#define CAPS_LOCK_ON    3
#define SCROLL_LOCK_OFF 4
#define SCROLL_LOCK_ON  5

#define NUM_LOCK_MASK    0x00000002
#define CAPS_LOCK_MASK   0x00000001
#define SCROLL_LOCK_MASK 0x00000004

#define WINDOW_ICON "keyboard-led_applet-logo.png"

struct _led_thread_arg_t {
  char *display_name;
};
typedef struct _led_thread_arg_t led_thread_arg_t;

void error_handler(const gchar *log_domain, GLogLevelFlags log_level,
		   const gchar *message, gpointer user_data);

inline int writen (register int fd, register char *ptr, register int nbytes);

inline int readn (register int fd, register char *ptr, register int nbytes);

void set_proc_name (int argc, char *argv[], const char *name);

#endif
