/***************************************************************************
                          kfocustasksview.h  -  description
                             -------------------
    begin                : Mon Aug 13 2001
    copyright            : (C) 2001 by Jeffrey Yu
    email                : jeffyu@cs.stanford.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KFOCUSTASKSVIEW_H
#define KFOCUSTASKSVIEW_H

#include <qwidget.h>
#include <qstring.h>
#include <qlist.h>
#include <qiconset.h>

class QListView;
class QListViewItem;
class QPushButton;
class QToolButton;

// Forward declaration of KFocus classes
class KFVTask;
class KFMTask;
class KFMTaskList;

/**View of KFocus tasks
  *@author Jeffrey Yu
  */

class KFVTaskList : public QWidget  {
   Q_OBJECT
public: 
	KFVTaskList(QWidget *parent=0, const char *name=0);
	~KFVTaskList();
	
	void taskList(KFMTaskList* taskList);

signals: // Signals
  /** Signal to send when the user completes a task */
  void taskCompleted(KFMTask* task);;


private: // Private attributes
  /** Subview of  task properties */
  KFVTask* props_;
  /** QListView to display task titles */
  QListView* lvTasks_;
  /** Col to display task position */
  int posCol_;
  /** Col to display task ETA */
  int etaCol_;
  /** Col to display task title */
  int titleCol_;
  /** QPushButton to add a new task */
  QPushButton* pbAdd_;
  /** QPushButton for removing tasks from the task list */
  QPushButton* pbDelete_;
  /** QPushButton for completing tasks */
  QPushButton* pbComplete_;
  /** Pointer the documents task list */
  KFMTaskList* taskList_;
  /** Currently selected task */
  KFMTask* currentTask_;
  /** Flag set to true when in the active state */
  bool active_;
  /** Button showing up arrow */
  QToolButton* tbUp_;
  /** Button showing down arrow */
  QToolButton* tbDown_;
  /** Button with trash icon */
  QToolButton* tbTrash_;
  /** List to hold QListViewItems */
  QList<QListViewItem> itemList_;

private: // Private methods
  /** Make the widgets in the view */
  void createWidgets();
  /** Retrive the current task */
  KFMTask* currentTask() const {return currentTask_;}

  /** Load the view's ListBow */
  void loadListView();
  /** Unload the view's list box */
  void unloadListView();
  /** Load the view's ListView with fresh data */
  void reloadListView();

  /** Update the arrow buttons to reflect current conditions */
  void updateArrows();
  /** Update the state of the trash toolbutton */
  void updateTrashButton();
  /** Retrieve an QIconSet for a tool button */
  QIconSet toolIconSet(QString name);

	/** Retrieve a QListViewItem to match a KFMTask
			@param task Task for which to find a view item
		*/
	QListViewItem* taskViewItem(const KFMTask* task);
	
	/** Fill a viewItem with data from a task
			@param task Task from which to fill the view item
		*/
	void fillViewItem(QListViewItem* item, const KFMTask* task);

private slots: // Private slots

  /** Switch into the active state */
  void enterActiveState();
  /** Put the tasks view into its base state */
  void enterBaseState();

  /** Set the current task */
  void currentTask(KFMTask* task);

  /** Slot to receive titleChanged signal from currentTItle */
  void onCurrentTaskTitleChanged();

  /** Create a new task */
  void onPbAddClicked();
  /** Slot to receive the clicked signal from pbDelete */
  void onPbDeleteClicked();
  /** Slot to receive the clicked signal from pbComplete */
  void onPbCompleteClicked();
  /** Slot to receive currentChanged signal from lvTasks */
  void onLvTasksSelectionChanged(QListViewItem* item);
  /** Slot for when the user clicks the Up button */
  void onUpButtonClicked();
  /** Slot for when the user clicks on the Down button */
  void onDownButtonClicked();

  /** Slot to receive taskAdded signal from the tasklist */
  void onTaskListTaskAdded( KFMTask* addedTask);
  /** Slot to handle removal of a task from the task list */
  void onTaskListTaskRemoved( KFMTask* removedTask);
  /** Slot for when the tasklist ordering changes */
  void onTaskListOrderChanged();

};

#endif
