\ stepfft.4th
\
\ Compute the FFT of a square pulse.
\
\ Requires:
\
\	matrix.4th
\	fft1d.4th
\

include matrix
include fft1d

2048 1 fmatrix pulse

variable pulse_width
100 pulse_width !

fvariable pulse_height
1e pulse_height f!

." Initial pulse width is " pulse_width @ . cr

variable start_pulse
variable stop_pulse

: gen_pulse ( -- | generate the pulse profile )
	pulse mat_size@ drop 2/
	dup pulse_width @ - start_pulse !
	pulse_width @ + stop_pulse !
	pulse mat_size@ drop 1+ 1 do
	  i start_pulse @ > 
	  if
	    i stop_pulse @ < if
	      pulse_height f@ i 1 pulse fmat!
	    else
	      0e i 1 pulse fmat!
	    then
	  else
	    0e i 1 pulse fmat!
	  then
	  0e i 1+ 1 pulse fmat!	\ imaginary component of the pulse
	2 +loop ;


: go ( -- compute the FFT and display real and imaginary components and power )
	gen_pulse
	pulse fft
	pulse mat_size@ drop 1+ 1 do
	  i 4 .r 2 spaces
	  i 1 pulse fmat@ fdup fdup f. f* 2 spaces
	  i 1+ 1 pulse fmat@ fdup fdup f. f* f+ 2 spaces
	  f. cr
	2 +loop ;
	

." Type 'go' to generate the FFT and print it." cr
