/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 * Copyright (C) 2004 Markus Brueffer <markus@brueffer.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include <qcheckbox.h>

#include <kcombobox.h>
#include <klocale.h>
#include <kurlrequester.h>

#include "kftpapi.h"
#include "editortls.h"
#include "kftpbookmarkeditortlswidget.h"
#include "misc.h"

using namespace KFTPGrabberBase;

namespace KFTPWidgets {

namespace Bookmarks {

KActionCollection *BookmarkEditorTLS::actionCollection()
{
  return KFTPAPI::getInstance()->mainWindow()->actionCollection();
}

BookmarkEditorTLS::BookmarkEditorTLS(QWidget *parent, const char *name)
 : KDialogBase(parent, name)
{
  m_mainWidget = new KFTPBookmarkEditorTLSWidget(this);
  setMainWidget(m_mainWidget);

  setCaption(i18n("SSL/TLS Settings"));
  showButtonApply(false);

  connect(m_mainWidget->useCert, SIGNAL(clicked()), this, SLOT(slotChangeActiveX509Group()));
}

BookmarkEditorTLS::~BookmarkEditorTLS()
{
  delete m_mainWidget;
}

void BookmarkEditorTLS::slotChangeActiveX509Group()
{
  m_mainWidget->certPath->setEnabled(m_mainWidget->useCert->isChecked());
}

int BookmarkEditorTLS::getTLSMode()
{
  return m_mainWidget->tlsMode->currentItem();
}

bool BookmarkEditorTLS::isCertChecked()
{
  return m_mainWidget->useCert->isChecked();
}

QString BookmarkEditorTLS::getCertPath()
{
  return m_mainWidget->certPath->url();
}

void BookmarkEditorTLS::setTLSMode(int mode)
{
  m_mainWidget->tlsMode->setCurrentItem(mode);
}

void BookmarkEditorTLS::setCertChecked(const bool checked)
{
  m_mainWidget->useCert->setChecked(checked);
}

void BookmarkEditorTLS::setCertPath(const QString &path)
{
  m_mainWidget->certPath->setURL(path);
}

}

}

#include "editortls.moc"
