/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sam Aug 11 19:50:48 CEST 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kwin.h>
#include <netwm_def.h>

#include "kgeo.h"

static const char *description =
	I18N_NOOP("Interactive Geometry");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE


static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

	KAboutData aboutData( "kgeo", I18N_NOOP("KGeo"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2000-2001, Marc Bartsch");
	aboutData.addAuthor("Marc Bartsch",0, "marc.bartsch@web.de");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication app;

  if (app.isRestored())
  {
    RESTORE(KGeoApp);
  }
  else
  {
    KGeoApp *kgeo = new KGeoApp();
		kapp->config()->setGroup("Startup");
		if ( kapp->config()->readBoolEntry( "Maximize", true ) )
		{
			kgeo->showMaximized();
		}
	  else
		{
	    kgeo->show();
		}

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

		if (args->count())
		{
	    kgeo->loadDrawing( args->arg(0) );
		}
  }

  return app.exec();
}
