/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KIAXADDRESSBOOK_H
#define KIAXADDRESSBOOK_H

#include <qptrlist.h>
#include "kiaxcontact.h"

class KiaxAddressBook : public QPtrList<KiaxContact> {
public:
    KiaxAddressBook() {};

    ~KiaxAddressBook() {clear();}
    int createNewContact();
    int addContact(KiaxContact * contact);
    KiaxAddressBook getContacts();
    KiaxContact* getContact(int i);
    void removeContact(int contactNumber);
    void save();
    void load();
    
protected:
   virtual int compareItems ( void* item1, void* item2 );

private:
    QSettings * getSettings();
};

#endif
