/***************************************************************************
 *   Copyright (C) 2004 by Emil Stoyanov                                   *
 *   emosto@users.sourceforge.net                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KIAXREGISTRATIONINDICATOR_H
#define KIAXREGISTRATIONINDICATOR_H

#include <qlabel.h>
#include <qevent.h>
#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qimage.h>
#include "kiaxaccount.h"
#include "kiaxmainwindow.h"

class KiaxRegistrationIndicator : public QLabel
{
Q_OBJECT
public:
    KiaxRegistrationIndicator(QWidget *parent = 0, const char *name = 0, KiaxAccount* account = 0);

    ~KiaxRegistrationIndicator();

    void setAccount(KiaxAccount* account);
    KiaxAccount* getAccount();
    virtual void mousePressEvent ( QMouseEvent * e );
    void setIconConnecting(QPixmap* icon);
    void setIconRejected(QPixmap* icon);
    void setIconAccepted(QPixmap* icon);
    void setIconTimeout(QPixmap* icon);
    void setIconInactive(QPixmap* icon);
    virtual QSize sizeHint () const;
    virtual QSize minimumSizeHint () const;

signals:
	
   void signalRegisterAccountAction(KiaxAccount* account);
   void signalUnregisterAccountAction(KiaxAccount* account);

public slots:

    virtual void registrationAccepted();
    virtual void registrationRejected();
    virtual void registrationConnecting();
    virtual void registrationTimeout();
    virtual void registrationInactive();
    virtual void registerAccount();
    virtual void unregisterAccount();

private:
    QString iconsPath;
    KiaxAccount * account;
    QPixmap* iconConnecting;
    QPixmap* iconAccepted;
    QPixmap* iconRejected;
    QPixmap* iconTimeout;
    QPixmap* iconInactive;
    QPopupMenu* popupMenu;

};

#endif
