/*
 * newstroke_font.cpp - definitions for automatically converted font
 *
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2010 vladimir uryvaev <vovanius@bk.ru>
 * Copyright (C) 1992-2010 KiCad Developers, see change_log.txt for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#include "newstroke_font.h"

const char* const newstroke_font[] =
{
    /* // BASIC LATIN (0020-007F) */
    "JZ", /* U+20 SPACE  */
    "MWRYSZR[QZRYR[ RRSQGRFSGRSRF",
    "JZNFNJ RVFVJ",
    "H]LM[M RRDL_ RYVJV RS_YD",
    "H\\LZO[T[VZWYXWXUWSVRTQPPNOMNLLLJMHNGPFUFXG RRCR^",
    "F^J[ZF RMFOGPIOKMLKKJIKGMF RYZZXYVWUUVTXUZW[YZ",
    "E_[[Z[XZUWPQNNMKMINGPFQFSGTITJSLRMLQKRJTJWKYLZN[Q[SZTYWUXRXP",
    "MWSFQJ",
    "KYVcUbS_R]QZPUPQQLRISGUDVC",
    "KYNcObQ_R]SZTUTQSLRIQGODNC",
    "JZRFRK RMIRKWI ROORKUO",
    "E_JSZS RR[RK",
    "MWSZS[R]Q^",
    "E_JSZS",
    "MWRYSZR[QZRYR[",
    "G][EI`",
    "H\\QFSFUGVHWJXNXSWWVYUZS[Q[OZNYMWLSLNMJNHOGQF", /* U+30 DIGIT_0  */
    "H\\X[L[ RR[RFPINKLL",
    "H\\LHMGOFTFVGWHXJXLWOK[X[",
    "H\\KFXFQNTNVOWPXRXWWYVZT[N[LZKY",
    "H\\VMV[ RQELTYT",
    "H\\WFMFLPMOONTNVOWPXRXWWYVZT[O[MZLY",
    "H\\VFRFPGOHMKLOLWMYNZP[T[VZWYXWXRWPVOTNPNNOMPLR",
    "H\\KFYFP[",
    "H\\PONNMMLKLJMHNGPFTFVGWHXJXKWMVNTOPONPMQLSLWMYNZP[T[VZWYXWXSWQVPTO",
    "H\\N[R[TZUYWVXRXJWHVGTFPFNGMHLJLOMQNRPSTSVRWQXO",
    "MWRYSZR[QZRYR[ RRNSORPQORNRP",
    "MWSZS[R]Q^ RRNSORPQORNRP",
    "E_ZMJSZY",
    "E_JPZP RZVJV",
    "E_JMZSJY",
    "I[QYRZQ[PZQYQ[ RMGOFTFVGWIWKVMUNSORPQRQS",
    "D_VQUPSOQOOPNQMSMUNWOXQYSYUXVW RVOVWWXXXZW[U[PYMVKRJNKKMIPHTIXK[N]R^V]Y[", /* U+40 AT  */
    "I[MUWU RK[RFY[",
    "G\\SPVQWRXTXWWYVZT[L[LFSFUGVHWJWLVNUOSPLP",
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH",
    "G\\L[LFQFTGVIWKXOXRWVVXTZQ[L[",
    "H[MPTP RW[M[MFWF",
    "HZTPMP RM[MFWF",
    "F[VGTFQFNGLIKKJOJRKVLXNZQ[S[VZWYWRSR",
    "G]L[LF RLPXP RX[XF",
    "MWR[RF",
    "JZUFUUTXRZO[M[",
    "G\\L[LF RX[OO RXFLR",
    "HYW[M[MF",
    "F^K[KFRUYFY[",
    "G]L[LFX[XF",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF",
    "G\\L[LFTFVGWHXJXMWOVPTQLQ", /* U+50 P_CAP  */
    "G]Z]X\\VZSWQVOV RP[NZLXKTKMLINGPFTFVGXIYMYTXXVZT[P[",
    "G\\X[QQ RL[LFTFVGWHXJXMWOVPTQLQ",
    "H\\LZO[T[VZWYXWXUWSVRTQPPNOMNLLLJMHNGPFUFXG",
    "JZLFXF RR[RF",
    "G]LFLWMYNZP[T[VZWYXWXF",
    "I[KFR[YF",
    "F^IFN[RLV[[F",
    "H\\KFY[ RYFK[",
    "I[RQR[ RKFRQYF",
    "H\\KFYFK[Y[",
    "KYVbQbQDVD",
    "KYID[_",
    "KYNbSbSDND",
    "LXNHREVH",
    "JZJ]Z]",
    "NVPESH", /* U+60 GRAVE  */
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR",
    "H[M[MF RMNOMSMUNVOWQWWVYUZS[O[MZ",
    "HZVZT[P[NZMYLWLQMONNPMTMVN",
    "I\\W[WF RWZU[Q[OZNYMWMQNOONQMUMWN",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT",
    "MYOMWM RR[RISGUFWF",
    "I\\WMW^V`UaSbPbNa RWZU[Q[OZNYMWMQNOONQMUMWN",
    "H[M[MF RV[VPUNSMPMNNMO",
    "MWR[RM RRFQGRHSGRFRH",
    "MWRMR_QaObNb RRFQGRHSGRFRH",
    "IZN[NF RPSV[ RVMNU",
    "MXU[SZRXRF",
    "D`I[IM RIOJNLMOMQNRPR[ RRPSNUMXMZN[P[[",
    "I\\NMN[ RNOONQMTMVNWPW[",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[",
    "H[MMMb RMNOMSMUNVOWQWWVYUZS[O[MZ", /* U+70 P_SMALL  */
    "I\\WMWb RWZU[Q[OZNYMWMQNOONQMUMWN",
    "KXP[PM RPQQORNTMVM",
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN",
    "MYOMWM RRFRXSZU[W[",
    "H[VMV[ RMMMXNZP[S[UZVY",
    "JZMMR[WM",
    "G]JMN[RQV[ZM",
    "IZL[WM RLMW[",
    "JZMMR[ RWMR[P`OaMb",
    "IZLMWML[W[",
    "KYVcUcSbR`RVQTOSQRRPRFSDUCVC",
    "H\\RbRD",
    "KYNcOcQbR`RVSTUSSRRPRFQDOCNC",
    "KZMHNGPFTHVGWF",
    "F^K[KFYFY[K[",
    /* // LATIN-1 SUPPLEMENT (0080-00FF) */
    "F^K[KFYFY[K[", /* U+80 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+90 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "JZ", /* U+A0 SPACE  */
    "MWROQNRMSNRORM RRUSaRbQaRURb",
    "HZVZT[P[NZMYLWLQMONNPMTMVN RRJR^",
    "H[LMTM RL[W[ RO[OIPGRFUFWG",
    "H]LYOV RLLOO RVVYY RVOYL RVVTWQWOVNTNQOOQNTNVOWQWTVV",
    "F^JTZT RJMZM RRQR[ RKFRQYF",
    "MWRbRW RRFRQ",
    "I[N]P^S^U]V[UYOSNQNPONQM RVGTFQFOGNIOKUQVSVTUVSW",
    "LXNFOGNHMGNFNH RVFWGVHUGVFVH",
    "@dVKTJPJNKLMKOKSLUNWPXTXVW RRCMDHGELDQEVH[M^R_W^\\[_V`Q_L\\GWDRC",
    "KZOEQDSDUEVGVN RVMTNQNOMNKOIQHVH",
    "H\\RMLSRY RXWTSXO",
    "E_JQZQZV",
    "RR",
    "@dWXRR RNXNJTJVKWMWOVQTRNR RRCMDHGELDQEVH[M^R_W^\\[_V`Q_L\\GWDRC",
    "LXMGWG",
    "JZRFPGOIPKRLTKUITGRF", /* U+B0 DEGREE  */
    "E_JOZO RRWRG RZ[J[",
    "JZNAP@S@UAVCVEUGNNVN",
    "JZN@V@RESEUFVHVKUMSNPNNM",
    "NVTEQH",
    "H^MMMb RWXXZZ[ RMXNZP[T[VZWXWM",
    "F]VMV[ ROMOXNZL[ RZMMMKNJP",
    "JZRRQSRTSSRRRT",
    "MWR\\T]U_TaRbOb",
    "JZVNNN RNCPBR@RN",
    "KYQNOMNKNGOEQDSDUEVGVKUMSNQN",
    "H\\RMXSRY RLWPSLO",
    "G]KQYQ RVNNN RNCPBR@RN RUYUa RQSN]W]",
    "G]KQYQ RVNNN RNCPBR@RN RNTPSSSUTVVVXUZNaVa",
    "G]KQYQ RN@V@RESEUFVHVKUMSNPNNM RUYUa RQSN]W]",
    "I[SORNSMTNSOSM RWaUbPbNaM_M]N[OZQYRXSVSU",
    "I[MUWU RK[RFY[ RP>SA", /* U+C0 A_CAP GRAVE */
    "I[MUWU RK[RFY[ RT>QA",
    "I[MUWU RK[RFY[ RNAR>VA",
    "I[MUWU RK[RFY[ RMAN@P?TAV@W?",
    "I[MUWU RK[RFY[ RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "I[MUWU RK[RFY[ RRFPEOCPAR@TAUCTERF",
    "F`JURU RRPYP RH[OF\\F RRFR[\\[",
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH RR\\T]U_TaRbOb",
    "H[MPTP RW[M[MFWF RP>SA",
    "H[MPTP RW[M[MFWF RT>QA",
    "H[MPTP RW[M[MFWF RNAR>VA",
    "H[MPTP RW[M[MFWF RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "MWR[RF RP>SA",
    "MWR[RF RT>QA",
    "MWR[RF RNAR>VA",
    "MWR[RF RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "G\\L[LFQFTGVIWKXOXRWVVXTZQ[L[ RIPQP", /* U+D0 D_CAP STROKE_H */
    "G]L[LFX[XF RMAN@P?TAV@W?",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RP>SA",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RT>QA",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RNAR>VA",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RMAN@P?TAV@W?",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "E_LMXY RXMLY",
    "G]ZFJ[ RP[NZLXKTKMLINGPFTFVGXIYMYTXXVZT[P[",
    "G]LFLWMYNZP[T[VZWYXWXF RP>SA",
    "G]LFLWMYNZP[T[VZWYXWXF RT>QA",
    "G]LFLWMYNZP[T[VZWYXWXF RNAR>VA",
    "G]LFLWMYNZP[T[VZWYXWXF RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "I[RQR[ RKFRQYF RT>QA",
    "G\\LFL[ RLKTKVLWMXOXRWTVUTVLV",
    "F]K[KJLHMGOFRFTGUHVJVMSMQNPPPQQSSTVTXUYWYXXZV[R[PZ",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RPESH", /* U+E0 A_SMALL GRAVE */
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RTEQH",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNHREVH",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RMHNGPFTHVGWF",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RRHPGOEPCRBTCUETGRH",
    "D`INKMOMQNRP R[ZY[U[SZRXRPSNUMYM[N\\P\\RRSKSITHVHXIZK[O[QZRX",
    "HZVZT[P[NZMYLWLQMONNPMTMVN RR\\T]U_TaRbOb",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RPESH",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RTEQH",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RNHREVH",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "MWR[RM RPESH",
    "MWR[RM RTEQH",
    "LXNHREVH RR[RM",
    "LXNFOGNHMGNFNH RVFWGVHUGVFVH RR[RM",
    "I\\SCQI RWNUMQMONNOMQMXNZP[T[VZWXWLVITGRFNE", /* U+F0 ETH_SMALL  */
    "I\\NMN[ RNOONQMTMVNWPW[ RMHNGPFTHVGWF",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RPESH",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RTEQH",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RNHREVH",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RMHNGPFTHVGWF",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "E_ZSJS RRXSYRZQYRXRZ RRLSMRNQMRLRN",
    "H[XMK[ RP[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[",
    "H[VMV[ RMMMXNZP[S[UZVY RPESH",
    "H[VMV[ RMMMXNZP[S[UZVY RTEQH",
    "H[VMV[ RMMMXNZP[S[UZVY RNHREVH",
    "H[VMV[ RMMMXNZP[S[UZVY RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "JZMMR[ RWMR[P`OaMb RTEQH",
    "H[MFMb RMNOMSMUNVOWQWWVYUZS[O[MZ",
    "JZMMR[ RWMR[P`OaMb RNFOGNHMGNFNH RVFWGVHUGVFVH",
    /* // LATIN EXTENDED-A (0100-017F) */
    "I[MUWU RK[RFY[ RM@W@", /* U+100 A_CAP MACRON */
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RMGWG",
    "I[MUWU RK[RFY[ RN>O@QASAU@V>",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNEOGQHSHUGVE",
    "I[MUWU RK[RFY[ RY[W]V_WaYb[b",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RW[U]T_UaWbYb",
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH RT>QA",
    "HZVZT[P[NZMYLWLQMONNPMTMVN RTEQH",
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH RNAR>VA",
    "HZVZT[P[NZMYLWLQMONNPMTMVN RNHREVH",
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH RR?Q@RAS@R?RA",
    "HZVZT[P[NZMYLWLQMONNPMTMVN RRFQGRHSGRFRH",
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH RN>RAV>",
    "HZVZT[P[NZMYLWLQMONNPMTMVN RNERHVE",
    "G\\L[LFQFTGVIWKXOXRWVVXTZQ[L[ RN>RAV>",
    "IfW[WF RWZU[Q[OZNYMWMQNOONQMUMWN RbF`J",
    "G\\L[LFQFTGVIWKXOXRWVVXTZQ[L[ RIPQP", /* U+110 D_CAP STROKE_H */
    "I\\W[WF RWZU[Q[OZNYMWMQNOONQMUMWN RRHZH",
    "H[MPTP RW[M[MFWF RM@W@",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RMGWG",
    "H[MPTP RW[M[MFWF RN>O@QASAU@V>",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RNEOGQHSHUGVE",
    "H[MPTP RW[M[MFWF RR?Q@RAS@R?RA",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RRFQGRHSGRFRH",
    "H[MPTP RW[M[MFWF RR[P]O_PaRbTb",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RR[P]O_PaRbTb",
    "H[MPTP RW[M[MFWF RN>RAV>",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RNERHVE",
    "F[VGTFQFNGLIKKJOJRKVLXNZQ[S[VZWYWRSR RNAR>VA",
    "I\\WMW^V`UaSbPbNa RWZU[Q[OZNYMWMQNOONQMUMWN RNHREVH",
    "F[VGTFQFNGLIKKJOJRKVLXNZQ[S[VZWYWRSR RN>O@QASAU@V>",
    "I\\WMW^V`UaSbPbNa RWZU[Q[OZNYMWMQNOONQMUMWN RNEOGQHSHUGVE",
    "F[VGTFQFNGLIKKJOJRKVLXNZQ[S[VZWYWRSR RR?Q@RAS@R?RA", /* U+120 G_CAP DOT */
    "I\\WMW^V`UaSbPbNa RWZU[Q[OZNYMWMQNOONQMUMWN RRFQGRHSGRFRH",
    "F[VGTFQFNGLIKKJOJRKVLXNZQ[S[VZWYWRSR RR\\T]U_TaRbOb",
    "I\\WMW^V`UaSbPbNa RWZU[Q[OZNYMWMQNOONQMUMWN RRGPFODPBRAUA",
    "G]L[LF RLPXP RX[XF RNAR>VA",
    "H[M[MF RV[VPUNSMPMNNMO RIAM>QA",
    "G]IJ[J RL[LF RLPXP RX[XF",
    "H[M[MF RV[VPUNSMPMNNMO RJHRH",
    "MWR[RF RMAN@P?TAV@W?",
    "MWR[RM RMHNGPFTHVGWF",
    "MWR[RF RM@W@",
    "MWR[RM RMGWG",
    "MWR[RF RN>O@QASAU@V>",
    "MWR[RM RNEOGQHSHUGVE",
    "MWR[RF RR[P]O_PaRbTb",
    "MWR[RM RR[P]O_PaRbTb",
    "MWR[RF RR?Q@RAS@R?RA", /* U+130 I_CAP DOT */
    "MWR[RM",
    "MgR[RF RbFbUaX_Z\\[Z[",
    "MaR[RM RRFQGRHSGRFRH R\\M\\_[aYbXb R\\F[G\\H]G\\F\\H",
    "JZUFUUTXRZO[M[ RQAU>YA",
    "MWRMR_QaObNb RNHREVH",
    "G\\L[LF RX[OO RXFLR RR\\T]U_TaRbOb",
    "IZN[NF RPSV[ RVMNU RR\\T]U_TaRbOb",
    "IZNMN[ RPSV[ RVMNU",
    "HYW[M[MF RO>LA",
    "MXU[SZRXRF RTEQH",
    "HYW[M[MF RR\\T]U_TaRbOb",
    "MXU[SZRXRF RR\\T]U_TaRbOb",
    "HYW[M[MF RVHSK",
    "M^U[SZRXRF RZFXJ",
    "HYW[M[MF RUNTOUPVOUNUP",
    "M\\U[SZRXRF RYOZPYQXPYOYQ", /* U+140 L_SMALL_MIDDOT  */
    "HYW[M[MF RJQPM",
    "MXU[SZRXRF ROQUM",
    "G]L[LFX[XF RT>QA",
    "I\\NMN[ RNOONQMTMVNWPW[ RTEQH",
    "G]L[LFX[XF RR\\T]U_TaRbOb",
    "I\\NMN[ RNOONQMTMVNWPW[ RR\\T]U_TaRbOb",
    "G]L[LFX[XF RN>RAV>",
    "I\\NMN[ RNOONQMTMVNWPW[ RNERHVE",
    "MjSFQJ R\\M\\[ R\\O]N_MbMdNePe[",
    "G]LFL[ RLINGPFTFVGWHXJX^W`VaTbQb",
    "I\\NMN[ RNOONQMTMVNWPW_VaTbRb",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RM@W@",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RMGWG",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RN>O@QASAU@V>",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RNEOGQHSHUGVE",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RQ>NA RX>UA", /* U+150 O_CAP ACUTE_DBL */
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RQENH RXEUH",
    "E`RPYP RRFR[ R\\FNFLGJIIMITJXLZN[\\[",
    "C`[ZY[U[SZRXRPSNUMYM[N\\P\\RRT RRQQOPNNMKMINHOGQGWHYIZK[N[PZQYRW",
    "G\\X[QQ RL[LFTFVGWHXJXMWOVPTQLQ RT>QA",
    "KXP[PM RPQQORNTMVM RTEQH",
    "G\\X[QQ RL[LFTFVGWHXJXMWOVPTQLQ RR\\T]U_TaRbOb",
    "KXP[PM RPQQORNTMVM RR\\T]U_TaRbOb",
    "G\\X[QQ RL[LFTFVGWHXJXMWOVPTQLQ RN>RAV>",
    "KXP[PM RPQQORNTMVM RNERHVE",
    "H\\LZO[T[VZWYXWXUWSVRTQPPNOMNLLLJMHNGPFUFXG RT>QA",
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN RTEQH",
    "H\\LZO[T[VZWYXWXUWSVRTQPPNOMNLLLJMHNGPFUFXG RNAR>VA",
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN RNHREVH",
    "H\\LZO[T[VZWYXWXUWSVRTQPPNOMNLLLJMHNGPFUFXG RR\\T]U_TaRbOb",
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN RR\\T]U_TaRbOb",
    "H\\LZO[T[VZWYXWXUWSVRTQPPNOMNLLLJMHNGPFUFXG RN>RAV>", /* U+160 S_CAP CARON */
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN RNERHVE",
    "JZLFXF RR[RF RR\\T]U_TaRbOb",
    "MYOMWM RRFRXSZU[W[ RR\\T]U_TaRbOb",
    "JZLFXF RR[RF RN>RAV>",
    "M[OMWM RYFXI RRFRXSZU[W[",
    "JZLFXF RR[RF RNQVQ",
    "MYOMWM RRFRXSZU[W[ ROSUS",
    "G]LFLWMYNZP[T[VZWYXWXF RMAN@P?TAV@W?",
    "H[VMV[ RMMMXNZP[S[UZVY RMHNGPFTHVGWF",
    "G]LFLWMYNZP[T[VZWYXWXF RM@W@",
    "H[VMV[ RMMMXNZP[S[UZVY RMGWG",
    "G]LFLWMYNZP[T[VZWYXWXF RN>O@QASAU@V>",
    "H[VMV[ RMMMXNZP[S[UZVY RNEOGQHSHUGVE",
    "G]LFLWMYNZP[T[VZWYXWXF RRAP@O>P<R;T<U>T@RA",
    "H[VMV[ RMMMXNZP[S[UZVY RRHPGOEPCRBTCUETGRH",
    "G]LFLWMYNZP[T[VZWYXWXF RQ>NA RX>UA", /* U+170 U_CAP ACUTE_DBL */
    "H[VMV[ RMMMXNZP[S[UZVY RQENH RXEUH",
    "G]LFLWMYNZP[T[VZWYXWXF RR[P]O_PaRbTb",
    "H[VMV[ RMMMXNZP[S[UZVY RV[T]S_TaVbXb",
    "F^IFN[RLV[[F RNAR>VA",
    "G]JMN[RQV[ZM RNHREVH",
    "I[RQR[ RKFRQYF RNAR>VA",
    "JZMMR[ RWMR[P`OaMb RNHREVH",
    "JZLFXF RR[RF RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "H\\KFYFK[Y[ RT>QA",
    "IZLMWML[W[ RTEQH",
    "H\\KFYFK[Y[ RR?Q@RAS@R?RA",
    "IZLMWML[W[ RRFQGRHSGRFRH",
    "H\\KFYFK[Y[ RN>RAV>",
    "IZLMWML[W[ RNERHVE",
    "MYR[RISGUFWF",
    /* // LATIN EXTENDED-B (0180-024F) */
    "H[M[MF RMNOMSMUNVOWQWWVYUZS[O[MZ RJHRH", /* U+180 B_SMALL STROKE_H */
    "C\\LFL[T[VZWYXWXTWRVQSPLP RFKFIGGIFSFUGVHWJWLVNUOSP",
    "G\\VFLFL[R[UZWXXVXSWQUORNLN",
    "H[WFMFM[ RMNOMSMUNVOWQWWVYUZS[O[MZ",
    "H]MFM[S[VZXXYVYSXQVOSNMN",
    "IZNMN[S[UZVXVUUSSRNR",
    "I^MHNGQFSFVGXIYKZOZRYVXXVZS[Q[NZMY",
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH RMHKGJEKCLB",
    "HZVZT[P[NZMYLWLQMONNPMTMVN RTMTIUGWFYF",
    "G\\L[LFQFTGVIWKXOXRWVVXTZQ[L[ RIPQP",
    "C\\FKFIGGIFQFTGVIWKXOXRWVVXTZQ[L[LF",
    "H]NFXFX[R[OZMXLVLSMQOORNXN",
    "I\\MFWFW[ RWNUMQMONNOMQMWNYOZQ[U[WZ",
    "I\\Q[T[VZWYXWXQWOVNTMQMONNOMQMWNYOZQ[T\\V]W_VaTbPbNa",
    "I\\WPPP RM[W[WFMF",
    "F^MHNGQFSFVGXIYKZOZRYVXXVZS[Q[NZLXKVJRZP",
    "G[PPTP RWGUFPFNGMHLJLLMNNOPPMQLRKTKWLYMZO[U[WZ", /* U+190 EPSILON_LARGE  */
    "HZTPMP RM[MFWF RM[M_LaJbHb",
    "MYOMWM RR[RISGUFWF RR[R_QaObMb",
    "F[VGTFQFNGLIKKJOJRKVLXNZQ[S[VZWYWRSR RMHKGJEKCLB",
    "I[KFU[U_TaRbPaO_O[YF",
    "D`I[IF RIOJNLMOMQNRPRXSZU[X[ZZ[Y\\W\\P[NZM",
    "MZRFRWSYTZV[X[",
    "MWR[RF RNPVP",
    "G_L[LF RX[OO RLRWGYF[G\\I\\K",
    "IZNMN[ RPSV[ RVMNU RNMNIOGQFSF",
    "MXU[SZRXRF RNOVO",
    "JZRMM[ RMFOFPGRMW[ RNLTH",
    "Ca\\F\\[ R\\XZZX[V[TZSYRWRF RRWQYPZN[L[JZIYHWHF",
    "G]L[LFX[XF RL[L_KaIbGb",
    "I\\NMN[ RNOONQMTMVNWPWb",
    "G]KPYP RPFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RVGXFYDXBWA", /* U+1A0 O_CAP HORN */
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RUNWMXKWIVH",
    "DaSGQFMFKGIIHMHTIXKZM[Q[SZUXVTVMUISGUFYF[G\\I\\b",
    "E^RNPMMMKNJOIQIWJYKZM[P[RZSYTWTQSORNTMVMXNYPYb",
    "C\\LFL[ RFKFIGGIFTFVGWHXJXMWOVPTQLQ",
    "H[MMMb RMNOMSMUNVOWQWWVYUZS[O[MZ RRMRISGUFWF",
    "G\\LFL[ RQVXb RLKTKVLWMXOXRWTVUTVLV",
    "H\\XZU[P[NZMYLWLUMSNRPQTPVOWNXLXJWHVGTFOFLG",
    "IZVZT[P[NZMXMWNUPTSTUSVQVPUNSMPMNN",
    "H[W[L[SPLFWF",
    "JYWbUbSaR_RIQGOFMGLIMKOLQKRI",
    "MYOMWM RRFRXSZU[W[ RW[W_VaTbRb",
    "HZR[RF RKKKILGNFXF",
    "MYOMWM RWFUFSGRIRXSZU[W[",
    "JZLFXF RR[RF RR[R_SaUbWb",
    "G]LFLWMYNZP[T[VZWYXWXF RXFZE[CZAY@",
    "H[VMV[ RMMMXNZP[S[UZVY RVMXLYJXHWG", /* U+1B0 U_SMALL HORN */
    "F^ZFUFUJWKYMZPZUYXWZT[P[MZKXJUJPKMMKOJOFJF",
    "G]LFLWMYNZP[T[VZXXYVYIXGWF",
    "I`RQR[ RKFRQXGZF\\G]I]K",
    "J^MMR[ RMbOaP`R[VNXMZN[P[R",
    "H\\KFYFK[Y[ RNPVP",
    "IZLMWML[W[ RNTVT",
    "H\\KFXFQNTNVOWPXRXWWYVZT[N[LZKY",
    "H\\YFLFSNPNNOMPLRLWMYNZP[V[XZYY",
    "JZWMNMUVRVPWOXNZN^O`PaRbUbWa",
    "JZMMVMOTSTUUVWVXUZS[Q[O\\N^N_OaQbVb",
    "H\\LHMGOFTFVGWHXJXLWOK[X[ RNSVS",
    "H\\WFMFLPMOONTNVOWPXRXWWYVZT[O[MZLY",
    "JZVMOMNSPRSRUSVUVXUZS[P[NZ",
    "J^MZP[T[WZYXZVZSYQWOTNPNPF RLITI",
    "H[MMMb RMONNPMTMVNWPWSVUM^",
    "MWRFRb", /* U+1C0 LINE_V_LETTER  */
    "JZOFOb RUFUb",
    "MWRFRb ROWUW ROQUQ",
    "MWRYSZR[QZRYR[ RRSQGRFSGRSRF",
    "GpL[LFQFTGVIWKXOXRWVVXTZQ[L[ R_FmF_[m[ Rb>fAj>",
    "GmL[LFQFTGVIWKXOXRWVVXTZQ[L[ R_MjM_[j[ RaEeHiE",
    "ImW[WF RWZU[Q[OZNYMWMQNOONQMUMWN R_MjM_[j[ RaEeHiE",
    "HiW[M[MF RdFdUcXaZ^[\\[",
    "HcW[M[MF R^M^_]a[bZb R^F]G^H_G^F^H",
    "MbU[SZRXRF R]M]_\\aZbYb R]F\\G]H^G]F]H",
    "GmL[LFX[XF RhFhUgXeZb[`[",
    "GgL[LFX[XF RbMb_aa_b^b RbFaGbHcGbFbH",
    "IfNMN[ RNOONQMTMVNWPW[ RaMa_`a^b]b RaF`GaHbGaFaH",
    "I[MUWU RK[RFY[ RN>RAV>",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNERHVE",
    "MWR[RF RN>RAV>",
    "MWR[RM RNERHVE", /* U+1D0 I_SMALL CARON */
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RN>RAV>",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RNERHVE",
    "G]LFLWMYNZP[T[VZWYXWXF RN>RAV>",
    "H[VMV[ RMMMXNZP[S[UZVY RNERHVE",
    "G]LFLWMYNZP[T[VZWYXWXF RN?O@NAM@N?NA RV?W@VAU@V?VA RM;W;",
    "H[VMV[ RMMMXNZP[S[UZVY RNFOGNHMGNFNH RVFWGVHUGVFVH RM@W@",
    "G]LFLWMYNZP[T[VZWYXWXF RN?O@NAM@N?NA RV?W@VAU@V?VA RT9Q<",
    "H[VMV[ RMMMXNZP[S[UZVY RNFOGNHMGNFNH RVFWGVHUGVFVH RT>QA",
    "G]LFLWMYNZP[T[VZWYXWXF RN?O@NAM@N?NA RV?W@VAU@V?VA RN9R<V9",
    "H[VMV[ RMMMXNZP[S[UZVY RNFOGNHMGNFNH RVFWGVHUGVFVH RN>RAV>",
    "G]LFLWMYNZP[T[VZWYXWXF RN?O@NAM@N?NA RV?W@VAU@V?VA RP9S<",
    "H[VMV[ RMMMXNZP[S[UZVY RNFOGNHMGNFNH RVFWGVHUGVFVH RP>SA",
    "I[NNPMTMVNWPWXVZT[P[NZMXMVWT",
    "I[MUWU RK[RFY[ RN?O@NAM@N?NA RV?W@VAU@V?VA RM;W;",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNFOGNHMGNFNH RVFWGVHUGVFVH RM@W@",
    "I[MUWU RK[RFY[ RR?Q@RAS@R?RA RM;W;", /* U+1E0 A_CAP DOT */
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RRFQGRHSGRFRH RM@W@",
    "F`JURU RRPYP RH[OF\\F RRFR[\\[ RO@Y@",
    "D`INKMOMQNRP R[ZY[U[SZRXRPSNUMYM[N\\P\\RRSKSITHVHXIZK[O[QZRX RMGWG",
    "F[VGTFQFNGLIKKJOJRKVLXNZQ[S[VZWYWRSR RSV[V",
    "I\\WMW^V`UaSbPbNa RWZU[Q[OZNYMWMQNOONQMUMWN RS^[^",
    "F[VGTFQFNGLIKKJOJRKVLXNZQ[S[VZWYWRSR RN>RAV>",
    "I\\WMW^V`UaSbPbNa RWZU[Q[OZNYMWMQNOONQMUMWN RNERHVE",
    "G\\L[LF RX[OO RXFLR RN>RAV>",
    "IZN[NF RPSV[ RVMNU RJANDRA",
    "G]R[P]O_PaRbTb RPFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF",
    "H[R[P]O_PaRbTb RP[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[",
    "G]R[P]O_PaRbTb RPFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RM@W@",
    "H[R[P]O_PaRbTb RP[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RMGWG",
    "H\\KFXFQNTNVOWPXRXWWYVZT[N[LZKY RN>RAV>",
    "JZMMVMOVRVTWUXVZV^U`TaRbObMa RNERHVE",
    "MWRMR_QaObNb RNERHVE", /* U+1F0 J_SMALL CARON */
    "GpL[LFQFTGVIWKXOXRWVVXTZQ[L[ R_FmF_[m[",
    "GmL[LFQFTGVIWKXOXRWVVXTZQ[L[ R_MjM_[j[",
    "ImW[WF RWZU[Q[OZNYMWMQNOONQMUMWN R_MjM_[j[",
    "F[VGTFQFNGLIKKJOJRKVLXNZQ[S[VZWYWRSR RT>QA",
    "I\\WMW^V`UaSbPbNa RWZU[Q[OZNYMWMQNOONQMUMWN RTEQH",
    "CaH[HF RHPTP RTFTXUZW[Z[\\Z]X]M",
    "G\\LFLb RLINGPFTFVGWHXJXOWRUUL^",
    "G]L[LFX[XF RP>SA",
    "I\\NMN[ RNOONQMTMVNWPW[ RPESH",
    "I[MUWU RK[RFY[ RZ9X< RR;P<O>P@RAT@U>T<R;",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RZ@XC RRBPCOEPGRHTGUETCRB",
    "F`JURU RRPYP RH[OF\\F RRFR[\\[ RV>SA",
    "D`INKMOMQNRP R[ZY[U[SZRXRPSNUMYM[N\\P\\RRSKSITHVHXIZK[O[QZRX RTEQH",
    "G]ZFJ[ RP[NZLXKTKMLINGPFTFVGXIYMYTXXVZT[P[ RT>QA",
    "H[XMK[ RP[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RTEQH",
    "I[MUWU RK[RFY[ ROAL> RVAS>", /* U+200 A_CAP GRAVE_DBL */
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR ROHLE RVHSE",
    "I[MUWU RK[RFY[ RNAO?Q>S>U?VA",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNHOFQESEUFVH",
    "H[MPTP RW[M[MFWF ROAL> RVAS>",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT ROHLE RVHSE",
    "H[MPTP RW[M[MFWF RNAO?Q>S>U?VA",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RNHOFQESEUFVH",
    "MWR[RF ROAL> RVAS>",
    "MWR[RM ROHLE RVHSE",
    "MWR[RF RNAO?Q>S>U?VA",
    "MWR[RM RNHOFQESEUFVH",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF ROAL> RVAS>",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ ROHLE RVHSE",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RNAO?Q>S>U?VA",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RNHOFQESEUFVH",
    "G\\X[QQ RL[LFTFVGWHXJXMWOVPTQLQ ROAL> RVAS>", /* U+210 R_CAP GRAVE_DBL */
    "KXP[PM RPQQORNTMVM RPHME RWHTE",
    "G\\X[QQ RL[LFTFVGWHXJXMWOVPTQLQ RNAO?Q>S>U?VA",
    "KXP[PM RPQQORNTMVM ROHPFRETEVFWH",
    "G]LFLWMYNZP[T[VZWYXWXF ROAL> RVAS>",
    "H[VMV[ RMMMXNZP[S[UZVY ROHLE RVHSE",
    "G]LFLWMYNZP[T[VZWYXWXF RNAO?Q>S>U?VA",
    "H[VMV[ RMMMXNZP[S[UZVY RNHOFQESEUFVH",
    "H\\LZO[T[VZWYXWXUWSVRTQPPNOMNLLLJMHNGPFUFXG RS`SaRcQd",
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN RS`SaRcQd",
    "JZLFXF RR[RF RS`SaRcQd",
    "MYOMWM RRFRXSZU[W[ RU`UaTcSd",
    "I]VRXTYVY[X]V_T`Lb RLHMGOFUFWGXHYJYNXPVRTSNU",
    "J[UWVXWZW]V_U`SaMb RMNOMSMUNVOWQWTVVUWSXOY",
    "G]L[LF RLPXP RX[XF RN>RAV>",
    "H[M[MF RV[VPUNSMPMNNMO RI>MAQ>",
    "G]L[LFX[XF RX[Xb", /* U+220 N_CAP LEG */
    "IbWFWXXZZ[\\[^Z_X^V\\UZVV^ RWNUMQMONNOMQMWNYOZQ[T[VZWX",
    "G]NFLGKIKKLMMNOO RVFXGYIYKXMWNUO ROOUOWPXQYSYWXYWZU[O[MZLYKWKSLQMPOO",
    "J[MJMMNORQVOWMWJ RPQTQVRWTWXVZT[P[NZMXMTNRPQ",
    "H\\KFYFK[Y[ RY[Y_XaVbTb",
    "IZLMWML[W[ RW[W_VaTbRb",
    "I[MUWU RK[RFY[ RR?Q@RAS@R?RA",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RRFQGRHSGRFRH",
    "H[MPTP RW[M[MFWF RR\\T]U_TaRbOb",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RR\\T]U_TaRbOb",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RN?O@NAM@N?NA RV?W@VAU@V?VA RM;W;",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RNFOGNHMGNFNH RVFWGVHUGVFVH RM@W@",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RMAN@P?TAV@W? RM;W;",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RMHNGPFTHVGWF RM@W@",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RR?Q@RAS@R?RA",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RRFQGRHSGRFRH",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RR?Q@RAS@R?RA RM;W;", /* U+230 O_CAP DOT */
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RRFQGRHSGRFRH RM@W@",
    "I[RQR[ RKFRQYF RM@W@",
    "JZMMR[ RWMR[P`OaMb RMGWG",
    "M]RFRXSZU[W[YZZXYVWUUVQ^",
    "IbNMN[ RNOONQMTMVNWPWXXZZ[\\[^Z_X^V\\UZVV^",
    "M]OMWM RRFRXSZU[W[YZZXYVWUUVQ^",
    "MWRMR_QaObNb",
    "D`R[RF RRZP[L[JZIYHWHQIOJNLMPMRN RTMXMZN[O\\Q\\W[YZZX[T[RZ",
    "D`RMRb RRZP[L[JZIYHWHQIOJNLMPMRN RTMXMZN[O\\Q\\W[YZZX[T[RZ",
    "I[MUWU RK[RFY[ RXCL`",
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH RXCL`",
    "HZVZT[P[NZMYLWLQMONNPMTMVN RWHM`",
    "HYW[M[MF RIOQO",
    "JZLFXF RR[RF RXCL`",
    "J[P[R^T_W_ RNZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN",
    "IZLMWML[N[P\\R^T_W_", /* U+240 Z_SMALL_SWASHTAIL  */
    "J^MGPFTFWGYIZKZNYPWRTSPSP[",
    "J^NNPMTMVNWOXQXSWUVVTWPWP[",
    "G\\SPVQWRXTXWWYVZT[L[LFSFUGVHWJWLVNUOSPLP RIUOU",
    "G]IM[M RLFLWMYNZP[T[VZWYXWXF",
    "I[Y[RFK[",
    "H[MPTP RW[M[MFWF RXCL`",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RWHM`",
    "JZUFUUTXRZO[M[ RQPYP",
    "MWRMR_QaObNb ROTUT RRFQGRHSGRFRH",
    "G]XFX^Y`Za\\b^b RXIVGTFPFNGLIKMKTLXNZP[T[VZXX",
    "I\\WMW^X`Ya[b]b RWZU[Q[OZNYMWMQNOONQMUMWN",
    "G\\X[QQ RL[LFTFVGWHXJXMWOVPTQLQ RIQOQ",
    "KXP[PM RPQQORNTMVM RMTUT",
    "I[KIYI RRQR[ RKFRQYF",
    "JZLQXQ RMMR[ RWMR[P`OaMb",
    /* // IPA EXTENSIONS (0250-02AF) */
    "H[MMMXNZP[T[VZ RMNOMTMVNWPWRVTTUOUMV", /* U+250 +A_SMALL  */
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[",
    "G\\K[NQOOPNRMTMVNWOXRXVWYVZT[R[PZOYNWMPLNJM",
    "H[RFPFNGMIM[ RMNOMSMUNVOWQWWVYUZS[O[MZ",
    "J\\NNPMTMVNWOXQXWWYVZT[P[NZ",
    "HZVNTMPMNNMOLQLWMYNZP[S[UZVXUVSUQVM^",
    "I\\W[WF RWZU[Q[OZNYMWMQNOONQMUMWN RW[W_XaZb\\b",
    "I\\\\FZFXGWIW[ RWZU[Q[OZNYMWMQNOONQMUMWN",
    "I[NZP[T[VZWXWPVNTMPMNNMPMRWT",
    "I[NNPMTMVNWPWXVZT[P[NZMXMVWT",
    "IbNNPMTMVNWPWXVZT[P[NZMXMV\\S\\U]W_X`X",
    "IZPTNUMWMXNZP[T[VZ RRTPTNSMQMPNNPMTMVN",
    "J[TTVSWQWPVNTMPMNN RRTTTVUWWWXVZT[P[NZ",
    "JaRTTTVUWWWXVZT[P[NZ RNNPMTMVNWPWQVSTT[S[U\\W^X_X",
    "H[TTVSWQWPVNTMPMNNMOLRLVMYNZP[T[VZWXWWVUTTRT",
    "MWRMR_QaObNb ROTUT",
    "I\\WMW^V`UaSbPbNa RWZU[Q[OZNYMWMQNOONQMUMWN RWMWIXGZF\\F", /* U+260 G_SMALL +HOOK */
    "I\\WYVZT[P[NZMXMQNOONQMWMW^V`UaSbMb",
    "HZUNSMPMNNMOLQLWMYNZP[T[VZVUSU",
    "JZMMU[U_TaRbPaO_O[WM",
    "JZMMTVUXTZR[PZOXPVWM",
    "I\\WMWb RNMNXOZQ[T[VZWY",
    "H[RFPFNGMIM[ RV[VPUNSMPMNNMO",
    "H[RFPFNGMIM[ RV[VPUNSMPMNNMO RV[V_UaSbQb",
    "MWR[RM ROTUT RRFQGRHSGRFRH",
    "MXRMRXSZU[",
    "MWR[RM RU[O[ RUMOM",
    "MXU[SZRXRF RMONNPMTOVNWM",
    "IYU[SZRXRF RRQQOONMOLQMSOTWT",
    "MXRFR_SaUbWb",
    "GZLFLXMZO[ RLMVMOVRVTWUXVZV^U`TaRbObMa",
    "D`[M[[ R[YZZX[U[SZRXRM RRXQZO[L[JZIXIM",
    "D`[M[[ R[YZZX[U[SZRXRM RRXQZO[L[JZIXIM R[[[b", /* U+270 +M_SMALL LEG */
    "D`I[IM RIOJNLMOMQNRPR[ RRPSNUMXMZN[P[[ R[[[_ZaXbVb",
    "I\\NMN[ RNOONQMTMVNWPW[ RN[N_MaKbIb",
    "I\\NMN[ RNOONQMTMVNWPW[ RW[W_XaZb\\b",
    "H[M[MMV[VM",
    "H[LTWT RP[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[",
    "E]RTXT RRMR[ RZMMMKNJOIQIWJYKZM[Z[",
    "G]RTRXSZU[V[XZYXYQXOWNUMOMMNLOKQKXLZN[O[QZRX",
    "G]RFRb RPMTMVNXPYRYVXXVZT[P[NZLXKVKRLPNNPM",
    "LYTMT[ RTWSYRZP[N[",
    "LYTMT[ RTWSYRZP[N[ RTMTF",
    "LYTMT[ RTWSYRZP[N[ RT[T_UaWbYb",
    "KXP[PM RPQQORNTMVM RP[Pb",
    "KXP[PM RPQQORNTMVM RP[P_QaSbUb",
    "KXM[S[ RVMTMRNQOPRP[",
    "LYW[Q[ RNMPMRNSOTRT[",
    "I[RUW[ RN[NMTMVNWPWRVTTUNU", /* U+280 R_SMALLCAP  */
    "I[RSWM RNMN[T[VZWXWVVTTSNS",
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN RN[N_OaQbSb",
    "KYWFUFSGRIR_QaObMb",
    "MWRMR_QaObNb ROTUT RRMRISGUFWF",
    "KYMFOFQGRIRXSZU[W[",
    "KYWFUFSGRIR_QaObMaL_M]O\\V\\",
    "KWU[M[ RRbRPQNOMMM",
    "MYOMWM RRFR_SaUbWb",
    "H[JRYR RVMV[ RMMMXNZP[S[UZVY",
    "I\\XMUMUPWRXTXWWYVZT[Q[OZNYMWMTNRPPPMMM",
    "H[MMMXNZP[S[UZVYWWWPVNUM",
    "JZW[RMM[",
    "G]Z[VMRWNMJ[",
    "JZW[RM RM[RMTHUGWF",
    "KYRTR[ RMMRTWM",
    "IZLMWML[W[ RW[W_XaZb\\b", /* U+290 Z_SMALL !HOOK */
    "IZLMWML[T[VZWXVVTURVN^",
    "JZMMVMOVRVTWUXVZV^U`TaRbObMa",
    "JZMMVMOVRVTWUXVZV^U`TaRbPbNaM_N]P\\R]Uc",
    "J^MGPFTFWGYIZKZNYPWRTSPSP[",
    "FZWGTFPFMGKIJKJNKPMRPSTST[",
    "J^MZP[T[WZYXZVZSYQWOTNPNPF",
    "F[WHVGSFQFNGLIKKJOJYK]L_NaQbSbVaW`",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RROQPRQSPRORQ",
    "I[STVUWWWXVZT[N[NMSMUNVPVQUSSTNT",
    "I\\PTNUMWMXNZP[T[VZWYXVXRWOVNTMPMNNMPMQNSPTRT",
    "HZUNSMPMNNMOLQLWMYNZP[T[VZVUSU RUMUIVGXFZF",
    "H[MTVT RMMM[ RVMV[",
    "LXRMR_QaObMaL_M]O\\V\\ RRFQGRHSGRFRH",
    "J[VMVb RTUNM RN[VS",
    "JYOMO[V[",
    "I\\WMWb RWZU[Q[OZNYMWMQNOONQMUMWN RWMWIXGZF\\F", /* U+2A0 Q_SMALL +HOOK */
    "J^MGPFTFWGYIZKZNYPWRTSPSP[ RLXTX",
    "FZWGTFPFMGKIJKJNKPMRPSTST[ RPXXX",
    "D`R[RF RRM]MR[][ RRZP[L[JZIYHWHQIOJNLMPMRN",
    "E`RFR[ RRNPMMMKNJOIQIWJYKZM[P[RZ RRM\\MUVXVZW[X\\Z\\^[`ZaXbUbSa",
    "D`R[RF RRM]MR[Z[\\Z]X\\VZUXVT^ RRZP[L[JZIYHWHQIOJNLMPMRN",
    "G^IMQM RLFLXMZO[QZS[W[YZZXZWYUWTTTRSQQQPRNTMWMYN",
    "I[KMTM RNFNXOZQ[T[ RYFWFUGTIT_SaQbOb",
    "F^HMPM RKFKXLZN[P[RZ RZNXMTMRNQOPQPWQYRZT[W[YZZXYVWUUVQ^",
    "F]HMPMP[ RK[KILGNFPF RPOQNSMVMXNYPY_XaVbTb",
    "G^LFLXMZO[QZS[W[YZZXZWYUWTTTRSQQQPRNTMWMYN",
    "H^MM[MP[ RMFMXNZP[[[",
    "G]JSN[RUV[ZS RJFNNRHVNZF",
    "G]XXXSLSLX RXKXFLFLK",
    "I\\WMWb RNMNXOZQ[T[VZWY RNMNIMGKFIF",
    "I\\\\bZbXaW_WM RNMNXOZQ[T[VZWY RNMNIMGKFIF",
    /* // SPACING MODIFIER LETTERS (02B0-02FF) */
    "F^K[KFYFY[K[", /* U+2B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // COMBINING DIACRITICAL MARKS (0300-036F) */
    "F^K[KFYFY[K[", /* U+300 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+310 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+320 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+330 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+340 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+350 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+360 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // GREEK AND COPTIC (0370-03FF) */
    "H[MFM[ RXPMP", /* U+370 HETA_CAP  */
    "IZNTVT RNMN[",
    "G]R[RF RKOKFYFYO",
    "I[R[RF RMOMFWFWO",
    "MWSFQJ",
    "MWS[Q_",
    "G]LFL[XFX[",
    "H\\MMM[WMW[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "NVR`RcSdTd",
    "J\\NZP[T[VZWYXWXQWOVNTMPMNN",
    "HZVZT[P[NZMYLWLQMONNPMTMVN RRSQTRUSTRSRU",
    "J\\NZP[T[VZWYXWXQWOVNTMPMNN RRSQTRUSTRSRU",
    "MWSZS[R]Q^ RRNSORPQORNRP",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+380 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "NVTEQH",
    "LXNFOGNHMGNFNH RVFWGVHUGVFVH RT>QA",
    "G[MUWU RK[RFY[ RMEJH",
    "JZRRQSRTSSRRRT",
    "B[MPTP RW[M[MFWF RHEEH",
    "A]L[LF RLPXP RX[XF RGEDH",
    "GWR[RF RMEJH",
    "RR",
    "B]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RHEEH",
    "RR",
    "@[RQR[ RKFRQYF RFECH",
    "@^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RFECH",
    "MXRMRXSZU[ RNFOGNHMGNFNH RVFWGVHUGVFVH RT>QA", /* U+390 IOTA_SMALL DIAERESIS */
    "I[MUWU RK[RFY[",
    "G\\SPVQWRXTXWWYVZT[L[LFSFUGVHWJWLVNUOSPLP",
    "HZM[MFXF",
    "I[K[RFY[K[",
    "H[MPTP RW[M[MFWF",
    "H\\KFYFK[Y[",
    "G]L[LF RLPXP RX[XF",
    "F^OPUP RPFTFVGXIYKZNZSYVXXVZT[P[NZLXKVJSJNKKLINGPF",
    "MWR[RF",
    "G\\L[LF RX[OO RXFLR",
    "I[K[RFY[",
    "F^K[KFRUYFY[",
    "G]L[LFX[XF",
    "H[L[W[ RLFWF RUPNP",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF",
    "G]L[LFXFX[", /* U+3A0 PI_CAP  */
    "G\\L[LFTFVGWHXJXMWOVPTQLQ",
    "RR",
    "H[W[L[SPLFWF",
    "JZLFXF RR[RF",
    "I[RQR[ RKFRQYF",
    "G]R[RF RPITIWJYLZNZRYTWVTWPWMVKTJRJNKLMJPI",
    "H\\KFY[ RYFK[",
    "G]R[RF RHFJGKIKNLQMROSUSWRXQYNYIZG\\F",
    "F^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[",
    "MWR[RF RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "I[RQR[ RKFRQYF RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RTEQH",
    "IZPTNUMWMXNZP[T[VZ RRTPTNSMQMPNNPMTMVN RTEQH",
    "I\\NMN[ RNOONQMTMVNWPWb RTEQH",
    "MXRMRXSZU[ RTEQH",
    "H[MMMXNZP[S[UZVYWWWPVNUM RNFOGNHMGNFNH RVFWGVHUGVFVH RT>QA", /* U+3B0 UPSILON_SMALL DIAERESIS */
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[",
    "H[SOUPVQWSWWVYUZS[P[NZMY RKbLaM_MINGPFSFUGVIVLUNSOQO",
    "JZRYRb RLMMMNNRYWM",
    "H[SMPMNNMOLQLWMYNZP[S[UZVYWWWQVOUNSMPLNKMINGPFTFVG",
    "IZPTNUMWMXNZP[T[VZ RRTPTNSMQMPNNPMTMVN",
    "HZMFWFPMNPMSMWNYOZQ[S[U\\V^V_UaSbRb",
    "I\\NMN[ RNOONQMTMVNWPWb",
    "H[LPWP RPFSFUGVHWKWVVYUZS[P[NZMYLVLKMHNGPF",
    "MXRMRXSZU[",
    "IZNMN[ RPSV[ RVMNU",
    "JZRMM[ RMFOFPGRMW[",
    "H^MMMb RWXXZZ[ RMXNZP[T[VZWXWM",
    "J[MMR[WPWOVM",
    "HZMFWF RQFOGNINLONQOUO RQOOPNQMSMWNYOZQ[S[U\\V^V_UaSbRb",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[",
    "F]VMV[ ROMOXNZL[ RZMMMKNJP", /* U+3C0 PI_SMALL  */
    "H\\MbMQNOONQMTMVNWOXQXWWYVZT[Q[OZMX",
    "HZVNTMPMNNMOLQLWMYNZP[S[U\\V^V_UaSb",
    "H\\YMPMNNMOLQLWMYNZP[S[UZVYWWWQVOUNSM",
    "H\\LPMNOMXM RRMRXSZU[",
    "H[MMMXNZP[S[UZVYWWWPVNUM",
    "G]MMLNKPKVLXNZP[T[VZXXYVYPXNVMUMSNRPRb",
    "IZWMLb RLMNNOPT_UaWb",
    "G]RMRb RKMKVLXNZP[T[VZXXYVYM",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM",
    "LXNFOGNHMGNFNH RVFWGVHUGVFVH RRMRXSZU[",
    "H[MMMXNZP[S[UZVYWWWPVNUM RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RTEQH",
    "H[MMMXNZP[S[UZVYWWWPVNUM RTEQH",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RTEQH",
    "G\\L[LF RXFLR ROOX[Qb",
    "H[SOUPVQWSWWVYUZS[P[NZMXMINGPFSFUGVIVLUNSOQO", /* U+3D0 BETA_SMALL_CURLED  */
    "H[JPKQLSLVMYNZP[S[UZVYWVWKVHUGSFPFNGMHLJLLMNNOPPWP",
    "I\\KFMFOGQIRKR[ RRKSHTGVFWFYGZI",
    "NiTEQH RXFZF\\G^I_K_[ R_K`HaGcFdFfGgI",
    "I\\KFMFOGQIRKR[ RRKSHTGVFWFYGZI RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "G]RFRb RPMTMVNXPYRYVXXVZT[P[NZLXKVKRLPNNPM",
    "F^RTRX R[MIM RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM",
    "IZLMNNOPOXNZM[LZLXMVVRWPWNVMUNTPTXUZW[V^U`TaRb",
    "G]R[Rb RPFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF",
    "H[R[Rb RP[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[",
    "FZWFQFNGLIKKJOJRKVLXNZQ[R[T\\U^U_TaSbQb",
    "HZVMPMNNMOLQLWMYNZP[R[T\\U^U_TaRbPb",
    "HZTPMP RM[MFWF",
    "MZVPRP RWFUFSGRIR_QaOb",
    "H\\MFOGPILSXNTXUZW[",
    "I[RFMPWPR[",
    "H\\NGNL RXIULTNTW RKIMGPFTFVGXIYKZOZUYYX[", /* U+3E0 SAMPI_CAP  */
    "H\\L[UR RR[WV RLMPNSPURWVXZXb",
    "CaRWRR R\\XY]V`SaMa RLFJGHIGLGUHXJZL[N[PZQYRWSYTZV[X[ZZ\\X]U]L\\IZGXF",
    "G]RTRX RXZW\\S`PaOa RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM",
    "G]XFXb RPFNGLIKMKTLXNZP[T[VZXX",
    "I\\WMWb RQMONNOMQMWNYOZQ[T[VZWY",
    "F]KFK[ RKQMOPNTNVOXQYTYWXZW\\U^R`Nb",
    "I[WLWMVPTRRSPSNRMPMONMPLRLTMVPWSWWVYUZS[M[",
    "F]KHLGOFTFWGXHYJYLXOVQJ[N^Q_V_Y^",
    "J[NNPMTMVNWPWRVTTVN[P]R^U^W]",
    "G]I[[[ RIFJFLGXZZ[ R[FZFXGLZJ[",
    "H[KMMNVZX[K[MZVNXM",
    "G\\XEVFOFMGLHKJKWLYMZO[T[VZWYXWXPWNVMTLNLLMKN",
    "H[WEVFTGPGNHMILKLWMYNZP[S[UZVYWWWQVOUNSMOMMNLO",
    "G]RFRb RKQKMYMYQ",
    "I[MMWM RRFRb",
    "IZLMNNOPOXNZM[LZLXMVVRWPWNVMUNTPTXUZW[", /* U+3F0 KAPPA_SMALL_SCRIPT  */
    "H\\WbQbOaN`M^MQNOONQMTMVNWOXQXWWYVZT[Q[OZMX",
    "HZVZT[P[NZMYLWLQMONNPMTMVN",
    "MWRMR_QaObNb RRFQGRHSGRFRH",
    "G]KPYP RPFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF",
    "HZLTST RVZT[P[NZMYLWLQMONNPMTMVN",
    "J\\XTQT RNZP[T[VZWYXWXQWOVNTMPMNN",
    "G\\LFL[ RLKTKVLWMXOXRWTVUTVLV",
    "H[MFMb RMNOMSMUNVOWQWWVYUZS[O[MZ",
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH",
    "F^K[KFRMYFY[",
    "G]LbLMRSXMX[",
    "G\\J`S` RMbMQNOONQMTMVNWOXQXWWYVZT[Q[OZMX",
    "I^MYNZQ[S[VZXXYVZRZOYKXIVGSFQFNGMH",
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH RROQPRQSPRORQ",
    "I^MYNZQ[S[VZXXYVZRZOYKXIVGSFQFNGMH RROQPRQSPRORQ",
    /* // Cyrillic (0400-04FF) */
    "H[MPTP RW[M[MFWF RP>SA", /* U+400 E_CAP GRAVE */
    "H[MPTP RW[M[MFWF RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "JbLFXF RR[RF RRMXM[N]P^S^\\]_[aXbVb",
    "HZM[MFXF RT>QA",
    "F[JPTP RWYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH",
    "H\\LZO[T[VZWYXWXUWSVRTQPPNOMNLLLJMHNGPFUFXG",
    "MWR[RF",
    "MWR[RF RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "JZUFUUTXRZO[M[",
    "AbC[D[FZGXILJILGOFRFR[X[[Z]X^V^S]Q[OXNRN",
    "AbF[FF RRFR[X[[Z]X^V^S]Q[OXNFN",
    "JbLFXF RR[RF RRMXM[N]P^S^[",
    "G\\L[LF RX[OO RXFLR RT>QA",
    "G]LFL[XFX[ RP>SA",
    "G[KFRT RYFPXNZL[K[ RN>O@QASAU@V>",
    "G]R[R` RLFL[X[XF",
    "I[MUWU RK[RFY[", /* U+410 A_CAP  */
    "G\\VFLFL[R[UZWXXVXSWQUORNLN",
    "G\\SPVQWRXTXWWYVZT[L[LFSFUGVHWJWLVNUOSPLP",
    "HZM[MFXF",
    "F^[`[[I[I` RW[WFRFPGOHNJL[",
    "H[MPTP RW[M[MFWF",
    "BbOOF[ RR[RF RRRFF R^[UO R^FRR",
    "I]PPTP RMGOFTFVGWHXJXLWNVOTPWQXRYTYWXYWZU[O[MZ",
    "G]LFL[XFX[",
    "G]LFL[XFX[ RN>O@QASAU@V>",
    "G\\L[LF RX[OO RXFLR",
    "F\\W[WFTFQGOINLLXKZI[H[",
    "F^K[KFRUYFY[",
    "G]L[LF RLPXP RX[XF",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF",
    "G]L[LFXFX[",
    "G\\L[LFTFVGWHXJXMWOVPTQLQ", /* U+420 P_CAP  */
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH",
    "JZLFXF RR[RF",
    "G[KFRT RYFPXNZL[K[",
    "G]R[RF RPITIWJYLZNZRYTWVTWPWMVKTJRJNKLMJPI",
    "H\\KFY[ RYFK[",
    "G]XFX[ RLFL[Z[Z`",
    "H\\WFW[ RLFLNMPNQPRWR",
    "CaRFR[ RHFH[\\[\\F",
    "CaRFR[ RHFH[\\[\\F R\\[^[^`",
    "F]HFMFM[S[VZXXYVYSXQVOSNMN",
    "Da\\F\\[ RIFI[O[RZTXUVUSTQROONIN",
    "H]MFM[S[VZXXYVYSXQVOSNMN",
    "I^ZQPQ RMHNGQFSFVGXIYKZOZRYVXXVZS[Q[NZMY",
    "CaHFH[ ROPHP RTFXFZG\\I]M]T\\XZZX[T[RZPXOTOMPIRGTF",
    "G\\RQK[ RW[WFOFMGLHKJKMLOMPOQWQ",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR", /* U+430 A_SMALL  */
    "H[WEVFTGPGNHMILKLWMYNZP[S[UZVYWWWQVOUNSMOMMNLO",
    "I[STVUWWWXVZT[N[NMSMUNVPVQUSSTNT",
    "JYO[OMWM",
    "H[WOVNTMPMNNMOLQLWMYNZP[S[UZVYWWWJVHUGSFOFMG",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT",
    "F^QTJ[ RRUJM RRMR[ RZ[ST RZMRU",
    "K[RTTT RNNPMTMVNWPWQVSTTVUWWWXVZT[P[NZ",
    "H\\MMM[WMW[",
    "H\\MMM[WMW[ RNEOGQHSHUGVE",
    "IZNMN[ RPSV[ RVMNU",
    "I[V[VMSMQNPPOXNZL[",
    "G]L[LMRXXMX[",
    "H[MTVT RMMM[ RVMV[",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[",
    "H[M[MMVMV[",
    "H[MMMb RMNOMSMUNVOWQWWVYUZS[O[MZ", /* U+440 P_SMALL  */
    "HZVZT[P[NZMYLWLQMONNPMTMVN",
    "KYMMWM RRMR[",
    "JZMMR[ RWMR[P`OaMb",
    "G]RFRb RPMTMVNXPYRYVXXVZT[P[NZLXKVKRLPNNPM",
    "IZL[WM RLMW[",
    "I\\WMW[ RNMN[Y[Y`",
    "J\\VMV[ RNMNROTQUVU",
    "F^RMR[ RKMK[Y[YM",
    "F^RMR[ RKMK[Y[YM RY[[[[`",
    "HZJMNMN[S[UZVXVUUSSRNR",
    "F^YMY[ RKMK[P[RZSXSURSPRKR",
    "IZNMN[S[UZVXVUUSSRNR",
    "J\\XTQT RNNPMTMVNWOXQXWWYVZT[P[NZ",
    "E_JTPT RJMJ[ RT[RZQYPWPQQORNTMWMYNZO[Q[WZYYZW[T[",
    "I[RUM[ RV[VMPMNNMPMRNTPUVU",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RPESH", /* U+450 E_SMALL GRAVE */
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "M^OKXK RRFR[ RRSSRUQWQYRZTZ[Y^WaVb",
    "JYO[OMWM RTEQH",
    "HZLTST RVZT[P[NZMYLWLQMONNPMTMVN",
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN",
    "MWR[RM RRFQGRHSGRFRH",
    "LXNFOGNHMGNFNH RVFWGVHUGVFVH RR[RM",
    "MWRMR_QaObNb RRFQGRHSGRFRH",
    "E^H[JZKXLPMNOMRMR[W[YZZXZUYSWRRR",
    "D^IMI[ RRMR[W[YZZXZVYTWSIS",
    "M^OKXK RRFR[ RRSSRUQWQYRZTZ[",
    "IZNMN[ RPSV[ RVMNU RTEQH",
    "H\\MMM[WMW[ RPESH",
    "JZMMR[ RWMR[P`OaMb RNEOGQHSHUGVE",
    "H]R[R` RMMM[W[WM",
    "CaRWRR RLFJGHIGLGUHXJZL[N[PZQYRWSYTZV[X[ZZ\\X]U]L\\IZGXF", /* U+460 OMEGA_LARGE  */
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM",
    "F]IIVI RMFM[S[VZXXYVYSXQVOSNMN",
    "HZJMTM RNFN[S[UZVXVUUSSRNR",
    "D`IFI[ RYPIP R\\Y[ZX[V[SZQXPVOROOPKQISGVFXF[G\\H",
    "F^KMK[ RWTKT RZZX[T[RZQYPWPQQORNTMXMZN",
    "F^LSXS RRSR[ RH[RF\\[",
    "I[NUVU RRUR[ RK[RMY[",
    "AbF[FF RFS\\S RVSV[ RL[VF`[",
    "E_J[JM RVUV[ RZUJU RO[VM][",
    "E_R[RPJFZFRP RI[IVJSLQOPUPXQZS[V[[",
    "G]R[RTLMXMRT RK[KXLVMUOTUTWUXVYXY[",
    "AcF[FF RFPSP RV[VPNF^FVP RM[MVNSPQSPYP\\Q^S_V_[",
    "DaI[IM RITST RV[VTPM\\MVT RO[OXPVQUSTYT[U\\V]X][",
    "H\\OPSP RNAQFSBTAUA RLGNFSFUGVHWJWLVNUOSPVQWRXTXWWYVZT[O[M\\L^L_MaObWb",
    "J[RTTT ROHRMTIUHVH RNNPMTMVNWPWQVSTTVUWWWXVZT[Q[O\\N^N_OaQbVb",
    "G]R[RF RHFJGKIKNLQMROSUSWRXQYNYIZG\\F", /* U+470 PSI_CAP  */
    "G]RMRb RKMKVLXNZP[T[VZXXYVYM",
    "G]KPYP RPFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF",
    "H[LTWT RP[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[",
    "I[KFR[YF",
    "JZMMR[WM",
    "I[KFR[YF ROAL> RVAS>",
    "JZMMR[WM ROHLE RVHSE",
    "GmPFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF R`Me[ RjMe[c`ba`b",
    "HkP[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ R^Mc[ RhMc[a``a^b",
    "CaRXR^ RRCRI RMFJGHIGLGUHXJZM[W[ZZ\\X]U]L\\IZGWFMF",
    "G]RYR] RRKRO ROMMNLOKQKWLYMZO[U[WZXYYWYQXOWNUMOM",
    "CaRWRR RLFJGHIGLGUHXJZL[N[PZQYRWSYTZV[X[ZZ\\X]U]L\\IZGXF RLBM@O?R?U@X@",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RLIMGOFRFUGXG",
    "CaRWRR RLFJGHIGLGUHXJZL[N[PZQYRWSYTZV[X[ZZ\\X]U]L\\IZGXF RM<W< RR<R?",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RMEWE RRERH",
    "FZWGTFPFMGKIJKJNKPMRPSTST[", /* U+480 KOPPA_CYR_CAP  */
    "FZVNTMPMNNMOLQLSMUNVPWTWT[",
    "H[N]UO ROQWU RT[LW",
    "JZMHMFWGWE",
    "JZMHUEVH",
    "NVPESH",
    "NVTEQH",
    "KZLIMGOFRFUGXG",
    ":j>R?PAOCPDR RC^D\\F[H\\I^ RCFDDFCHDIF ROcPaR`TaUc ROAP?R>T?UA R[^\\\\^[`\\a^ R[F\\D^C`DaF R`RaPcOePfR",
    ":jDQ>Q RH[D_ RHGDC RR_Re RRCR= R\\[`_ R\\G`C R`QfQ",
    "G]LFL[XFX[ RX[[[Ub RN>O@QASAU@V>",
    "H\\MMM[WMW[ RW[Z[Tb RNEOGQHSHUGVE",
    "H]MFM[S[VZXXYVYSXQVOSNMN RJIPI",
    "IZKMQM RNFN[S[UZVXVUUSSRNR",
    "G\\L[LFTFVGWHXJXMWOVPTQLQ RTMXS",
    "H[MMMb RMNOMSMUNVOWQWWVYUZS[O[MZ RSWW]",
    "HZM[MFXFXA", /* U+490 GAMMA_CAP_UPTURN  */
    "JYO[OMWMWH",
    "HZM[MFXF RJQRQ",
    "JYO[OMWM RLTTT",
    "H]M[MFXF RMMSMVNXPYSY\\X_VaSbQb",
    "J\\O[OMWM ROTTTVUWVXXX[W^UaTb",
    "BbOOF[ RR[RF RRRFF R^[UO R^FRR R^[`[``",
    "F^QTJ[ RRUJM RRMR[ RZ[ST RZMRU RZ[\\[\\`",
    "I]PPTP RMGOFTFVGWHXJXLWNVOTPWQXRYTYWXYWZU[O[MZ RR\\T]U_TaRbOb",
    "K[RTTT RNNPMTMVNWPWQVSTTVUWWWXVZT[P[NZ RR\\T]U_TaRbOb",
    "G\\L[LF RX[OO RXFLR RX[Z[Z`",
    "IZNMN[ RPSV[ RVMNU RV[X[X`",
    "G\\L[LF RX[OO RXFLR RPKPS",
    "IZNMN[ RPSV[ RVMNU RRORW",
    "G\\L[LF RX[OO RXFLR RIJOJ",
    "IZN[NF RPSV[ RVMNU RKJQJ",
    "E\\X[OO RXFLR RGFLFL[", /* U+4A0 K_CAP_BASHKIR  */
    "HZPSV[ RVMNU RJMNMN[",
    "G]L[LF RLPXP RX[XF RX[Z[Z`",
    "H[MTVT RMMM[ RVMV[ RV[X[X`",
    "GeL[LF RLPXP RX[XFcF",
    "H`MTVT RMMM[ RV[VM^M",
    "GhL[LFXFX[ RXM^MaNcPdSd\\c_aa^b\\b",
    "HcM[MMVMV[ RVT[T]U^V_X_[^^\\a[b",
    "F^QFNGLIKKJOJRKVLXNZQ[S[VZXXYVZRZMYJWIVITJSMSRTVUXWZY[[[",
    "H\\QMPMNNMOLQLWMYNZP[T[VZWYXWXRWPUOSPRRRWSYTZV[Y[",
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH RR\\T]U_TaRbOb",
    "HZVZT[P[NZMYLWLQMONNPMTMVN RR\\T]U_TaRbOb",
    "JZLFXF RR[RF RR[T[T`",
    "KYMMWM RRMR[ RR[T[T`",
    "I[RQR[ RKFRQYF",
    "JZR[Rb RMMR[WM",
    "I[RQR[ RKFRQYF RNUVU", /* U+4B0 Y_CAP STROKE_H */
    "JZR[Rb RMMR[WM RN]V]",
    "H\\KFY[ RYFK[ RX[Z[Z`",
    "IZL[WM RLMW[ RV[X[X`",
    "D]FFRF RXFX[ RLFL[Z[Z`",
    "G\\RMIM RWMW[ RNMN[Y[Y`",
    "H\\WFW[ RLFLNMPNQPRWR RW[Y[Y`",
    "J\\VMV[ RNMNROTQUVU RV[X[X`",
    "H\\WFW[ RLFLNMPNQPRWR RRNRV",
    "J\\VMV[ RNMNROTQUVU RRQRY",
    "G]L[LF RL[ RLPRPUQWSXVX[",
    "H[M[MF RV[VPUNSMPMNNMO",
    "@^WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGXIYKZOJQGQEPDOCMCK",
    "E[VZT[P[NZMXMPNNPMTMVNWPWRMTKTISHQHO",
    "@^WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGXIYKZOJQGQEPDOCMCK RR[P]O_PaRbTb",
    "E[VZT[P[NZMXMPNNPMTMVNWPWRMTKTISHQHO RR[P]O_PaRbTb",
    "MWR[RF", /* U+4C0 I_CAP  */
    "BbOOF[ RR[RF RRRFF R^[UO R^FRR RN>O@QASAU@V>",
    "F^QTJ[ RRUJM RRMR[ RZ[ST RZMRU RNEOGQHSHUGVE",
    "G\\L[LF RX[OO RXFLR RX[X_WaUbSb",
    "IZNMN[ RPSV[ RVMNU RV[V_UaSbQb",
    "F\\W[WFTFQGOINLLXKZI[H[ RW[Z[Tb",
    "I[V[VMSMQNPPOXNZL[ RV[Y[Sb",
    "G]L[LF RLPXP RX[XF RX[X_WaUbSb",
    "H[MTVT RMMM[ RVMV[ RV[V_UaSbQb",
    "G]L[LF RLPXP RX[XF RX[[[Ub",
    "H[MTVT RMMM[ RVMV[ RV[Y[Sb",
    "H\\WFW[ RLFLNMPNQPRWR RW[U[U`",
    "J\\VMV[ RNMNROTQUVU RV[T[T`",
    "F^K[KFRUYFY[ RY[\\[Vb",
    "G]L[LMRXXMX[ RX[[[Ub",
    "MWR[RF",
    "I[MUWU RK[RFY[ RN>O@QASAU@V>", /* U+4D0 A_CAP BREVE */
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNEOGQHSHUGVE",
    "I[MUWU RK[RFY[ RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "F`JURU RRPYP RH[OF\\F RRFR[\\[",
    "D`INKMOMQNRP R[ZY[U[SZRXRPSNUMYM[N\\P\\RRSKSITHVHXIZK[O[QZRX",
    "H[MPTP RW[M[MFWF RN>O@QASAU@V>",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RNEOGQHSHUGVE",
    "F^MHNGQFSFVGXIYKZOZRYVXXVZS[Q[NZLXKVJRZP",
    "I[NNPMTMVNWPWXVZT[P[NZMXMVWT",
    "F^MHNGQFSFVGXIYKZOZRYVXXVZS[Q[NZLXKVJRZP RNBOCNDMCNBND RVBWCVDUCVBVD",
    "I[NNPMTMVNWPWXVZT[P[NZMXMVWT RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "BbOOF[ RR[RF RRRFF R^[UO R^FRR RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "F^QTJ[ RRUJM RRMR[ RZ[ST RZMRU RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "I]PPTP RMGOFTFVGWHXJXLWNVOTPWQXRYTYWXYWZU[O[MZ RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "K[RTTT RNNPMTMVNWPWQVSTTVUWWWXVZT[P[NZ RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "H\\KFXFQNTNVOWPXRXWWYVZT[N[LZKY", /* U+4E0 DIGIT_3  */
    "JZMMVMOVRVTWUXVZV^U`TaRbObMa",
    "G]LFL[XFX[ RM@W@",
    "H\\MMM[WMW[ RMGWG",
    "G]LFL[XFX[ RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "H\\MMM[WMW[ RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "G]KPYP RPFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF",
    "H[LTWT RP[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[",
    "G]KPYP RPFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "H[LTWT RP[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "I^ZPPP RMYNZQ[S[VZXXYVZRZOYKXIVGSFQFNGMH RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "J\\XTQT RNZP[T[VZWYXWXQWOVNTMPMNN RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "G[KFRT RYFPXNZL[K[ RM@W@",
    "JZMMR[ RWMR[P`OaMb RMGWG",
    "G[KFRT RYFPXNZL[K[ RN?O@NAM@N?NA RV?W@VAU@V?VA", /* U+4F0 Y_LARGE DIAERESIS */
    "JZMMR[ RWMR[P`OaMb RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "G[KFRT RYFPXNZL[K[ RQ>NA RX>UA",
    "JZMMR[ RWMR[P`OaMb RQENH RXEUH",
    "H\\WFW[ RLFLNMPNQPRWR RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "J\\VMV[ RNMNROTQUVU RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "HZM[MFXF RM[O[O`",
    "JYO[OMWM RO[Q[Q`",
    "Da\\F\\[ RIFI[O[RZTXUVUSTQROONIN RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "F^YMY[ RKMK[P[RZSXSURSPRKR RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "HZWFMFM[Q[Q_PaNbLb RJQRQ",
    "JYWMOMO[S[S_RaPbNb RLTTT",
    "H\\KFY[ RYFK[ RX[X_WaUbSb",
    "IZL[WM RLMW[ RV[V_UaSbQb",
    "H\\KFY[ RYFK[ RNPVP",
    "IZL[WM RLMW[ RNTVT",
    /* // Cyrillic Supplement (500-52F) */
    "G\\WFW[Q[NZLXKVKSLQNOQNWN", /* U+500 !SOFT_CAP  */
    "J[VMV[Q[OZNXNUOSQRVR",
    "B_RXSZU[X[ZZ[X[M RRFRXQZO[L[IZGXFVFSGQIOLNRN",
    "E]RXSZU[V[XZYXYQ RRMRXQZO[M[KZJXJUKSMRRR",
    "IePPTP RMGOFTFVGWHXJXLWNVOTPVQWRXTXXYZ[[^[`ZaXaM",
    "KbRTTT RNNPMTMVNWPWQVSTTVUWWWXXZZ[[[]Z^X^Q",
    "I\\PPTP RMGOFTFVGWHXJXLWNVOTPVQWRXTX[Z[Z`",
    "K[RTTT RNNPMTMVNWPWQVSTTVUWWW[Y[Y`",
    "FdH[I[KZLXNLOIQGTFWFWXXZZ[][_Z`X`M",
    "IaL[NZOXPPQNSMVMVXWZY[Z[\\Z]X]Q",
    "CaH[HF RHPTP RTFTXUZW[Z[\\Z]X]M",
    "F^KTTT RKMK[ RTMTXUZW[X[ZZ[X[R",
    "F[VGTFQFNGLIKKJOJRKVLXNZQ[S[VZWYWRSR",
    "HZUNSMPMNNMOLQLWMYNZP[T[VZVUSU",
    "J_LFXF RRFRXSZU[X[ZZ[X[M",
    "K]MMWM RRMRXSZU[V[XZYXYS",
    "G[PPTP RWGUFPFNGMHLJLLMNNOPPMQLRKTKWLYMZO[U[WZ", /* U+510 EPSILON_LARGE  */
    "IZPTNUMWMXNZP[T[VZ RRTPTNSMQMPNNPMTMVN",
    "F\\W[WFTFQGOINLLXKZI[H[ RW[W_VaTbRb",
    "I[V[VMSMQNPPOXNZL[ RV[V_UaSbQb",
    "BaP[^F RD[E[GZHXJLKIMGPF^[",
    "E^[MO[ RH[JZKXLPMNOM[[",
    "E_\\FUO\\[ RJ[JFRFTGUHVJVMUOTPRQJQ",
    "F^KMKb R[MUT[[ RKNMMQMSNTOUQUWTYSZQ[M[KZ",
    "DaOQH[ RTFT[^[ R[QLQJPIOHMHJIHJGLF^F",
    "D`H[MU RRPRMKMINHPHRITKURU R[ZY[U[SZRXRPSNUMYM[N\\P\\RRT",
    "G]Z]X\\VZSWQVOV RP[NZLXKTKMLINGPFTFVGXIYMYTXXVZT[P[",
    "I\\WMWb RWZU[Q[OZNYMWMQNOONQMUMWN",
    "F^IFN[RLV[[F",
    "G]JMN[RQV[ZM",
    "G\\L[LF RX[OO RXFLR RXKRG",
    "IZNMN[ RPSV[ RVMNU RWQQM",
    "FgW[WFTFQGOINLLXKZI[H[ RWM]M`NbPcSc\\b_`a]b[b", /* U+520 LYUDI_CAP MIDDLE_HOOK_CAP */
    "IcV[VMSMQNPPOXNZL[ RVT[T]U^V_X_[^^\\a[b",
    "GhL[LF RLPXP RX[XF RXM^MaNcPdSd\\c_aa^b\\b",
    "HcMTVT RMMM[ RVMV[ RVT[T]U^V_X_[^^\\a[b",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Armenian (530-58F) */
    "F^K[KFYFY[K[", /* U+530 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+540 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+550 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+560 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+570 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+580 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Hebrew (590-5FF) */
    "F^K[KFYFY[K[", /* U+590 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+5A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+5B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+5C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+5D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+5E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+5F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Arabic (600-6FF) */
    "F^K[KFYFY[K[", /* U+600 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+610 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+620 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+630 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+640 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+650 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+660 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+670 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+680 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+690 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+6A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+6B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+6C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+6D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+6E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+6F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Syriac (700-74F) */
    "F^K[KFYFY[K[", /* U+700 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+710 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+720 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+730 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+740 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Arabic Supplement (750-77F) */
    "F^K[KFYFY[K[", /* U+750 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+760 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+770 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Taana (780-7BF) */
    "F^K[KFYFY[K[", /* U+780 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+790 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+7A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+7B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // N'Ko (7C0-7FF) */
    "F^K[KFYFY[K[", /* U+7C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+7D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+7E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+7F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // - (800-8FF) */
    "F^K[KFYFY[K[", /* U+800 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+810 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+820 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+830 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+840 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+850 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+860 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+870 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+880 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+890 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+8A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+8B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+8C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+8D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+8E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+8F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Devanagari (900-97F) */
    "F^K[KFYFY[K[", /* U+900 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+910 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+920 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+930 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+940 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+950 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+960 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+970 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Bengali (980-9FF) */
    "F^K[KFYFY[K[", /* U+980 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+990 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+9A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+9B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+9C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+9D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+9E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+9F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Gurmukhi (A00-A7F) */
    "F^K[KFYFY[K[", /* U+A00 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+A10 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+A20 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+A30 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+A40 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+A50 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+A60 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+A70 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Gujarati (A80-AFF) */
    "F^K[KFYFY[K[", /* U+A80 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+A90 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+AA0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+AB0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+AC0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+AD0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+AE0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+AF0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Oriya (B00-B7F) */
    "F^K[KFYFY[K[", /* U+B00 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+B10 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+B20 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+B30 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+B40 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+B50 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+B60 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+B70 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Tamil (B80-BFF) */
    "F^K[KFYFY[K[", /* U+B80 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+B90 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+BA0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+BB0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+BC0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+BD0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+BE0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+BF0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Telugu (C00-C7F) */
    "F^K[KFYFY[K[", /* U+C00 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+C10 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+C20 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+C30 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+C40 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+C50 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+C60 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+C70 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Kannada (C80-CFF) */
    "F^K[KFYFY[K[", /* U+C80 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+C90 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+CA0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+CB0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+CC0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+CD0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+CE0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+CF0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Malayalam (D00-D7F) */
    "F^K[KFYFY[K[", /* U+D00 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+D10 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+D20 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+D30 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+D40 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+D50 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+D60 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+D70 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Simhala (D80-DFF) */
    "F^K[KFYFY[K[", /* U+D80 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+D90 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+DA0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+DB0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+DC0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+DD0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+DE0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+DF0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Thai (E00-E7F) */
    "F^K[KFYFY[K[", /* U+E00 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+E10 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+E20 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+E30 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+E40 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+E50 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+E60 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+E70 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Lao (E80-EFF) */
    "F^K[KFYFY[K[", /* U+E80 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+E90 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+EA0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+EB0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+EC0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+ED0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+EE0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+EF0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Tibetan (F00-FFF) */
    "F^K[KFYFY[K[", /* U+F00 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+F10 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+F20 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+F30 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+F40 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+F50 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+F60 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+F70 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+F80 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+F90 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+FA0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+FB0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+FC0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+FD0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+FE0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+FF0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Myanmar (1000-109F) */
    "F^K[KFYFY[K[", /* U+1000 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1010 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1020 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1030 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1040 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1050 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1060 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1070 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1080 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1090 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Geogian (10A0-10FF) */
    "F^K[KFYFY[K[", /* U+10A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+10B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+10C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+10D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+10E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+10F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Hangul Jamo (1100-11FF) */
    "F^K[KFYFY[K[", /* U+1100 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1110 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1120 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1130 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1140 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1150 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1160 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1170 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1180 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1190 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+11A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+11B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+11C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+11D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+11E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+11F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Ethiopic (1200-137F) */
    "F^K[KFYFY[K[", /* U+1200 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1210 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1220 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1230 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1240 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1250 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1260 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1270 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1280 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1290 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+12A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+12B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+12C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+12D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+12E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+12F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1300 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1310 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1320 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1330 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1340 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1350 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1360 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1370 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Ethiopic Supplement (1380-139F) */
    "F^K[KFYFY[K[", /* U+1380 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1390 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Cherokee (13A0-13FF) */
    "F^K[KFYFY[K[", /* U+13A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+13B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+13C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+13D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+13E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+13F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Unified Canadian Aboriginal Syllabics (1400-167F) */
    "F^K[KFYFY[K[", /* U+1400 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1410 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1420 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1430 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1440 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1450 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1460 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1470 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1480 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1490 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+14A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+14B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+14C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+14D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+14E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+14F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1500 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1510 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1520 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1530 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1540 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1550 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1560 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1570 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1580 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1590 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+15A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+15B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+15C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+15D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+15E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+15F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1600 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1610 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1620 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1630 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1640 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1650 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1660 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1670 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Ogham (1680-169F) */
    "F^K[KFYFY[K[", /* U+1680 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1690 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Runic (16A0-16FF) */
    "F^K[KFYFY[K[", /* U+16A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+16B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+16C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+16D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+16E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+16F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Tagalog (1700-171F) */
    "F^K[KFYFY[K[", /* U+1700 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1710 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Hanunoo (1720-173F) */
    "F^K[KFYFY[K[", /* U+1720 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1730 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Buhid (1740-175F) */
    "F^K[KFYFY[K[", /* U+1740 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1750 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Tagbanwa (1760-177F) */
    "F^K[KFYFY[K[", /* U+1760 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1770 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Khmer (1780-17FF) */
    "F^K[KFYFY[K[", /* U+1780 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1790 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+17A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+17B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+17C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+17D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+17E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+17F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Mongolian (1800-18AF) */
    "F^K[KFYFY[K[", /* U+1800 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1810 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1820 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1830 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1840 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1850 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1860 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1870 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1880 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1890 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+18A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // - (18B0-18FF) */
    "F^K[KFYFY[K[", /* U+18B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+18C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+18D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+18E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+18F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Limbu (1900-194F) */
    "F^K[KFYFY[K[", /* U+1900 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1910 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1920 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1930 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1940 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Tai Le (1950-197F) */
    "F^K[KFYFY[K[", /* U+1950 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1960 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1970 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // New Tai Lue (1980-19DF) */
    "F^K[KFYFY[K[", /* U+1980 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1990 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+19A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+19B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+19C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+19D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Khmer Symbols (19E0-19FF) */
    "F^K[KFYFY[K[", /* U+19E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+19F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Buginese (1A00-1A1F) */
    "F^K[KFYFY[K[", /* U+1A00 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1A10 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // - (1A20-1AFF) */
    "F^K[KFYFY[K[", /* U+1A20 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1A30 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1A40 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1A50 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1A60 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1A70 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1A80 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1A90 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1AA0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1AB0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1AC0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1AD0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1AE0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1AF0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Balinese (1B00-1B7F) */
    "F^K[KFYFY[K[", /* U+1B00 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1B10 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1B20 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1B30 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1B40 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1B50 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1B60 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1B70 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Sudanese (1B80-1BBF) */
    "F^K[KFYFY[K[", /* U+1B80 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1B90 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1BA0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1BB0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // - (1BC0-1BFF) */
    "F^K[KFYFY[K[", /* U+1BC0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1BD0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1BE0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1BF0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Lepcha (1C00-1C4F) */
    "F^K[KFYFY[K[", /* U+1C00 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1C10 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1C20 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1C30 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1C40 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Ol Chiki (1C50-1C7F) */
    "F^K[KFYFY[K[", /* U+1C50 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1C60 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1C70 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // - (1C80-1CFF) */
    "F^K[KFYFY[K[", /* U+1C80 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1C90 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1CA0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1CB0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1CC0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1CD0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1CE0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1CF0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Phonetic Extensions (1D00-1D7F) */
    "JZNXVX RM[RMW[", /* U+1D00 A_SMALLCAP  */
    "H\\LXRX RRTWT RRMR[Y[ RYMPMK[",
    "D`[ZY[U[SZRX RINKMOMQNRPRXQZO[K[IZHXHVRUYU[T\\R\\P[NYMUMSNRP",
    "I[STVUWWWXVZT[N[NMSMUNVPVQUSSTNT RKWQW",
    "HZVZT[P[NZMYLWLQMONNPMTMVN",
    "J[SMOMO[S[UZVYWVWRVOUNSM",
    "J[SMOMO[S[UZVYWVWRVOUNSM RLTRT",
    "JYOTTT RVMOMO[V[",
    "J[TTVSWQWPVNTMPMNN RRTTTVUWWWXVZT[P[NZ",
    "MWRMR[ RRbSaR`QaRbR`",
    "LYTMTWSYRZP[O[",
    "IZNMN[ RPSV[ RVMNU",
    "JYOMO[V[ RLVRR",
    "G]L[LMRXXMX[",
    "I\\W[WMN[NM",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[",
    "J\\NNPMTMVNWOXQXWWYVZT[P[NZ", /* U+1D10 +C_SMALL  */
    "G]YSYVXXWYUZOZMYLXKVKSLQMPOOUOWPXQYS",
    "G]XYYWYSXQWPUOOOMPLQKSKWLY",
    "G]YNK[ RYSYVXXWYUZOZMYLXKVKSLQMPOOUOWPXQYS",
    "DaINKMOMQNRPRXQZO[K[IZHXHVRT RRWSYTZV[Y[[Z\\Y]W]Q\\O[NYMVMTNSORQ",
    "G]OMNNMPNRPS RTSVRWPVNUM RPSTSVTWVWXVZT[P[NZMXMVNTPS",
    "I\\XTXQWOVNTMQMONNOMQMT",
    "H[LTLWMYNZP[S[UZVYWWWT",
    "I[N[NMTMVNWPWRVTTUNU",
    "I[RUM[ RV[VMPMNNMPMRNTPUVU",
    "I[RSMM RVMV[P[NZMXMVNTPSVS",
    "KYMMWM RRMR[",
    "H[MMMXNZP[S[UZVXVM",
    "G]KPYP RKYVYXXYVYSXQWP",
    "@]KPYP RKYVYXXYVYSXQWP REWFXEYDXEWEY REOFPEQDPEOEQ",
    "G]KKYK RWKXLYNYQXSVTKT RVTXUYWYZX\\V]K]",
    "JZMMR[WM", /* U+1D20 V_SMALL  */
    "G]JMN[RQV[ZM",
    "IZLMWML[W[",
    "JZNMVMRRSRUSVUVXUZS[P[NZ",
    "H\\XNUMPMNNMOLQLSMUNVPWTXVYWZX\\X^W`VaTbObLa RRTR\\",
    "JZW[PROPPNRMTNUPTRM[",
    "JYO[OMWM",
    "JZM[RMW[",
    "H[M[MMVMV[",
    "I[N[NMTMVNWPWRVTTUNU",
    "I[RMR[ RLMMNMRNTPUTUVTWRWNXM",
    "I[V[VMSMQNPPOXNZL[",
    "JZNKVK RMNR@WN",
    "H\\LKRK RRGWG RR@RNYN RY@P@KN",
    "I[SGVHWJWKVMTNNNN@S@UAVCVDUFSGNG",
    "I[SGVHWJWKVMTNNNN@S@UAVCVDUFSGNG RKGQG",
    "J[S@O@ONSNUMVLWIWEVBUAS@", /* U+1D30 ^D_SMALLCAP  */
    "JYOGTG RV@O@ONVN",
    "KZUGPG RN@U@UNNN",
    "HZUAS@P@NAMBLDLJMLNMPNTNVMVHSH",
    "H[MGVG RM@MN RV@VN",
    "MWRNR@ RUNON RU@O@",
    "LYT@TJSLRMPNON",
    "IZN@NN RPFVN RV@NH",
    "JYO@ONVN",
    "G]LNL@RKX@XN",
    "H[MNM@VNV@",
    "I\\WNW@NNN@",
    "H[PNNMMLLJLDMBNAP@S@UAVBWDWJVLUMSNPN",
    "G]O@NAMCNEPF RTFVEWCVAU@ RPFTFVGWIWKVMTNPNNMMKMINGPF",
    "I[NNN@T@VAWCWEVGTHNH",
    "I[RHWN RNNN@T@VAWCWEVGTHNH",
    "KYM@W@ RR@RN", /* U+1D40 ^T_SMALLCAP  */
    "H[M@MKNMPNSNUMVKV@",
    "G]J@NNRDVNZ@",
    "KZOEQDSDUEVGVN RVMTNQNOMNKOIQHVH",
    "JYNDNKOMQNSNUM RNEPDSDUEVGUISJNJ",
    "H]WDUKTMRNPNNMMKMGNEPDRDTEVMWN",
    "H\\XMVNUNSMRK RLDODQERHRKQMONNNLMKKKJVJXIYGXEVDUDSERH",
    "KYO@ON ROMQNSNUMVKVGUESDQDOE",
    "KYU@UN RUESDQDOENGNKOMQNSNUM",
    "LYVMTNRNPMOKOGPERDSDUEVGVHOI",
    "LYOEQDSDUEVGVKUMSNRNPMOKOJVI",
    "LXPIRI RUETDPDOEOHPIOJOMPNTNUM",
    "LXRITI ROEPDTDUEUHTIUJUMTNPNOM",
    "KYUDUPTRRSOS RUESDQDOENGNKOMQNSNUM",
    "NVRDRN RRUSTRSQTRURS",
    "IZO@ON RUNQH RUDOJ",
    "G]KNKD RKEMDODQERGRN RRGSEUDVDXEYGYN", /* U+1D50 ^M_TINY  */
    "KZODON ROEQDSDUEVGVPURSSRS",
    "KYQNOMNKNGOEQDSDUEVGVKUMSNQN",
    "LYOEQDSDUEVGVKUMSNQNOM",
    "KYNINGOEQDSDUEVGVI",
    "KYNINKOMQNSNUMVKVI",
    "KYOSOD ROEQDSDUEVGVKUMSNQNOM",
    "NXPDVD RR@RKSMUNVN",
    "KYUDUN RNDNKOMQNSNUM",
    "I[MFWF RMMTMVLWJWHVF",
    "G]YDYN RYMWNUNSMRKRD RRKQMONNNLMKKKD",
    "LXNDRNVD",
    "LXVNPGPEQDSDTETGNN",
    "KYSFRF RNSOQOCPAR@S@UAVCUESFUGVIVKUMSNQNOM",
    "KXRMRS RMDOERMVD",
    "KYSDQDOENGNKOMQNSNUMVKVGUESDPCOBOAP@U@",
    "I[MDLFLJMLNMPNTNVMWLXJXGWEUDSERGRS", /* U+1D60 ^PHI_TINY  */
    "LXVDNS RNDPETRVS",
    "NVRWRa RRPQQRRSQRPRR",
    "LWPWPa RPZQXSWUW",
    "KYUWUa RNWN^O`QaSaU`",
    "LXNWRaVW",
    "KYSYRY RNfOdOVPTRSSSUTVVUXSYUZV\\V^U`SaQaO`",
    "KXR`Rf RMWOXR`VW",
    "KYOfOZPXRWSWUXVZV^U`SaQaO`",
    "I[MWLYL]M_N`PaTaV`W_X]XZWXUWSXRZRf",
    "LXVWNf RNWPXTeVf",
    "D`IMIXJZL[O[QZRX R[ZY[U[SZRXRPSNUMYM[N\\P\\RRT",
    "H[M[MF RMNOMSMUNVOWQWWVYUZS[O[MZ RIHJGLFPHRGSF",
    "I\\W[WF RWZU[Q[OZNYMWMQNOONQMUMWN RQHRGTFXHZG[F",
    "MYOMWM RR[RISGUFWF RMTNSPRTTVSWR",
    "D`I[IM RIOJNLMOMQNRPR[ RRPSNUMXMZN[P[[ RMTNSPRTTVSWR",
    "I\\NMN[ RNOONQMTMVNWPW[ RMTNSPRTTVSWR", /* U+1D70 N_SMALL TILDE */
    "H[MMMb RMNOMSMUNVOWQWWVYUZS[O[MZ RI`J_L^P`R_S^",
    "KXP[PM RPQQORNTMVM RLTMSORSTUSVR",
    "KXM[S[ RVMTMRNQOPRP[ RLTMSORSTUSVR",
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN RNTOSQRUTWSXR",
    "MYOMWM RRFRXSZU[W[ RMSNRPQTSVRWQ",
    "IZLMWML[W[ RMTNSPRTTVSWR",
    "H[M[MJNHOGQFTFVG RMNOMSMUNVOWQWWVYUZS[O[MZ",
    "H[MGVG RM@MN RV@VN",
    "JZMMVMOURUTVUWVYV^U`TaRbPbNaM_M^N\\P[V[",
    "MlOMWM RRFRXSZU[W[ R^[^F Rg[gPfNdMaM_N^O RiC]`",
    "MWR[RM RU[O[ RUMOM ROTUT",
    "MXRMRXSZU[ ROTUT",
    "H[MMMb RMNOMSMUNVOWQWWVYUZS[O[MZ RHT\\T",
    "H[MMMXNZP[S[UZVXVM RHT\\T",
    "I\\XMUMUPWRXTXWWYVZT[Q[OZNYMWMTNRPPPMMM RHU\\U",
    /* // Phonetic Extensions Supplement (1D80-1DBF) */
    "F^K[KFYFY[K[", /* U+1D80 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1D90 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1DA0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1DB0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Combining Diacritical Marks Supplement (1DC0-1DFF) */
    "F^K[KFYFY[K[", /* U+1DC0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1DD0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1DE0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+1DF0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Latin Extended Additional (1E00-1EFF) */
    "I[MUWU RK[RFY[ RR`TaUcTeRfPeOcPaR`", /* U+1E00 A_CAP +RING */
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RR`TaUcTeRfPeOcPaR`",
    "G\\SPVQWRXTXWWYVZT[L[LFSFUGVHWJWLVNUOSPLP RR?Q@RAS@R?RA",
    "H[M[MF RMNOMSMUNVOWQWWVYUZS[O[MZ RN?M@NAO@N?NA",
    "G\\SPVQWRXTXWWYVZT[L[LFSFUGVHWJWLVNUOSPLP RRbSaR`QaRbR`",
    "H[M[MF RMNOMSMUNVOWQWWVYUZS[O[MZ RRbSaR`QaRbR`",
    "G\\SPVQWRXTXWWYVZT[L[LFSFUGVHWJWLVNUOSPLP RWaMa",
    "H[M[MF RMNOMSMUNVOWQWWVYUZS[O[MZ RWaMa",
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH RR\\T]U_TaRbOb RT>QA",
    "HZVZT[P[NZMYLWLQMONNPMTMVN RR\\T]U_TaRbOb RTEQH",
    "G\\L[LFQFTGVIWKXOXRWVVXTZQ[L[ RR?Q@RAS@R?RA",
    "I\\W[WF RWZU[Q[OZNYMWMQNOONQMUMWN RV?U@VAW@V?VA",
    "G\\L[LFQFTGVIWKXOXRWVVXTZQ[L[ RRbSaR`QaRbR`",
    "I\\W[WF RWZU[Q[OZNYMWMQNOONQMUMWN RSbTaS`RaSbS`",
    "G\\L[LFQFTGVIWKXOXRWVVXTZQ[L[ RWaMa",
    "I\\W[WF RWZU[Q[OZNYMWMQNOONQMUMWN RXaNa",
    "G\\L[LFQFTGVIWKXOXRWVVXTZQ[L[ RQ\\S]T_SaQbNb", /* U+1E10 D_CAP CEDILLA */
    "I\\W[WF RWZU[Q[OZNYMWMQNOONQMUMWN RS\\U]V_UaSbPb",
    "G\\L[LFQFTGVIWKXOXRWVVXTZQ[L[ RVcR`Nc",
    "I\\W[WF RWZU[Q[OZNYMWMQNOONQMUMWN RWcS`Oc",
    "H[MPTP RW[M[MFWF RM@W@ RP9S<",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RMGWG RP>SA",
    "H[MPTP RW[M[MFWF RM@W@ RT9Q<",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RMGWG RT>QA",
    "H[MPTP RW[M[MFWF RVcR`Nc",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RVcR`Nc",
    "H[MPTP RW[M[MFWF RW`VaTbP`NaMb",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RW`VaTbP`NaMb",
    "H[MPTP RW[M[MFWF RR\\T]U_TaRbOb RN>O@QASAU@V>",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RR\\T]U_TaRbOb RNEOGQHSHUGVE",
    "HZTPMP RM[MFWF RR?Q@RAS@R?RA",
    "MYOMWM RR[RISGUFWF RT?S@TAU@T?TA",
    "F[VGTFQFNGLIKKJOJRKVLXNZQ[S[VZWYWRSR RM@W@", /* U+1E20 G_CAP MACRON */
    "I\\WMW^V`UaSbPbNa RWZU[Q[OZNYMWMQNOONQMUMWN RMGWG",
    "G]L[LF RLPXP RX[XF RR?Q@RAS@R?RA",
    "H[M[MF RV[VPUNSMPMNNMO RM?L@MAN@M?MA",
    "G]L[LF RLPXP RX[XF RRbSaR`QaRbR`",
    "H[M[MF RV[VPUNSMPMNNMO RRbSaR`QaRbR`",
    "G]L[LF RLPXP RX[XF RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "H[M[MF RV[VPUNSMPMNNMO RI?J@IAH@I?IA RQ?R@QAP@Q?QA",
    "G]L[LF RLPXP RX[XF RL\\N]O_NaLbIb",
    "H[M[MF RV[VPUNSMPMNNMO RM\\O]P_OaMbJb",
    "G]L[LF RLPXP RX[XF RV`UbScQcObN`",
    "H[M[MF RV[VPUNSMPMNNMO RV`UbScQcObN`",
    "MWR[RF RW`VaTbP`NaMb",
    "MWR[RM RRFQGRHSGRFRH RW`VaTbP`NaMb",
    "MWR[RF RN?O@NAM@N?NA RV?W@VAU@V?VA RT9Q<",
    "MWR[RM RNFOGNHMGNFNH RVFWGVHUGVFVH RT>QA",
    "G\\L[LF RX[OO RXFLR RT>QA", /* U+1E30 K_CAP ACUTE */
    "IZN[NF RPSV[ RVMNU RPAMD",
    "G\\L[LF RX[OO RXFLR RRbSaR`QaRbR`",
    "IZN[NF RPSV[ RVMNU RRbSaR`QaRbR`",
    "G\\L[LF RX[OO RXFLR RWaMa",
    "IZN[NF RPSV[ RVMNU RWaMa",
    "HYW[M[MF RRbSaR`QaRbR`",
    "MXU[SZRXRF RSbTaS`RaSbS`",
    "HYW[M[MF RH@R@ RRbSaR`QaRbR`",
    "MXU[SZRXRF RM@W@ RSbTaS`RaSbS`",
    "HYW[M[MF RWaMa",
    "MXU[SZRXRF RXaNa",
    "HYW[M[MF RVcR`Nc",
    "MXU[SZRXRF RWcS`Oc",
    "F^K[KFRUYFY[ RT>QA",
    "D`I[IM RIOJNLMOMQNRPR[ RRPSNUMXMZN[P[[ RTEQH",
    "F^K[KFRUYFY[ RR?Q@RAS@R?RA", /* U+1E40 M_CAP DOT */
    "D`I[IM RIOJNLMOMQNRPR[ RRPSNUMXMZN[P[[ RRFQGRHSGRFRH",
    "F^K[KFRUYFY[ RRbSaR`QaRbR`",
    "D`I[IM RIOJNLMOMQNRPR[ RRPSNUMXMZN[P[[ RRbSaR`QaRbR`",
    "G]L[LFX[XF RR?Q@RAS@R?RA",
    "I\\NMN[ RNOONQMTMVNWPW[ RRFQGRHSGRFRH",
    "G]L[LFX[XF RRbSaR`QaRbR`",
    "I\\NMN[ RNOONQMTMVNWPW[ RRbSaR`QaRbR`",
    "G]L[LFX[XF RWaMa",
    "I\\NMN[ RNOONQMTMVNWPW[ RWaMa",
    "G]L[LFX[XF RVcR`Nc",
    "I\\NMN[ RNOONQMTMVNWPW[ RVcR`Nc",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RMAN@P?TAV@W? RT9Q<",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RMHNGPFTHVGWF RT>QA",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RMAN@P?TAV@W? RN:O;N<M;N:N< RV:W;V<U;V:V<",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RMHNGPFTHVGWF RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RM@W@ RP9S<", /* U+1E50 O_CAP MACRON */
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RMGWG RP>SA",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RM@W@ RT9Q<",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RMGWG RT>QA",
    "G\\L[LFTFVGWHXJXMWOVPTQLQ RT>QA",
    "H[MMMb RMNOMSMUNVOWQWWVYUZS[O[MZ RTEQH",
    "G\\L[LFTFVGWHXJXMWOVPTQLQ RR?Q@RAS@R?RA",
    "H[MMMb RMNOMSMUNVOWQWWVYUZS[O[MZ RRFQGRHSGRFRH",
    "G\\X[QQ RL[LFTFVGWHXJXMWOVPTQLQ RR?Q@RAS@R?RA",
    "KXP[PM RPQQORNTMVM RSFRGSHTGSFSH",
    "G\\X[QQ RL[LFTFVGWHXJXMWOVPTQLQ RRbSaR`QaRbR`",
    "KXP[PM RPQQORNTMVM RPbQaP`OaPbP`",
    "G\\X[QQ RL[LFTFVGWHXJXMWOVPTQLQ RM@W@ RRbSaR`QaRbR`",
    "KXP[PM RPQQORNTMVM RNGXG RPbQaP`OaPbP`",
    "G\\X[QQ RL[LFTFVGWHXJXMWOVPTQLQ RWaMa",
    "KXP[PM RPQQORNTMVM RUaKa",
    "H\\LZO[T[VZWYXWXUWSVRTQPPNOMNLLLJMHNGPFUFXG RR?Q@RAS@R?RA", /* U+1E60 S_CAP DOT */
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN RRFQGRHSGRFRH",
    "H\\LZO[T[VZWYXWXUWSVRTQPPNOMNLLLJMHNGPFUFXG RRbSaR`QaRbR`",
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN RRbSaR`QaRbR`",
    "H\\LZO[T[VZWYXWXUWSVRTQPPNOMNLLLJMHNGPFUFXG RU>RA RM>N?M@L?M>M@",
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN RUERH RMENFMGLFMEMG",
    "H\\LZO[T[VZWYXWXUWSVRTQPPNOMNLLLJMHNGPFUFXG RN>RAV> RR:Q;R<S;R:R<",
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN RNERHVE RR?Q@RAS@R?RA",
    "H\\LZO[T[VZWYXWXUWSVRTQPPNOMNLLLJMHNGPFUFXG RR?Q@RAS@R?RA RRbSaR`QaRbR`",
    "J[NZP[T[VZWXWWVUTTQTOSNQNPONQMTMVN RRFQGRHSGRFRH RRbSaR`QaRbR`",
    "JZLFXF RR[RF RR?Q@RAS@R?RA",
    "MYOMWM RRFRXSZU[W[ RR?Q@RAS@R?RA",
    "JZLFXF RR[RF RRbSaR`QaRbR`",
    "MYOMWM RRFRXSZU[W[ RTbUaT`SaTbT`",
    "JZLFXF RR[RF RWaMa",
    "MYOMWM RRFRXSZU[W[ RYaOa",
    "JZLFXF RR[RF RVcR`Nc", /* U+1E70 T_CAP +CARON */
    "MYOMWM RRFRXSZU[W[ RXcT`Pc",
    "G]LFLWMYNZP[T[VZWYXWXF RVbUaV`WaVbV` RNbMaN`OaNbN`",
    "H[VMV[ RMMMXNZP[S[UZVY RVbUaV`WaVbV` RNbMaN`OaNbN`",
    "G]LFLWMYNZP[T[VZWYXWXF RW`VaTbP`NaMb",
    "H[VMV[ RMMMXNZP[S[UZVY RW`VaTbP`NaMb",
    "G]LFLWMYNZP[T[VZWYXWXF RVcR`Nc",
    "H[VMV[ RMMMXNZP[S[UZVY RVcR`Nc",
    "G]LFLWMYNZP[T[VZWYXWXF RMAN@P?TAV@W? RT9Q<",
    "H[VMV[ RMMMXNZP[S[UZVY RMHNGPFTHVGWF RT>QA",
    "G]LFLWMYNZP[T[VZWYXWXF RM@W@ RN:O;N<M;N:N< RV:W;V<U;V:V<",
    "H[VMV[ RMMMXNZP[S[UZVY RMGWG RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "I[KFR[YF RMAN@P?TAV@W?",
    "JZMMR[WM RMHNGPFTHVGWF",
    "I[KFR[YF RRbSaR`QaRbR`",
    "JZMMR[WM RRbSaR`QaRbR`",
    "F^IFN[RLV[[F RP>SA", /* U+1E80 W_CAP GRAVE */
    "G]JMN[RQV[ZM RPESH",
    "F^IFN[RLV[[F RT>QA",
    "G]JMN[RQV[ZM RTEQH",
    "F^IFN[RLV[[F RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "G]JMN[RQV[ZM RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "F^IFN[RLV[[F RR?Q@RAS@R?RA",
    "G]JMN[RQV[ZM RRFQGRHSGRFRH",
    "F^IFN[RLV[[F RRbSaR`QaRbR`",
    "G]JMN[RQV[ZM RRbSaR`QaRbR`",
    "H\\KFY[ RYFK[ RR?Q@RAS@R?RA",
    "IZL[WM RLMW[ RRFQGRHSGRFRH",
    "H\\KFY[ RYFK[ RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "IZL[WM RLMW[ RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "I[RQR[ RKFRQYF RR?Q@RAS@R?RA",
    "JZMMR[ RWMR[P`OaMb RRFQGRHSGRFRH",
    "H\\KFYFK[Y[ RNAR>VA", /* U+1E90 Z_CAP CIRCUMFLEX */
    "IZLMWML[W[ RNHREVH",
    "H\\KFYFK[Y[ RRbSaR`QaRbR`",
    "IZLMWML[W[ RRbSaR`QaRbR`",
    "H\\KFYFK[Y[ RWaMa",
    "IZLMWML[W[ RWaMa",
    "H[M[MF RV[VPUNSMPMNNMO RWaMa",
    "MYOMWM RRFRXSZU[W[ RN?O@NAM@N?NA RV?W@VAU@V?VA",
    "G]JMN[RQV[ZM RRHPGOEPCRBTCUETGRH",
    "JZMMR[ RWMR[P`OaMb RRHPGOEPCRBTCUETGRH",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RWJYIZGYEWD",
    "MYR[RISGUFWF RT?S@TAU@T?TA",
    "MYR[RISGUFWF ROSUO",
    "MYR[RISGUFWF ROLUL",
    "E^J[JLKIMGPFZFSNVNXOYPZRZWYYXZV[R[PZOY",
    "H[SMPMNNMOLQLWMYNZP[S[UZVYWWWQVOUNSMPLNKMINGPFTFVG",
    "I[MUWU RK[RFY[ RRbSaR`QaRbR`", /* U+1EA0 A_CAP +DOT */
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RRbSaR`QaRbR`",
    "I[MUWU RK[RFY[ RRAT?U=T;R:P:",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RRHTFUDTBRAPA",
    "I[MUWU RK[RFY[ RU>X; RNAR>VA",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RUEXB RNHREVH",
    "I[MUWU RK[RFY[ RO>L; RNAR>VA",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR ROELB RNHREVH",
    "I[MUWU RK[RFY[ RNAR>VA RXAZ?[=Z;X:V:",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNHREVH RXHZF[DZBXAVA",
    "I[MUWU RK[RFY[ RNAR>VA RM<N;P:T<V;W:",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNHREVH RMAN@P?TAV@W?",
    "I[MUWU RK[RFY[ RNAR>VA RRbSaR`QaRbR`",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNHREVH RRbSaR`QaRbR`",
    "I[MUWU RK[RFY[ RN>O@QASAU@V> RT9Q<",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNEOGQHSHUGVE RT>QA",
    "I[MUWU RK[RFY[ RN>O@QASAU@V> RP9S<", /* U+1EB0 A_CAP BREVE */
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNEOGQHSHUGVE RP>SA",
    "I[MUWU RK[RFY[ RN>O@QASAU@V> RP>R<S:R8P7N7",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNEOGQHSHUGVE RPERCSAR?P>N>",
    "I[MUWU RK[RFY[ RN>O@QASAU@V> RM<N;P:T<V;W:",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNEOGQHSHUGVE RMAN@P?TAV@W?",
    "I[MUWU RK[RFY[ RN>O@QASAU@V> RRbSaR`QaRbR`",
    "I\\W[WPVNTMPMNN RWZU[P[NZMXMVNTPSUSWR RNEOGQHSHUGVE RRbSaR`QaRbR`",
    "H[MPTP RW[M[MFWF RRbSaR`QaRbR`",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RRbSaR`QaRbR`",
    "H[MPTP RW[M[MFWF RRAT?U=T;R:P:",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RRHTFUDTBRAPA",
    "H[MPTP RW[M[MFWF RMAN@P?TAV@W?",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RMHNGPFTHVGWF",
    "H[MPTP RW[M[MFWF RU>X; RNAR>VA",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RUEXB RNHREVH",
    "H[MPTP RW[M[MFWF RO>L; RNAR>VA", /* U+1EC0 E_CAP CIRCUMFLEX_GRAVE */
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT ROELB RNHREVH",
    "H[MPTP RW[M[MFWF RNAR>VA RXAZ?[=Z;X:V:",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RNHREVH RXHZF[DZBXAVA",
    "H[MPTP RW[M[MFWF RNAR>VA RM<N;P:T<V;W:",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RNHREVH RMAN@P?TAV@W?",
    "H[MPTP RW[M[MFWF RNAR>VA RRbSaR`QaRbR`",
    "I[VZT[P[NZMXMPNNPMTMVNWPWRMT RNHREVH RRbSaR`QaRbR`",
    "MWR[RF RRAT?U=T;R:P:",
    "MWR[RM RRHTFUDTBRAPA",
    "MWR[RF RRbSaR`QaRbR`",
    "MWR[RM RRFQGRHSGRFRH RRbSaR`QaRbR`",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RRbSaR`QaRbR`",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RRbSaR`QaRbR`",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RRAT?U=T;R:P:",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RRHTFUDTBRAPA",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RU>X; RNAR>VA", /* U+1ED0 O_CAP CIRCUMFLEX_ACUTE */
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RUEXB RNHREVH",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RO>L; RNAR>VA",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ ROELB RNHREVH",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RNAR>VA RXAZ?[=Z;X:V:",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RNHREVH RXHZF[DZBXAVA",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RNAR>VA RM<N;P:T<V;W:",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RNHREVH RMAN@P?TAV@W?",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RNAR>VA RRbSaR`QaRbR`",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RNHREVH RRbSaR`QaRbR`",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RVGXFYDXBWA RT>QA",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RUNWMXKWIVH RTEQH",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RVGXFYDXBWA RP>SA",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RUNWMXKWIVH RPESH",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RVGXFYDXBWA RRAT?U=T;R:P:",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RUNWMXKWIVH RRHTFUDTBRAPA",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RVGXFYDXBWA RWAVBTCPANBMC", /* U+1EE0 O_CAP HORN */
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RUNWMXKWIVH RWHVITJPHNIMJ",
    "G]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RVGXFYDXBWA RRbSaR`QaRbR`",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RUNWMXKWIVH RRbSaR`QaRbR`",
    "G]LFLWMYNZP[T[VZWYXWXF RRbSaR`QaRbR`",
    "H[VMV[ RMMMXNZP[S[UZVY RRbSaR`QaRbR`",
    "G]LFLWMYNZP[T[VZWYXWXF RRAT?U=T;R:P:",
    "H[VMV[ RMMMXNZP[S[UZVY RRHTFUDTBRAPA",
    "G]LFLWMYNZP[T[VZWYXWXF RXFZE[CZAY@ RT>QA",
    "H[VMV[ RMMMXNZP[S[UZVY RVMXLYJXHWG RTEQH",
    "G]LFLWMYNZP[T[VZWYXWXF RXFZE[CZAY@ RP>SA",
    "H[VMV[ RMMMXNZP[S[UZVY RVMXLYJXHWG RPESH",
    "G]LFLWMYNZP[T[VZWYXWXF RXFZE[CZAY@ RRAT?U=T;R:P:",
    "H[VMV[ RMMMXNZP[S[UZVY RVMXLYJXHWG RRHTFUDTBRAPA",
    "G]LFLWMYNZP[T[VZWYXWXF RXFZE[CZAY@ RWAVBTCPANBMC",
    "H[VMV[ RMMMXNZP[S[UZVY RVMXLYJXHWG RWHVITJPHNIMJ",
    "G]LFLWMYNZP[T[VZWYXWXF RXFZE[CZAY@ RRbSaR`QaRbR`", /* U+1EF0 U_CAP HORN */
    "H[VMV[ RMMMXNZP[S[UZVY RVMXLYJXHWG RRbSaR`QaRbR`",
    "I[RQR[ RKFRQYF RP>SA",
    "JZMMR[ RWMR[P`OaMb RPESH",
    "I[RQR[ RKFRQYF RRbSaR`QaRbR`",
    "JZMMR[ RWMR[P`OaMb RVbWaV`UaVbV`",
    "I[RQR[ RKFRQYF RRAT?U=T;R:P:",
    "JZMMR[ RWMR[P`OaMb RRHTFUDTBRAPA",
    "I[RQR[ RKFRQYF RMAN@P?TAV@W?",
    "JZMMR[ RWMR[P`OaMb RMHNGPFTHVGWF",
    "E\\PFP[ RJFJ[Z[",
    "J[MMWM ROFOXPZR[ RX[VZUXUF",
    "G]QFOGMJLMLWMYNZP[T[VZXXYVYTXPVMUL",
    "H[QMONNOMQMWNYOZQ[S[UZVYWWWUVSURSQ",
    "G[KFRT RYFRTPXOZM[KZJXKVMUOVPX",
    "JZMMR[ RWMR[Q_PaNbLaK_L]N\\P]Q_",
    /* // Greek Extended (1F00-1FFF) */
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RQHRHSGSE", /* U+1F00 ALPHA_SMALL PSILI */
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RQEQGRHSH",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RTEWH RMHNHOGOE",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RTEWH RMEMGNHOH",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RXEUH RMHNHOGOE",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RXEUH RMEMGNHOH",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RQHRHSGSE RMAN@P?TAV@W?",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RQEQGRHSH RMAN@P?TAV@W?",
    "G[MUWU RK[RFY[ RJHKHLGLE",
    "G[MUWU RK[RFY[ RJEJGKHLH",
    "?[MUWU RK[RFY[ RIELH RBHCHDGDE",
    "?[MUWU RK[RFY[ RIELH RBEBGCHDH",
    "?[MUWU RK[RFY[ RMEJH RBHCHDGDE",
    "?[MUWU RK[RFY[ RMEJH RBEBGCHDH",
    "D[MUWU RK[RFY[ RFAG@I?MAO@P? RJHKHLGLE",
    "D[MUWU RK[RFY[ RFAG@I?MAO@P? RJEJGKHLH",
    "IZPTNUMWMXNZP[T[VZ RRTPTNSMQMPNNPMTMVN RQHRHSGSE", /* U+1F10 EPSILON_SMALL PSILI */
    "IZPTNUMWMXNZP[T[VZ RRTPTNSMQMPNNPMTMVN RQEQGRHSH",
    "IZPTNUMWMXNZP[T[VZ RRTPTNSMQMPNNPMTMVN RTEWH RMHNHOGOE",
    "IZPTNUMWMXNZP[T[VZ RRTPTNSMQMPNNPMTMVN RTEWH RMEMGNHOH",
    "IZPTNUMWMXNZP[T[VZ RRTPTNSMQMPNNPMTMVN RXEUH RMHNHOGOE",
    "IZPTNUMWMXNZP[T[VZ RRTPTNSMQMPNNPMTMVN RXEUH RMEMGNHOH",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "B[MPTP RW[M[MFWF REHFHGGGE",
    "B[MPTP RW[M[MFWF REEEGFHGH",
    ":[MPTP RW[M[MFWF RDEGH R=H>H?G?E",
    ":[MPTP RW[M[MFWF RDEGH R=E=G>H?H",
    ":[MPTP RW[M[MFWF RHEEH R=H>H?G?E",
    ":[MPTP RW[M[MFWF RHEEH R=E=G>H?H",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "I\\NMN[ RNOONQMTMVNWPWb RQHRHSGSE", /* U+1F20 ETA_SMALL PSILI */
    "I\\NMN[ RNOONQMTMVNWPWb RQEQGRHSH",
    "I\\NMN[ RNOONQMTMVNWPWb RTEWH RMHNHOGOE",
    "I\\NMN[ RNOONQMTMVNWPWb RTEWH RMEMGNHOH",
    "I\\NMN[ RNOONQMTMVNWPWb RXEUH RMHNHOGOE",
    "I\\NMN[ RNOONQMTMVNWPWb RXEUH RMEMGNHOH",
    "I\\NMN[ RNOONQMTMVNWPWb RQHRHSGSE RMAN@P?TAV@W?",
    "I\\NMN[ RNOONQMTMVNWPWb RQEQGRHSH RMAN@P?TAV@W?",
    "A]L[LF RLPXP RX[XF RDHEHFGFE",
    "A]L[LF RLPXP RX[XF RDEDGEHFH",
    "9]L[LF RLPXP RX[XF RCEFH R<H=H>G>E",
    "9]L[LF RLPXP RX[XF RCEFH R<E<G=H>H",
    "9]L[LF RLPXP RX[XF RGEDH R<H=H>G>E",
    "9]L[LF RLPXP RX[XF RGEDH R<E<G=H>H",
    ">]L[LF RLPXP RX[XF R@AA@C?GAI@J? RDHEHFGFE",
    ">]L[LF RLPXP RX[XF R@AA@C?GAI@J? RDEDGEHFH",
    "MXRMRXSZU[ RQHRHSGSE", /* U+1F30 IOTA_SMALL PSILI */
    "MXRMRXSZU[ RQEQGRHSH",
    "MXRMRXSZU[ RTEWH RMHNHOGOE",
    "MXRMRXSZU[ RTEWH RMEMGNHOH",
    "MXRMRXSZU[ RXEUH RMHNHOGOE",
    "MXRMRXSZU[ RXEUH RMEMGNHOH",
    "MXRMRXSZU[ RQHRHSGSE RMAN@P?TAV@W?",
    "MXRMRXSZU[ RQEQGRHSH RMAN@P?TAV@W?",
    "GWR[RF RJHKHLGLE",
    "GWR[RF RJEJGKHLH",
    "?WR[RF RIELH RBHCHDGDE",
    "?WR[RF RIELH RBEBGCHDH",
    "?WR[RF RMEJH RBHCHDGDE",
    "?WR[RF RMEJH RBEBGCHDH",
    "DWR[RF RFAG@I?MAO@P? RJHKHLGLE",
    "DWR[RF RFAG@I?MAO@P? RJEJGKHLH",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RQHRHSGSE", /* U+1F40 O_SMALL PSILI */
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RQEQGRHSH",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RTEWH RMHNHOGOE",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RTEWH RMEMGNHOH",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RXEUH RMHNHOGOE",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RXEUH RMEMGNHOH",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "B]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF REHFHGGGE",
    "B]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF REEEGFHGH",
    ":]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RDEGH R=H>H?G?E",
    ":]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RDEGH R=E=G>H?H",
    ":]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RHEEH R=H>H?G?E",
    ":]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RHEEH R=E=G>H?H",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "H[MMMXNZP[S[UZVYWWWPVNUM RQHRHSGSE", /* U+1F50 UPSILON_SMALL PSILI */
    "H[MMMXNZP[S[UZVYWWWPVNUM RQEQGRHSH",
    "H[MMMXNZP[S[UZVYWWWPVNUM RTEWH RMHNHOGOE",
    "H[MMMXNZP[S[UZVYWWWPVNUM RTEWH RMEMGNHOH",
    "H[MMMXNZP[S[UZVYWWWPVNUM RXEUH RMHNHOGOE",
    "H[MMMXNZP[S[UZVYWWWPVNUM RXEUH RMEMGNHOH",
    "H[MMMXNZP[S[UZVYWWWPVNUM RQHRHSGSE RMAN@P?TAV@W?",
    "H[MMMXNZP[S[UZVYWWWPVNUM RQEQGRHSH RMAN@P?TAV@W?",
    "F^K[KFYFY[K[",
    "@[RQR[ RKFRQYF RCECGDHEH",
    "F^K[KFYFY[K[",
    "8[RQR[ RKFRQYF RBEEH R;E;G<H=H",
    "F^K[KFYFY[K[",
    "8[RQR[ RKFRQYF RFECH R;E;G<H=H",
    "F^K[KFYFY[K[",
    "=[RQR[ RKFRQYF R?A@@B?FAH@I? RCECGDHEH",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RQHRHSGSE", /* U+1F60 OMEGA_SMALL PSILI */
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RQEQGRHSH",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RTEWH RMHNHOGOE",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RTEWH RMEMGNHOH",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RXEUH RMHNHOGOE",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RXEUH RMEMGNHOH",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RQHRHSGSE RMAN@P?TAV@W?",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RQEQGRHSH RMAN@P?TAV@W?",
    "@^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RCHDHEGEE",
    "@^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RCECGDHEH",
    "8^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RBEEH R;H<H=G=E",
    "8^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RBEEH R;E;G<H=H",
    "8^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RFECH R;H<H=G=E",
    "8^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RFECH R;E;G<H=H",
    "=^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ R?A@@B?FAH@I? RCHDHEGEE",
    "=^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ R?A@@B?FAH@I? RCECGDHEH",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RTEQH", /* U+1F70 ALPHA_SMALL ACUTE */
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RTEQH",
    "IZPTNUMWMXNZP[T[VZ RRTPTNSMQMPNNPMTMVN RTEQH",
    "IZPTNUMWMXNZP[T[VZ RRTPTNSMQMPNNPMTMVN RTEQH",
    "I\\NMN[ RNOONQMTMVNWPWb RTEQH",
    "I\\NMN[ RNOONQMTMVNWPWb RTEQH",
    "MXRMRXSZU[ RTEQH",
    "MXRMRXSZU[ RTEQH",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RTEQH",
    "H[P[NZMYLWLQMONNPMSMUNVOWQWWVYUZS[P[ RTEQH",
    "H[MMMXNZP[S[UZVYWWWPVNUM RTEQH",
    "H[MMMXNZP[S[UZVYWWWPVNUM RTEQH",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RTEQH",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RTEQH",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RQHRHSGSE RR`RcSdTd", /* U+1F80 ALPHA_SMALL PSILI */
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RQEQGRHSH RR`RcSdTd",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RTEWH RMHNHOGOE RR`RcSdTd",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RTEWH RMEMGNHOH RR`RcSdTd",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RXEUH RMHNHOGOE RR`RcSdTd",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RXEUH RMEMGNHOH RR`RcSdTd",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RQHRHSGSE RMAN@P?TAV@W? RR`RcSdTd",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RQEQGRHSH RMAN@P?TAV@W? RR`RcSdTd",
    "G[MUWU RK[RFY[ RJHKHLGLE RR`RcSdTd",
    "G[MUWU RK[RFY[ RJEJGKHLH RR`RcSdTd",
    "?[MUWU RK[RFY[ RIELH RBHCHDGDE RR`RcSdTd",
    "?[MUWU RK[RFY[ RIELH RBEBGCHDH RR`RcSdTd",
    "?[MUWU RK[RFY[ RMEJH RBHCHDGDE RR`RcSdTd",
    "?[MUWU RK[RFY[ RMEJH RBEBGCHDH RR`RcSdTd",
    "D[MUWU RK[RFY[ RFAG@I?MAO@P? RJHKHLGLE RR`RcSdTd",
    "D[MUWU RK[RFY[ RFAG@I?MAO@P? RJEJGKHLH RR`RcSdTd",
    "I\\NMN[ RNOONQMTMVNWPWb RQHRHSGSE RN`NcOdPd", /* U+1F90 ETA_SMALL PSILI */
    "I\\NMN[ RNOONQMTMVNWPWb RQEQGRHSH RN`NcOdPd",
    "I\\NMN[ RNOONQMTMVNWPWb RTEWH RMHNHOGOE RN`NcOdPd",
    "I\\NMN[ RNOONQMTMVNWPWb RTEWH RMEMGNHOH RN`NcOdPd",
    "I\\NMN[ RNOONQMTMVNWPWb RXEUH RMHNHOGOE RN`NcOdPd",
    "I\\NMN[ RNOONQMTMVNWPWb RXEUH RMEMGNHOH RN`NcOdPd",
    "I\\NMN[ RNOONQMTMVNWPWb RQHRHSGSE RMAN@P?TAV@W? RN`NcOdPd",
    "I\\NMN[ RNOONQMTMVNWPWb RQEQGRHSH RMAN@P?TAV@W? RN`NcOdPd",
    "N]L[LF RLPXP RX[XF RR`RcSdTd",
    "A]L[LF RLPXP RX[XF RDEDGEHFH RR`RcSdTd",
    "9]L[LF RLPXP RX[XF RCEFH R<H=H>G>E RR`RcSdTd",
    "9]L[LF RLPXP RX[XF RCEFH R<E<G=H>H RR`RcSdTd",
    "9]L[LF RLPXP RX[XF RGEDH R<H=H>G>E RR`RcSdTd",
    "9]L[LF RLPXP RX[XF RGEDH R<E<G=H>H RR`RcSdTd",
    ">]L[LF RLPXP RX[XF R@AA@C?GAI@J? RDHEHFGFE RR`RcSdTd",
    ">]L[LF RLPXP RX[XF R@AA@C?GAI@J? RDEDGEHFH RR`RcSdTd",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RQHRHSGSE RR`RcSdTd", /* U+1FA0 OMEGA_SMALL PSILI */
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RQEQGRHSH RR`RcSdTd",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RTEWH RMHNHOGOE RR`RcSdTd",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RTEWH RMEMGNHOH RR`RcSdTd",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RXEUH RMHNHOGOE RR`RcSdTd",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RXEUH RMEMGNHOH RR`RcSdTd",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RQHRHSGSE RMAN@P?TAV@W? RR`RcSdTd",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RQEQGRHSH RMAN@P?TAV@W? RR`RcSdTd",
    "@^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RCHDHEGEE RR`RcSdTd",
    "@^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RCECGDHEH RR`RcSdTd",
    "8^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RBEEH R;H<H=G=E RR`RcSdTd",
    "8^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RBEEH R;E;G<H=H RR`RcSdTd",
    "8^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RFECH R;H<H=G=E RR`RcSdTd",
    "8^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RFECH R;E;G<H=H RR`RcSdTd",
    "=^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ R?A@@B?FAH@I? RCHDHEGEE RR`RcSdTd",
    "=^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ R?A@@B?FAH@I? RCECGDHEH RR`RcSdTd",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RNEOGQHSHUGVE", /* U+1FB0 ALPHA_SMALL BREVE */
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RMGWG",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RPESH RR`RcSdTd",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RR`RcSdTd",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RTEQH RR`RcSdTd",
    "F^K[KFYFY[K[",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RMHNGPFTHVGWF",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RMHNGPFTHVGWF RR`RcSdTd",
    "I[MUWU RK[RFY[ RN>O@QASAU@V>",
    "I[MUWU RK[RFY[ RM@W@",
    "G[MUWU RK[RFY[ RIELH",
    "G[MUWU RK[RFY[ RMEJH",
    "I[MUWU RK[RFY[ RR`RcSdTd",
    "NVQHRHSGSE",
    "NVR`RcSdTd",
    "NVQHRHSGSE",
    "KZMHNGPFTHVGWF", /* U+1FC0 TILDE  */
    "LXMCNBPATCVBWA RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "I\\NMN[ RNOONQMTMVNWPWb RPESH RN`NcOdPd",
    "I\\NMN[ RNOONQMTMVNWPWb RN`NcOdPd",
    "I\\NMN[ RNOONQMTMVNWPWb RTEQH RN`NcOdPd",
    "F^K[KFYFY[K[",
    "I\\NMN[ RNOONQMTMVNWPWb RMHNGPFTHVGWF",
    "I\\NMN[ RNOONQMTMVNWPWb RMHNGPFTHVGWF RN`NcOdPd",
    "B[MPTP RW[M[MFWF RDEGH",
    "B[MPTP RW[M[MFWF RHEEH",
    "A]L[LF RLPXP RX[XF RCEFH",
    "A]L[LF RLPXP RX[XF RGEDH",
    "G]L[LF RLPXP RX[XF RR`RcSdTd",
    "JZTEWH RMHNHOGOE",
    "JZXEUH RMHNHOGOE",
    "NVQHRHSGSE RMAN@P?TAV@W?",
    "MXRMRXSZU[ RNEOGQHSHUGVE", /* U+1FD0 IOTA_SMALL BREVE */
    "MXRMRXSZU[ RMGWG",
    "MXRMRXSZU[ RNFOGNHMGNFNH RVFWGVHUGVFVH RP>SA",
    "MXRMRXSZU[ RNFOGNHMGNFNH RVFWGVHUGVFVH RT>QA",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "MXRMRXSZU[ RMHNGPFTHVGWF",
    "MXRMRXSZU[ RMCNBPATCVBWA RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "MWR[RF RN>O@QASAU@V>",
    "MWR[RF RM@W@",
    "GWR[RF RIELH",
    "GWR[RF RMEJH",
    "F^K[KFYFY[K[",
    "JZTEWH RMEMGNHOH",
    "JZXEUH RMEMGNHOH",
    "NVQEQGRHSH RMAN@P?TAV@W?",
    "H[MMMXNZP[S[UZVYWWWPVNUM RNEOGQHSHUGVE", /* U+1FE0 UPSILON_SMALL BREVE */
    "H[MMMXNZP[S[UZVYWWWPVNUM RMGWG",
    "H[MMMXNZP[S[UZVYWWWPVNUM RNFOGNHMGNFNH RVFWGVHUGVFVH RP>SA",
    "H[MMMXNZP[S[UZVYWWWPVNUM RNFOGNHMGNFNH RVFWGVHUGVFVH RT>QA",
    "H\\MbMQNOONQMTMVNWOXQXWWYVZT[Q[OZMX RQHRHSGSE",
    "H\\MbMQNOONQMTMVNWOXQXWWYVZT[Q[OZMX RQEQGRHSH",
    "H[MMMXNZP[S[UZVYWWWPVNUM RMHNGPFTHVGWF",
    "H[MMMXNZP[S[UZVYWWWPVNUM RMCNBPATCVBWA RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "I[RQR[ RKFRQYF RN>O@QASAU@V>",
    "I[RQR[ RKFRQYF RM@W@",
    "@[RQR[ RKFRQYF RBEEH",
    "@[RQR[ RKFRQYF RFECH",
    "A\\L[LFTFVGWHXJXMWOVPTQLQ RDEDGEHFH",
    "LXNFOGNHMGNFNH RVFWGVHUGVFVH RP>SA",
    "LXNFOGNHMGNFNH RVFWGVHUGVFVH RT>QA",
    "NVPESH",
    "F^K[KFYFY[K[", /* U+1FF0 */
    "F^K[KFYFY[K[",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RPESH RR`RcSdTd",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RR`RcSdTd",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RTEQH RR`RcSdTd",
    "F^K[KFYFY[K[",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RMHNGPFTHVGWF",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RMHNGPFTHVGWF RR`RcSdTd",
    "B]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RDEGH",
    "B]PFTFVGXIYMYTXXVZT[P[NZLXKTKMLINGPF RHEEH",
    "@^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RBEEH",
    "@^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RFECH",
    "F^J[O[OWMVKTJQJLKIMGPFTFWGYIZLZQYTWVUWU[Z[ RR`RcSdTd",
    "NVTEQH",
    "NVQEQGRHSH",
    "F^K[KFYFY[K[",
    /* // General Punctuation (2000-206F) */
    "F^", /* U+2000 SPACE_EM  */
    "LX",
    "F^",
    "LX",
    "NV",
    "OU",
    "PT",
    "H\\",
    "MW",
    "PT",
    "QS",
    "RR",
    "RR",
    "RR",
    "RR",
    "RR",
    "LXOTUT", /* U+2010 HYPHEN  */
    "LXOTUT",
    "H\\JRZR",
    "LXVTNT",
    "F^IT[T",
    "F^IT[T",
    "H\\ODOb RUDUb",
    "JZJbZb RJ]Z]",
    "MWQGQFRDSC",
    "MWSFSGRIQJ",
    "MWSZS[R]Q^",
    "MWQFQGRISJ",
    "JZUGUFVDWC RMGMFNDOC",
    "JZOFOGNIMJ RWFWGVIUJ",
    "JZOZO[N]M^ RWZW[V]U^",
    "JZUFUGVIWJ RMFMGNIOJ",
    "I[MMWM RRFRb", /* U+2020 DEI_SMALL  */
    "I[M[W[ RMMWM RRFRb",
    "E_PQPU RQUQQ RRPRV RSUSQ RTQTU RPTRVTT RPRRPTR RPQRPTQUSTURVPUOSPQ",
    "E_PPPV RQQQU RRQRU RSSUS RSRST ROPUSOV RVSOWOOVS",
    "MWRYSZR[QZRYR[",
    "MaRYSZR[QZRYR[ R\\Y]Z\\[[Z\\Y\\[",
    "MkRYSZR[QZRYR[ R\\Y]Z\\[[Z\\Y\\[ RfYgZf[eZfYf[",
    "JZRRQSRTSSRRRT",
    "RR",
    "RR",
    "RR",
    "RR",
    "RR",
    "RR",
    "RR",
    "RR",
    "FjJ[ZF RMFOGPIOKMLKKJIKGMF RcUeVfXeZc[aZ`XaVcU RYZZXYVWUUVTXUZW[YZ", /* U+2030 PERMILLE  */
    "FvJ[ZF RMFOGPIOKMLKKJIKGMF RcUeVfXeZc[aZ`XaVcU RoUqVrXqZo[mZlXmVoU RYZZXYVWUUVTXUZW[YZ",
    "MWTFQL",
    "JZQFNL RWFTL",
    "G]NFKL RTFQL RZFWL",
    "MWPFSL",
    "JZSFVL RMFPL",
    "G]VFYL RPFSL RJFML",
    "LXVcR`Nc",
    "KYUMOSUY",
    "KYOMUSOY",
    "E_LMXY RXMLY RKRLSKTJSKRKT RRYSZR[QZRYR[ RRKSLRMQLRKRM RYRZSYTXSYRYT",
    "MaRYSZR[QZRYR[ RRSQGRFSGRSRF R\\Y]Z\\[[Z\\Y\\[ R\\S[G\\F]G\\S\\F",
    "I[QFQS RQYRZQ[PZQYQ[ RQYRZQ[PZQYQ[ RMGOFTFVGWIWKVMUNSORPQRQS RMGOFTFVGWIWKVMUNSORPQRQS",
    "E_JGZG",
    "OUb`aa^c\\dYeTfPfKeHdFcCaB`",
    "OUBFCEFCHBKAP@T@YA\\B^CaEbF", /* U+2040 TIE  */
    "E_N_VW RV_R[",
    "CaKRKW RRFRK RYRYW RFUKWPU RH[KWN[ RMIRKWI ROORKUO RTUYW^U RV[YW\\[",
    "LXOTUT",
    "G][EI`",
    "KYQSVS RVbQbQDVD",
    "KYSSNS RNbSbSDND",
    "ImQYRZQ[PZQYQ[ RMGOFTFVGWIWKVMUNSORPQRQS RcYdZc[bZcYc[ R_GaFfFhGiIiKhMgNeOdPcRcS",
    "IeQYRZQ[PZQYQ[ RMGOFTFVGWIWKVMUNSORPQRQS R`YaZ`[_Z`Y`[ R`S_G`FaG`S`F",
    "MiRYSZR[QZRYR[ RRSQGRFSGRSRF R_Y`Z_[^Z_Y_[ R[G]FbFdGeIeKdMcNaO`P_R_S",
    "KYNMVMPb",
    "G^NMN[ RUMUXVZX[ RJMWMYNZP",
    "H\\NQNU RWPWV RPVPPOQOUPV RQPPPNQMSNUPVQVQP",
    "H\\VQVU RMPMV RTVTPUQUUTV RSPTPVQWSVUTVSVSP",
    "JZR[RV RWXRVMX RURRVOR",
    "MWQZQ[R]S^ RRNQORPSORNRP",
    "OUBFCEFCHBKAP@T@YA\\B^CaEbF Rb`aa^c\\dYeTfPfKeHdFcCaB`", /* U+2050 TIE *TIE */
    "JZRFRK RMIRKWI ROORKUO RRFRK RWIRKMI RUORKOO",
    "JZM^WB RNFOGNHMGNFNH RVYWZV[UZVYV[",
    "E_JSKRNQQRSTVUYTZS",
    ">fB^B]C[EZOZQYRWSYUZ_Za[b]b^",
    "E_JSZS RR[RK RLMXY RXMLY",
    "E_LRMSLTKSLRLT RXYYZX[WZXYX[ RXKYLXMWLXKXM",
    "D`KFHL RQFNL RWFTL R]FZL",
    "E_KRLSKTJSKRKT RRYSZR[QZRYR[ RRKSLRMQLRKRM RYRZSYTXSYRYT",
    "E_LXMYLZKYLXLZ RLLMMLNKMLLLN RRRSSRTQSRRRT RXXYYXZWYXXXZ RXLYMXNWMXLXN",
    "MWRYSZR[QZRYR[ RRNSORPQORNRP",
    "E_KRLSKTJSKRKT RRYSZR[QZRYR[ RRKSLRMQLRKRM RYRZSYTXSYRYT",
    "E_JSZS RR[RK RLXMYLZKYLXLZ RLLMMLNKMLLLN RXXYYXZWYXXXZ RXLYMXNWMXLXN",
    "CaR\\S]R^Q]R\\R^ RRRSSRTQSRRRT RRHSIRJQIRHRJ",
    "CaR^S_R`Q_R^R` RRVSWRXQWRVRX RRNSORPQORNRP RRFSGRHQGRFRH",
    "OU",
    "RR", /* U+2060 0  */
    "RR",
    "RR",
    "RR",
    "RR",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "RR",
    "RR",
    "RR",
    "RR",
    "RR",
    "RR",
    /* // Subscripts and Superscripts (2070-209F) */
    "JZQ@S@UAVDVJUMSNQNOMNJNDOAQ@", /* U+2070 ^DIGIT_0_SMALL  */
    "NVRDRN RR=Q>R?S>R=R?",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "JZUFUN RQ@NJWJ",
    "JZV@O@NFPESEUFVHVKUMSNPNNM",
    "JZNHOFQESEUFVHVKUMSNQNOMNKNFOCPAR@U@",
    "JZM@W@PN",
    "JZQFOENCOAQ@S@UAVCUESFQFOGNINKOMQNSNUMVKVIUGSF",
    "JZVFUHSIQIOHNFNCOAQ@S@UAVCVHUKTMRNON",
    "I[LHXH RRBRN",
    "I[LHXH",
    "I[LJXJ RLFXF",
    "MWT=S>RAQFQJROSRTS",
    "MWP=Q>RASFSJROQRPS",
    "KZODON ROEQDSDUEVGVN",
    "JZQSSSUTVWV]U`SaQaO`N]NWOTQS", /* U+2080 .DIGIT_0_SMALL  */
    "JZVaNa RNVPURSRa",
    "JZNTPSSSUTVVVXUZNaVa",
    "JZNSVSRXSXUYV[V^U`SaPaN`",
    "JZUYUa RQSN]W]",
    "JZVSOSNYPXSXUYV[V^U`SaPaN`",
    "JZN[OYQXSXUYV[V^U`SaQaO`N^NYOVPTRSUS",
    "JZMSWSPa",
    "JZQYOXNVOTQSSSUTVVUXSYQYOZN\\N^O`QaSaU`V^V\\UZSY",
    "JZVYU[S\\Q\\O[NYNVOTQSSSUTVVV[U^T`RaOa",
    "I[L[X[ RRURa",
    "I[L[X[",
    "I[L]X] RLYXY",
    "MWTPSQRTQYQ]RbSeTf",
    "MWPPQQRTSYS]RbQePf",
    "RR",
    "KZOXQWSWUXVZVa RV`TaQaO`N^O\\Q[V[", /* U+2090 .A_TINY  */
    "LYV`TaRaP`O^OZPXRWSWUXVZV[O\\",
    "KYQaO`N^NZOXQWSWUXVZV^U`SaQa",
    "KYNWVa RVWNa",
    "LYOXQWSWUXVZV^U`SaRaP`O^O]V\\",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Currency Symbols (20A0-20CF) */
    "F[XMPMP[X[ RTGRFNFLGKHJJJPKRLSNTUT", /* U+20A0 ECU  */
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH RSBG_ RZBN_",
    "F[WYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH RR[RM RRQSOTNVMXM",
    "HZTPMP RM[MFWF RJVRV",
    "H[LMTM RL[W[ RO[OIPGRFUFWG RLSTS",
    "D`I[IM RIOJNLMOMQNRPR[ RRPSNUMXMZN[P[[ RWHM`",
    "G]L[LFX[XF RHV\\V RHP\\P",
    "GyL[LFTFVGWHXJXMWOVPTQLQ R^MfM RaFaXbZd[f[ RlZn[r[tZuXuWtUrToTmSlQlPmNoMrMtN",
    "GmX[QQ RL[LFTFVGWHXJXMWOVPTQLQ R`Zb[f[hZiXiWhUfTcTaS`Q`PaNcMfMhN",
    "F^IFN[RLV[[F RHV\\V RHP\\P",
    "D`I[IFOFRGTIULUR RONOUPXRZU[[[[F",
    "I\\W[WF RWZU[Q[OZNYMWMQNOONQMUMWN RRHZH RXaNa",
    "F[HSQS RHNTN RWYVZS[Q[NZLXKVJRJOKKLINGQFSFVGWH",
    "G\\L[LF RX[OO RXFLR RLOTO",
    "JZLFXF RR[RF ROVUR ROPUL",
    "IoK[RFY[K[ R`b`QaObNdMgMiNjOkQkWjYiZg[d[bZ`X",
    "G]ITJSLRNSOTQUSTXOYLYIXGVFUFSGRIRLSOXTYVYWXYWZT[", /* U+20B0 PENNY_GERMAN  */
    "G\\L[LFTFVGWHXJXMWOVPTQLQ RHL\\L",
    "F[VGTFQFNGLIKKJOJRKVLXNZQ[S[VZWYWRSR RRCR^",
    "I[K[RFY[ RHV\\V RHP\\P",
    "H\\XZU[P[NZMYLWLUMSNRPQTPVOWNXLXJWHVGTFOFLG RRCR^",
    "HZVZT[P[NZMYLWLQMONNPMTMVN RRJR^",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+20C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Combining Diacritical Marks For Symbols (20D0-20FF) */
    "F^K[KFYFY[K[", /* U+20D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+20E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+20F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Letterlike Symbols (2100-214F) */
    "F^K[KFYFY[K[", /* U+2100 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2110 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2120 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2130 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2140 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Number Forms (2150-218F) */
    "F^K[KFYFY[K[", /* U+2150 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2160 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2170 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2180 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Arrows (2190-21FF) */
    "E_ZSJS RNWJSNO", /* U+2190 !ARROW_E  */
    "E_R[RK RNORKVO",
    "E_JSZS RVWZSVO",
    "E_RKR[ RVWR[NW",
    "E_JSZS RVWZSVO RNOJSNW",
    "E_R[RK RNORKVO RVWR[NW",
    "E_KLYZ RRLKLKS",
    "E_YLKZ RRLYLYS",
    "E_YZKL RRZYZYS",
    "E_KZYL RRZKZKS",
    "E_ZSJS RRWVO RNOJSNW",
    "E_JSZS RRONW RVWZSVO",
    "E_JWJQPQ RJQMTOUQTSRUQWRZU",
    "E_ZWZQTQ RZQWTUUSTQROQMRJU",
    "E_ZSJS RTOPSTW RNWJSNO",
    "E_R[RK RNURQVU RNORKVO",
    "E_JSZS RPOTSPW RVWZSVO", /* U+21A0 ARROW_DBL_E  */
    "E_RKR[ RVQRUNQ RVWR[NW",
    "E_JSVS RZOVSZW RNWJSNO",
    "E_ZSNS RJONSJW RVWZSVO",
    "E_ZOZW RJSZS RNWJSNO",
    "E_R[RK RV[N[ RNORKVO",
    "E_JOJW RZSJS RVWZSVO",
    "E_RKR[ RNKVK RVWR[NW",
    "E_N[V[ RR[RK RNWR[VW RNORKVO",
    "E_NWJSNO RJSWSYRZPYNWM",
    "E_VWZSVO RZSMSKRJPKNMM",
    "E_NWJSNO RJSWSYRZPYNWMUNTPTW",
    "E_VWZSVO RZSMSKRJPKNMMONPPPW",
    "E_PUJUJO RZWZQTQ RZQWTUUSTQROQMRJU",
    "E_JSZS RTOPW RNOJSNW RVWZSVO",
    "E_PWR[VY ROKLTVOR[",
    "E_V[VOJO RNSJONK", /* U+21B0 !ARROW_E_N  */
    "E_N[NOZO RVSZOVK",
    "E_VKVWJW RNSJWN[",
    "E_NKNWZW RVSZWV[",
    "E_JOVOV[ RZWV[RW",
    "E_VKVWJW RNSJWN[",
    "E_OQKUGQ RYRYQXNVLSKQKNLLNKQKU",
    "E_UQYU]Q RKRKQLNNLQKSKVLXNYQYU",
    "E_KLYZ RKHYH RRLKLKS",
    "E_JWZW RJKJS RZSZ[ RZOJO RNSJONK RV[ZWVS",
    "E_[KUKUQ RMMLNKQKSLVNXQYSYVXXVYSYQXNUK",
    "E_IKOKOQ RWMXNYQYSXVVXSYQYNXLVKSKQLNOK",
    "E_ZSJSNO",
    "E_ZSJSNW",
    "E_R[RKVO",
    "E_R[RKNO",
    "E_JSZSVO", /* U+21C0 HARPOON_UP_E  */
    "E_JSZSVW",
    "E_RKR[VW",
    "E_RKR[NW",
    "E_ZWJW RJOZO RVSZOVK RN[JWNS",
    "E_N[NK RVKV[ RJONKRO RRWV[ZW",
    "E_JWZW RZOJO RNSJONK RV[ZWVS",
    "E_ZWJW RJOZO RN[JWNSJONK",
    "E_N[NK RVKV[ RJONKROVKZO",
    "E_JWZW RZOJO RV[ZWVSZOVK",
    "E_VKV[ RN[NK RZWV[RWN[JW",
    "E_JVZVVZ RZPJPNL",
    "E_ZVJVNZ RJPZPVL",
    "E_ZPMP RZVMV RRXVN ROXJSON",
    "E_MVWV RMPWP RSNQX ROXJSON RUNZSUX",
    "E_JVWV RJPWP RRNNX RUNZSUX",
    "E_ZPMP RZVMV ROXJSON", /* U+21D0 *ARROW_E_DBL  */
    "E_ONO[ RUNU[ RWPRKMP",
    "E_JVWV RJPWP RUNZSUX",
    "E_UXUK ROXOK RMVR[WV",
    "E_MVWV RMPWP ROXJSON RUNZSUX",
    "E_OXON RUXUN RMVR[WV RWPRKMP",
    "E_[XOL RW\\KP RSLKLKT",
    "E_IXUL RM\\YP RQLYLYT",
    "E_INUZ RMJYV RQZYZYR",
    "E_[NOZ RWJKV RSZKZKR",
    "E_ZXOX RZSJS RZNON RQLJSQZ",
    "E_JXUX RJSZS RJNUN RSLZSSZ",
    "E_NWJSNO RZUWQTUQQNULSJS",
    "E_VWZSVO RJUMQPUSQVUXSZS",
    "E_NXVX RNSVS RR[RK RNORKVO",
    "E_VNNN RVSNS RRKR[ RVWR[NW",
    "E_ZSWS RSSQS RMSJS RNOJSNW", /* U+21E0 *ARROW_E_DASHED  */
    "E_R[RX RRTRR RRNRK RNORKVO",
    "E_JSMS RQSSS RWSZS RVWZSVO",
    "E_RKRN RRRRT RRXR[ RVWR[NW",
    "E_ZSJS RJWJO RNOJSNW",
    "E_JSZS RZOZW RVWZSVO",
    "E_ZPZVOVOXJSONOPZP",
    "E_U[O[OPMPRKWPUPU[",
    "E_JVJPUPUNZSUXUVJV",
    "E_OKUKUVWVR[MVOVOK",
    "E_U[O[OWUWU[ RUSOSOPMPRKWPUPUS",
    "E_W[M[MWOWOPMPRKWPUPUWWWW[",
    "E_ONUN RW[M[MWOWOPMPRKWPUPUWWWW[",
    "E_RKR[ RW[M[MWOWOPMPRKWPUPUWWWW[",
    "E_PPMPRKWPTP RU[O[OSMSRNWSUSU[",
    "E_PPMPRKWPTP RW[M[MWOWOSMSRNWSUSUWWWW[",
    "E_JNNNNPUPUNZSUXUVNVNXJXJN", /* U+21F0 ARROW_E_WALL_WHITE  */
    "E_Z[NO RZKJKJ[ RUONONV",
    "E_JKVW RJ[Z[ZK ROWVWVP",
    "E_MPRKWPUPUVWVR[MVOVOPMP",
    "E_JSZS RVWZSVO RTRTTSVQWOWMVLTLRMPOOQOSPTR",
    "E_V[VK RNKN[ RZOVKRO RRWN[JW",
    "E_J[Z[ RJKZK RZSJS RVGZKVOZSVWZ[V_",
    "E_ZSJS RTWTO RNOJSNW",
    "E_JSZS RPOPW RVWZSVO",
    "E_JSZS RRORW RNOJSNW RVWZSVO",
    "E_ZSJS RWWWO RRWRO RNOJSNW",
    "E_JSZS RMOMW RRORW RVWZSVO",
    "E_JSZS RPOPW RTOTW RNWJSNO RVWZSVO",
    "E_NSZS RNWNOJSNW",
    "E_VSJS RVWVOZSVW",
    "E_NSVS RNWJSNONW RVWVOZSVW",
    /* // Mathematical Operators (2200-22FF) */
    "I[MLWL RKFR[YF", /* U+2200 =A_CAP  */
    "HZVHUGSFPFNGMHLKLVMYNZP[S[UZVY",
    "H[WOVNTMPMNNMOLQLWMYNZP[S[UZVYWWWJVHUGSFOFMG",
    "I\\WPPP RM[W[WFMF",
    "I\\WQPQ RMFWFW[M[ RXCL`",
    "C`G[\\F ROFTFXHZJ\\N\\SZWXYT[O[KYIWGSGNIJKHOF",
    "I[K[RFY[K[",
    "I[YFR[KFYF",
    "C`\\QGQ R\\GOGKIIKGOGSIWKYO[\\[",
    "C`[CH^ R\\QGQ R\\GOGKIIKGOGSIWKYO[\\[",
    "E_JSZS RZZPZMYKWJTJRKOMMPLZL",
    "DaHP]P RHZUZYX[V]R]N[JYHUFHF",
    "DaI^\\C RHP]P RHZUZYX[V]R]N[JYHUFHF",
    "E_ZSJS RJZTZWYYWZTZRYOWMTLJL",
    "E_M[WQ RMZWP RMYWO RMXWN RMWWM RMVWL RMUWK RMTVK RMSUK RMRTK RMQSK RMPRK RMOQK RMNPK RMMOK RMLNK RN[WR RO[WS RP[WT RQ[WU RR[WV RS[WW RT[WX RU[WY RV[WZ RM[MKWKW[M[",
    "E_Z`ZFJFJ`",
    "E_ZFZ`J`JF", /* U+2210 ~PI_CAP_HUGE  */
    "E_Z`I`TSIF[F",
    "E_JSZS",
    "E_ZWJW RROR_ RJKZK",
    "E_JSZS RR[RK RRDQERFSERDRF",
    "G][EI`",
    "KYID[_",
    "E_KOYW RR[RK RYOKW",
    "E_PQRPTQUSTURVPUOSPQ",
    "E_PQPU RQUQQ RRPRV RSUSQ RTQTU RPTRVTT RPRRPTR RPQRPTQUSTURVPUOSPQ",
    "IbMTQSS[bB",
    "IbMTQSS[bB RN@V@RESEUFVHVKUMSNPNNM",
    "IbMTQSS[bB RUFUN RQ@NJWJ",
    "E_XPWPUQQUOVMULSMQOPQQUUWVXV",
    "E_TQVPXQYSXUVVTUPQNPLQKSLUNVPUTQ",
    "E_JKJ[Z[",
    "E_ZKJ[Z[", /* U+2220 ANGLE  */
    "E_ZKJ[Z[ RPSRUTZT]",
    "E_Z[JSZK RSYTWUSTOSM",
    "H\\RbRD",
    "H\\NUVQ RRDRb",
    "H\\ODOb RUDUb",
    "H\\LVXP RODOb RUDUb",
    "E_[[RKI[",
    "E_IKR[[K",
    "E_Z[ZQXMTKPKLMJQJ[",
    "E_JKJULYP[T[XYZUZK",
    "H\\L]M_O`Q_R]RISGUFWGXI",
    "D`H]I_K`M_N]NIOGQFSGTI RP]Q_S`U_V]VIWGYF[G\\I",
    "@dD]E_G`I_J]JIKGMFOGPI RL]M_O`Q_R]RISGUFWGXI RT]U_W`Y_Z]ZI[G]F_G`I",
    "H\\L]M_O`Q_R]RISGUFWGXI RRMUNWPXSWVUXRYOXMVLSMPONRM",
    "D`H]I_K`M_N]NIOGQFSGTI RP]Q_S`U_V]VIWGYF[G\\I RVMYN[P\\S[VYXVYNYKXIVHSIPKNNMVM",
    "@dD]E_G`I_J]JIKGMFOGPI RL]M_O`Q_R]RISGUFWGXI RT]U_W`Y_Z]ZI[G]F_G`I RZM]N_P`S_V]XZYJYGXEVDSEPGNJMZM", /* U+2230 INTEGRAL_TPL_CONTOUR  */
    "H\\URXU[R RLSMPONRMUNWPXSXU RL]M_O`Q_R]RISGUFWGXI",
    "H\\UQXT[Q RL]M_O`Q_R]RISGUFWGXI RLSMPONRMUNWPXSWVUXRYOXMVLS",
    "H\\UUXR[U RL]M_O`Q_R]RISGUFWGXI RLSMPONRMUNWPXSWVUXRYOXMVLS",
    "E_KXLYKZJYKXKZ RRLSMRNQMRLRN RYXZYYZXYYXYZ",
    "E_YNXMYLZMYNYL RRZQYRXSYRZRX RKNJMKLLMKNKL",
    "JZRXSYRZQYRXRZ RRLSMRNQMRLRN",
    "E_LXMYLZKYLXLZ RLLMMLNKMLLLN RXXYYXZWYXXXZ RXLYMXNWMXLXN",
    "E_JSZS RRFQGRHSGRFRH",
    "E_JSTS RYXZYYZXYYXYZ RYLZMYNXMYLYN",
    "E_JSZS RLXMYLZKYLXLZ RLLMMLNKMLLLN RXXYYXZWYXXXZ RXLYMXNWMXLXN",
    "E_JSKRNQQRSTVUYTZS RRXSYRZQYRXRZ RRLSMRNQMRLRN",
    "E_JSKRNQQRSTVUYTZS",
    "E_ZSYRVQSRQTNUKTJS",
    "E_WPYQZSYUWVTUPQMPKQJSKUMV",
    "E_JSKNLLNKPLQNSXTZV[XZYXZS",
    "E_RKSLTOSRQTPWQZR[", /* U+2240 WREATH_PRODUCT  */
    "E_JSKRNQQRSTVUYTZS RVKN[",
    "E_ZPJP RZVYWVXSWQUNTKUJV",
    "E_JVZV RJPKONNQOSQVRYQZP",
    "E_JVZV RJPKONNQOSQVRYQZP RVKN[",
    "E_JYZY RJSZS RJMKLNKQLSNVOYNZM",
    "E_JYZY RJSZS RUPO\\ RJMKLNKQLSNVOYNZM",
    "E_JYZY RJSZS RJMKLNKQLSNVOYNZM RXGL_",
    "E_JVKUNTQUSWVXYWZV RJPKONNQOSQVRYQZP",
    "E_JVKUNTQUSWVXYWZV RJPKONNQOSQVRYQZP RVKN[",
    "E_JYZY RJSKRNQQRSTVUYTZS RJMKLNKQLSNVOYNZM",
    "E_JYKXNWQXSZV[YZZY RJSKRNQQRSTVUYTZS RJMKLNKQLSNVOYNZM",
    "E_ZYJY RZSJS RZMYLVKSLQNNOKNJM",
    "E_JXLWPVTVXWZX RJNLOPPTPXOZN",
    "E_JVNVNWOYQZSZUYVWVVZV RJPNPNOOMQLSLUMVOVPZP",
    "E_ZVJV RJPNPNOOMQLSLUMVOVPZP",
    "E_JPZP RZVJV RRHQIRJSIRHRJ", /* U+2250 EQUAL DOT */
    "E_JPZP RZVJV RRXSYRZQYRXRZ RRLSMRNQMRLRN",
    "E_JPZP RZVJV RKJLKKLJKKJKL RYZZ[Y\\X[YZY\\",
    "E_ZPJP RJVZV RYJXKYLZKYJYL RKZJ[K\\L[KZK\\",
    "AcNP^P R^VNV RGVHWGXFWGVGX RGNHOGPFOGNGP",
    "AcVPFP RFVVV R]V\\W]X^W]V]X R]N\\O]P^O]N]P",
    "E_JPZP RZVJV RPQRPTQUSTURVPUOSPQ",
    "E_JPZP RZVJV RRJPIOGPERDTEUGTIRJ",
    "E_JPZP RZVJV RNJOHQGSGUHVJ",
    "E_JPZP RZVJV RNJRGVJ",
    "E_JPZP RZVJV RNGRJVG",
    "E_JPZP RZVJV RRATGOCUCPGRA",
    "E_JPZP RZVJV RR?NJVJR?",
    "E_JPZP RYC]C RZVJV R]?[@ZBZJ RM?MJKJIIHGHEICKBMB RQFVFVCUBRBQCQIRJUJ",
    "E_JPZP RZVJV RMBMJ RMCNBQBRCRJ RRCSBVBWCWJ",
    "E_JPZP RZVJV RRHSIRJQIRHRJ RN@P?S?U@VBUDSE",
    "E_JPZP RTMPY RZVJV", /* U+2260 EQUAL_SLASH  */
    "E_JYZY RJSZS RJMZM",
    "E_JYZY RJSZS RJMZM RXGL_",
    "E_J\\Z\\ RJPZP RJJZJ RZVJV",
    "E_ZZJZ RZVJPZJ",
    "E_JZZZ RJVZPJJ",
    "E_J]Z] RZWJW RZSJMZG",
    "E_Z]J] RJWZW RJSZMJG",
    "E_J]Z] RTTP` RZWJW RZSJMZG",
    "E_JWZW RTTP` RZ]J] RJSZMJG",
    "=gRMBSRY RbMRSbY",
    "=gRMbSRY RBMRSBY",
    "I[OCPDRGSITLUQUUTZS]R_PbOc RUcTbR_Q]PZOUOQPLQIRGTDUC",
    "E_JXLWPVTVXWZX RJNLOPPTPXOZN RVKN[",
    "E_ZMJSZY RVKN[",
    "E_JMZSJY RVKN[",
    "E_ZZJZ RZVJPZJ RXGL_", /* U+2270 LESS_MINUS SLASH_OP */
    "E_JZZZ RJVZPJJ RXGL_",
    "E_ZVJPZJ RJZKYNXQYS[V\\Y[ZZ",
    "E_JVZPJJ RJZKYNXQYS[V\\Y[ZZ",
    "E_ZVJPZJ RJZKYNXQYS[V\\Y[ZZ RXGL_",
    "E_JVZPJJ RJZKYNXQYS[V\\Y[ZZ RXGL_",
    "E_JSZYJ_ RZSJMZG",
    "E_ZSJYZ_ RJSZMJG",
    "E_JSZYJ_ RZSJMZG RXGL_",
    "E_ZSJYZ_ RJSZMJG RXGL_",
    "E_ZKXNVPRRJSRTVVXXZ[",
    "E_JKLNNPRRZSRTNVLXJ[",
    "E_JVRWVYX[Z^ RZHXKVMROJPRQVSXUZX",
    "E_ZVRWNYL[J^ RJHLKNMROZPRQNSLUJX",
    "E_J[KZNYQZS\\V]Y\\Z[ RZHXKVMROJPRQVSXUZX",
    "E_J[KZNYQZS\\V]Y\\Z[ RJXLUNSRQZPRONMLKJH",
    "E_ZKXNVPRRJSRTVVXXZ[ RVKN[", /* U+2280 PRECEDES SLASH_REL */
    "E_JKLNNPRRZSRTNVLXJ[ RVKN[",
    "E_ZMNMLNKOJQJUKWLXNYZY",
    "E_JMVMXNYOZQZUYWXXVYJY",
    "E_ZMNMLNKOJQJUKWLXNYZY RVKN[",
    "E_JMVMXNYOZQZUYWXXVYJY RVKN[",
    "E_J\\Z\\ RZJNJLKKLJNJRKTLUNVZV",
    "E_Z\\J\\ RJJVJXKYLZNZRYTXUVVJV",
    "E_J\\Z\\ RZJNJLKKLJNJRKTLUNVZV RXGL_",
    "E_Z\\J\\ RJJVJXKYLZNZRYTXUVVJV RXGL_",
    "E_J\\Z\\ RZJNJLKKLJNJRKTLUNVZV RSYQ_",
    "E_Z\\J\\ RJJVJXKYLZNZRYTXUVVJV RSYQ_",
    "E_JKJULYP[T[XYZUZK ROSUS RSUUSSQ",
    "E_JKJULYP[T[XYZUZK RRRQSRTSSRRRT",
    "E_JKJULYP[T[XYZUZK RLSXS RRMRY",
    "E_ZYJYJMZM",
    "E_JYZYZMJM", /* U+2290 !SQIMAGE  */
    "E_Z\\J\\ RZVJVJJZJ",
    "E_J\\Z\\ RJVZVZJJJ",
    "E_Z[ZKJKJ[",
    "E_JKJ[Z[ZK",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RLSXS RRMRY",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RLSXS",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RMNWX RWNMX",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RWFM^",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RRRQSRTSSRRRT",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RPQRPTQUSTURVPUOSPQ",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RRNRS RMQRSWQ ROWRSUW",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RLUXU RLQXQ",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RNSVS",
    "E_JKZKZ[J[JK RLSXS RRMRY",
    "E_JKZKZ[J[JK RLSXS",
    "E_JKZKZ[J[JK RMNWX RWNMX", /* U+22A0 SQUARE MULTIPLY_SMALL */
    "E_JKZKZ[J[JK RRRQSRTSSRRRT",
    "E_J[JK RJSZS",
    "E_Z[ZK RZSJS",
    "E_ZKJK RRKR[",
    "E_J[Z[ RR[RK",
    "I[NSVS RNKN[",
    "I[NVVV RNPVP RNKN[",
    "E_JVZV RJPZP RJKJ[",
    "E_JKJ[ RPSZS RPKP[",
    "E_JKJ[ ROKO[ RTKT[ RYSTS",
    "E_JKJ[ RPVYV RPPYP RPKP[",
    "E_J[JK RJSZS RXGL_",
    "E_JVZV RJPZP RJKJ[ RXGL_",
    "E_JKJ[ RPSZS RPKP[ RXGL_",
    "E_JKJ[ RPVYV RPPYP RPKP[ RXGL_",
    "E_VKXLYNXPVQRRJSRTVUXVYXXZV[", /* U+22B0 PRECEDESREL  */
    "E_NKLLKNLPNQRRZSRTNULVKXLZN[",
    "E_JSZYZMJS",
    "E_ZSJYJMZS",
    "E_Z[J[ RJQZWZKJQ",
    "E_J[Z[ RZQJWJKZQ",
    "BbXQXU RYQYU RZPZV R[Q[U R\\Q\\U RMSLQJPHQGSHUJVLUMSWSXUZV\\U]S\\QZPXQWS",
    "BbLQLU RKQKU RJPJV RIQIU RHQHU RWSXQZP\\Q]S\\UZVXUWSMSLUJVHUGSHQJPLQMS",
    "E_JSTSUUWVYUZSYQWPUQTS",
    "E_JSNS RR[RW RRKRO RZSVS",
    "I[NFVF RRFR[",
    "E_J[Z[ RZKRVJK",
    "E_ZKJK RJ[RPZ[",
    "E_JKZK RZPR[JP",
    "E_JKJ[Z[ RJOLOQQTTVYV[",
    "E_Z[ZKJ[Z[",
    "Bb_`REE`", /* U+22C0 *OR_HUGE  */
    "BbEFRa_F",
    "Bb]`]O\\KZHWFSEQEMFJHHKGOG`",
    "BbGFGWH[J^M`QaSaW`Z^\\[]W]F",
    "E_RaJSRFZSRa",
    "JZRRQSRTSSRRRT",
    "I[RRTXOTUTPXRR",
    "E_ZSJS RRXSYRZQYRXRZ RRLSMRNQMRLRN RLMXY RXMLY",
    "E_JKZ[ZKJ[JK",
    "E_ZKJ[JKZ[",
    "E_JKZ[ZKJ[",
    "E_JKZ[ RRSJ[",
    "E_ZKJ[ RRSZ[",
    "E_ZVJV RZPYOVNSOQQNRKQJP",
    "E_JKMMOOQSR[SSUOWMZK",
    "E_Z[WYUWSSRKQSOWMYJ[",
    "E_ZPSPQQPSQUSVZV RZ\\Q\\N[KXJUJQKNNKQJZJ", /* U+22D0 SUBSET_DBL  */
    "E_JPQPSQTSSUQVJV RJ\\S\\V[YXZUZQYNVKSJJJ",
    "E_U[UTTRRQPROTO[ R[[[RZOWLTKPKMLJOIRI[",
    "E_OKORPTRUTTURUK RIKITJWMZP[T[WZZW[T[K",
    "E_RKR[ RL[LSMPNOQNSNVOWPXSX[",
    "E_JPZP RZVJV RODOb RUDUb",
    "E_ZMJSZY RYRXSYTZSYRYT",
    "E_JMZSJY RKRJSKTLSKRKT",
    "5oJM:SJY RZMJSZY RjMZSjY",
    "5oZMjSZY RJMZSJY R:MJS:Y",
    "E_ZSJS RJWZ[J_ RZOJKZG",
    "E_JSZS RZWJ[Z_ RJOZKJG",
    "E_ZLJL RZPJVZ\\",
    "E_JLZL RJPZVJ\\",
    "E_JPROVMXKZH RZ^X[VYRWJVRUVSXQZN",
    "E_ZPRONMLKJH RJ^L[NYRWZVRUNSLQJN",
    "E_JPROVMXKZH RZ^X[VYRWJVRUVSXQZN RXGL_", /* U+22E0 ~PRECEDESEQ SLASH_OP */
    "E_ZPRONMLKJH RJ^L[NYRWZVRUNSLQJN RXGL_",
    "E_Z\\J\\ RZVJVJJZJ RXGL_",
    "E_J\\Z\\ RJVZVZJJJ RXGL_",
    "E_Z\\J\\ RZVJVJJZJ RSYQ_",
    "E_J\\Z\\ RJVZVZJJJ RSYQ_",
    "E_ZVJPZJ RJZKYNXQYS[V\\Y[ZZ RSWQ]",
    "E_JVZPJJ RJZKYNXQYS[V\\Y[ZZ RSWQ]",
    "E_J[KZNYQZS\\V]Y\\Z[ RZHXKVMROJPRQVSXUZX RSXQ^",
    "E_J[KZNYQZS\\V]Y\\Z[ RJXLUNSRQZPRONMLKJH RSXQ^",
    "E_JSZYZMJS RXGL_",
    "E_ZSJYJMZS RXGL_",
    "E_Z[J[ RJQZWZKJQ RXGL_",
    "E_J[Z[ RZQJWJKZQ RXGL_",
    "CaR\\S]R^Q]R\\R^ RRRSSRTQSRRRT RRHSIRJQIRHRJ",
    "CaHRISHTGSHRHT RRRSSRTQSRRRT R\\R]S\\T[S\\R\\T",
    "Ca\\H[I\\J]I\\H\\J RRRQSRTSSRRRT RH\\G]H^I]H\\H^", /* U+22F0 !ELLIPSIS_DIAG  */
    "CaHHIIHJGIHHHJ RRRSSRTQSRRRT R\\\\]]\\^[]\\\\\\^",
    ">`BQ\\Q R\\GOGKIIKGOGSIWKYO[\\[",
    ">`GQ\\Q R\\M\\U R\\GOGKIIKGOGSIWKYO[\\[",
    "E_JSZS RZPZV RZZPZMYKWJTJRKOMMPLZL",
    "C`\\QGQ R\\GOGKIIKGOGSIWKYO[\\[ RR@QARBSAR@RB",
    "C`GA\\A R\\QGQ R\\[O[KYIWGSGOIKKIOG\\G",
    "E_JSZS RZGJG RZLPLMMKOJRJTKWMYPZZZ",
    "C`G`\\` R\\PGP R\\FOFKHIJGNGRIVKXOZ\\Z",
    "C`HT\\T RHN\\N R\\GOGKIIKGOGSIWKYO[\\[",
    "DfbQHQ RHGUGYI[K]O]S[WYYU[H[",
    "Df]QHQ RHMHU RHGUGYI[K]O]S[WYYU[H[",
    "E_ZSJS RJPJV RJZTZWYYWZTZRYOWMTLJL",
    "Da]AHA RHQ]Q RH[U[YY[W]S]O[KYIUGHG",
    "E_ZSJS RJGZG RJLTLWMYOZRZTYWWYTZJZ",
    "C`GQ\\Q R\\GGGG[\\[",
    /* // Miscellaneous Technical (2300-23FF) */
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RZKJ[", /* U+2300 CIRCLE SLASH_SYM */
    "E_JQRWROZU",
    "E_J[JORGZOZ[J[",
    "E_NORKVO",
    "E_VWR[NW",
    "E_ZKJK RJ[RPZ[",
    "E_JNZN RJHZH RJ[RSZ[",
    "H\\RDSETGSIRJQLRNSOTQSSRTQVRXSYT[S]R^Q`Rb",
    "KYQbQDVD",
    "KYSbSDND",
    "KYQDQbVb",
    "KYSDSbNb",
    "E_RWR[ RVSZS",
    "E_RWR[ RNSJS",
    "E_RORK RVSZS",
    "E_RORK RNSJS",
    "E_ZQJQJV", /* U+2310 !NOT  */
    "D`[JZLYPYVZZ[\\Y[UZOZK[I\\JZKVKPJLIJKKOLULYK[J",
    "E_JSJQLMPKTKXMZQZS",
    "E_JSJQLMPKTKXMZQZS RJSZS",
    "E_JMLLPKTKXLZMR[JM",
    "E_PUJ[ RTKWLYNZQYTWVTWQVOTNQONQLTK",
    "E_JSZS RR[RK RVRUPSOQOOPNRNTOVQWSWUVVTVR",
    "E_JWZW RJOZO RNKN[ RVKV[",
    "E_LPXPZO[MZKXJVKUMUYV[X\\Z[[YZWXVLVJWIYJ[L\\N[OYOMNKLJJKIMJOLP",
    "E_ZUJUJP",
    "E_RORSUS RPKTKXMZQZUXYT[P[LYJUJQLMPK",
    "E_M[RVW[ RN[RWV[ RP[RYT[ RS[RZQ[ RU[RXO[ RYMRPKMROYM RJFZFZKYMKTJVJ[Z[ZVYTKMJJJF",
    "JZVFNFNM",
    "JZNFVFVM",
    "JZV[N[NT",
    "JZN[V[VT",
    "H\\RbRMSITGVFXGYI", /* U+2320 INTEGRAL_TOP  */
    "H\\RDRYQ]P_N`L_K]",
    "E_JUKTMSRRWSYTZU",
    "E_ZQYRWSRTMSKRJQ",
    "E_LKHK RXK\\K RNORKVO",
    "@dXK^K RFKLKX[^[",
    "AfJKZ[ RZKJ[ RFKZKbSZ[F[FK",
    "AcJKZ[ RZKJ[ RFK^K^[F[FK",
    "9k>VfV R>LfL RCQCL RD[DV REVEQ RFLFG RHQHL RJVJQ RK[KV RKLKG RMQML ROVOQ RPLPG RRQRL RTVTQ RULUG RWQWL RYVYQ RZ[ZV RZLZG R\\Q\\L R^V^Q R_L_G R`[`V R>QaQaL R>[>GfGf[>[",
    "KYUcOSUC",
    "KYOcUSOC",
    ">cZKJ[ RJKZ[ R^KJKBSJ[^[^K",
    "AcKOKW RR[YW RRKYO RRE^L^ZRaFZFLRE",
    "H\\PNKX RYNTX RVRUPSOQOOPNRNTOVQWSWUVVTVR",
    "E_N[J[JW RZSRSJ[ RVRUPSOQOOPNRNTOVQWSWUVVTVR",
    "E_JSZS RNYVY RVMNM",
    "E_RPRKNN RZPZKVN RRKJ[R[ZK", /* U+2330 TOTAL_RUNOUT  */
    "H\\LS[S RRMRY RXP[SXV RVRUPSOQOOPNRNTOVQWSWUVVTVR",
    "E_ZSJ\\JJZS RJSZS",
    "E_J[JRZ[J[",
    "E_JWJ[Z[ZW",
    "E_VWR[NW",
    "D`JaZa RJFZF RRFRa",
    "D`MFWFWaMaMF",
    "D`IF[F[aIaIF RJPZP RZVJV",
    "D`IF[F[aIaIF RZSJS RRXSYRZQYRXRZ RRLSMRNQMRLRN",
    "D`IF[F[aIaIF RRJ[SR\\ISRJ",
    "D`IF[F[aIaIF RPQRPTQUSTURVPUOSPQ",
    "D`IF[F[aIaIF RPKTKXMZQZUXYT[P[LYJUJQLMPK",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RRbRD",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RPQRPTQUSTURVPUOSPQ",
    "E_JSZS RZKJ[",
    "E_JSZS RJKZ[", /* U+2340 MINUS !SLASH_SYM */
    "D`IaIF[F[aIa[F",
    "D`[a[FIFIa[aIF",
    "D`IF[F[aIaIF RZMJSZY",
    "D`IF[F[aIaIF RJMZSJY",
    "E_ZSJS RNWJSNO RR[RK",
    "E_JSZS RVWZSVO RR[RK",
    "D`IF[F[aIaIF RZSJS RNWJSNO",
    "D`IF[F[aIaIF RJSZS RVWZSVO",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RLGX_",
    "E_J[Z[ RR[RK RZaJa",
    "E_RKX[L[RK RRbRD",
    "D`IF[F[aIaIF RIKR[[K",
    "D`IF[F[aIaIF RRKX[L[RK",
    "E_ZKJK RRKR[ RVRUPSOQOOPNRNTOVQWSWUVVTVR",
    "E_R[RK RNORKVO RJSZS",
    "D`IF[F[aIaIF RR[RK RNORKVO", /* U+2350 RECTANGLE_V_HUGE ARROW_N */
    "E_ZKJK RRKR[ RMEWE",
    "E_R[LKXKR[ RRbRD",
    "D`IF[F[aIaIF R[[RKI[",
    "D`IF[F[aIaIF RR[LKXKR[",
    "E_J[Z[ RR[RK RPQRPTQUSTURVPUOSPQ",
    "E_RKR[ RVWR[NW RJSZS",
    "D`IF[F[aIaIF RRKR[ RVWR[NW",
    "JZJ]Z] RSFQJ",
    "E_RKX[L[RK RJ]Z]",
    "E_RJ[SR\\ISRJ RJ]Z]",
    "E_PQRPTQUSTURVPUOSPQ RJ]Z]",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RJ]Z]",
    "E_Z[ZQXMTKPKLMJQJ[ RPQRPTQUSTURVPUOSPQ",
    "D`IF[F[aIaIF RSFQJ",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RRPTVORURPVRP",
    "D`IF[F[aIaIF RRYSZR[QZRYR[ RRNSORPQORNRP", /* U+2360 RECTANGLE_V_HUGE COLON */
    "E_ZKJK RRKR[ RNDOENFMENDNF RVDWEVFUEVDVF",
    "E_R[LKXKR[ RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "E_RKWZJQZQMZRK RNDOENFMENDNF RVDWEVFUEVDVF",
    "E_PQRPTQUSTURVPUOSPQ RNIOJNKMJNINK RVIWJVKUJVIVK",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RNDOENFMENDNF RVDWEVFUEVDVF",
    "E_JKJULYP[T[XYZUZK RRbRD",
    "E_ZMNMLNKOJQJUKWLXNYZY RRbRD",
    "E_JSKRNQQRSTVUYTZS RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "E_JMZSJY RNFOGNHMGNFNH RVFWGVHUGVFVH",
    "E_JSZS RSZS[R]Q^",
    "E_R[LKXKR[ RJSKRNQQRSTVUYTZS",
    "H\\QFSFUGVHWJXNXSWWVYUZS[Q[OZNYMWLSLNMJNHOGQF RJPKONNQOSQVRYQZP",
    "E_JSKRNQQRSTVUYTZS RRbRD",
    "MWSZS[R]Q^ RRNSORPQORNRP RJ]Z]",
    "D`IF[F[aIaIF RJPZP RTMPY RZVJV",
    "D`IF[F[aIaIF RQYRZQ[PZQYQ[ RMGOFTFVGWIWKVMUNSORPQRQS", /* U+2370 RECTANGLE_V_HUGE QUESTION */
    "E_IKR[[K RJSKRNQQRSTVUYTZS",
    "E_[[RKI[ RJSKRNQQRSTVUYTZS",
    "MXRMRXSZU[",
    "H\\MbMQNOONQMTMVNWOXQXWWYVZT[Q[OZMX",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[ RJ]Z]",
    "HZLTST RVZT[P[NZMYLWLQMONNPMTMVN RJ]Z]",
    "MXRMRXSZU[ RJ]Z]",
    "G]RTRX RMMLNKPKXLZN[O[QZRXSZU[V[XZYXYPXNWM RJ]Z]",
    "H]YMVWUYTZR[P[NZMYLVLRMONNPMRMTNUOVQWXXZZ[",
    "IbMTQSS[bB RXL`L",
    "A_J_F_F[ RJKJ[Z[ RF_OVEQOG",
    "E_JWNWN[V[VWZW",
    "E_NSN[J[ RVSV[Z[ RJSJQLMPKTKXMZQZSJS",
    "E_PQPU RQUQQ RRPRV RSUSQ RTQTU RPTRVTT RPRRPTR RPQRPTQUSTURVPUOSPQ RRbRD",
    "E_VWR[NW ROEQDSDUEVGVN RVMTNQNOMNKOIQHVH", /* U+2380 *ARROWHEAD_N ^A_TINY */
    "BbF[^[ RGLIKKKMLNNNU RUSVTUUTTUSUU R]S^T]U\\T]S]U RNTLUIUGTFRGPIONO",
    "BbF[N[ RV[^[ RGLIKKKMLNNNU RWLYK[K]L^N^U RNTLUIUGTFRGPIONO R^T\\UYUWTVRWPYO^O",
    "BbHPDP RJUFX RJKFH R^XZU R^HZK R`P\\P RTTRUPUNTMRMQNNPLRKVKTU",
    "=_RKR[B[BKRK RPKTKXMZQZUXYT[P[LYJUJQLMPK",
    "E_JKZKZ[J[JK RRbRD",
    "C_ESUS RQWUSQO RJWJ[Z[ZKJKJO",
    "@dX[^[ RZO^KZG RF[L[XK^K",
    "E_KOYW RR[RK RYOKW RRMONMPLSMVOXRYUXWVXSWPUNRM",
    "E_JSOSR[USZS RPKTKXMZQZUXYT[P[LYJUJQLMPK",
    "E_R[KOYOR[ RPKTKXMZQZUXYT[P[LYJUJQLMPK",
    "E_STJK RJOJKNK RSKTKXMZQZUXYT[P[LYJUJT",
    "D`KNKROR RYRWPTOPOMPKR RNXMVKUIVHXIZK[MZNX RVXWZY[[Z\\X[VYUWVVX",
    "E_I[N[NKVKV[[[",
    "E_I[V[VK RN[NK[K",
    "E_JKZK RJSRKZSR[JS",
    "E_Z[J[ RZSR[JSRKZS", /* U+2390 *OPEN_H  */
    "E_JKZK RJSRKZSR[JS RJSZS",
    "E_Z[J[ RZSR[JSRKZS RJSZS",
    "E_JVLV RJPZP RQVSV RXVZV",
    "BbL[FQLGXG^QX[L[",
    "D`IF[F[aIaIF",
    "MWTFQL",
    "AcZSJS RRORK RR[RW RNOJSNW R^[F[FK^K^[",
    "AcJSZS RRWR[ RRKRO RVWZSVO RFK^K^[F[FK",
    "BbLHQHQC RLSLHQCXCXSLS RLKJKHLGNGXHZJ[Z[\\Z]X]N\\LZKXK",
    "BbROJW RZORW RGXGNHLJKZK\\L]N]X\\ZZ[J[HZGX",
    "H\\XDVGUITLSQR[Rb",
    "H\\RbRD",
    "H\\XbV_U]TZSURKRD",
    "H\\LDNGOIPLQQR[Rb",
    "H\\RbRD",
    "H\\LbN_O]PZQURKRD", /* U+23A0 *PAREN_TOP  */
    "H\\XGRGRb",
    "H\\RbRD",
    "H\\X_R_RD",
    "H\\LGRGRb",
    "H\\RbRD",
    "H\\L_R_RD",
    "H\\XDTHSJRNRb",
    "H\\RDRIQMPOLSPWQYR]Rb",
    "H\\XbT^S\\RXRD",
    "H\\RbRD",
    "H\\LDPHQJRNRb",
    "H\\RDRISMTOXSTWSYR]Rb",
    "H\\LbP^Q\\RXRD",
    "H\\RbRD",
    "H\\HS\\S",
    "H\\WDSHRKR[Q^Mb", /* U+23B0 MOUSTACHE  */
    "H\\MDQHRKR[S^Wb",
    "E_VbIF\\F",
    "E_VDI`\\`",
    ">fC^CYaYa^",
    ">fCHCMaMaH",
    ">fC^CYaYa^ RaHaMCMCH",
    "IbMTQSS[bB",
    "H\\RbRD",
    "H\\RbRD",
    "H\\HG\\G",
    "H\\HM\\M",
    "H\\\\YHY",
    "H\\\\_H_",
    "E_UFOFO[",
    "E_U[O[OF",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RRbRD", /* U+23C0 CIRCLE LINE_V */
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RZEJE RRERa",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RJaZa RRaRE",
    "E_RK[[I[RK RRbRD",
    "E_RK[[I[RK RZEJE RRERa",
    "E_RK[[I[RK RJaZa RRaRE",
    "E_JSKRNQQRSTVUYTZS RRbRD",
    "E_JSKRNQQRSTVUYTZS RZEJE RRERa",
    "E_JSKRNQQRSTVUYTZS RJaZa RRaRE",
    "E_JaZa RRaRE",
    "E_ZEJE RRERa",
    "E_OFUFU[",
    "E_O[U[UF",
    "D`TFQL RMKJKJ[Z[ZKWK",
    "E_IWN\\NZZZZKTKTTNTNRIW",
    "E_Z[J[ RJVRKZV",
    "H\\RbRD", /* U+23D0 LINE_V  */
    "H\\NQNROTQUSUUTVRVQ",
    "H\\NQNROTQUSUUTVRVQ RMKWK",
    "H\\NQNROTQUSUUTVRVQ RW[M[",
    "CaGQGRHTJULUNTOROQ RUQURVTXUZU\\T]R]Q RGK]K",
    "CaGQGRHTJULUNTOROQ RUQURVTXUZU\\T]R]Q R][G[",
    "E_JQJRKTMUOUQTRRRQ RRRSTUUWUYTZRZQ",
    "E_JUZUZP",
    "E_JPJUZUZP",
    "E_RPRU RJPJUZUZP",
    "E_HO\\O RLUXU RRFRO RT[P[",
    "E_HS\\S RJMZMZYJYJM",
    ">fB]C\\FZHYKXPWTWYX\\Y^Za\\b]",
    ">fbIaJ^L\\MYNTOPOKNHMFLCJBI",
    ">fB^B]C[EZOZQYRWSYUZ_Za[b]b^",
    ">fbHbIaK_LULSMROQMOLELCKBIBH",
    ">fB^FY^Yb^", /* U+23E0 TOR_BRACKET_OVER  */
    ">fbH^MFMBH",
    "E_I[NKVK[[I[",
    "AcRE^L^ZRaFZFLRE RQLSLVMXOYRYTXWVYSZQZNYLWKTKRLONMQL",
    "E_JSZS",
    "E_HXMN\\NWXHX",
    "E_JSZS RJSKNLLNKPLQNSXTZV[XZYXZS",
    "E_LMXY RXMLY RPQRPTQUSTURVPUOSPQ",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+23F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Control Pictures (2400-243F) */
    "F^K[KFYFY[K[", /* U+2400 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2410 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2420 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2430 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Optical Character Recognition (2440-245F) */
    "F^K[KFYFY[K[", /* U+2440 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2450 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Enclosed Alphanumerics (2460-24FF) */
    "F^K[KFYFY[K[", /* U+2460 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2470 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2480 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2490 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+24A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+24B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+24C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+24D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+24E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+24F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Box Drawing (2500-257F) */
    "F^K[KFYFY[K[", /* U+2500 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2510 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2520 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2530 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2540 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2550 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2560 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2570 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Block Elements (2580-259F) */
    "F^K[KFYFY[K[", /* U+2580 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2590 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Geometric Shapes (25A0-25FF) */
    "E_KKK[ RL[LK RMKM[ RN[NK ROKO[ RP[PK RQKQ[ RR[RK RSKS[ RT[TK RUKU[ RV[VK RWKW[ RX[XK RYKY[ RJKZKZ[J[JK", /* U+25A0 SQUARE_BLACK  */
    "E_JKZKZ[J[JK",
    "E_KLMKWKYLZNZXYZW[M[KZJXJNKL",
    "E_JKZKZ[J[JK RPPPV RQVQP RRPRV RSVSP RTPTV ROVOPUPUVOV",
    "E_JWZW RJSZS RJOZO RJKZKZ[J[JK",
    "E_NKN[ RRKR[ RVKV[ RJKZKZ[J[JK",
    "E_JWZW RJSZS RJOZO RNKN[ RRKR[ RVKV[ RJKZKZ[J[JK",
    "E_JKZ[ RN[JW RT[JQ RZUPK RZOVK RJKZKZ[J[JK",
    "E_J[ZK RJUTK RJONK RP[ZQ RV[ZW RJKZKZ[J[JK",
    "E_J[ZK RJUTK RJONK RJKZ[ RN[JW RP[ZQ RT[JQ RV[ZW RZUPK RZOVK RJKZKZ[J[JK",
    "E_PPPV RQVQP RRPRV RSVSP RTPTV ROVOPUPUVOV",
    "E_OVOPUPUVOV",
    "E_JXTN RJWSN RJVRN RJUQN RJTPN RJSON RJRNN RJQMN RJPLN RJOKN RKXUN RLXVN RMXWN RNXXN ROXYN RPXZN RQXZO RRXZP RSXZQ RTXZR RUXZS RVXZT RWXZU RXXZV RYXZW RJNZNZXJXJN",
    "E_JNZNZXJXJN",
    "E_M[WQ RMZWP RMYWO RMXWN RMWWM RMVWL RMUWK RMTVK RMSUK RMRTK RMQSK RMPRK RMOQK RMNPK RMMOK RMLNK RN[WR RO[WS RP[WT RQ[WU RR[WV RS[WW RT[WX RU[WY RV[WZ RM[MKWKW[M[",
    "E_M[MKWKW[M[",
    "E_NNLP RONKR RPNJT RQNIV RRNHX RSNIX RTNJX RUNKX RVNLX RWNMX RXVVX RXNNX RYTUX RYNOX RZRTX RZNPX R[PSX R[NQX R\\NRX RHXMN\\NWXHX", /* U+25B0 PARALLELOGRAM_BLACK  */
    "E_HXMN\\NWXHX",
    "E_JZJ[ RKXK[ RLVL[ RMTM[ RNSN[ ROQO[ RPOP[ RQMQ[ RRKR[ RSMS[ RTOT[ RUQU[ RVSV[ RWTW[ RXVX[ RYXY[ RZ[RLJ[ RZZZ[ RRK[[I[RK",
    "E_RK[[I[RK",
    "E_OUOV RPSPV RQQQV RRORV RSQSV RTSTV RUUUV ROVRPUV RROVVNVRO",
    "E_ROVVNVRO",
    "E_KKK[ RLLLZ RMLMZ RNMNY ROMOY RPNPX RQNQX RRORW RSPSV RTPTV RUQUU RVQVU RWSXS RWRWT RJKYSJ[ RZSJ\\JJZS",
    "E_ZSJ\\JJZS",
    "E_PPPV RQQQU RRQRU RSSUS RSRST ROPUSOV RVSOWOOVS",
    "E_VSOWOOVS",
    "E_KNKX RLNLX RMOMW RNONW ROOOW RPPPV RQPQV RRPRV RSQSU RTQTU RURUT RVRVT RWRWT RXSWS RJNYSJX RZSJYJMZS",
    "E_ZSJYJMZS",
    "E_ZLZK RYNYK RXPXK RWRWK RVSVK RUUUK RTWTK RSYSK RR[RK RQYQK RPWPK ROUOK RNSNK RMRMK RLPLK RKNKK RJKRZZK RJLJK RR[IK[KR[",
    "E_R[IK[KR[",
    "E_UQUP RTSTP RSUSP RRWRP RQUQP RPSPP ROQOP RUPRVOP RRWNPVPRW",
    "E_RWNPVPRW",
    "E_Y[YK RXZXL RWZWL RVYVM RUYUM RTXTN RSXSN RRWRO RQVQP RPVPP ROUOQ RNUNQ RMSLS RMTMR RZ[KSZK RJSZJZ\\JS", /* U+25C0 *TRIANGLE_E_BLACK  */
    "E_JSZJZ\\JS",
    "E_TVTP RSUSQ RRURQ RQSOS RQTQR RUVOSUP RNSUOUWNS",
    "E_NSUOUWNS",
    "E_YXYN RXXXN RWWWO RVWVO RUWUO RTVTP RSVSP RRVRP RQUQQ RPUPQ ROTOR RNTNR RMTMR RLSMS RZXKSZN RJSZMZYJS",
    "E_JSZMZYJS",
    "E_JRJT RKUKQ RLPLV RMWMO RNNNX ROYOM RPLPZ RQ[QK RRJR\\ RS[SK RTLTZ RUYUM RVNVX RWWWO RXPXV RYUYQ RZRZT RRJ[SR\\ISRJ",
    "E_RJ[SR\\ISRJ",
    "E_RJ[SR\\ISRJ RPRPT RQUQQ RRPRV RSUSQ RTRTT RRPUSRVOSRP",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RPQPU RQUQQ RRPRV RSUSQ RTQTU RPTRVTT RPRRPTR RPQRPTQUSTURVPUOSPQ",
    "E_RaJSRFZSRa",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK",
    "E_JQKO RKWJU RNLPK RP[NZ RTKVL RVZT[ RYOZQ RZUYW",
    "E_NLNZ RRKR[ RVLVZ RPKTKXMZQZUXYT[P[LYJUJQLMPK",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RPQRPTQUSTURVPUOSPQ",
    "E_KOKW RLXP[ RLNPK RLMLY RMYMM RNLNZ ROZOL RPKP[ RQ[QK RRKR[ RS[SK RT[XX RTKT[ RTKXN RUZUL RVLVZ RWYWM RXMXY RYWYO RPKTKXMZQZUXYT[P[LYJUJQLMPK",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RKOKW RLYLM RMMMY RNZNL ROLOZ RP[LX RP[PK RLN RQKQ[ RR[P[LYJUJQLMPKRKR[", /* U+25D0 CIRCLE CIRCLE_LEFTHALF_BLACK */
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RYWYO RXMXY RWYWM RVLVZ RUZUL RTKXN RTKT[ RXX RS[SK RRKTKXMZQZUXYT[R[RK",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RKOKS RLMLS RMSMM RNLNS ROSOL RPKLN RPKPS RQKQS RRKRS RSKSS RTSTK RXN RULUS RVSVL RWMWS RXMXS RYOYS RJSJQLMPKTKXMZQZSJS",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RYWYS RXYXS RWSWY RVZVS RUSUZ RT[XX RT[TS RS[SS RR[RS RQ[QS RPSP[ RLX ROZOS RNSNZ RMYMS RLYLS RKWKS RZSZUXYT[P[LYJUJSZS",
    "E_SSSK RTKTS RTKXN RUSUL RVLVS RWSWM RXMXS RYSYO RZSRSRK RPKTKXMZQZUXYT[P[LYJUJQLMPK",
    "E_QSQ[ RP[PS RP[LX ROSOZ RNZNS RMSMY RLYLS RKSKW RJSRSR[ RT[P[LYJUJQLMPKTKXMZQZUXYT[ RYWYO RXMXY RWYWM RVLVZ RUZUL RTKXN RTKT[ RXX RS[SK RRKTKXMZQZUXYT[R[RK",
    "E_KOKW RLYLM RMMMY RNZNL ROLOZ RP[LX RP[PK RLN RQKQ[ RR[P[LYJUJQLMPKRKR[",
    "E_YWYO RXMXY RWYWM RVLVZ RUZUL RTKXN RTKT[ RXX RS[SK RRKTKXMZQZUXYT[R[RK",
    "E_FDFb RGbGD RHDHb RIbID RJDJb RKbKD RLbLW RLDLO RMXMb RMNMD RNbNY RNDNM ROZOb ROLOD RPbPZ RPDPL RQZQb RQLQD RRbRZ RRDRL RSZSb RSLSD RTbTZ RTDTL RUZUb RULUD RVbVY RVDVM RWXWb RWNWD RXbXW RXDXO RYbYD RZDZb R[b[D R\\D\\b R]b]D R^D^b R_bEbED_D_b RKTKRLONMQLSLVMXOYRYTXWVYSZQZNYLWKT",
    "E_FRFD RGNIJ RGDGN RHLHD RIDIK RJJJD RJJMG RKDKI RLHLD RMHQF RMDMH RNGND ROPOS RODOG RPSPP RPGPD RQPQS RQDQG RRSRO RRGRD RSPSS RSFWH RSDSG RTSTP RTGTD RUPUS RUDUG RVGVD RWGZJ RWDWH RXHXD RYDYI RZJZD R[J]N R[D[K R\\L\\D R]D]N R^R^D ROQROUQ RNSOPROUPVSNS RFSFRGNIKJJMHQGSGWHZJ[K]N^R^S_S_DEDESFS R^T^b R]X[\\ R]b]X R\\Z\\b R[b[[ RZ\\Zb RZ\\W_ RYbY] RX^Xb RW^S` RWbW^ RV_Vb RUVUS RUbU_ RTSTV RT_Tb RSVSS RSbS_ RRSRW RR_Rb RQVQS RQ`M^ RQbQ_ RPSPV RP_Pb ROVOS RObO_ RN_Nb RM_J\\ RMbM^ RL^Lb RKbK] RJ\\Jb RI\\GX RIbI[ RHZHb RGbGX RFTFb RUURWOU RVSUVRWOVNSVS R^S^T]X[[Z\\W^S_Q_M^J\\I[GXFTFSESEb_b_S^S",
    "E_FRFD RGNIJ RGDGN RHLHD RIDIK RJJJD RJJMG RKDKI RLHLD RMHQF RMDMH RNGND ROPOS RODOG RPSPP RPGPD RQPQS RQDQG RRSRO RRGRD RSPSS RSFWH RSDSG RTSTP RTGTD RUPUS RUDUG RVGVD RWGZJ RWDWH RXHXD RYDYI RZJZD R[J]N R[D[K R\\L\\D R]D]N R^R^D ROQROUQ RNSOPROUPVSNS RFSFRGNIKJJMHQGSGWHZJ[K]N^R^S_S_DEDESFS",
    "E_^T^b R]X[\\ R]b]X R\\Z\\b R[b[[ RZ\\Zb RZ\\W_ RYbY] RX^Xb RW^S` RWbW^ RV_Vb RUVUS RUbU_ RTSTV RT_Tb RSVSS RSbS_ RRSRW RR_Rb RQVQS RQ`M^ RQbQ_ RPSPV RP_Pb ROVOS RObO_ RN_Nb RM_J\\ RMbM^ RL^Lb RKbK] RJ\\Jb RI\\GX RIbI[ RHZHb RGbGX RFTFb RUURWOU RVSUVRWOVNSVS R^S^T]X[[Z\\W^S_Q_M^J\\I[GXFTFSESEb_b_S^S",
    "E_JSJQLMPKRK",
    "E_ZSZQXMTKRK",
    "E_ZSZUXYT[R[",
    "E_JSJULYP[R[",
    "E_JSJQLMPKTKXMZQZS", /* U+25E0 CIRCLE_TOPHALF  */
    "E_ZSZUXYT[P[LYJUJS",
    "E_KZK[ RLYL[ RMXM[ RNWN[ ROVO[ RPUP[ RQTQ[ RRSR[ RSRS[ RTQT[ RUPU[ RVOV[ RWNW[ RXMX[ RYLY[ RZ[ZKJ[Z[",
    "E_YZY[ RXYX[ RWXW[ RVWV[ RUVU[ RTUT[ RSTS[ RRSR[ RQRQ[ RPQP[ ROPO[ RNON[ RMNM[ RLML[ RKLK[ RJ[JKZ[J[",
    "E_YLYK RXMXK RWNWK RVOVK RUPUK RTQTK RSRSK RRSRK RQTQK RPUPK ROVOK RNWNK RMXMK RLYLK RKZKK RJKJ[ZKJK",
    "E_KLKK RLMLK RMNMK RNONK ROPOK RPQPK RQRQK RRSRK RSTSK RTUTK RUVUK RVWVK RWXWK RXYXK RYZYK RZKZ[JKZK",
    "E_PQRPTQUSTURVPUOSPQ",
    "E_JKZKZ[J[JK RK[KK RLKL[ RM[MK RNKN[ RO[OK RPKP[ RQ[QK RJ[JKRKR[J[",
    "E_JKZKZ[J[JK RYKY[ RX[XK RWKW[ RV[VK RUKU[ RT[TK RSKS[ RZKZ[R[RKZK",
    "E_JKZKZ[J[JK RYLYK RXMXK RWNWK RVOVK RUPUK RTQTK RSRSK RRSRK RQTQK RPUPK ROVOK RNWNK RMXMK RLYLK RKZKK RJKJ[ZKJK",
    "E_JKZKZ[J[JK RKZK[ RLYL[ RMXM[ RNWN[ ROVO[ RPUP[ RQTQ[ RRSR[ RSRS[ RTQT[ RUPU[ RVOV[ RWNW[ RXMX[ RYLY[ RZ[ZKJ[Z[",
    "E_JKZKZ[J[JK RR[RK",
    "E_RK[[I[RK RRUQVRWSVRURW",
    "E_J[RL RJZJ[ RKXK[ RLVL[ RMTM[ RNSN[ ROQO[ RPOP[ RQMQ[ RRKR[ RRK[[I[RK",
    "E_Z[RL RZZZ[ RYXY[ RXVX[ RWTW[ RVSV[ RUQU[ RTOT[ RSMS[ RRKR[ RRKI[[[RK",
    "C`OFTFXHZJ\\N\\SZWXYT[O[KYIWGSGNIJKHOF",
    "E_JKZKZ[J[JK RRKRSJS", /* U+25F0 SQUARE !QUADRANT */
    "E_JKZKZ[J[JK RR[RSJS",
    "E_JKZKZ[J[JK RR[RSZS",
    "E_JKZKZ[J[JK RRKRSZS",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RRKRSJS",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RR[RSJS",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RR[RSZS",
    "E_PKTKXMZQZUXYT[P[LYJUJQLMPK RRKRSZS",
    "E_JKJ[ZKJK",
    "E_ZKZ[JKZK",
    "E_J[JKZ[J[",
    "E_JKZKZ[J[JK",
    "E_KKK[ RL[LK RMKM[ RN[NK ROKO[ RP[PK RQKQ[ RR[RK RSKS[ RT[TK RUKU[ RV[VK RWKW[ RX[XK RYKY[ RJKZKZ[J[JK",
    "E_OVOPUPUVOV",
    "E_PPPV RQVQP RRPRV RSVSP RTPTV ROVOPUPUVOV",
    "E_Z[ZKJ[Z[",
    /* // Miscellaneous Symbols (2600-26FF) */
    "F^K[KFYFY[K[", /* U+2600 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2610 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2620 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2630 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2640 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2650 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2660 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2670 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2680 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2690 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+26A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+26B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+26C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+26D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+26E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+26F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Dingbats (2700-27BF) */
    "F^K[KFYFY[K[", /* U+2700 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2710 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2720 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2730 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2740 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2750 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2760 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2770 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2780 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2790 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+27A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+27B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Miscellaneous Mathematical Symbols A (27C0-27EF) */
    "F^K[KFYFY[K[", /* U+27C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+27D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+27E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Supplemental Arrows A (27F0-27FF) */
    "F^K[KFYFY[K[", /* U+27F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Braille Patterns (2800-28FF) */
    "F^K[KFYFY[K[", /* U+2800 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2810 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2820 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2830 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2840 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2850 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2860 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2870 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2880 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2890 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+28A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+28B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+28C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+28D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+28E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+28F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Supplemental Arrows B (2900-297F) */
    "F^K[KFYFY[K[", /* U+2900 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2910 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2920 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2930 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2940 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2950 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2960 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2970 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Miscellaneous Mathematical Symbols B (2980-29FF) */
    "F^K[KFYFY[K[", /* U+2980 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2990 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+29A0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+29B0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+29C0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+29D0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+29E0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+29F0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Supplemental Mathematical Operators (2A00-2AFF) */
    "F^K[KFYFY[K[", /* U+2A00 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2A10 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2A20 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2A30 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2A40 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2A50 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2A60 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2A70 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2A80 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2A90 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2AA0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2AB0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2AC0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2AD0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2AE0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2AF0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    /* // Miscellaneous Symbols and Arrows (2B00-2BFF) */
    "F^K[KFYFY[K[", /* U+2B00 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2B10 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2B20 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2B30 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2B40 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2B50 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2B60 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2B70 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2B80 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2B90 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2BA0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2BB0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2BC0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2BD0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2BE0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[", /* U+2BF0 */
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
    "F^K[KFYFY[K[",
};

const int newstroke_font_bufsize = sizeof(newstroke_font)/sizeof(newstroke_font[0]);

/* --- unused glyphs --- */
/*  RECTANGLE_V_BLACK_SMALL  */
/*  TRIANGLE_TALL_BLACK  */
/*  COMBINING  */
/*  DIAMOND_SMALL  */
