/*
  Copyright Mission Critical Linux, 2000

  Kimberlite is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  Kimberlite is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Kimberlite; see the file COPYING.  If not, write to the
  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
  MA 02139, USA.
*/

/*
 *
 * Author: Brian Stevens <stevens@missioncriticallinux.com>
 * description: library for retrieving communication status
 * 	and config information
 */

static const char *version __attribute__ ((unused)) = "$Revision: 1.5 $";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/param.h>
#include <errno.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <parseconf.h>
#include <clusterdefs.h>
#include <clucfg.h>
#include <clucfg_if.h>

int
if_lookup(
    char			*ip_name,
    struct ifreq *		req)
{
    int				sockfd, len, lastlen;
    char			*cptr;
    struct ifconf		ifc;
    struct ifreq		*ifr;
    struct hostent		*hp;
    int				i;

    sockfd = socket(AF_INET, SOCK_DGRAM, 0);
    if (sockfd < 0)
	return(1);

    lastlen = 0;
    len = 100 * sizeof(struct ifreq);
    for (;;) {
	ifr = (struct ifreq *) malloc(len);
	ifc.ifc_len = len;
	ifc.ifc_buf = (char *) ifr;
	if (ioctl(sockfd, SIOCGIFCONF, &ifc) < 0) {
	    if (errno != EINVAL || lastlen != 0) {
		free(ifr);
		close(sockfd);
		return(1);
	    }
 	} else {
	    if (ifc.ifc_len == lastlen)
		break;		/* success, len has not changed */
	    lastlen = ifc.ifc_len;
	}
	len += 10 * sizeof(struct ifreq);
	free(ifr);
    }
    close(sockfd);

    /*
     * Get the address for the ip name we are looking up
     */

    if ((hp = gethostbyname(ip_name)) == NULL)
	return(1);

    len = (int) ifc.ifc_len / sizeof(struct ifreq);
    for (i = 0; i < len; i++) {

	if (ifr[i].ifr_addr.sa_family != AF_INET)
	    continue;

	/*
	 * Deal with aliases
	 */

	if ((cptr = strchr(ifr[i].ifr_name, ':')) != NULL)
	    *cptr = 0;

	if (memcmp(&((struct sockaddr_in *)&ifr[i].ifr_addr)->sin_addr,
		   hp->h_addr, sizeof(struct in_addr)))
	    continue;

	memcpy(req, &ifr[i], sizeof(struct ifreq));
        free(ifr);
	return(0);
    }

    free(ifr);
    return(1);
}
