

#  Copyright Mission Critical Linux, 2000

#  Kimberlite is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by the
#  Free Software Foundation; either version 2, or (at your option) any
#  later version.

#  Kimberlite is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with Kimberlite; see the file COPYING.  If not, write to the
#  Free Software Foundation, Inc.,  675 Mass Ave, Cambridge, 
#  MA 02139, USA.
#
# $Revision: 1.11 $
#
# Author: Gregory P. Myrdal <Myrdal@MissionCriticalLinux.Com>
#
#------------------------------------------------------------

#
# KornShell global variables
#

DEBUG=yes

CLUSTER_DIR=/opt/cluster

#
# Cluster utilities
#
typeset CLUSTER_BIN=$CLUSTER_DIR/bin
typeset CLULOG=$CLUSTER_BIN/clulog
typeset GETCONFIG=$CLUSTER_BIN/getconfig
typeset GRATUITOUSARP=$CLUSTER_BIN/gratuitousarp
typeset INVALIDATEBUFFERS=$CLUSTER_BIN/invalidatebuffers
typeset MOUNT_SCRIPT=$CLUSTER_DIR/ksh_bin/mount.ksh
typeset -r \
	CLUSTER_BIN \
	CLULOG GETCONFIG \
	GRATUITOUSARP \
	INVALIDATEBUFFERS \
	MOUNT_SCRIPT

#
# Cluster configuration database information
#
typeset DB=/etc/opt/cluster/cluster.conf	# cluster database
typeset SEP=%					# config file char separator
typeset -r DB SEP

#
# Directories
#

#
# Return status 
#
# Note: these should stay the same as svcmgr.h
#
typeset SUCCESS=0
typeset FAIL=1
typeset YES=2
typeset NO=3  
typeset TIMEOUT=4
typeset NOT_FOUND=5
typeset -r \
	SUCCESS \
	FAIL \
	YES \
	NO \
	TIMEOUT \
	NOT_FOUND

#
# Service owners
#
# Note: these should stay the same as svcmgr.h
#
typeset SVC_OWNER_NOBODY=-1
typeset -r SVC_OWNER_NOBODY

#
# Values for the service database entries
#
# Note: these should stay the same as svcmgr.h
#
typeset YES_STR="yes"
typeset NO_STR="no"
typeset -r YES_STR NO_STR

#
# Service Manager database entry strings
#
# Note: these should stay the same as svcmgr.h
#
typeset SVCMGR_STR="svcmgr"
typeset SVCMGR_LOGLEVEL_STR="logLevel"
typeset SVCMGR_SVC_STOP_FAIL_STR="svcStopFailureAction"		# not used
typeset SVCMGR_EXIT_FAIL_STR="exitFailureAction"		# not used
typeset -r \
	SVCMGR_STR \
	SVCMGR_LOGLEVEL_STR \
	SVCMGR_SVC_STOP_FAIL_STR \
	SVCMGR_EXIT_FAIL_STR

#
# Service database entry strings.  These are the strings that are entered
# in the service database to describe the service.  Some of these entries
# are labels where the real values are in sub-sections.  Refer to the
# service database description file for more information.
#
# Note: these should stay the same as svcmgr.h
#
typeset SVC_SERVICES_LIST_STR="services"
typeset SVC_SERVICE_STR="service"
typeset SVC_NAME_STR="name"
typeset SVC_DISABLED_STR="disabled"
typeset SVC_PREFERRED_NODE_STR="preferredNode"
typeset SVC_RELOCATE_ON_BOOT_STR="relocateOnPreferredNodeBoot"
typeset SVC_USER_SCRIPT_STR="userScript"
typeset SVC_NETWORK_STR="network"
typeset SVC_IP_ADDR_STR="ipAddress"
typeset SVC_NETMASK_STR="netmask"
typeset SVC_BROADCAST_STR="broadcast"
typeset SVC_DEVICE_STR="device"
typeset SVC_DEVICE_NAME_STR="name"
typeset SVC_MOUNT_STR="mount"
typeset SVC_MOUNT_NAME_STR="name"
typeset SVC_MOUNT_FSTYPE_STR="fstype"
typeset SVC_MOUNT_OPTIONS_STR="options"
typeset SVC_FORCE_UNMOUNT_STR="forceUnmount"
typeset SVC_NFS_STR="NFS"
typeset SVC_NFS_SVR_DIR_STR="serverDir"
typeset SVC_NFS_SVR_DEV_STR="serverDev"
typeset SVC_EXPORT_STR="NFSexports"
typeset SVC_EXPORT_DIR_STR="directory"
typeset SVC_EXPORT_NAME_STR="name"
typeset SVC_EXPORT_CLIENT_STR="client"
typeset SVC_EXPORT_CLIENT_NAME_STR="name"
typeset SVC_EXPORT_CLIENT_OPTIONS_STR="options"
typeset SVC_DEVICE_OWNER_STR="owner"
typeset SVC_DEVICE_GROUP_STR="group"
typeset SVC_DEVICE_MODE_STR="mode"       

typeset -r \
	SVC_SERVICES_LIST_STR \
	SVC_SERVICE_STR SVC_NAME_STR \
	SVC_DISABLED_STR \
	SVC_PREFERRED_NODE_STR \
	SVC_RELOCATE_ON_BOOT_STR \
	SVC_USER_SCRIPT_STR \
	SVC_NETWORK_STR \
	SVC_IP_ADDR_STR \
	SVC_NETMASK_STR \
	SVC_BROADCAST_STR \
	SVC_DEVICE_STR \
	SVC_DEVICE_NAME_STR \
	SVC_MOUNT_STR \
	SVC_MOUNT_NAME_STR \
	SVC_MOUNT_FSTYPE_STR \
	SVC_MOUNT_OPTIONS_STR \
	SVC_FORCE_UNMOUNT_STR \
	SVC_NFS_STR \
	SVC_NFS_SVR_DIR_STR \
	SVC_EXPORT_STR \
	SVC_EXPORT_DIR_STR \
	SVC_EXPORT_NAME_STR \
	SVC_EXPORT_CLIENT_STR \
	SVC_EXPORT_CLIENT_NAME_STR \
	SVC_EXPORT_CLIENT_OPTIONS_STR \
	SVC_DEVICE_OWNER_STR \
	SVC_DEVICE_GROUP_STR \
	SVC_DEVICE_MODE_STR

typeset MIN_TOKEN_ID=0		# must be the same as in svcmgr.h
typeset -r MIN_TOKEN_ID

#-----------------------------------------------------------------------------
#
# General global shell functions
#
#-----------------------------------------------------------------------------

#
# Function to find the system V init directory
#
getSystemInitDir ()
{
	typeset dir

	for dir in /etc/rc.d/init.d /etc/init.d /sbin/init.d
	do
	  if [ -d $dir ]; then
            print $dir
	    return $SUCCESS
	  fi
	done

	print -u2 "Cannot find a System V style init directory"
	print ""
	return $FAIL
}
