/******************************************************************************
                                chatwindow.cpp
                             -------------------
    begin                : Wednesdat May 28 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : ben@meyerhome.net
 ******************************************************************************/

#include "chatwindow.h"
#include <kiconloader.h>
#include <qsplitter.h>
#include <kedittoolbar.h>
#include <klocale.h>
#include <kaction.h>
#include <kconfig.h>
#include <qmessagebox.h>

/**
 * Creates the toolbar.  Initializes the toolbar, chat window and menu bar.
 * @param userName the buddy we are chatting with ???
 * @param buddysName the buddy's friendly name
 * @param buddy whether this user is on the buddy list
 * @param parent the parent widget
 * @param name the name of the widget
 */
ChatWindow::ChatWindow(QString userName, QString buddysName, bool buddy, 
		       QWidget *parent, QString alias): 
  Chat(userName,buddysName,parent, alias) {
  
  // Create stuff 
  this->initChatWindow();

  (void)new KAction(i18n("&Save Size"), 0, this, SLOT(saveSize()), actionCollection(), "view_saveSize" );
  (void)new KAction(i18n("&Buddy Info"), 0, this, SLOT(slotBuddyInfo()), actionCollection(), "contact_info");
  (void)new KAction(i18n("&Warn Buddy..."), 0, this, SLOT(slotBuddyWarn()), actionCollection(), "contact_warn");
  addRemove = new KAction(i18n("&Remove Buddy..."), 0, this, SLOT(slotBuddyAddRemove()), actionCollection(), "contact_remove");
  (void)new KAction(i18n("&Block Buddy..."), 0, this, SLOT(slotBuddyBlock()), actionCollection(), "contact_block" );
  (void)new KAction(i18n("&Pounce Buddy..."), 0, this, SLOT(slotBuddyPounce()), actionCollection(), "contact_pounce" );
  
  createGUI("aimchatwindowrc");
  updateChatSettings();

  isBuddy = buddy;
  if(isBuddy == true){
    addRemove->setIcon( "edittrash" );
    addRemove->setText( "Remove Buddy" );
  }
  else{
    addRemove->setIcon( "kinkatta_buddy_add" );
    addRemove->setText( "Add Buddy" );
  }
  this->setMinimumSize(250,250);

  // Set up the default size of the window.
  KConfig &config = *KGlobal::config();
  config.setGroup("Aim Chat Window Size");
  int x = config.readNumEntry("width", 350);
  int y = config.readNumEntry("height", 330);
  int s = config.readNumEntry("splitter", 40);
  this->resize(x,y);
  QValueList<int> list;
  list = splitter->sizes();
  list[1] = s;
  splitter->setSizes(list);
}

/**
 * Allow for the toolbars to be minipulated.
 */
void ChatWindow::options_configuretoolbars(){
  KEditToolbar dlg(actionCollection(), "aimchatwindowrc");
  if(dlg.exec())
    createGUI("aimchatwindowrc");
}

/**
 * Saves the width, height and splitter location of the chat window.
 * emit saveNewSize signal.
 */
void ChatWindow::saveSize(){
  QValueList<int> list;
  list = splitter->sizes();
  int s1 = list[1];

  KConfig &config = *KGlobal::config();
  config.setGroup("Aim Chat Window Size");
  config.writeEntry("width", this->width());
  config.writeEntry("height", this->height());
  config.writeEntry("splitter", s1);
  QMessageBox::information(0, QString("Kinkatta - Message"), QString("Your sizes have been saved."));
}

/**
 * Emits a pounce for the buddy the user is chatting with in this window.
 */
void ChatWindow::slotBuddyPounce(){
  emit (pounce(contactName));
}

/**
 * Creates a splitter and initializes the Chat window.
 */
void ChatWindow::initChatWindow() {
  splitter = new QSplitter(this, "Splitter" );
  Chat::initChatWindow();
}

/**
 * Emit the getInfo signal
 */
void ChatWindow::slotBuddyInfo(){
  emit( getInfo( contactName ) );
}

/**
 * Insures the specified buddy is the user for this chat window.  Sets
 * the isBuddy variable appropriately, and then re-initializes the
 * toolbar and menubar.
 * @param name the name of the buddy
 * @param isABuddy the value to set
 */
void ChatWindow::setIfIsBuddy(QString name, bool isABuddy){
  if (name != contactName)
    return;
  isBuddy = isABuddy;

  if(isBuddy == true){
    addRemove->setIcon( "edittrash" );
    addRemove->setText( "Remove Buddy" );
  }
  else{
    addRemove->setIcon( "kinkatta_buddy_add" );
    addRemove->setText( "Add Buddy" );
  }
}

/**
 * Emits a warning for the buddy
 */
void ChatWindow::slotBuddyWarn(){
  emit( warningOut(contactName) );
}

/**
 * Emits a block for the buddy
 */
void ChatWindow::slotBuddyBlock(){
  emit( blockBuddy(contactName) );
}

/**
 * Checks to see if the user is on the buddy list.  If they are, then
 * they are removed, otherwise they are added
 */
void ChatWindow::slotBuddyAddRemove(){
  if (isBuddy == true){
    emit( removeContact(contactName) );
  }
  else{
    emit( addContact(contactName) );
  }
}

/**
 * Updates the buddy's name with buddy
 * @param buddy the new buddy name
 */
void ChatWindow::updateBuddyName(QString buddy){
  contactName = buddy;
}

// chatwindow.cpp

