/***************************************************************************
                           permitdenyoptionsimp.cpp
                             -------------------
    begin                : Tuesday Feb 13 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : ben@meyerhome.net
 ***************************************************************************/


#include "permitdenyoptionsimp.h"
#include <qinputdialog.h>
#include <qradiobutton.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <klocale.h>
#include <kapp.h>

/******************************************************************************
 * Constructor
 ******************************************************************************/
PermitDenyOptionsImp::PermitDenyOptionsImp(QWidget *parent, const char *name, TAim *connection) : PermitDenyOptions( parent,name,false ){
	i_aimSettings = setup::settings();
	i_connection = connection;
  connect(deny_add_permit, SIGNAL(clicked()), this, SLOT(addPermit()));
  connect(deny_delete_permit, SIGNAL(clicked()), this, SLOT(deletePermit()));
  connect(deny_add_deny, SIGNAL(clicked()), this, SLOT(addDeny()));
  connect(deny_delete_deny, SIGNAL(clicked()), this, SLOT(deleteDeny()));
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
PermitDenyOptionsImp::~PermitDenyOptionsImp(){
}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void PermitDenyOptionsImp::updateData(){
	i_aimSettings = setup::settings();

	permitChanged = 0;
  denyChanged = 0;
	
	if(i_aimSettings->login_name.isEmpty()){
		this->setEnabled(FALSE);

    access_anyone->setChecked(TRUE);
    deny_list_permit->clear();
    deny_list_deny->clear();
		AccessButtonGroup->setTitle( tr( "Accessibility Options" ) );
		user = "";

		return;
	} else {
		user = i_aimSettings->login_name;
		QString r = "Accessibility Options for " + user;
		AccessButtonGroup->setTitle( i18n( r.latin1() ));
		this->setEnabled(TRUE);
	}
		
  permissions = 0;
  buddyList.reset();
  permitList.reset();
  denyList.reset();


	if(i_connection->getStatus() == TAIM_OFFLINE){
		//if this is called while user is offline, it means the Options button in
		//the login window was pressed.  get the information from the users
		//buddyList instead of "connection"
		setup::instance()->parseBuddyList(i_aimSettings->login_name, &buddyList,
																		&permitList, &denyList, &permissions);
	} else {
		//user is online, get the information from "connection" (which,
		//technically, should be the same)
		permitList = i_connection->permitList();
		denyList = i_connection->denyList();
		permissions = i_connection->permissions();
	}

  if(permissions == 1)
    access_anyone->setChecked(true);
  if(permissions == 3)
    access_buddy->setChecked(true);
  if(permissions == 4)
    access_ask->setChecked(true);	
  deny_list_permit->clear();
  deny_list_deny->clear();
  QString userName = "";
  for(int i = 0; i < permitList.getCount(); i++) {
    userName = permitList.getName(i);
    deny_list_permit->insertStringList(userName);
  }
  for(int i = 0; i < denyList.getCount(); i++) {
    userName = denyList.getName(i);
    deny_list_deny->insertStringList(userName);
  }
}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void PermitDenyOptionsImp::getData(){
	permitList.reset();
  denyList.reset();
  QString userName = "";

	if(i_aimSettings->login_name.isEmpty()){
		return;
	}
		
  for (int i=0; i < deny_list_permit->numRows(); i++){
    userName = deny_list_permit->text(i);
    if (!!userName){
      TBuddy bud;
      bud.name = userName;
      permitList.add(&bud);
    }  
  }
  for (int i=0; i < deny_list_deny->numRows(); i++){
    userName = deny_list_deny->text(i);
    if (!!userName){
      TBuddy bud;
      bud.name = userName;
      denyList.add(&bud);
    }
  }

	if( i_connection->getStatus() == TAIM_OFFLINE ){
	  if(access_anyone->isChecked()){
	    permissions = 1;
	  }  
	  if(access_buddy->isChecked()){
	    permissions = 3;
	  }
	  if(access_ask->isChecked()){
	    permissions = 4;
	  }
		setup::instance()->saveBuddyList(user, &buddyList, &permitList, &denyList, permissions);
		
	} else { //online
	  if (permitChanged == 1)
	    i_connection->setPermitList(permitList);
	  if (denyChanged == 1)
	    i_connection->setDenyList(denyList);
	
	  if(access_anyone->isChecked()){
	    if(i_connection->permissions() != 1)
	      i_connection->setPermissions(1);
	  }  
	  if(access_buddy->isChecked()){
	    if(i_connection->permissions() != 3)
	      i_connection->setPermissions(3);
	  }
	  if(access_ask->isChecked()){
	    if(i_connection->permissions() != 4)
	      i_connection->setPermissions(4);
	  }
	}
}

void PermitDenyOptionsImp::addPermit(){
  bool ok = FALSE;
  QString user;
  #if QT_VERSION < 300
  user = QInputDialog::getText( i18n( "Enter Buddy's Name" ), i18n( "Please enter a buddy's name" ), QString::null, &ok, this );
  #else
  user = QInputDialog::getText( i18n( "Enter Buddy's Name" ), i18n( "Please enter a buddy's name" ), QLineEdit::Normal, QString::null, &ok, this );
  #endif
  if ( ok && !user.isEmpty() ){
    deny_list_permit->insertStringList(user); 
  }
  permitChanged = 1;
}

void PermitDenyOptionsImp::deletePermit(){
  if (deny_list_permit->currentItem()!=-1)
    deny_list_permit->removeItem(deny_list_permit->currentItem());
  permitChanged = 1;
}

void PermitDenyOptionsImp::addDeny(){
  bool ok = FALSE;
  QString user;
  #if QT_VERSION < 300
  user = QInputDialog::getText( i18n( "Enter Buddy's Name" ), i18n( "Please enter a buddy's name" ), QString::null, &ok, this );
  #else
  user = QInputDialog::getText( i18n( "Enter Buddy's Name" ), i18n( "Please enter a buddy's name" ), QLineEdit::Normal, QString::null, &ok, this );
  #endif
  if ( ok && !user.isEmpty() ){
    deny_list_deny->insertStringList(user); 
  }
  denyChanged = 1;
}

void PermitDenyOptionsImp::deleteDeny(){
  if (deny_list_deny->currentItem()!=-1)
    deny_list_deny->removeItem(deny_list_deny->currentItem());
  denyChanged = 1;
}

// PermitDenyOptionsImp.cpp
