/***************************************************************************
                         kinkattacomboplugin.cpp 
                           -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "kinkattacomboplugin.h"
#include "chat.h"
#include "buddylistwindow.h"
#include <qtoolbar.h>

/**
 * Constructor.  Initializes the plugin info and settings.
 * @param parent the parent widget
 * @param name the name of this widget
 */
KinkattaComboPlugin::KinkattaComboPlugin(QWidget *parent, const char *name) : KinkattaPlugin( parent,name ){
  info.messagePlugin = true;
}

/**
 * Does nothing.
 */
KinkattaComboPlugin::~KinkattaComboPlugin(){
}

/**
 * Connects to the main window to find out when windows are made/destroyed.
 */
void KinkattaComboPlugin::initPlugin(){
  connect(mainWindow, SIGNAL(creatingChatWindow(Chat*)), this, SLOT(chatWindowCreated(Chat*)));
  connect(mainWindow, SIGNAL(distroyingChatWindow(Chat*)), this, SLOT(distroyingChatWindow(Chat*)));
}
 
/**
 * Removes the chat window form our list.
 * @param window chat window to remove.
 */
void KinkattaComboPlugin::destroyingChatWindow( Chat *window ){
  //qDebug("Destroying a chat link");

  int find = windows.find(window);
  if( find != -1){
    windows.remove(find);
    buttons.remove(find);
  }
}

/**
 * Adds a window to our list of open chat windows.
 * @param window chat window to add.
 */
void KinkattaComboPlugin::chatWindowCreated( Chat *window ){
  //qDebug("We have a chat window");
  QToolBar *theToolBar = window->getPluginToolbar();
  theToolBar->show();
  KinkattaComboBox *c = new KinkattaComboBox(theToolBar, (info.Name).latin1());
  c->insertItem("Babel Disabled");
  c->insertItem("English->French");
  c->insertItem("English->German");
  c->insertItem("English->Italian");
  c->insertItem("English->Portuguese");
  c->insertItem("English->Spanish");
  c->insertItem("English->Korean");
  c->insertItem("English->Japanese");
  c->insertItem("English->Chinese");
  c->insertItem("French->English");
  c->insertItem("German->English");
  c->insertItem("German->French");
  c->insertItem("Italian->English"); 
  c->insertItem("Portuguese->English");
  c->insertItem("Spanish->English");
  c->insertItem("Korean->English");
  c->insertItem("Japanese->English");
  c->insertItem("Chinese->English");
  c->insertItem("French->German");
  c->insertItem("German->French");
  buttons.append(c);
  windows.append(window);
}

// kinkattacomboplugin.cpp

