/***************************************************************************
                           kinkattaplugin.cpp 
                           -------------------
    begin                : Tuesday Jan 31 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "kinkattaplugin.h"
#include "taim.h"
#include "buddylistwindow.h"
#include "chat.h"
#include <qtoolbutton.h>
#include <qtoolbar.h>

/**
 * Constructor.  Initialize info and settings. 
 * @param parent the parent widget
 * @param name the name of the widget
 */
KinkattaPlugin::KinkattaPlugin( QWidget *parent, const char *name ) : QObject( parent,name ){
  info.Name = "Unnamed Plugin";
  info.Author = "Unknown Author";
  info.Version = "0.00";
  info.HomePage = "I am all alone, please take me in.";
  info.messagePlugin = false;
  info.loadOnApplicationStart = false;

  physicalLocation = "/dev/null";
}

/**
 * Detailed information
 * @return the info
 */
plugin_info KinkattaPlugin::getInformation(){
  return info;
}

/**
 * Doesn't do anything in the base class.
 */
KinkattaPlugin::~KinkattaPlugin(){
}

/**
 * To be overloaded by other plugins.  They should have their own configure
 * widget that is returned.
 * @return NULL.
 */
QWidget *KinkattaPlugin::configure( QWidget * ){
  //Built in just to not crash the app.
  return NULL;
}	

/**
 * To be overloaded by other plugins.  We don't have a configure widget to get
 * data from and apply so we don't do anything.
 */
void KinkattaPlugin::applyConfigure(){
  return;
}
	
/**
 * To be overloaded by other plugins. Simply passes the message on.
 * @param message the incoming message.
 * @param buddy the buddy that the message is going to.
 * @param isAuto whether the message is automatic or not.
 */
void KinkattaPlugin::inChatMessage( QString message, QString buddy, bool isAuto ){
  emit ( goingInChatMessage( message, buddy, isAuto ) );
}

/**
 * To be overloaded by other plugins. Simply passes the message on.
 * @param message the outgoing message.
 * @param buddy the buddy that the message is going to.
 * @param isAuto whether the message is automatic or not.
 */
void KinkattaPlugin::outChatMessage( QString message, QString buddy, bool isAuto, bool endIdleNess ){
  emit ( goingOutChatMessage( message, buddy, isAuto, endIdleNess ) );
}

/**
 * To be overloaded by other plugins. Simply passes the message on.
 * @param message the incoming message.
 * @param room the room that the message is going to.
 */
void KinkattaPlugin::inChatRoomMessage( int room, QString message ){
  emit ( goingInChatRoomMessage( room, message ) );
}

/**
 * To be overloaded by other plugins. Simply passes the message on.
 * @param message the outgoing message.
 * @param room the room that the message is going to.
 */
void KinkattaPlugin::outChatRoomMessage( int room, QString message ){
  emit ( goingOutChatRoomMessage( room, message ) );
}

/**
 * Set up out pointers.
 * @param pmainWindow pointer to the mainWindow.
 * @param pconnection pointer to the network connection.
 */
void KinkattaPlugin::setPointers(BuddyListWindow *pmainWindow, TAim *pconnection){
  mainWindow = pmainWindow;
  connection = pconnection;
} 

/**
 * Return back the author of this plugin. 
 * @return the author.
 */
QString KinkattaPlugin::getAuthor(){
  return info.Author;
}

/**
 * Return back the version of this plugin. 
 * @return the version.
 */
QString KinkattaPlugin::getVersion(){
  return info.Version;
}

/**
 * Return back the name of this plugin. 
 * @return the name.
 */
QString  KinkattaPlugin::getName(){
  return info.Name;
}

/**
 * To be overloaded by other plugins.  Saves any internal settings.
 */
void KinkattaPlugin::saveSettings(){
}


//
//
// The start of usefull functions.
//
//
//


/**
 * Checks to see if we are online or not.
 * @return online status.
 */
bool KinkattaPlugin::onLine(){
  if( connection->getStatus() == TAIM_OFFLINE )
    return false;
  else
    return true;
}

/**
 * Sets the main window to be away at this very moment.  The message must be of length > 0.
 * @param message the text that we should use to set ourselves away with.
 */
void KinkattaPlugin::setAwayNow( QString message ){
  if( message.length() > 0 )
    mainWindow->away_setAwayMessageNow( message );
}

QString KinkattaPlugin::getCurrentInfo(){
  return connection->getInfo();
}

void KinkattaPlugin::setCurrentInfo( QString info ){
  connection->setUserInfo( info );
}

// kinkattaplugin.cpp


