/***************************************************************************
                            releasenotification.h
                             -------------------
    begin                : Saturday Dec 1 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

#ifndef KINKATTARELEASENOTIFICATION_H
#define KINKATTARELEASENOTIFICATION_H

#include <kinkattaplugin.h>
#include <kio/jobclasses.h>

class Configure;

/**
 * This plugin simply checks to see if their is a new version of Kinkatta.
 * @author Benjamin Meyer
 */

class ReleaseNotification : public KinkattaPlugin {

Q_OBJECT
	
public:
  /// Constructor.
  ReleaseNotification(QWidget *parent=0, const char *name=0);
  
public slots:
  
  /// After this plugin has been initialized this function is called.
  virtual void initPlugin();

  /// Get the configure widget for this plugin
  QWidget *configure( QWidget *parent );

private slots:
  /// Check for updates and monitor errors
  void checkForUpdatesWError();
  /// Check to see if we are running the latest version
  void checkForUpdates();
  /// Grunt work for checking for a new version
  void checkForUpdatesResult(KIO::Job *job);
  /// Tell the user there is a new version
  void checkForChangesResult(KIO::Job *job);

private:
  /// The Configure widget.
  Configure *configureWidget;

  /// Report errors if we can not connect (for used on the first time)
  bool checkForUpdateReportErrors;

  /// The user can ignore updates if they wish and it will remember.
  QString IgnoreThisUpdate;
};

#endif

// releasenotification.h

