/*
 * Copyright (C) 2000 Arne Schirmacher <arne@schirmacher.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <iostream>
#include <vector>

extern "C"
{
#include "interface.h"
#include "support.h"
}

using std::cout;
using std::endl;
using std::vector;

#include "bar.h"
#include "playlist.h"

// Sorry about this - quick hack
static PlayList *lastplaylist = NULL;

Bar::Bar()
{
    lastFrame = 0;
    gc = NULL;
}


Bar::~Bar()
{}


void Bar::Init(PlayList *playlist)
{
    int frameNum = 0;

	lastplaylist = playlist;

    sceneStartList.erase(sceneStartList.begin(),sceneStartList.end());

    while (frameNum < playlist->GetNumFrames()) {
        lastFrame = frameNum = playlist->FindEndOfScene(frameNum);
        frameNum++;
        sceneStartList.insert(sceneStartList.end(), frameNum);
    }
}

void Bar::Refresh(GtkWidget *drawingarea, int currentFrame)
{
	GtkAdjustment *adjust = gtk_range_get_adjustment( GTK_RANGE( drawingarea ) );
	adjust->upper = -1;
	gtk_signal_emit_by_name( GTK_OBJECT( adjust ), "changed" );
	Draw( drawingarea, currentFrame );
}

void Bar::Draw(GtkWidget *drawingarea, int currentFrame)
{
	// Hack alert - make sure that lastFrame recorded in the Init is still valid
	if ( lastplaylist != NULL ) {
		if ( lastFrame != lastplaylist->GetNumFrames() ) 
			Init( lastplaylist );
	}
	else {
		lastFrame = 0;
	}

	GtkAdjustment *adjust = gtk_range_get_adjustment( GTK_RANGE( drawingarea ) );
	
	if ( adjust->upper != lastFrame ) {
		drawingarea = lookup_widget( drawingarea, "drawingarea2" );
    	int xstart = 0 + 20;
    	int xend = drawingarea->allocation.width - 20;
    	int y = 10;

    	if (currentFrame < 0)
        	currentFrame = 0;
	
    	if (gc == NULL) {
        	gc = gdk_gc_new(drawingarea->window);
        	gdk_gc_get_values(gc, &values);
    	}
    	gdk_rgb_gc_set_foreground(gc,0x00FFFFFF);
    	gdk_draw_rectangle(drawingarea->window, gc,
                       	true, 0, 0, drawingarea->allocation.width, drawingarea->allocation.height);
	
    	gdk_rgb_gc_set_foreground(gc,0x00bbbbbb);
    	gdk_draw_rectangle(drawingarea->window, gc,
                       	true, xstart, y - 5, xend - xstart, 10);
	
    	gdk_rgb_gc_set_foreground(gc,0x00b00020);

		// Only continue with this if the scene and frame list is not empty
    	if ( sceneStartList.size() && lastFrame > 0) {
        	gdk_rgb_gc_set_foreground(gc,0x00FFFFFF);
        	for (unsigned int i = 0; i < sceneStartList.size() - 1; ++i) {
            	int tick = (sceneStartList[i] * (xend - xstart)) / lastFrame;
            	gdk_draw_line(drawingarea->window, gc,
                          	xstart + tick, y - 5, xstart + tick, y + 4);
        	}
    	}
		gtk_widget_realize( drawingarea );
	}

	if ( adjust->upper != lastFrame ) {
		adjust->lower = 0;
		adjust->upper = lastFrame;
		adjust->value = currentFrame < 0 ? 0 : currentFrame > lastFrame ? lastFrame : currentFrame;
		adjust->step_increment = 1;
		adjust->page_increment = 10;
		adjust->page_size = 25;
		gtk_signal_emit_by_name( GTK_OBJECT( adjust ), "changed" );
	}
	else {
		gtk_adjustment_set_value( adjust, currentFrame < 0 ? 0 : currentFrame > lastFrame ? lastFrame : currentFrame );
	}

}

