#ifndef KP_GUI_UTILS_H_
#define KP_GUI_UTILS_H_

#include <glade/glade.h>
#include <gtk/gtk.h>
#include <glib.h>

#include "kpviewmodel.h"
#include "kpstatusbar.h"

#define CB(func) (G_CALLBACK (func))

#define KP_W(xml,widget) kp_gui_get_widget(xml,widget)

typedef struct GuiModuleSignalsData_ {
  const gchar   *glade_widget_name;
  const gchar   *signal;
  GCallback      callback;
  gpointer       data;
} GuiModuleSignalsData;

GladeXML   *kp_gui_load                             (const gchar *module,
                                                     const gchar *root);
void        kp_gui_module_signals_connect           (GladeXML *xml,
                                                     GuiModuleSignalsData *gmd);
void        kp_gui_module_signals_connect_data      (GladeXML *xml,
                                                     GuiModuleSignalsData *gmd,
                                                     gpointer data);

gint        kp_gui_get_yes_no_cancel                (GtkWindow *window,
                                                     const gchar *message);

gchar      *kp_gui_get_file_from_user               (GFileTest valid_mask);

gchar      *kp_gui_get_file_to_open                 (GtkWindow *parent);
gchar      *kp_gui_get_file_to_save                 (GtkWindow *parent);
gchar      *kp_gui_get_dir                          (GtkWindow *parent);

/* Old, deprecated ones.. */
gchar      *kp_gui_get_filename_from_user           (void);
gchar      *kp_gui_get_dirname_from_user            (void);

void        kp_gui_open_file_dialog                 (GCallback handler);

GtkWidget  *kp_gui_get_widget                       (GladeXML *xml,
                                                     const gchar *widget_name);
gchar      *kp_gui_get_option_menu_active           (GtkOptionMenu *menu);
void        kp_gui_report_error                     (GtkWindow *window,
                                                     KPStatusbar *bar,
                                                     const gchar *msg);

void        kp_gui_destroy_widget_passed            (GtkWidget *widget,
                                                     gpointer data);

void        kp_gui_get_dates_for_view_type          (GDate *date,
                                                     KPViewModelType type,
                                                     GDate **start,
                                                     GDate **end,
                                                     KPTrainingLog *log);
gchar      *kp_get_combo_box_first_entry            (GtkComboBox *box);

#endif /* GUI_UTILS_H_ */
