#include "wtapfilesource.h"

#ifdef HAVE_LIBWIRETAP

int WtapFileSource::OpenSource(const char *dev) {
    snprintf(type, 64, "Wtap Save File");


    int err;

    packfile = wtap_open_offline(dev, &err, false);
    if (packfile == NULL) {
        snprintf(errstr, 1024, "Wtap file source unable to open %s: %s",
                 dev, strerror(err));
        return -1;
    }

    snprintf(errstr, 1024, "Wtap file source opened %s", dev);
    return 1;
}

int WtapFileSource::CloseSource() {

    if (packfile != NULL)
        wtap_close(packfile);
    return 1;
}

int WtapFileSource::FetchPacket(pkthdr *in_header, u_char *in_data) {
    int err;
    long int offset;

    if (!wtap_read(packfile, &err, &offset)) {
        snprintf(errstr, 1024, "Wtap file source failed to read packet.");
        return -1;
    }

    packet_header = wtap_phdr(packfile);

    if (packet_header == NULL) {
        snprintf(errstr, 1024, "Wtap file source failed to read header.\n");
        return -1;
    }

    packet_data = wtap_buf_ptr(packfile);

    if (packet_data == NULL) {
        snprintf(errstr, 1024, "Wtap file source failed to read data.\n");
        return -1;
    }

    Wtap2Common(in_header, in_data);

    return(in_header->len);

}

int WtapFileSource::Wtap2Common(pkthdr *in_header, u_char *in_data) {

    memset(in_header, 0, sizeof(pkthdr));
    memset(in_data, 0, MAX_PACKET_LEN);

    in_header->caplen = packet_header->caplen;

    if (packet_header->len > MAX_PACKET_LEN)
        in_header->len = MAX_PACKET_LEN;
    else
        in_header->len = packet_header->len;

    // in_header->pkt_encap = WTAP_ENCAP_IEEE_802_11;

    memcpy(in_data, packet_data, in_header->len);

    return 1;
}


#endif

