package kissme.vm.loaders;

import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;

import java.io.InputStream;
import java.io.File;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipException;

public class JarClassLoader {

  private static HashMap jarfilesMap = new HashMap();
  private static Object emptyJarFile = new Object();

  public static byte[] getClassData(String className, String loaderPath) 
  {
    Object hashResult = null;
    JarFile jf = null;

    /* We keep a map of Jarfiles */
    if((hashResult = jarfilesMap.get(loaderPath)) == null)
      {
	/* we haven't created this jar file yet */
	try {
	  jf = new JarFile(new File(loaderPath));
	} catch(FileNotFoundException fnf)
	  {
	    jarfilesMap.put(loaderPath, emptyJarFile); /* we use this Object to cache the fact that it doesn't exist */
	    return null;
	  }
	 catch(IOException ioe)
	   {
	    jarfilesMap.put(loaderPath, emptyJarFile); /* we use this Object to cache the fact that it doesn't exist */
	    return null;
	   }
	jarfilesMap.put(loaderPath, jf);
      }
    else
      {
	if(hashResult == emptyJarFile)
	  return null;
	
	jf = (JarFile) hashResult;
      }

    JarEntry je = (JarEntry) jf.getEntry(className + ".class");
    if(je != null)
      {
	int length = (int) je.getSize();
	byte[] buffer = new byte[length];
	try {
	  InputStream is = jf.getInputStream(je);
	  int haveread = 0;
	  while(haveread < length)
	    {
	      int res = is.read(buffer, haveread, (length - haveread));
	      if(res == -1)
		return null;
	      haveread += res;
	    }
	} catch(ZipException ze)
	  {
	    return null;
	  }
	 catch(IOException ioe)
	  {
	    return null;
	  }
	return buffer;
      }
    else
      {
	return null;
      }
  }
}
