package java.awt;

import java.awt.event.InputEvent;

public abstract class Component
{

public boolean handleInputEvent(InputEvent ie)
  {
    return false;
  }


// The bounding rectangle of this component.
private Rectangle bounding_rectangle = new Rectangle(0, 0, 100, 100);

// Indicates whether or not this component is visible
private boolean visible = true;

/**
  * Tests whether or not the specified point is contained within this
  * component.  Coordinates are relative to this component.
  *
  * @param x The X coordinate of the point to test.
  * @param y The Y coordinate of the point to test.
  *
  * @return <code>true</code> if the point is within this component,
  * <code>false</code> otherwise.
  */
public boolean
contains(int x, int y)
{
  // FIXME: Is the origin the upper left of this component, or the upper
  // left of the parent component?
  return(getBounds().contains(x, y));
}

/**
  * Returns a bounding rectangle for this component.  Note that the
  * returned rectange is relative to this component's parent, not to
  * the screen.
  *
  * @return The bounding rectangle for this component.
  */
public Rectangle
getBounds()
{
  return(bounding_rectangle);
}

/**
  * Makes this component visible or invisible.
  *
  * @param visible <code>true</code> to make this component visible,
  * </code>false</code> to make it invisible.
  */
public void
setVisible(boolean visible)
{
  this.visible = visible;
}

/*************************************************************************/

/**
  * Sets the bounding rectangle for this component to the specified
  * rectangle.  Note that these coordinates are relative to the parent,
  * not to the screen.
  *
  * @param bounding_rectangle The new bounding rectangle.
  */
public void
setBounds(Rectangle bounding_rectangle)
{
  setBounds(bounding_rectangle.x, bounding_rectangle.y,
            bounding_rectangle.width, bounding_rectangle.height);
}

/*************************************************************************/

/**
  * Sets the bounding rectangle for this component to the specified
  * values.  Note that these coordinates are relative to the parent,
  * not to the screen.
  *
  * @param x The X coordinate of the upper left corner of the rectangle.
  * @param y The Y coordinate of the upper left corner of the rectangle.
  * @param width The width of the rectangle.
  * @param height The height of the rectangle.
  */
public void
setBounds(int x, int y, int width, int height)
{
  bounding_rectangle = new Rectangle(x, y, width, height);
}

}
