package java.awt;

import java.io.Serializable;

import teaseme.console.Console;
import teaseme.console.ConsoleAPI;
import teaseme.console.ConsoleFactory;

/* Maps from a pixel coordinate system to a line and column system */

public class CoordinateManager
{
  public static final int PIXELS_PER_LINE = 12;
  public static final int PIXELS_PER_COLUMN = 7;

  public static Point convertFromPixelPoint(Point p)
  {
    return new Point(p.x / PIXELS_PER_COLUMN, p.y / PIXELS_PER_LINE);
  }

  public static Point convertFromRCPoint(Point p)
  {
    return new Point(p.x * PIXELS_PER_COLUMN, p.y * PIXELS_PER_LINE);
  }

  public static Rectangle convertFromPixelDimension(Rectangle d)
  {
    return new Rectangle( d.x / PIXELS_PER_COLUMN, d.y / PIXELS_PER_LINE, d.width / PIXELS_PER_COLUMN, d.height / PIXELS_PER_LINE);
  }
}



