package java.awt;

import java.awt.event.InputEvent;
import teaseme.console.Console;
import teaseme.console.ConsoleAPI;
import teaseme.console.ConsoleFactory;

public class Toolkit implements Runnable
{
  static private Console console;
  static private EventManager eventManager;
  static private boolean haveStarted = false;

  static private Toolkit defaultToolkit;

  public static Console getConsole()
  {
    return console;
  }

  static boolean initializeUI()
  {
    if(haveStarted == false)
      {
	console = ConsoleFactory.getConsoleAPIImpl().openConsole();
	eventManager = new EventManager();
	haveStarted = true;

	defaultToolkit = new Toolkit();
	//	new Thread(defaultToolkit).start();
	return false;
      }
    return true;
  }

  public static Toolkit getDefaultToolkit()
  {
    return defaultToolkit;
  }

  /* Handles input events */

  public void run()
  {
    while(true)
      {
	int input = console.readChar();
	
	/* Create an input event and send it to the EventManager */
	InputEvent ie = new InputEvent(input, CoordinateManager.convertFromRCPoint( console.getCurrentCursorPosition()));
	eventManager.handleInputEvent(ie);
      }
  }

  public static void registerWindow(Window w)
  {
    eventManager.addTopLevelWindow(w);
  }
}
