package teaseme.console;

import java.awt.Point;
import java.awt.Dimension;

public interface Console {

  /* Gets the x and y coordinates for the current cursor position */
  public Point getCurrentCursorPosition(); 

 /* Sets the x and y coordinates for the current cursor position 
  *
  * Returns previous position
  *
  */

  public Point setCurrentCursorPosition(Point p);

  /* Returns the width in columns and height in rows */

  public Dimension getConsoleHeightAndWidth();

  /* Checks whether there is input available */

  public boolean hasInput();

  /* Writes a character at the current cursor position */

  public boolean writeChar(char c);

  /* Reads a character */

  public int readChar();


  /* Make the changes take effect onscreen */
  public boolean refresh();

  public void erase();
  public void clear();
  public void clearToBottom();
  public void clearToEndOfLine();

  /* Closes the resources used for this console */
  public void close();
}
