package teaseme.console.curses;

import java.awt.Point;
import java.awt.Dimension;

import teaseme.console.Console;



public class CursesConsole implements Console {
  
  /* native methods */
  private native int initscr();
  private native int nonl();
  private native int cbreak();
  private native int noecho();
  private native int echo();
  private native int endwin();

  private native int getrows();
  private native int getcolumns();
  private native int addch(char c);
  private native int getch();

  private native int getcury();
  private native int getcurx();

  private native int move(int y, int x);
  private native boolean native_refresh();
  private native boolean native_hasInput();

  private native int native_erase();
  private native int native_clear();
  private native int native_clrtobot();
  private native int native_clrtoeol();

  public CursesConsole()
  {
    initscr();
    nonl();
    cbreak();
    noecho();
  }

  public void erase()
  {
    native_erase();
  }

  public void clear()
  {
    native_clear();
  }

  public void clearToBottom()
  {
    native_clrtobot();
  }

  public void clearToEndOfLine()
  {
    native_clrtoeol();
  }

  /* Gets the x and y coordinates for the current cursor position */
  public Point getCurrentCursorPosition()
  {
    int y = getcury();
    int x = getcurx();
    return new Point(x,y);
  }

 /* Sets the x and y coordinates for the current cursor position 
  *
  * Returns previous position
  *
  */

  public Point setCurrentCursorPosition(Point p)
  {
    Point op = getCurrentCursorPosition();
    move(p.x, p.y);
    return op;
  }

  /* Returns the width in columns and height in rows */

  public Dimension getConsoleHeightAndWidth()
  {
    int r = getrows();
    int c = getcolumns();
    return new Dimension(r,c);
  }

  /* Writes a character at the current cursor position */

  public boolean writeChar(char c)
  {
    addch(c);
    return true;
  }

  public boolean hasInput()
  {
    return native_hasInput();
  }

  /* Reads a character
   *
   * Returns the character in the two low words of the int
   * Returns -1 for failure
   */

  public int readChar()
  {
    int ret;
    ret = getch();
    return ret;
  }

  public void close()
  {
    endwin();
  }

  public boolean refresh()
  {
    native_refresh();
    return true;
  }
}





