package teaseme.console.xtc;

import teaseme.console.Console;
import java.awt.Point;
import java.awt.Dimension;


import XTC.tools.Tool;
import XTC.Color;
import XTC.Stylus;
import XTC.Text;
import XTC.Window;
import XTC.Matrix;


public class XTCConsole extends Tool implements Console {

  Matrix mx = new Matrix().translate(10, 20);
  Window window;

  public XTCConsole()
  {
    demo(this, 200, 70, new String[0]);
  }

  protected void init(Window w)
  {
    window = w;
    window.title("XTCConsole");
  }

  char[][] lines = new char[25][80];

  private Point currentCursorPosition;


  /*----------------------------------------------------------------*/

  public void draw(Stylus stylus)
  {
    Text t;
    	stylus.foreground(Color.white);
	stylus.fillSolid();
    	stylus.foreground(Color.black);
	for(int i = 0; i < lines.length;i++)
	  {
	    t = new Text(new String(lines[i]), window.getFont());
	    // stylus.getFont().print("Hello, World!", 10, 20);
	    // stylus.getFont().print(new String(lines[i]), 5, 20 * (i + 1));
	    stylus.draw(t, mx);
	  }
  }

  /*----------------------------------------------------------------*/

  /* Gets the x and y coordinates for the current cursor position */
  public Point getCurrentCursorPosition()
  {
    return currentCursorPosition;
  }

 /* Sets the x and y coordinates for the current cursor position 
  *
  * Returns previous position
  *
  */

  public Point setCurrentCursorPosition(Point p)
  {
    Point ret = currentCursorPosition;
    currentCursorPosition = p;
    return ret;
  }
  /* Returns the width in columns and height in rows */

  public Dimension getConsoleHeightAndWidth()
  {
    return new Dimension(80,25);
  }

  /* Checks whether there is input available */

  public boolean hasInput()
  {
    return false;
  }

  /* Writes a character at the current cursor position */

  public boolean writeChar(char c)
  {
    lines[ currentCursorPosition.y ][ currentCursorPosition.x++ ] = c;
    return true;
  }

  /* Reads a character */

  public int readChar(){
    return 'a';
  }

  /* Make the changes take effect onscreen */
  public boolean refresh()
  {
    return true;
  }

  public void erase()
  {

  }

  public void clear()
  {

  }

  public void clearToBottom()
  {

  }

  public void clearToEndOfLine()
  {

  }

  /* Closes the resources used for this console */
  public void close()
  {
  }

}
