package kissme_test;


import java.io.FileInputStream;
import java.io.DataInputStream;

import java.io.FileOutputStream;
import java.io.DataOutputStream;

import java.io.IOException;
import java.io.FileNotFoundException;

public class DataStreamTest {

  static int i = 22;
  static   long l = 0xbabadedeffff1111L;
  static   short s = 16;
  static   byte b = -79;
  static   char c = 'x';
  static   boolean bool = true;
  static   float f = 0x23456f;
  static   double d = 0.000000007;
  
  static int counter = 0;
  public static void check(boolean checkbool)
  {
    counter++;
    if(!checkbool)
      throw new RuntimeException("Failed test " + counter);
  }

    public static void main (String[] argv)
    {
      try {

	DataInputStream dis = new DataInputStream(new FileInputStream("stream.data"));
	
	try {
	  check( dis.readInt() == i);
	  check( dis.readLong() == l);
	  check( dis.readShort() == s);
	  check( dis.readByte() == b);
	  check( dis.readChar() == c);
	  check( dis.readBoolean() == bool);
	  float f2 = dis.readFloat();
	  check( (f2 - f) < 0.00000001);
	  check( (dis.readDouble() -d) < 0.00000001);
	dis.close();

	} catch(IOException ioe)
	  {
	    ioe.printStackTrace();
	  }
      } catch(FileNotFoundException fnf)
	{
	}
      
      try { 

	DataOutputStream dos = new DataOutputStream(new FileOutputStream("stream.data"));
	dos.writeInt(i);
	dos.writeLong(l);
	dos.writeShort(s);
	dos.writeByte(b);
	dos.writeChar(c);
	dos.writeBoolean(bool);
	dos.writeFloat(f);
	dos.writeDouble(d);
	
	dos.close();
      } catch(IOException ioe)
	{
	  ioe.printStackTrace();
	}
    }
}
