
package kissme_test;

public class LockTest extends Thread {
  
  public static Object lockObject;
  public static LockTest instance1;
  public static LockTest instance2;

    public void run() {

	  synchronized(lockObject)
	    {
	      if(this == instance1)
		{
		  System.err.println("thread 1 is notifying");
		  lockObject.notify();
		  throw new NullPointerException("do we lose the lock?");
		}
	      else
		{	      
		  System.err.println("thread 2 got lock on lockObject");
		  lockObject.notify();
		}
	    }
    }

    public static void main (String[] argv)
    {
      lockObject = new Object();
      instance1 = new LockTest();
      instance2 = new LockTest();

      synchronized(lockObject)
	{

	  instance1.start();
	  try {
	    System.err.println("main thread is waiting");
	    lockObject.wait();
	  } catch(InterruptedException ie)
	    {
	      ie.printStackTrace();
	    }

      System.err.println("main thread was notified");
      instance2.start();
	  try {
	    lockObject.wait();
	  } catch(InterruptedException ie)
	    {
	      ie.printStackTrace();
	    }
	}
      System.err.println("main thread was notified a second time");
    }
}
